/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CLVersion
implements Comparable<CLVersion> {
    private static final Pattern pattern = Pattern.compile("OpenCL (?:C )?(\\d+)\\.(\\d+)(.*)");
    public static final CLVersion CL_1_0 = new CLVersion("OpenCL 1.0");
    public static final CLVersion CL_1_1 = new CLVersion("OpenCL 1.1");
    public final String fullversion;
    public final String implversion;
    public final short minor;
    public final short major;

    protected CLVersion(String string) {
        this.fullversion = string;
        Matcher matcher = pattern.matcher(string);
        matcher.matches();
        this.major = Short.parseShort(matcher.group(1));
        this.minor = Short.parseShort(matcher.group(2));
        this.implversion = matcher.groupCount() == 4 ? matcher.group(3).substring(1) : "";
    }

    @Override
    public int compareTo(CLVersion cLVersion) {
        return this.compareTo(cLVersion.major, cLVersion.minor);
    }

    private int compareTo(int n, int n2) {
        if (n == this.major && n2 == this.minor) {
            return 0;
        }
        if (this.major > n || this.major == n && this.minor > n2) {
            return 1;
        }
        return -1;
    }

    public boolean isAtLeast(CLVersion cLVersion) {
        return this.compareTo(cLVersion) >= 0;
    }

    public boolean isAtLeast(int n, int n2) {
        return this.compareTo(n, n2) >= 0;
    }

    public boolean isEqual(CLVersion cLVersion) {
        return this.isEqual(cLVersion.major, cLVersion.minor);
    }

    public boolean isEqual(int n, int n2) {
        return this.major == n && this.minor == n2;
    }

    public String getSpecVersion() {
        return "OpenCL " + this.major + '.' + this.minor;
    }

    public String getFullVersion() {
        return this.fullversion;
    }

    public String getImplVersion() {
        return this.implversion;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.getFullVersion();
    }

    public int hashCode() {
        return this.fullversion.hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == this.getClass() && this.fullversion.equals(((CLVersion)object).fullversion);
    }
}

