/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import mitiv.array.ShapedArray;
import mitiv.deconv.Deconvolution;
import mitiv.io.BufferedImageUtils;
import mitiv.utils.CommonUtils;

public class mitivCLI {
    static String regularization = "wiener";
    static String[] regularizationChoice = new String[]{"wiener", "quadratic", "cg"};
    static String postTreatment = "none";
    static String[] postTreatmentChoice = new String[]{"none", "corrected", "colormap", "correted_colormap"};
    static String alpha = "1.0";
    static String PSF = "";
    static String image = "";
    static String outputImage = "DeconvoluatedImage.png";

    private static boolean isIn(String element, String[] tab) {
        int i = 0;
        while (i < tab.length) {
            if (tab[i].compareTo(element) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void checkArgs() {
        if (PSF.compareTo("") == 0 || image.compareTo("") == 0) {
            System.out.println("We need at least PSF and a image\n");
            mitivCLI.printHelp();
            System.exit(1);
        }
        if (!mitivCLI.isIn(regularization, regularizationChoice)) {
            System.out.println("The regularization chosen does not exist: " + regularization);
            System.exit(1);
        }
        if (!mitivCLI.isIn(postTreatment, postTreatmentChoice)) {
            System.out.println("The post treatment chosen does not exist: " + postTreatment);
            System.exit(1);
        }
        try {
            Double.parseDouble(alpha);
        }
        catch (Exception e) {
            System.out.println("The alpha chosen is not good: " + alpha);
            System.exit(1);
        }
    }

    private static BufferedImage chooseReg(String reg, Deconvolution deconv, double alpha) {
        ShapedArray tmp;
        if (reg.compareTo(regularizationChoice[0]) == 0) {
            tmp = deconv.firstDeconvolution(alpha);
        } else if (reg.compareTo(regularizationChoice[1]) == 0) {
            tmp = deconv.firstDeconvolutionQuad(alpha);
        } else if (reg.compareTo(regularizationChoice[2]) == 0) {
            tmp = deconv.firstDeconvolutionCG(alpha);
        } else {
            throw new IllegalArgumentException("Invalid Job");
        }
        return BufferedImageUtils.arrayToImage(tmp).get(0);
    }

    private static int choosePost(String post) {
        if (post.compareTo(postTreatmentChoice[0]) == 0) {
            return CommonUtils.SCALE;
        }
        if (post.compareTo(postTreatmentChoice[1]) == 0) {
            return CommonUtils.SCALE_CORRECTED;
        }
        if (post.compareTo(postTreatmentChoice[2]) == 0) {
            return CommonUtils.SCALE_COLORMAP;
        }
        if (post.compareTo(postTreatmentChoice[3]) == 0) {
            return CommonUtils.SCALE_CORRECTED_COLORMAP;
        }
        throw new IllegalArgumentException("Invalid Job");
    }

    private static void printHelp() {
        System.out.println("Usage: mitivCLI psf image");
        System.out.println("      option: -o output image, Default: " + outputImage);
        System.out.println("      option: -r kind of regularization, Default: " + regularization);
        System.out.println("                  regularization: " + Arrays.toString(regularizationChoice));
        System.out.println("      option: -p post treatment, Default: " + postTreatment);
        System.out.println("                  treatment: " + Arrays.toString(postTreatmentChoice));
        System.out.println("      option: -a alpha value, Default: " + alpha);
    }

    public static void main(String[] args) {
        boolean psfFound = false;
        int i = 0;
        while (i < args.length) {
            String tmp = args[i];
            if (tmp.charAt(0) == '-') {
                String next = args[i + 1];
                switch (tmp.charAt(1)) {
                    case 'h': {
                        mitivCLI.printHelp();
                        System.exit(0);
                    }
                    case 'o': {
                        outputImage = next;
                        break;
                    }
                    case 'r': {
                        regularization = next;
                        break;
                    }
                    case 'p': {
                        postTreatment = next;
                        break;
                    }
                    case 'a': {
                        alpha = next;
                        break;
                    }
                }
                ++i;
            } else if (!psfFound) {
                PSF = tmp;
                psfFound = true;
            } else {
                image = tmp;
            }
            ++i;
        }
        mitivCLI.checkArgs();
        System.out.format("Regularization: %s, PostTreatment: %s, alpha: %s, Output: %s\n", regularization, postTreatment, alpha, outputImage);
        Deconvolution deconvolution = new Deconvolution(image, PSF, mitivCLI.choosePost(postTreatment), true);
        BufferedImage img = mitivCLI.chooseReg(regularization, deconvolution, Double.parseDouble(alpha));
        try {
            File outputfile = new File(outputImage);
            ImageIO.write((RenderedImage)img, "png", outputfile);
            System.out.println("Done.");
        }
        catch (IOException e) {
            System.err.println("Bad output path");
        }
    }
}

