/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tboolean;

import cern.colt.PersistentObject;
import cern.colt.buffer.tboolean.BooleanBuffer2DConsumer;
import cern.colt.list.tboolean.BooleanArrayList;

public class BooleanBuffer2D
extends PersistentObject
implements BooleanBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected BooleanBuffer2DConsumer target;
    protected boolean[] xElements;
    protected boolean[] yElements;
    protected BooleanArrayList xList;
    protected BooleanArrayList yList;
    protected int capacity;
    protected int size;

    public BooleanBuffer2D(BooleanBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new boolean[capacity];
        this.yElements = new boolean[capacity];
        this.xList = new BooleanArrayList(this.xElements);
        this.yList = new BooleanArrayList(this.yElements);
        this.size = 0;
    }

    public void add(boolean x, boolean y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    @Override
    public void addAllOf(BooleanArrayList x, BooleanArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

