/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.IntIntDComplexFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SelectedDenseColumnDComplexMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import cern.jet.math.tdcomplex.DComplexMult;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnDComplexMatrix2D
extends DComplexMatrix2D {
    static final long serialVersionUID = 1020177651L;
    private DoubleFFT_2D fft2;
    protected double[] elements;

    public DenseColumnDComplexMatrix2D(double[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length / 2);
        this.assign(values);
    }

    public DenseColumnDComplexMatrix2D(DoubleMatrix2D realPart) {
        this(realPart.rows(), realPart.columns());
        this.assignReal(realPart);
    }

    public DenseColumnDComplexMatrix2D(int rows, int columns) {
        this.setUp(rows, columns, 0, 0, 2, 2 * rows);
        this.elements = new double[rows * 2 * columns];
    }

    public DenseColumnDComplexMatrix2D(int rows, int columns, double[] elements, int rowZero, int columnZero, int rowStride, int columnStride, boolean isNoView) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] a = f.apply(DenseColumnDComplexMatrix2D.this.elements[idx], DenseColumnDComplexMatrix2D.this.elements[idx + 1]);
                        int d = 1;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = d;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                idx = zero + r * DenseColumnDComplexMatrix2D.this.rowStride + c * DenseColumnDComplexMatrix2D.this.columnStride;
                                a = aggr.apply(a, f.apply(DenseColumnDComplexMatrix2D.this.elements[idx], DenseColumnDComplexMatrix2D.this.elements[idx + 1]));
                                ++r;
                            }
                            d = 0;
                            ++c;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero], this.elements[zero + 1]);
            int d = 1;
            int c = 0;
            while (c < this.columns) {
                int r = d;
                while (r < this.rows) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    a = aggr.apply(a, f.apply(this.elements[idx], this.elements[idx + 1]));
                    ++r;
                }
                d = 0;
                ++c;
            }
        }
        return a;
    }

    @Override
    public double[] aggregate(DComplexMatrix2D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        if (!(other instanceof DenseColumnDComplexMatrix2D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        double[] b = new double[2];
        if (this.size() == 0L) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        final int zero = (int)this.index(0, 0);
        final int zeroOther = (int)other.index(0, 0);
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final double[] elemsOther = (double[])other.elements();
        double[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        double[] a = f.apply(new double[]{DenseColumnDComplexMatrix2D.this.elements[idx], DenseColumnDComplexMatrix2D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int d = 1;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = d;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                idx = zero + r * DenseColumnDComplexMatrix2D.this.rowStride + c * DenseColumnDComplexMatrix2D.this.columnStride;
                                idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                                a = aggr.apply(a, f.apply(new double[]{DenseColumnDComplexMatrix2D.this.elements[idx], DenseColumnDComplexMatrix2D.this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                                ++r;
                            }
                            d = 0;
                            ++c;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new double[]{this.elements[zero], this.elements[zero + 1]}, new double[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int d = 1;
            int c = 0;
            while (c < this.columns) {
                int r = d;
                while (r < this.rows) {
                    int idx = zero + r * this.rowStride + c * this.columnStride;
                    int idxOther = zeroOther + r * rowStrideOther + c * columnStrideOther;
                    a = aggr.apply(a, f.apply(new double[]{this.elements[idx], this.elements[idx + 1]}, new double[]{elemsOther[idxOther], elemsOther[idxOther + 1]}));
                    ++r;
                }
                d = 0;
                ++c;
            }
        }
        return a;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            if (function instanceof DComplexMult) {
                double[] multiplicator = ((DComplexMult)function).multiplicator;
                if (multiplicator[0] == 1.0 && multiplicator[1] == 0.0) {
                    return this;
                }
                if (multiplicator[0] == 0.0 && multiplicator[1] == 0.0) {
                    return this.assign(0.0, 0.0);
                }
            }
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] tmp = new double[2];
                        if (function instanceof DComplexMult) {
                            double[] multiplicator = ((DComplexMult)function).multiplicator;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp = function.apply(DenseColumnDComplexMatrix2D.this.elements[i], DenseColumnDComplexMatrix2D.this.elements[i + 1]);
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = tmp[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] tmp = new double[2];
            if (function instanceof DComplexMult) {
                double[] multiplicator = ((DComplexMult)function).multiplicator;
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        this.elements[i] = tmp[0] * multiplicator[0] - tmp[1] * multiplicator[1];
                        this.elements[i + 1] = tmp[1] * multiplicator[0] + tmp[0] * multiplicator[1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp = function.apply(this.elements[i], this.elements[i + 1]);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = tmp[1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure cond, final DComplexDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] elem = new double[2];
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                elem[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                elem[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    elem = function.apply(elem);
                                    DenseColumnDComplexMatrix2D.this.elements[i] = elem[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = elem[1];
                                }
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        elem = function.apply(elem);
                        this.elements[i] = elem[0];
                        this.elements[i + 1] = elem[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexProcedure cond, final double[] value) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] elem = new double[2];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                elem[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                elem[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                if (cond.apply(elem)) {
                                    DenseColumnDComplexMatrix2D.this.elements[i] = value[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = value[1];
                                }
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] elem = new double[2];
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    elem[0] = this.elements[i];
                    elem[1] = this.elements[i + 1];
                    if (cond.apply(elem)) {
                        this.elements[i] = value[0];
                        this.elements[i + 1] = value[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final DComplexRealFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] tmp = new double[2];
                        if (function == DComplexFunctions.abs) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    double d;
                                    tmp[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    double absX = Math.abs(DenseColumnDComplexMatrix2D.this.elements[i]);
                                    double absY = Math.abs(DenseColumnDComplexMatrix2D.this.elements[i + 1]);
                                    if (absX == 0.0 && absY == 0.0) {
                                        DenseColumnDComplexMatrix2D.this.elements[i] = 0.0;
                                    } else if (absX >= absY) {
                                        d = tmp[1] / tmp[0];
                                        DenseColumnDComplexMatrix2D.this.elements[i] = absX * Math.sqrt(1.0 + d * d);
                                    } else {
                                        d = tmp[0] / tmp[1];
                                        DenseColumnDComplexMatrix2D.this.elements[i] = absY * Math.sqrt(1.0 + d * d);
                                    }
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = 0.0;
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    tmp[0] = function.apply(tmp);
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = 0.0;
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] tmp = new double[2];
            if (function == DComplexFunctions.abs) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        double d;
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        double absX = Math.abs(tmp[0]);
                        double absY = Math.abs(tmp[1]);
                        if (absX == 0.0 && absY == 0.0) {
                            this.elements[i] = 0.0;
                        } else if (absX >= absY) {
                            d = tmp[1] / tmp[0];
                            this.elements[i] = absX * Math.sqrt(1.0 + d * d);
                        } else {
                            d = tmp[0] / tmp[1];
                            this.elements[i] = absY * Math.sqrt(1.0 + d * d);
                        }
                        this.elements[i + 1] = 0.0;
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        tmp[0] = this.elements[i];
                        tmp[1] = this.elements[i + 1];
                        tmp[0] = function.apply(tmp);
                        this.elements[i] = tmp[0];
                        this.elements[i + 1] = 0.0;
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D source) {
        if (!(source instanceof DenseColumnDComplexMatrix2D)) {
            super.assign(source);
            return this;
        }
        DenseColumnDComplexMatrix2D other = (DenseColumnDComplexMatrix2D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            DComplexMatrix2D c = other.copy();
            if (!(c instanceof DenseColumnDComplexMatrix2D)) {
                super.assign(other);
                return this;
            }
            other = (DenseColumnDComplexMatrix2D)c;
        }
        final double[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = other.columnStride;
        final int rowStrideOther = other.rowStride;
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                DenseColumnDComplexMatrix2D.this.elements[i] = elemsOther[j];
                                DenseColumnDComplexMatrix2D.this.elements[i + 1] = elemsOther[j + 1];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = elemsOther[j];
                    this.elements[i + 1] = elemsOther[j + 1];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(DComplexMatrix2D y, final DComplexDComplexDComplexFunction function) {
        if (!(y instanceof DenseColumnDComplexMatrix2D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final double[] elemsOther = ((DenseColumnDComplexMatrix2D)y).elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int columnStrideOther = y.columnStride();
        final int rowStrideOther = y.rowStride();
        final int zeroOther = (int)y.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        double[] tmp1 = new double[2];
                        double[] tmp2 = new double[2];
                        if (function == DComplexFunctions.mult) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else if (function == DComplexFunctions.multConjFirst) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else if (function == DComplexFunctions.multConjSecond) {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        } else {
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int j = idxOther;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    tmp1[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                    tmp1[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                    tmp2[0] = elemsOther[j];
                                    tmp2[1] = elemsOther[j + 1];
                                    tmp1 = function.apply(tmp1, tmp2);
                                    DenseColumnDComplexMatrix2D.this.elements[i] = tmp1[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = tmp1[1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    j += rowStrideOther;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                idxOther += columnStrideOther;
                                ++c;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            double[] tmp1 = new double[2];
            double[] tmp2 = new double[2];
            int idx = zero;
            int idxOther = zeroOther;
            if (function == DComplexFunctions.mult) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] - tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else if (function == DComplexFunctions.multConjFirst) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = -tmp1[1] * tmp2[0] + tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else if (function == DComplexFunctions.multConjSecond) {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        this.elements[i] = tmp1[0] * tmp2[0] + tmp1[1] * tmp2[1];
                        this.elements[i + 1] = tmp1[1] * tmp2[0] - tmp1[0] * tmp2[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            } else {
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int j = idxOther;
                    int r = 0;
                    while (r < this.rows) {
                        tmp1[0] = this.elements[i];
                        tmp1[1] = this.elements[i + 1];
                        tmp2[0] = elemsOther[j];
                        tmp2[1] = elemsOther[j + 1];
                        tmp1 = function.apply(tmp1, tmp2);
                        this.elements[i] = tmp1[0];
                        this.elements[i + 1] = tmp1[1];
                        i += this.rowStride;
                        j += rowStrideOther;
                        ++r;
                    }
                    idx += this.columnStride;
                    idxOther += columnStrideOther;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double re, final double im) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                DenseColumnDComplexMatrix2D.this.elements[i] = re;
                                DenseColumnDComplexMatrix2D.this.elements[i + 1] = im;
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = re;
                    this.elements[i + 1] = im;
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstColumn * DenseColumnDComplexMatrix2D.this.rows * 2;
                            int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    DenseColumnDComplexMatrix2D.this.elements[i] = values[idxOther++];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = values[idxOther++];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idxOther = 0;
                int idx = zero;
                int c = 0;
                while (c < this.columns) {
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        this.elements[i] = values[idxOther++];
                        this.elements[i + 1] = values[idxOther++];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final double[][] values) {
        if (values.length != this.columns) {
            throw new IllegalArgumentException("Must have same number of columns: values.length=" + values.length + "columns()=" + this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = 2 * DenseColumnDComplexMatrix2D.this.rows;
                            int i = firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                double[] currentColumn = values[c];
                                if (currentColumn.length != idx) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                                }
                                System.arraycopy(currentColumn, 0, DenseColumnDComplexMatrix2D.this.elements, i, idx);
                                i += idx;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 2 * this.rows;
                int i = 0;
                int c = 0;
                while (c < this.columns) {
                    double[] currentColumn = values[c];
                    if (currentColumn.length != idx) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                    }
                    System.arraycopy(currentColumn, 0, this.elements, i, idx);
                    i += idx;
                    ++c;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                double[] currentColumn = values[c];
                                if (currentColumn.length != 2 * DenseColumnDComplexMatrix2D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                                }
                                int i = idx;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    DenseColumnDComplexMatrix2D.this.elements[i] = currentColumn[2 * r];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = currentColumn[2 * r + 1];
                                    i += DenseColumnDComplexMatrix2D.this.rowStride;
                                    ++r;
                                }
                                idx += DenseColumnDComplexMatrix2D.this.columnStride;
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = zero;
                int c = 0;
                while (c < this.columns) {
                    double[] currentColumn = values[c];
                    if (currentColumn.length != 2 * this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every column: rows=" + currentColumn.length + "2*rows()=" + idx);
                    }
                    int i = idx;
                    int r = 0;
                    while (r < this.rows) {
                        this.elements[i] = currentColumn[2 * r];
                        this.elements[i + 1] = currentColumn[2 * r + 1];
                        i += this.rowStride;
                        ++r;
                    }
                    idx += this.columnStride;
                    ++c;
                }
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assign(final float[] values) {
        if (values.length != this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "rows()*2*columns()=" + this.rows() * 2 * this.columns());
        }
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = firstColumn * DenseColumnDComplexMatrix2D.this.rows * 2;
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                DenseColumnDComplexMatrix2D.this.elements[i] = values[idxOther++];
                                DenseColumnDComplexMatrix2D.this.elements[i + 1] = values[idxOther++];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = 0;
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = values[idxOther++];
                    this.elements[i + 1] = values[idxOther++];
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignImaginary(DoubleMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final double[] elemsOther = ((DenseDoubleMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                DenseColumnDComplexMatrix2D.this.elements[i + 1] = elemsOther[j];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i + 1] = elemsOther[j];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D assignReal(DoubleMatrix2D other) {
        this.checkShape(other);
        final int columnStrideOther = other.columnStride();
        final int rowStrideOther = other.rowStride();
        final int zeroOther = (int)other.index(0, 0);
        final int zero = (int)this.index(0, 0);
        final double[] elemsOther = ((DenseDoubleMatrix2D)other).elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                DenseColumnDComplexMatrix2D.this.elements[i] = elemsOther[j];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    this.elements[i] = elemsOther[j];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                if (DenseColumnDComplexMatrix2D.this.elements[i] != 0.0 || DenseColumnDComplexMatrix2D.this.elements[i + 1] != 0.0) {
                                    ++cardinality;
                                }
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    if (this.elements[i] != 0.0 || this.elements[i + 1] != 0.0) {
                        ++cardinality;
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return cardinality;
    }

    public void fft2() {
        DComplexMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexForward((double[])transpose.elements());
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void fftColumns() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewColumn(c)).fft();
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseDComplexMatrix1D)this.viewColumn(c)).fft();
                ++c;
            }
        }
    }

    public void fftRows() {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewRow(r)).fft();
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseDComplexMatrix1D)this.viewRow(r)).fft();
                ++r;
            }
        }
    }

    @Override
    public DComplexMatrix2D forEachNonZero(final IntIntDComplexFunction function) {
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        double[] value = new double[2];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                value[0] = DenseColumnDComplexMatrix2D.this.elements[i];
                                value[1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                if (value[0] != 0.0 || value[1] != 0.0) {
                                    double[] v = function.apply(r, c, value);
                                    DenseColumnDComplexMatrix2D.this.elements[i] = v[0];
                                    DenseColumnDComplexMatrix2D.this.elements[i + 1] = v[1];
                                }
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            double[] value = new double[2];
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    value[0] = this.elements[i];
                    value[1] = this.elements[i + 1];
                    if (value[0] != 0.0 || value[1] != 0.0) {
                        double[] v = function.apply(r, c, value);
                        this.elements[i] = v[0];
                        this.elements[i + 1] = v[1];
                    }
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return this;
    }

    @Override
    public DComplexMatrix2D getConjugateTranspose() {
        DComplexMatrix2D transpose = this.viewDice().copy();
        final double[] elemsOther = ((DenseColumnDComplexMatrix2D)transpose).elements;
        final int zeroOther = (int)transpose.index(0, 0);
        final int columnStrideOther = transpose.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        int columnsOther = transpose.columns();
        final int rowsOther = transpose.rows();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, columnsOther);
            Future[] futures = new Future[nthreads];
            int k = columnsOther / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columnsOther : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < rowsOther) {
                                elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                                idxOther += 2;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idxOther = zeroOther;
            int c = 0;
            while (c < columnsOther) {
                int r = 0;
                while (r < rowsOther) {
                    elemsOther[idxOther + 1] = -elemsOther[idxOther + 1];
                    idxOther += 2;
                    ++r;
                }
                ++c;
            }
        }
        return transpose;
    }

    public double[] elements() {
        return this.elements;
    }

    @Override
    public DoubleMatrix2D getImaginaryPart() {
        DenseColumnDoubleMatrix2D Im = new DenseColumnDoubleMatrix2D(this.rows, this.columns);
        final double[] elemsOther = Im.elements();
        final int columnStrideOther = Im.columnStride();
        final int rowStrideOther = Im.rowStride();
        final int zeroOther = (int)Im.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                elemsOther[j] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[j] = this.elements[i + 1];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList rowList, IntArrayList columnList, ArrayList<double[]> valueList) {
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int idx = (int)this.index(0, 0);
        int c = 0;
        while (c < this.columns) {
            int i = idx;
            int r = 0;
            while (r < this.rows) {
                double[] value = new double[]{this.elements[i], this.elements[i + 1]};
                if (value[0] != 0.0 || value[1] != 0.0) {
                    rowList.add(r);
                    columnList.add(c);
                    valueList.add(value);
                }
                i += this.rowStride;
                ++r;
            }
            idx += this.columnStride;
            ++c;
        }
    }

    @Override
    public double[] getQuick(int row, int column) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        return new double[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public DoubleMatrix2D getRealPart() {
        DenseColumnDoubleMatrix2D R = new DenseColumnDoubleMatrix2D(this.rows, this.columns);
        final double[] elemsOther = R.elements();
        final int columnStrideOther = R.columnStride();
        final int rowStrideOther = R.rowStride();
        final int zeroOther = (int)R.index(0, 0);
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int idxOther = zeroOther + firstColumn * columnStrideOther;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int j = idxOther;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                elemsOther[j] = DenseColumnDComplexMatrix2D.this.elements[i];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                j += rowStrideOther;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            idxOther += columnStrideOther;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int j = idxOther;
                int r = 0;
                while (r < this.rows) {
                    elemsOther[j] = this.elements[i];
                    i += this.rowStride;
                    j += rowStrideOther;
                    ++r;
                }
                idx += this.columnStride;
                idxOther += columnStrideOther;
                ++c;
            }
        }
        return R;
    }

    public void ifft2(boolean scale) {
        DComplexMatrix2D transpose = this.viewDice().copy();
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft2 == null) {
            this.fft2 = new DoubleFFT_2D(this.rows, this.columns);
        }
        this.fft2.complexInverse((double[])transpose.elements(), scale);
        this.assign(transpose.viewDice().copy());
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifftColumns(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewColumn(c)).ifft(scale);
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int c = 0;
            while (c < this.columns) {
                ((DenseDComplexMatrix1D)this.viewColumn(c)).ifft(scale);
                ++c;
            }
        }
    }

    public void ifftRows(final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int r = firstRow;
                        while (r < lastRow) {
                            ((DenseDComplexMatrix1D)DenseColumnDComplexMatrix2D.this.viewRow(r)).ifft(scale);
                            ++r;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            int r = 0;
            while (r < this.rows) {
                ((DenseDComplexMatrix1D)this.viewRow(r)).ifft(scale);
                ++r;
            }
        }
    }

    @Override
    public DComplexMatrix2D like(int rows, int columns) {
        return new DenseColumnDComplexMatrix2D(rows, columns);
    }

    @Override
    public DComplexMatrix1D like1D(int size) {
        return new DenseDComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, double re, double im) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int row, int column, double[] value) {
        int idx = this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public double[][] toArray() {
        final double[][] values = new double[this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                values[r][2 * c] = DenseColumnDComplexMatrix2D.this.elements[i];
                                values[r][2 * c + 1] = DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    values[r][2 * c] = this.elements[i];
                    values[r][2 * c + 1] = this.elements[i + 1];
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return values;
    }

    @Override
    public DComplexMatrix1D vectorize() {
        DenseDComplexMatrix1D v = new DenseDComplexMatrix1D((int)this.size());
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((DComplexMatrix1D)v).elements(), 0, this.elements.length);
        } else {
            final int zero = (int)this.index(0, 0);
            final int zeroOther = (int)((AbstractMatrix1D)v).index(0);
            final int strideOther = v.stride();
            final double[] elemsOther = (double[])((DComplexMatrix1D)v).elements();
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.columns);
                Future[] futures = new Future[nthreads];
                int k = this.columns / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstColumn = j * k;
                    final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                    final int firstIdx = j * k * this.rows;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idx = 0;
                            int idxOther = zeroOther + firstIdx * strideOther;
                            int c = firstColumn;
                            while (c < lastColumn) {
                                idx = zero + c * DenseColumnDComplexMatrix2D.this.columnStride;
                                int r = 0;
                                while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                    elemsOther[idxOther] = DenseColumnDComplexMatrix2D.this.elements[idx];
                                    elemsOther[idxOther + 1] = DenseColumnDComplexMatrix2D.this.elements[idx + 1];
                                    idx += DenseColumnDComplexMatrix2D.this.rowStride;
                                    idxOther += strideOther;
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx = 0;
                int idxOther = zeroOther;
                int c = 0;
                while (c < this.columns) {
                    idx = zero + c * this.columnStride;
                    int r = 0;
                    while (r < this.rows) {
                        elemsOther[idxOther] = this.elements[idx];
                        elemsOther[idxOther + 1] = this.elements[idx + 1];
                        idx += this.rowStride;
                        idxOther += strideOther;
                        ++r;
                    }
                    ++c;
                }
            }
        }
        return v;
    }

    @Override
    public DComplexMatrix2D zMult(DComplexMatrix2D B, DComplexMatrix2D C, final double[] alpha, final double[] beta, final boolean transposeA, final boolean transposeB) {
        int columnsC;
        int rowsA = this.rows;
        int columnsA = this.columns;
        int rowsB = B.rows();
        int columnsB = B.columns();
        int rowsC = transposeA ? columnsA : rowsA;
        int n = columnsC = transposeB ? rowsB : columnsB;
        if (C == null) {
            C = new DenseColumnDComplexMatrix2D(rowsC, columnsC);
        }
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        if (B.rows() != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != columnsB) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        long flops = 2L * (long)rowsA * (long)columnsA * (long)columnsB;
        int noOfTasks = (int)Math.min(flops / 30000L, (long)ConcurrencyUtils.getNumberOfThreads());
        boolean splitB = columnsB >= noOfTasks;
        int width = splitB ? columnsB : rowsA;
        noOfTasks = Math.min(width, noOfTasks);
        if (noOfTasks < 2) {
            return this.zMultSeq(B, C, alpha, beta, transposeA, transposeB);
        }
        int span = width / noOfTasks;
        Future[] subTasks = new Future[noOfTasks];
        int i = 0;
        while (i < noOfTasks) {
            DComplexMatrix2D CC;
            DComplexMatrix2D BB;
            DComplexMatrix2D AA;
            int offset = i * span;
            if (i == noOfTasks - 1) {
                span = width - span * i;
            }
            if (splitB) {
                AA = this;
                BB = B.viewPart(0, offset, columnsA, span);
                CC = C.viewPart(0, offset, rowsA, span);
            } else {
                AA = this.viewPart(offset, 0, span, columnsA);
                BB = B;
                CC = C.viewPart(offset, 0, span, columnsB);
            }
            subTasks[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    ((DenseColumnDComplexMatrix2D)AA).zMultSeq(BB, CC, alpha, beta, transposeA, transposeB);
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(subTasks);
        return C;
    }

    protected DComplexMatrix2D zMultSeq(DComplexMatrix2D B, DComplexMatrix2D C, double[] alpha, double[] beta, boolean transposeA, boolean transposeB) {
        if (transposeA) {
            return this.getConjugateTranspose().zMult(B, C, alpha, beta, false, transposeB);
        }
        if (transposeB) {
            return this.zMult(B.getConjugateTranspose(), C, alpha, beta, transposeA, false);
        }
        int m = this.rows;
        int n = this.columns;
        int p = B.columns();
        if (C == null) {
            C = new DenseColumnDComplexMatrix2D(m, p);
        }
        if (!(C instanceof DenseColumnDComplexMatrix2D)) {
            return super.zMult(B, C, alpha, beta, transposeA, transposeB);
        }
        if (B.rows() != n) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + B.toStringShort());
        }
        if (C.rows() != m || C.columns() != p) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + B.toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseColumnDComplexMatrix2D BB = (DenseColumnDComplexMatrix2D)B;
        DenseColumnDComplexMatrix2D CC = (DenseColumnDComplexMatrix2D)C;
        double[] AElems = this.elements;
        double[] BElems = BB.elements;
        double[] CElems = CC.elements;
        if (AElems == null || BElems == null || CElems == null) {
            throw new InternalError();
        }
        int cA = this.columnStride;
        int cB = BB.columnStride;
        int cC = CC.columnStride;
        int rA = this.rowStride;
        int rB = BB.rowStride;
        int rC = CC.rowStride;
        int BLOCK_SIZE = 30000;
        int m_optimal = (30000 - n) / (n + 1);
        if (m_optimal <= 0) {
            m_optimal = 1;
        }
        int blocks = m / m_optimal;
        int rr = 0;
        if (m % m_optimal != 0) {
            ++blocks;
        }
        while (--blocks >= 0) {
            int jB = (int)BB.index(0, 0);
            int indexA = (int)this.index(rr, 0);
            int jC = (int)CC.index(rr, 0);
            rr += m_optimal;
            if (blocks == 0) {
                m_optimal += m - rr;
            }
            int j = p;
            while (--j >= 0) {
                int iA = indexA;
                int iC = jC;
                int i = m_optimal;
                while (--i >= 0) {
                    double imB;
                    double reB;
                    double imA;
                    double reA;
                    int kA = iA;
                    int kB = jB;
                    double reS = 0.0;
                    double imS = 0.0;
                    kA -= cA;
                    kB -= rB;
                    int k = n % 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    k = n / 4;
                    while (--k >= 0) {
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                        reA = AElems[kA += cA];
                        imA = AElems[kA + 1];
                        reB = BElems[kB += rB];
                        imB = BElems[kB + 1];
                        reS += reA * reB - imA * imB;
                        imS += imA * reB + reA * imB;
                    }
                    double reC = CElems[iC];
                    double imC = CElems[iC + 1];
                    CElems[iC] = alpha[0] * reS - alpha[1] * imS + beta[0] * reC - beta[1] * imC;
                    CElems[iC + 1] = alpha[1] * reS + alpha[0] * imS + beta[1] * reC + beta[0] * imC;
                    iA += rA;
                    iC += rC;
                }
                jB += cB;
                jC += cC;
            }
        }
        return C;
    }

    @Override
    public double[] zSum() {
        double[] sum = new double[2];
        final int zero = (int)this.index(0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? this.columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        int idx = zero + firstColumn * DenseColumnDComplexMatrix2D.this.columnStride;
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int i = idx;
                            int r = 0;
                            while (r < DenseColumnDComplexMatrix2D.this.rows) {
                                sum[0] = sum[0] + DenseColumnDComplexMatrix2D.this.elements[i];
                                sum[1] = sum[1] + DenseColumnDComplexMatrix2D.this.elements[i + 1];
                                i += DenseColumnDComplexMatrix2D.this.rowStride;
                                ++r;
                            }
                            idx += DenseColumnDComplexMatrix2D.this.columnStride;
                            ++c;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                int j2 = 0;
                while (j2 < nthreads) {
                    double[] tmp = (double[])futures[j2].get();
                    sum[0] = sum[0] + tmp[0];
                    sum[1] = sum[1] + tmp[1];
                    ++j2;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int c = 0;
            while (c < this.columns) {
                int i = idx;
                int r = 0;
                while (r < this.rows) {
                    sum[0] = sum[0] + this.elements[i];
                    sum[1] = sum[1] + this.elements[i + 1];
                    i += this.rowStride;
                    ++r;
                }
                idx += this.columnStride;
                ++c;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix2D other) {
        if (other instanceof SelectedDenseColumnDComplexMatrix2D) {
            SelectedDenseColumnDComplexMatrix2D otherMatrix = (SelectedDenseColumnDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseColumnDComplexMatrix2D) {
            DenseColumnDComplexMatrix2D otherMatrix = (DenseColumnDComplexMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    protected DComplexMatrix1D like1D(int size, int zero, int stride) {
        return new DenseDComplexMatrix1D(size, this.elements, zero, stride, false);
    }

    @Override
    protected DComplexMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseColumnDComplexMatrix2D(this.elements, rowOffsets, columnOffsets, 0);
    }
}

