/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tdouble.Double27Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.SelectedDenseDoubleMatrix3D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseDoubleMatrix3D
extends DoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    private DoubleFFT_3D fft3;
    private DoubleDCT_3D dct3;
    private DoubleDST_3D dst3;
    private DoubleDHT_3D dht3;
    protected double[] elements;

    public DenseDoubleMatrix3D(double[][][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length, values.length == 0 ? 0 : (values[0].length == 0 ? 0 : values[0][0].length));
        this.assign(values);
    }

    public DenseDoubleMatrix3D(int slices, int rows, int columns) {
        this.setUp(slices, rows, columns);
        this.elements = new double[slices * rows * columns];
    }

    public DenseDoubleMatrix3D(int slices, int rows, int columns, double[] elements, int sliceZero, int rowZero, int columnZero, int sliceStride, int rowStride, int columnStride, boolean isView) {
        this.setUp(slices, rows, columns, sliceZero, rowZero, columnZero, sliceStride, rowStride, columnStride);
        this.elements = elements;
        this.isNoView = !isView;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseDoubleMatrix3D.this.elements[zero + firstSlice * DenseDoubleMatrix3D.this.sliceStride]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(DenseDoubleMatrix3D.this.elements[zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride + c * DenseDoubleMatrix3D.this.columnStride]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero]);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, final DoubleProcedure cond) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double elem = DenseDoubleMatrix3D.this.elements[zero + firstSlice * DenseDoubleMatrix3D.this.sliceStride];
                        double a = 0.0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    elem = DenseDoubleMatrix3D.this.elements[zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride + c * DenseDoubleMatrix3D.this.columnStride];
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            double elem = this.elements[zero];
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction aggr, final DoubleFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            return Double.NaN;
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        final int zero = (int)this.index(0, 0, 0);
        double a = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double a = f.apply(DenseDoubleMatrix3D.this.elements[zero + sliceElements[firstIdx] * DenseDoubleMatrix3D.this.sliceStride + rowElements[firstIdx] * DenseDoubleMatrix3D.this.rowStride + columnElements[firstIdx] * DenseDoubleMatrix3D.this.columnStride]);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            double elem = DenseDoubleMatrix3D.this.elements[zero + sliceElements[i] * DenseDoubleMatrix3D.this.sliceStride + rowElements[i] * DenseDoubleMatrix3D.this.rowStride + columnElements[i] * DenseDoubleMatrix3D.this.columnStride];
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.elements[zero + sliceElements[0] * this.sliceStride + rowElements[0] * this.rowStride + columnElements[0] * this.columnStride]);
            int i = 1;
            while (i < size) {
                double elem = this.elements[zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride];
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    @Override
    public double aggregate(DoubleMatrix3D other, final DoubleDoubleFunction aggr, final DoubleDoubleFunction f) {
        if (!(other instanceof DenseDoubleMatrix3D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkShape(other);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double a = 0.0;
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other.index(0, 0, 0);
        final int sliceStrideOther = other.sliceStride();
        final int rowStrideOther = other.rowStride();
        final int columnStrideOther = other.columnStride();
        final double[] elementsOther = (double[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        int idx = zero + firstSlice * DenseDoubleMatrix3D.this.sliceStride;
                        int idxOther = zeroOther + firstSlice * sliceStrideOther;
                        double a = f.apply(DenseDoubleMatrix3D.this.elements[idx], elementsOther[idxOther]);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride + c * DenseDoubleMatrix3D.this.columnStride;
                                    idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * columnStrideOther;
                                    a = aggr.apply(a, f.apply(DenseDoubleMatrix3D.this.elements[idx], elementsOther[idxOther]));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride;
                        int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther + c * columnStrideOther;
                        a = aggr.apply(a, f.apply(this.elements[idx], elementsOther[idxOther]));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    @Override
    public DoubleMatrix3D assign(final DoubleFunction function) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    DenseDoubleMatrix3D.this.elements[idx] = function.apply(DenseDoubleMatrix3D.this.elements[idx]);
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx]);
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(final DoubleProcedure cond, final DoubleFunction f) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    double elem = DenseDoubleMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseDoubleMatrix3D.this.elements[idx] = f.apply(elem);
                                    }
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        double elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = f.apply(elem);
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(final DoubleProcedure cond, final double value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    double elem = DenseDoubleMatrix3D.this.elements[idx];
                                    if (cond.apply(elem)) {
                                        DenseDoubleMatrix3D.this.elements[idx] = value;
                                    }
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        double elem = this.elements[idx];
                        if (cond.apply(elem)) {
                            this.elements[idx] = value;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(final double value) {
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    DenseDoubleMatrix3D.this.elements[idx] = value;
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = value;
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(final double[] values) {
        if ((long)values.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int idxOther = firstSlice * DenseDoubleMatrix3D.this.rows * DenseDoubleMatrix3D.this.columns;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                int r = 0;
                                while (r < DenseDoubleMatrix3D.this.rows) {
                                    int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                    int c = 0;
                                    while (c < DenseDoubleMatrix3D.this.columns) {
                                        DenseDoubleMatrix3D.this.elements[idx] = values[idxOther++];
                                        idx += DenseDoubleMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int idxOther = 0;
                int s = 0;
                while (s < this.slices) {
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = values[idxOther++];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(final double[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstSlice * DenseDoubleMatrix3D.this.sliceStride;
                            int s = firstSlice;
                            while (s < lastSlice) {
                                double[][] currentSlice = values[s];
                                if (currentSlice.length != DenseDoubleMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseDoubleMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseDoubleMatrix3D.this.rows) {
                                    double[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseDoubleMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseDoubleMatrix3D.this.columns());
                                    }
                                    System.arraycopy(currentRow, 0, DenseDoubleMatrix3D.this.elements, i, DenseDoubleMatrix3D.this.columns);
                                    i += DenseDoubleMatrix3D.this.columns;
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int i = 0;
                int s = 0;
                while (s < this.slices) {
                    double[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        double[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        System.arraycopy(currentRow, 0, this.elements, i, this.columns);
                        i += this.columns;
                        ++r;
                    }
                    ++s;
                }
            }
        } else {
            final int zero = (int)this.index(0, 0, 0);
            if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
                nthreads = Math.min(nthreads, this.slices);
                Future[] futures = new Future[nthreads];
                int k = this.slices / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstSlice = j * k;
                    final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int s = firstSlice;
                            while (s < lastSlice) {
                                double[][] currentSlice = values[s];
                                if (currentSlice.length != DenseDoubleMatrix3D.this.rows) {
                                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + DenseDoubleMatrix3D.this.rows());
                                }
                                int r = 0;
                                while (r < DenseDoubleMatrix3D.this.rows) {
                                    int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                    double[] currentRow = currentSlice[r];
                                    if (currentRow.length != DenseDoubleMatrix3D.this.columns) {
                                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + DenseDoubleMatrix3D.this.columns());
                                    }
                                    int c = 0;
                                    while (c < DenseDoubleMatrix3D.this.columns) {
                                        DenseDoubleMatrix3D.this.elements[idx] = currentRow[c];
                                        idx += DenseDoubleMatrix3D.this.columnStride;
                                        ++c;
                                    }
                                    ++r;
                                }
                                ++s;
                            }
                        }
                    });
                    ++j;
                }
                try {
                    j = 0;
                    while (j < nthreads) {
                        futures[j].get();
                        ++j;
                    }
                }
                catch (ExecutionException ex) {
                    ex.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                int s = 0;
                while (s < this.slices) {
                    double[][] currentSlice = values[s];
                    if (currentSlice.length != this.rows) {
                        throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                    }
                    int r = 0;
                    while (r < this.rows) {
                        int idx = zero + s * this.sliceStride + r * this.rowStride;
                        double[] currentRow = currentSlice[r];
                        if (currentRow.length != this.columns) {
                            throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                        }
                        int c = 0;
                        while (c < this.columns) {
                            this.elements[idx] = currentRow[c];
                            idx += this.columnStride;
                            ++c;
                        }
                        ++r;
                    }
                    ++s;
                }
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(DoubleMatrix3D source) {
        if (!(source instanceof DenseDoubleMatrix3D)) {
            super.assign(source);
            return this;
        }
        DenseDoubleMatrix3D other = (DenseDoubleMatrix3D)source;
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        if (this.haveSharedCells(other)) {
            DoubleMatrix3D c = other.copy();
            if (!(c instanceof DenseDoubleMatrix3D)) {
                super.assign(source);
                return this;
            }
            other = (DenseDoubleMatrix3D)c;
        }
        DenseDoubleMatrix3D other_final = other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other_final.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)other_final.index(0, 0, 0);
        final int sliceStrideOther = other_final.sliceStride;
        final int rowStrideOther = other_final.rowStride;
        final int columnStrideOther = other_final.columnStride;
        final double[] elementsOther = other_final.elements;
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    DenseDoubleMatrix3D.this.elements[idx] = elementsOther[idxOther];
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    futures[j].get();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = elementsOther[idxOther];
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(DoubleMatrix3D y, final DoubleDoubleFunction function) {
        if (!(y instanceof DenseDoubleMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final double[] elementsOther = (double[])y.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    DenseDoubleMatrix3D.this.elements[idx] = function.apply(DenseDoubleMatrix3D.this.elements[idx], elementsOther[idxOther]);
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    idxOther += columnStrideOther;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int idxOther = zeroOther + s * sliceStrideOther + r * rowStrideOther;
                    int c = 0;
                    while (c < this.columns) {
                        this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                        idx += this.columnStride;
                        idxOther += columnStrideOther;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    @Override
    public DoubleMatrix3D assign(DoubleMatrix3D y, final DoubleDoubleFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (!(y instanceof DenseDoubleMatrix3D)) {
            super.assign(y, function);
            return this;
        }
        this.checkShape(y);
        final int zero = (int)this.index(0, 0, 0);
        final int zeroOther = (int)y.index(0, 0, 0);
        final int sliceStrideOther = y.sliceStride();
        final int rowStrideOther = y.rowStride();
        final int columnStrideOther = y.columnStride();
        final double[] elementsOther = (double[])y.elements();
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int idx = zero + sliceElements[i] * DenseDoubleMatrix3D.this.sliceStride + rowElements[i] * DenseDoubleMatrix3D.this.rowStride + columnElements[i] * DenseDoubleMatrix3D.this.columnStride;
                            int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                            DenseDoubleMatrix3D.this.elements[idx] = function.apply(DenseDoubleMatrix3D.this.elements[idx], elementsOther[idxOther]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                int idx = zero + sliceElements[i] * this.sliceStride + rowElements[i] * this.rowStride + columnElements[i] * this.columnStride;
                int idxOther = zeroOther + sliceElements[i] * sliceStrideOther + rowElements[i] * rowStrideOther + columnElements[i] * columnStrideOther;
                this.elements[idx] = function.apply(this.elements[idx], elementsOther[idxOther]);
                ++i;
            }
        }
        return this;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    if (DenseDoubleMatrix3D.this.elements[idx] != 0.0) {
                                        ++cardinality;
                                    }
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        if (this.elements[idx] != 0.0) {
                            ++cardinality;
                        }
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public void dct2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).dct2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).dct2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.forward(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dct3.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht2Slices() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).dht2();
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).dht2();
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dht3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.forward(this.elements);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dht3.forward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).dst2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).dst2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void dst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.forward(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dst3.forward((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[] elements() {
        return this.elements;
    }

    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realForward(this.elements);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.fft3.realForward((double[])copy.elements());
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public DenseDComplexMatrix3D getFft2Slices() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix3D C = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            C.viewSlice(s).assign(((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).getFft2());
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                C.viewSlice(s).assign(((DenseDoubleMatrix2D)this.viewSlice(s)).getFft2());
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix3D getFft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseDComplexMatrix3D C = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        final int sliceStride = this.rows * this.columns;
        final int rowStride = this.columns;
        final double[] elems = this.isNoView ? this.elements : (double[])this.copy().elements();
        final double[] cElems = C.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = s * sliceStride + r * rowStride;
                                System.arraycopy(elems, idx, cElems, idx, DenseDoubleMatrix3D.this.columns);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = s * sliceStride + r * rowStride;
                    System.arraycopy(elems, idx, cElems, idx, this.columns);
                    ++r;
                }
                ++s;
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(cElems);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix3D getIfft2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        final DenseDComplexMatrix3D C = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            C.viewSlice(s).assign(((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).getIfft2(scale));
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                C.viewSlice(s).assign(((DenseDoubleMatrix2D)this.viewSlice(s)).getIfft2(scale));
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    public DenseDComplexMatrix3D getIfft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        DenseDComplexMatrix3D C = new DenseDComplexMatrix3D(this.slices, this.rows, this.columns);
        final int sliceStride = this.rows * this.columns;
        final int rowStride = this.columns;
        final double[] cElems = C.elements();
        final double[] elems = this.isNoView ? this.elements : (double[])this.copy().elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = s * sliceStride + r * rowStride;
                                System.arraycopy(elems, idx, cElems, idx, DenseDoubleMatrix3D.this.columns);
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = s * sliceStride + r * rowStride;
                    System.arraycopy(elems, idx, cElems, idx, this.columns);
                    ++r;
                }
                ++s;
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(cElems, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
        return C;
    }

    @Override
    public double[] getMaxLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        double maxValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        double maxValue = DenseDoubleMatrix3D.this.elements[zero + firstSlice * DenseDoubleMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    double elem = DenseDoubleMatrix3D.this.elements[zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride + c * DenseDoubleMatrix3D.this.columnStride];
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new double[]{maxValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        double elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (maxValue < elem) {
                            maxValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new double[]{maxValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public double[] getMinLocation() {
        final int zero = (int)this.index(0, 0, 0);
        int slice_loc = 0;
        int row_loc = 0;
        int col_loc = 0;
        double minValue = 0.0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int slice_loc = firstSlice;
                        int row_loc = 0;
                        int col_loc = 0;
                        double minValue = DenseDoubleMatrix3D.this.elements[zero + slice_loc * DenseDoubleMatrix3D.this.sliceStride];
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int c = d;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    double elem = DenseDoubleMatrix3D.this.elements[zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride + c * DenseDoubleMatrix3D.this.columnStride];
                                    if (minValue > elem) {
                                        minValue = elem;
                                        slice_loc = s;
                                        row_loc = r;
                                        col_loc = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new double[]{minValue, slice_loc, row_loc, col_loc};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (double[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                slice_loc = (int)results[0][1];
                row_loc = (int)results[0][2];
                col_loc = (int)results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        slice_loc = (int)results[j][1];
                        row_loc = (int)results[j][2];
                        col_loc = (int)results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.elements[zero];
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        double elem = this.elements[zero + s * this.sliceStride + r * this.rowStride + c * this.columnStride];
                        if (minValue > elem) {
                            minValue = elem;
                            slice_loc = s;
                            row_loc = r;
                            col_loc = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new double[]{minValue, slice_loc, row_loc, col_loc};
    }

    @Override
    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    double value = this.elements[idx];
                    if (value < 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    double value = this.elements[idx];
                    if (value != 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, DoubleArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int zero = (int)this.index(0, 0, 0);
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int idx = zero + s * this.sliceStride + r * this.rowStride;
                int c = 0;
                while (c < this.columns) {
                    double value = this.elements[idx];
                    if (value > 0.0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    idx += this.columnStride;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    @Override
    public double getQuick(int slice, int row, int column) {
        return this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride];
    }

    public void idct2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).idct2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).idct2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idct3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dct3.inverse(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dct3.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).idht2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).idht2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idht3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dht3.inverse(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dht3.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst2Slices(final boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            ((DenseDoubleMatrix2D)DenseDoubleMatrix3D.this.viewSlice(s)).idst2(scale);
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                ((DenseDoubleMatrix2D)this.viewSlice(s)).idst2(scale);
                ++s;
            }
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void idst3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.dst3.inverse(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.dst3.inverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        if (this.isNoView) {
            this.fft3.realInverse(this.elements, scale);
        } else {
            DoubleMatrix3D copy = this.copy();
            this.fft3.realInverse((double[])copy.elements(), scale);
            this.assign((double[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public long index(int slice, int row, int column) {
        return this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride;
    }

    @Override
    public DoubleMatrix3D like(int slices, int rows, int columns) {
        return new DenseDoubleMatrix3D(slices, rows, columns);
    }

    @Override
    public DoubleMatrix2D like2D(int rows, int columns) {
        return new DenseDoubleMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int slice, int row, int column, double value) {
        this.elements[this.sliceZero + slice * this.sliceStride + this.rowZero + row * this.rowStride + this.columnZero + column * this.columnStride] = value;
    }

    @Override
    public double[][][] toArray() {
        final double[][][] values = new double[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        final int zero = (int)this.index(0, 0, 0);
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            double[][] currentSlice = values[s];
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                double[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    currentRow[c] = DenseDoubleMatrix3D.this.elements[idx];
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                double[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    double[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    @Override
    public DoubleMatrix1D vectorize() {
        DenseDoubleMatrix1D v = new DenseDoubleMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        int s = 0;
        while (s < this.slices) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
            ++s;
        }
        return v;
    }

    @Override
    public void zAssign27Neighbors(DoubleMatrix3D B, Double27Function function) {
        if (!(B instanceof DenseDoubleMatrix3D)) {
            super.zAssign27Neighbors(B, function);
            return;
        }
        if (function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(B);
        int r = this.rows - 1;
        int c = this.columns - 1;
        if (this.rows < 3 || this.columns < 3 || this.slices < 3) {
            return;
        }
        DenseDoubleMatrix3D BB = (DenseDoubleMatrix3D)B;
        int A_ss = this.sliceStride;
        int A_rs = this.rowStride;
        int B_rs = BB.rowStride;
        int A_cs = this.columnStride;
        int B_cs = BB.columnStride;
        double[] elems = this.elements;
        double[] B_elems = BB.elements;
        if (elems == null || B_elems == null) {
            throw new InternalError();
        }
        int k = 1;
        while (k < this.slices - 1) {
            int A_index = (int)this.index(k, 1, 1);
            int B_index = (int)BB.index(k, 1, 1);
            int i = 1;
            while (i < r) {
                int A002 = A_index - A_ss - A_rs - A_cs;
                int A012 = A002 + A_rs;
                int A022 = A012 + A_rs;
                int A102 = A002 + A_ss;
                int A112 = A102 + A_rs;
                int A122 = A112 + A_rs;
                int A202 = A102 + A_ss;
                int A212 = A202 + A_rs;
                int A222 = A212 + A_rs;
                double a000 = elems[A002];
                double a001 = elems[A002 += A_cs];
                double a010 = elems[A012];
                double a011 = elems[A012 += A_cs];
                double a020 = elems[A022];
                double a021 = elems[A022 += A_cs];
                double a100 = elems[A102];
                double a101 = elems[A102 += A_cs];
                double a110 = elems[A112];
                double a111 = elems[A112 += A_cs];
                double a120 = elems[A122];
                double a121 = elems[A122 += A_cs];
                double a200 = elems[A202];
                double a201 = elems[A202 += A_cs];
                double a210 = elems[A212];
                double a211 = elems[A212 += A_cs];
                double a220 = elems[A222];
                double a221 = elems[A222 += A_cs];
                int B11 = B_index;
                int j = 1;
                while (j < c) {
                    double a002 = elems[A002 += A_cs];
                    double a012 = elems[A012 += A_cs];
                    double a022 = elems[A022 += A_cs];
                    double a102 = elems[A102 += A_cs];
                    double a112 = elems[A112 += A_cs];
                    double a122 = elems[A122 += A_cs];
                    double a202 = elems[A202 += A_cs];
                    double a212 = elems[A212 += A_cs];
                    double a222 = elems[A222 += A_cs];
                    B_elems[B11] = function.apply(a000, a001, a002, a010, a011, a012, a020, a021, a022, a100, a101, a102, a110, a111, a112, a120, a121, a122, a200, a201, a202, a210, a211, a212, a220, a221, a222);
                    B11 += B_cs;
                    a000 = a001;
                    a001 = a002;
                    a010 = a011;
                    a011 = a012;
                    a020 = a021;
                    a021 = a022;
                    a100 = a101;
                    a101 = a102;
                    a110 = a111;
                    a111 = a112;
                    a120 = a121;
                    a121 = a122;
                    a200 = a201;
                    a201 = a202;
                    a210 = a211;
                    a211 = a212;
                    a220 = a221;
                    a221 = a222;
                    ++j;
                }
                A_index += A_rs;
                B_index += B_rs;
                ++i;
            }
            ++k;
        }
    }

    @Override
    public double zSum() {
        double sum = 0.0;
        final int zero = (int)this.index(0, 0, 0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double sum = 0.0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < DenseDoubleMatrix3D.this.rows) {
                                int idx = zero + s * DenseDoubleMatrix3D.this.sliceStride + r * DenseDoubleMatrix3D.this.rowStride;
                                int c = 0;
                                while (c < DenseDoubleMatrix3D.this.columns) {
                                    sum += DenseDoubleMatrix3D.this.elements[idx];
                                    idx += DenseDoubleMatrix3D.this.columnStride;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    sum += ((Double)futures[j].get()).doubleValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int idx = zero + s * this.sliceStride + r * this.rowStride;
                    int c = 0;
                    while (c < this.columns) {
                        sum += this.elements[idx];
                        idx += this.columnStride;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return sum;
    }

    @Override
    protected boolean haveSharedCellsRaw(DoubleMatrix3D other) {
        if (other instanceof SelectedDenseDoubleMatrix3D) {
            SelectedDenseDoubleMatrix3D otherMatrix = (SelectedDenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseDoubleMatrix3D) {
            DenseDoubleMatrix3D otherMatrix = (DenseDoubleMatrix3D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected DoubleMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        return new DenseDoubleMatrix2D(rows, columns, this.elements, rowZero, columnZero, rowStride, columnStride, true);
    }

    @Override
    protected DoubleMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseDoubleMatrix3D(this.elements, sliceOffsets, rowOffsets, columnOffsets, 0);
    }
}

