/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2DProcedure;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class FComplexMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected FComplexMatrix3D() {
    }

    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = d;
                                while (c < FComplexMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(FComplexMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public float[] aggregate(final FComplexMatrix3D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        this.checkShape(other);
        float[] b = new float[2];
        if (this.size() == 0L) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] a = f.apply(FComplexMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = d;
                                while (c < FComplexMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(FComplexMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public FComplexMatrix3D assign(final FComplexFComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, function.apply(FComplexMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexRealFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] tmp = new float[2];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    tmp[0] = function.apply(FComplexMatrix3D.this.getQuick(s, r, c));
                                    FComplexMatrix3D.this.setQuick(s, r, c, tmp);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        tmp[0] = function.apply(this.getQuick(s, r, c));
                        this.setQuick(s, r, c, tmp);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure cond, final FComplexFComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    float[] elem = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        FComplexMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        float[] elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, f.apply(elem));
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexProcedure cond, final float[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    float[] elem = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        FComplexMatrix3D.this.setQuick(s, r, c, value);
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        float[] elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, value);
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(FComplexMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final FComplexMatrix3D B = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, B.getQuick(s, r, c));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, B.getQuick(s, r, c));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final FComplexMatrix3D y, final FComplexFComplexFComplexFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, function.apply(FComplexMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float re, final float im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, re, im);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[] values) {
        if (values.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstSlice * FComplexMatrix3D.this.rows * FComplexMatrix3D.this.columns * 2;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, values[idx], values[idx + 1]);
                                    idx += 2;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, values[idx], values[idx + 1]);
                        idx += 2;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assign(final float[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            float[][] currentSlice = values[s];
                            if (currentSlice.length != FComplexMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + FComplexMatrix3D.this.rows());
                            }
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                float[] currentRow = currentSlice[r];
                                if (currentRow.length != 2 * FComplexMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * FComplexMatrix3D.this.columns());
                                }
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    FComplexMatrix3D.this.setQuick(s, r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                float[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = currentSlice[r];
                    if (currentRow.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "2*columns()=" + 2 * this.columns());
                    }
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, currentRow[2 * c], currentRow[2 * c + 1]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assignImaginary(final FloatMatrix3D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    float re = FComplexMatrix3D.this.getQuick(s, r, c)[0];
                                    float im = other.getQuick(s, r, c);
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        float re = this.getQuick(s, r, c)[0];
                        float im = other.getQuick(s, r, c);
                        this.setQuick(s, r, c, re, im);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public FComplexMatrix3D assignReal(final FloatMatrix3D other) {
        this.checkShape(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    float re = other.getQuick(s, r, c);
                                    float im = FComplexMatrix3D.this.getQuick(s, r, c)[1];
                                    FComplexMatrix3D.this.setQuick(s, r, c, re, im);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        float re = other.getQuick(s, r, c);
                        float im = this.getQuick(s, r, c)[1];
                        this.setQuick(s, r, c, re, im);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        float[] tmp = new float[2];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    tmp = FComplexMatrix3D.this.getQuick(s, r, c);
                                    if ((double)tmp[0] != 0.0 || (double)tmp[1] != 0.0) {
                                        ++cardinality;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            float[] tmp = new float[2];
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        tmp = this.getQuick(s, r, c);
                        if (tmp[0] != 0.0f || tmp[1] != 0.0f) {
                            ++cardinality;
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public FComplexMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(float[] value) {
        return FComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FComplexMatrix3D)) {
            return false;
        }
        return FComplexProperty.DEFAULT.equals(this, (FComplexMatrix3D)obj);
    }

    public float[] get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    public abstract Object elements();

    public abstract FloatMatrix3D getImaginaryPart();

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, ArrayList<float[]> valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    float[] value = this.getQuick(s, r, c);
                    if (value[0] != 0.0f || value[1] != 0.0f) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public abstract float[] getQuick(int var1, int var2, int var3);

    public abstract FloatMatrix3D getRealPart();

    public FComplexMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract FComplexMatrix3D like(int var1, int var2, int var3);

    public void set(int slice, int row, int column, float[] value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public void set(int slice, int row, int column, float re, float im) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, re, im);
    }

    public abstract void setQuick(int var1, int var2, int var3, float var4, float var5);

    public abstract void setQuick(int var1, int var2, int var3, float[] var4);

    public float[][][] toArray() {
        final float[][][] values = new float[this.slices][this.rows][2 * this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] tmp = new float[2];
                        int s = firstSlice;
                        while (s < lastSlice) {
                            float[][] currentSlice = values[s];
                            int r = 0;
                            while (r < FComplexMatrix3D.this.rows) {
                                float[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < FComplexMatrix3D.this.columns) {
                                    tmp = FComplexMatrix3D.this.getQuick(s, r, c);
                                    currentRow[2 * c] = tmp[0];
                                    currentRow[2 * c + 1] = tmp[1];
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            int s = 0;
            while (s < this.slices) {
                float[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    float[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        tmp = this.getQuick(s, r, c);
                        currentRow[2 * c] = tmp[0];
                        currentRow[2 * c + 1] = tmp[1];
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer sb = new StringBuffer(String.format("ComplexMatrix3D: %d slices, %d rows, %d columns\n\n", this.slices, this.rows, this.columns));
        float[] elem = new float[2];
        int s = 0;
        while (s < this.slices) {
            sb.append(String.format("(:,:,%d)=\n", s));
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    elem = this.getQuick(s, r, c);
                    if (elem[1] == 0.0f) {
                        sb.append(String.format(String.valueOf(format) + "\t", Float.valueOf(elem[0])));
                    } else if (elem[0] == 0.0f) {
                        sb.append(String.format(String.valueOf(format) + "i\t", Float.valueOf(elem[1])));
                    } else if (elem[1] < 0.0f) {
                        sb.append(String.format(String.valueOf(format) + " - " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(-elem[1])));
                    } else {
                        sb.append(String.format(String.valueOf(format) + " + " + format + "i\t", Float.valueOf(elem[0]), Float.valueOf(elem[1])));
                    }
                    ++c;
                }
                sb.append("\n");
                ++r;
            }
            ++s;
        }
        return sb.toString();
    }

    public abstract FComplexMatrix1D vectorize();

    public FComplexMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewColumnFlip() {
        return (FComplexMatrix3D)this.view().vColumnFlip();
    }

    public FComplexMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (FComplexMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public FComplexMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (FComplexMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public FComplexMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewRowFlip() {
        return (FComplexMatrix3D)this.view().vRowFlip();
    }

    public FComplexMatrix3D viewSelection(FComplexMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.slices) {
            if (condition.apply(this.viewSlice(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    public FComplexMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < sliceIndexes.length) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    public FComplexMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public FComplexMatrix3D viewSliceFlip() {
        return (FComplexMatrix3D)this.view().vSliceFlip();
    }

    public FComplexMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (FComplexMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    public float[] zSum() {
        if (this.size() == 0L) {
            return new float[2];
        }
        return this.aggregate(FComplexFunctions.plus, FComplexFunctions.identity);
    }

    protected FComplexMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(FComplexMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(FComplexMatrix3D other) {
        return false;
    }

    protected abstract FComplexMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected FComplexMatrix3D view() {
        return (FComplexMatrix3D)this.clone();
    }

    protected abstract FComplexMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public abstract FComplexMatrix2D like2D(int var1, int var2);
}

