/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.IntIntFComplexFunction;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.algo.FComplexProperty;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.WrapperFComplexMatrix2D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import cern.jet.math.tfcomplex.FComplexPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DiagonalFComplexMatrix2D
extends WrapperFComplexMatrix2D {
    private static final long serialVersionUID = 1L;
    protected float[] elements;
    protected int dlength;
    protected int dindex;

    public DiagonalFComplexMatrix2D(float[][] values, int dindex) {
        this(values.length, values.length == 0 ? 0 : values[0].length, dindex);
        this.assign(values);
    }

    public DiagonalFComplexMatrix2D(int rows, int columns, int dindex) {
        int diff;
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (dindex < -rows + 1 || dindex > columns - 1) {
            throw new IllegalArgumentException("index is out of bounds");
        }
        this.dindex = dindex;
        this.dlength = dindex == 0 ? Math.min(rows, columns) : (dindex > 0 ? (rows >= columns ? columns - dindex : (dindex <= (diff = columns - rows) ? rows : rows - (dindex - diff))) : (rows >= columns ? (-dindex <= (diff = rows - columns) ? columns : columns + dindex + diff) : rows + dindex));
        this.elements = new float[2 * this.dlength];
    }

    @Override
    public FComplexMatrix2D assign(FComplexFComplexFunction function) {
        if (function instanceof FComplexMult) {
            float[] alpha = ((FComplexMult)function).multiplicator;
            if (alpha[0] == 1.0f && alpha[1] == 0.0f) {
                return this;
            }
            if (alpha[0] == 0.0f && alpha[1] == 0.0f) {
                return this.assign(alpha);
            }
            if (alpha[0] != alpha[0] || alpha[1] != alpha[1]) {
                return this.assign(alpha);
            }
            float[] elem = new float[2];
            int j = 0;
            while (j < this.dlength) {
                elem[0] = this.elements[2 * j];
                elem[1] = this.elements[2 * j + 1];
                elem = FComplex.mult(elem, alpha);
                this.elements[2 * j] = elem[0];
                this.elements[2 * j + 1] = elem[1];
                ++j;
            }
        } else {
            float[] elem = new float[2];
            int j = 0;
            while (j < this.dlength) {
                elem[0] = this.elements[2 * j];
                elem[1] = this.elements[2 * j + 1];
                elem = function.apply(elem);
                this.elements[2 * j] = elem[0];
                this.elements[2 * j + 1] = elem[1];
                ++j;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(float re, float im) {
        int j = 0;
        while (j < this.dlength) {
            this.elements[2 * j] = re;
            this.elements[2 * j + 1] = im;
            ++j;
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(final float[] values) {
        if (values.length != 2 * this.dlength) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + " 2*dlength=" + 2 * this.dlength);
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DiagonalFComplexMatrix2D.this.elements[2 * i] = values[2 * i];
                            DiagonalFComplexMatrix2D.this.elements[2 * i + 1] = values[2 * i + 1];
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.dlength) {
                this.elements[2 * i] = values[2 * i];
                this.elements[2 * i + 1] = values[2 * i + 1];
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(float[][] values) {
        int c;
        int r;
        if (values.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + values.length + "rows()=" + this.rows());
        }
        if (this.dindex >= 0) {
            r = 0;
            c = this.dindex;
        } else {
            r = -this.dindex;
            c = 0;
        }
        int i = 0;
        while (i < this.dlength) {
            if (values[i].length != 2 * this.columns) {
                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + values[r].length + "2 * columns()=" + 2 * this.columns());
            }
            this.elements[2 * i] = values[r][2 * c];
            this.elements[2 * i + 1] = values[r][2 * c + 1];
            ++c;
            ++r;
            ++i;
        }
        return this;
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D other = (DiagonalFComplexMatrix2D)source;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("source is DiagonalFComplexMatrix2D with different diagonal stored.");
            }
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        return super.assign(source);
    }

    @Override
    public FComplexMatrix2D assign(FComplexMatrix2D y, final FComplexFComplexFComplexFunction function) {
        this.checkShape(y);
        if (y instanceof DiagonalFComplexMatrix2D) {
            float[] alpha;
            DiagonalFComplexMatrix2D other = (DiagonalFComplexMatrix2D)y;
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                throw new IllegalArgumentException("y is DiagonalFComplexMatrix2D with different diagonal stored.");
            }
            if (function instanceof FComplexPlusMultSecond && (alpha = ((FComplexPlusMultSecond)function).multiplicator)[0] == 0.0f && alpha[1] == 0.0f) {
                return this;
            }
            final float[] otherElements = other.elements;
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, this.dlength);
                Future[] futures = new Future[nthreads];
                int k = this.dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (function instanceof FComplexPlusMultSecond) {
                                float[] alpha = ((FComplexPlusMultSecond)function).multiplicator;
                                if (alpha[0] == 1.0f && alpha[1] == 0.0f) {
                                    int j = firstIdx;
                                    while (j < lastIdx) {
                                        int n = 2 * j;
                                        DiagonalFComplexMatrix2D.this.elements[n] = DiagonalFComplexMatrix2D.this.elements[n] + otherElements[2 * j];
                                        int n2 = 2 * j + 1;
                                        DiagonalFComplexMatrix2D.this.elements[n2] = DiagonalFComplexMatrix2D.this.elements[n2] + otherElements[2 * j + 1];
                                        ++j;
                                    }
                                } else {
                                    float[] elem = new float[2];
                                    int j = firstIdx;
                                    while (j < lastIdx) {
                                        elem[0] = otherElements[2 * j];
                                        elem[1] = otherElements[2 * j + 1];
                                        elem = FComplex.mult(alpha, elem);
                                        int n = 2 * j;
                                        DiagonalFComplexMatrix2D.this.elements[n] = DiagonalFComplexMatrix2D.this.elements[n] + elem[0];
                                        int n3 = 2 * j + 1;
                                        DiagonalFComplexMatrix2D.this.elements[n3] = DiagonalFComplexMatrix2D.this.elements[n3] + elem[1];
                                        ++j;
                                    }
                                }
                            } else if (function == FComplexFunctions.mult) {
                                float[] elem = new float[2];
                                float[] otherElem = new float[2];
                                int j = firstIdx;
                                while (j < lastIdx) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalFComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalFComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = FComplex.mult(elem, otherElem);
                                    DiagonalFComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                    ++j;
                                }
                            } else if (function == FComplexFunctions.div) {
                                float[] elem = new float[2];
                                float[] otherElem = new float[2];
                                int j = firstIdx;
                                while (j < lastIdx) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalFComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalFComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = FComplex.div(elem, otherElem);
                                    DiagonalFComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                    ++j;
                                }
                            } else {
                                float[] elem = new float[2];
                                float[] otherElem = new float[2];
                                int j = firstIdx;
                                while (j < lastIdx) {
                                    otherElem[0] = otherElements[2 * j];
                                    otherElem[1] = otherElements[2 * j + 1];
                                    elem[0] = DiagonalFComplexMatrix2D.this.elements[2 * j];
                                    elem[1] = DiagonalFComplexMatrix2D.this.elements[2 * j + 1];
                                    elem = function.apply(elem, otherElem);
                                    DiagonalFComplexMatrix2D.this.elements[2 * j] = elem[0];
                                    DiagonalFComplexMatrix2D.this.elements[2 * j + 1] = elem[1];
                                    ++j;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else if (function instanceof FComplexPlusMultSecond) {
                float[] alpha2 = ((FComplexPlusMultSecond)function).multiplicator;
                if (alpha2[0] == 1.0f && alpha2[1] == 0.0f) {
                    int j = 0;
                    while (j < this.dlength) {
                        int n = 2 * j;
                        this.elements[n] = this.elements[n] + otherElements[2 * j];
                        int n2 = 2 * j + 1;
                        this.elements[n2] = this.elements[n2] + otherElements[2 * j + 1];
                        ++j;
                    }
                } else {
                    float[] elem = new float[2];
                    int j = 0;
                    while (j < this.dlength) {
                        elem[0] = otherElements[2 * j];
                        elem[1] = otherElements[2 * j + 1];
                        elem = FComplex.mult(alpha2, elem);
                        int n = 2 * j;
                        this.elements[n] = this.elements[n] + elem[0];
                        int n3 = 2 * j + 1;
                        this.elements[n3] = this.elements[n3] + elem[1];
                        ++j;
                    }
                }
            } else if (function == FComplexFunctions.mult) {
                float[] elem = new float[2];
                float[] otherElem = new float[2];
                int j = 0;
                while (j < this.dlength) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = FComplex.mult(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                    ++j;
                }
            } else if (function == FComplexFunctions.div) {
                float[] elem = new float[2];
                float[] otherElem = new float[2];
                int j = 0;
                while (j < this.dlength) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = FComplex.div(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                    ++j;
                }
            } else {
                float[] elem = new float[2];
                float[] otherElem = new float[2];
                int j = 0;
                while (j < this.dlength) {
                    otherElem[0] = otherElements[2 * j];
                    otherElem[1] = otherElements[2 * j + 1];
                    elem[0] = this.elements[2 * j];
                    elem[1] = this.elements[2 * j + 1];
                    elem = function.apply(elem, otherElem);
                    this.elements[2 * j] = elem[0];
                    this.elements[2 * j + 1] = elem[1];
                    ++j;
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.dlength);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.dlength / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.dlength : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (DiagonalFComplexMatrix2D.this.elements[2 * i] != 0.0f || DiagonalFComplexMatrix2D.this.elements[2 * i + 1] != 0.0f) {
                                ++cardinality;
                            }
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < this.dlength) {
                if (this.elements[2 * i] != 0.0f || this.elements[2 * i + 1] != 0.0f) {
                    ++cardinality;
                }
                ++i;
            }
        }
        return cardinality;
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public boolean equals(float[] value) {
        float epsilon = FComplexProperty.DEFAULT.tolerance();
        float[] x = new float[2];
        float[] diff = new float[2];
        int i = 0;
        while (i < this.dlength) {
            x[0] = this.elements[2 * i];
            x[1] = this.elements[2 * i + 1];
            diff[0] = Math.abs(value[0] - x[0]);
            diff[1] = Math.abs(value[1] - x[1]);
            if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                diff[0] = 0.0f;
                diff[1] = 0.0f;
            }
            if (diff[0] > epsilon || diff[1] > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DiagonalFComplexMatrix2D) {
            DiagonalFComplexMatrix2D other = (DiagonalFComplexMatrix2D)obj;
            float epsilon = FComplexProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            int rows = this.rows();
            int columns = this.columns();
            if (columns != other.columns() || rows != other.rows()) {
                return false;
            }
            if (this.dindex != other.dindex || this.dlength != other.dlength) {
                return false;
            }
            float[] otherElements = other.elements;
            float[] x = new float[2];
            float[] value = new float[2];
            float[] diff = new float[2];
            int i = 0;
            while (i < this.dlength) {
                x[0] = this.elements[2 * i];
                x[1] = this.elements[2 * i + 1];
                value[0] = otherElements[2 * i];
                value[1] = otherElements[2 * i + 1];
                diff[0] = Math.abs(value[0] - x[0]);
                diff[1] = Math.abs(value[1] - x[1]);
                if (!((diff[0] == diff[0] && diff[1] == diff[1] || value[0] == value[0] && value[1] == value[1] || x[0] == x[0] && x[1] == x[1]) && !FComplex.isEqual(value, x, epsilon))) {
                    diff[0] = 0.0f;
                    diff[1] = 0.0f;
                }
                if (diff[0] > epsilon || diff[1] > epsilon) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public FComplexMatrix2D forEachNonZero(IntIntFComplexFunction function) {
        float[] value = new float[2];
        int i = 0;
        while (i < this.dlength) {
            value[0] = this.elements[2 * i];
            value[1] = this.elements[2 * i + 1];
            if (value[0] != 0.0f || value[1] != 0.0f) {
                value = function.apply(i, i, value);
                this.elements[2 * i] = value[0];
                this.elements[2 * i + 1] = value[1];
            }
            ++i;
        }
        return this;
    }

    public int diagonalLength() {
        return this.dlength;
    }

    public int diagonalIndex() {
        return this.dindex;
    }

    @Override
    public float[] getQuick(int row, int column) {
        if (this.dindex >= 0) {
            if (column < this.dindex) {
                return new float[2];
            }
            if (row < this.dlength && row + this.dindex == column) {
                return new float[]{this.elements[2 * row], this.elements[2 * row + 1]};
            }
            return new float[2];
        }
        if (row < -this.dindex) {
            return new float[2];
        }
        if (column < this.dlength && row + this.dindex == column) {
            return new float[]{this.elements[2 * column], this.elements[2 * column + 1]};
        }
        return new float[2];
    }

    @Override
    public FComplexMatrix2D like(int rows, int columns) {
        return new SparseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix1D like1D(int size) {
        return new SparseFComplexMatrix1D(size);
    }

    @Override
    public void setQuick(int row, int column, float[] value) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[2 * row] = value[0];
                this.elements[2 * row + 1] = value[1];
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[2 * column] = value[0];
            this.elements[2 * column + 1] = value[1];
        }
    }

    @Override
    public void setQuick(int row, int column, float re, float im) {
        if (this.dindex >= 0) {
            if (column >= this.dindex && row < this.dlength && row + this.dindex == column) {
                this.elements[2 * row] = re;
                this.elements[2 * row + 1] = im;
            }
        } else if (row >= -this.dindex && column < this.dlength && row + this.dindex == column) {
            this.elements[2 * column] = re;
            this.elements[2 * column + 1] = im;
        }
    }

    @Override
    public FComplexMatrix1D zMult(FComplexMatrix1D y, FComplexMatrix1D z, float[] alpha, float[] beta, boolean transposeA) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        boolean bl = ignore = z == null;
        if (z == null) {
            z = new DenseFComplexMatrix1D(rowsA);
        }
        if (!(this.isNoView && y instanceof DenseFComplexMatrix1D && z instanceof DenseFComplexMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        if (!(ignore || beta[0] == 1.0f && beta[1] == 0.0f)) {
            z.assign(FComplexFunctions.mult(beta));
        }
        DenseFComplexMatrix1D zz = (DenseFComplexMatrix1D)z;
        float[] elementsZ = zz.elements;
        int strideZ = zz.stride();
        int zeroZ = (int)z.index(0);
        DenseFComplexMatrix1D yy = (DenseFComplexMatrix1D)y;
        float[] elementsY = yy.elements;
        int strideY = yy.stride();
        int zeroY = (int)y.index(0);
        if (elementsY == null || elementsZ == null) {
            throw new InternalError();
        }
        float[] elemA = new float[2];
        float[] elemY = new float[2];
        if (!transposeA) {
            if (this.dindex >= 0) {
                int i = 0;
                while (i < this.dlength) {
                    elemA[0] = this.elements[2 * i];
                    elemA[1] = this.elements[2 * i + 1];
                    elemY[0] = elementsY[2 * this.dindex + zeroY + strideY * i];
                    elemY[1] = elementsY[2 * this.dindex + zeroY + strideY * i + 1];
                    elemA = FComplex.mult(elemA, elemY);
                    elemA = FComplex.mult(alpha, elemA);
                    int n = zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + elemA[0];
                    int n2 = zeroZ + strideZ * i + 1;
                    elementsZ[n2] = elementsZ[n2] + elemA[1];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.dlength) {
                    elemA[0] = this.elements[2 * i];
                    elemA[1] = this.elements[2 * i + 1];
                    elemY[0] = elementsY[zeroY + strideY * i];
                    elemY[1] = elementsY[zeroY + strideY * i + 1];
                    elemA = FComplex.mult(elemA, elemY);
                    elemA = FComplex.mult(alpha, elemA);
                    int n = -2 * this.dindex + zeroZ + strideZ * i;
                    elementsZ[n] = elementsZ[n] + elemA[0];
                    int n3 = -2 * this.dindex + zeroZ + strideZ * i + 1;
                    elementsZ[n3] = elementsZ[n3] + elemA[1];
                    ++i;
                }
            }
        } else if (this.dindex >= 0) {
            int i = 0;
            while (i < this.dlength) {
                elemA[0] = this.elements[2 * i];
                elemA[1] = -this.elements[2 * i + 1];
                elemY[0] = elementsY[zeroY + strideY * i];
                elemY[1] = elementsY[zeroY + strideY * i + 1];
                elemA = FComplex.mult(elemA, elemY);
                elemA = FComplex.mult(alpha, elemA);
                int n = 2 * this.dindex + zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + elemA[0];
                int n4 = 2 * this.dindex + zeroZ + strideZ * i + 1;
                elementsZ[n4] = elementsZ[n4] + elemA[1];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.dlength) {
                elemA[0] = this.elements[2 * i];
                elemA[1] = -this.elements[2 * i + 1];
                elemY[0] = elementsY[-2 * this.dindex + zeroY + strideY * i];
                elemY[1] = elementsY[-2 * this.dindex + zeroY + strideY * i + 1];
                elemA = FComplex.mult(elemA, elemY);
                elemA = FComplex.mult(alpha, elemA);
                int n = zeroZ + strideZ * i;
                elementsZ[n] = elementsZ[n] + elemA[0];
                int n5 = zeroZ + strideZ * i + 1;
                elementsZ[n5] = elementsZ[n5] + elemA[1];
                ++i;
            }
        }
        return z;
    }

    @Override
    protected FComplexMatrix2D getContent() {
        return this;
    }
}

