/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.list.tfloat.AbstractFloatList;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;

public class FloatFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatFactory1D dense = new FloatFactory1D();
    public static final FloatFactory1D sparse = new FloatFactory1D();

    protected FloatFactory1D() {
    }

    public FloatMatrix1D append(FloatMatrix1D A, FloatMatrix1D B) {
        FloatMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public FloatMatrix1D ascending(int size) {
        return this.descending(size).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(size)));
    }

    public FloatMatrix1D descending(int size) {
        FloatMatrix1D matrix = this.make(size);
        int v = 0;
        int i = size;
        while (--i >= 0) {
            matrix.setQuick(i, v++);
        }
        return matrix;
    }

    public FloatMatrix1D make(AbstractFloatList values) {
        int size = values.size();
        FloatMatrix1D vector = this.make(size);
        int i = size;
        while (--i >= 0) {
            vector.set(i, values.get(i));
        }
        return vector;
    }

    public FloatMatrix1D make(float[] values) {
        if (this == sparse) {
            return new SparseFloatMatrix1D(values);
        }
        return new DenseFloatMatrix1D(values);
    }

    public FloatMatrix1D make(FloatMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        int i = 0;
        while (i < parts.length) {
            size = (int)((long)size + parts[i].size());
            ++i;
        }
        FloatMatrix1D vector = this.make(size);
        size = 0;
        int i2 = 0;
        while (i2 < parts.length) {
            vector.viewPart(size, (int)parts[i2].size()).assign(parts[i2]);
            size = (int)((long)size + parts[i2].size());
            ++i2;
        }
        return vector;
    }

    public FloatMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseFloatMatrix1D(size);
        }
        return new DenseFloatMatrix1D(size);
    }

    public FloatMatrix1D make(int size, float initialValue) {
        return this.make(size).assign(initialValue);
    }

    public FloatMatrix1D random(int size) {
        return this.make(size).assign(FloatFunctions.random());
    }

    public FloatMatrix1D repeat(FloatMatrix1D A, int repeat) {
        int size = (int)A.size();
        FloatMatrix1D matrix = this.make(repeat * size);
        int i = repeat;
        while (--i >= 0) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public FloatMatrix1D sample(int size, float value, float nonZeroFraction) {
        float epsilon = 1.0E-5f;
        if (nonZeroFraction < 0.0f - epsilon || nonZeroFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0f) {
            nonZeroFraction = 0.0f;
        }
        if (nonZeroFraction > 1.0f) {
            nonZeroFraction = 1.0f;
        }
        FloatMatrix1D matrix = this.make(size);
        int n = Math.round((float)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        FloatRandomSamplingAssistant sampler = new FloatRandomSamplingAssistant(n, size, new FloatMersenneTwister());
        int i = size;
        while (--i >= 0) {
            if (!sampler.sampleNextElement()) continue;
            matrix.setQuick(i, value);
        }
        return matrix;
    }

    public FloatArrayList toList(FloatMatrix1D values) {
        int size = (int)values.size();
        FloatArrayList list = new FloatArrayList(size);
        list.setSize(size);
        int i = size;
        while (--i >= 0) {
            list.setQuick(i, values.get(i));
        }
        return list;
    }
}

