/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.Timer;
import cern.colt.function.tfloat.FloatComparator;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatFactory3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.FloatFormatter;
import cern.colt.matrix.tfloat.algo.FloatMatrix1DComparator;
import cern.colt.matrix.tfloat.algo.FloatMatrix2DComparator;
import cern.colt.matrix.tfloat.algo.FloatStatistic;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FRand;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import hep.aida.tfloat.bin.FloatBinFunction1D;
import hep.aida.tfloat.bin.FloatBinFunctions1D;

public class FloatSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatSorting quickSort = new FloatSorting();
    public static final FloatSorting mergeSort = new FloatSorting(){
        private static final long serialVersionUID = 1L;

        @Override
        protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
            Sorting.mergeSort(a, fromIndex, toIndex, c);
        }

        @Override
        protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
            GenericSorting.mergeSort(fromIndex, toIndex, c, swapper);
        }
    };

    protected FloatSorting() {
    }

    private static final int compareNaN(float a, float b) {
        if (a != a) {
            if (b != b) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    protected void runSort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        Sorting.parallelQuickSort(a, fromIndex, toIndex, c);
    }

    protected void runSort(int fromIndex, int toIndex, IntComparator c, Swapper swapper) {
        GenericSorting.quickSort(fromIndex, toIndex, c, swapper);
    }

    public FloatMatrix1D sort(FloatMatrix1D vector) {
        return vector.viewSelection(this.sortIndex(vector));
    }

    public int[] sortIndex(final FloatMatrix1D vector) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseFloatMatrix1D) {
            final float[] velems = (float[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                @Override
                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    float av = velems[idxa];
                    float bv = velems[idxb];
                    if (av != av || bv != bv) {
                        return FloatSorting.compareNaN(av, bv);
                    }
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        } else {
            comp = new IntComparator(){

                @Override
                public int compare(int a, int b) {
                    float av = vector.getQuick(a);
                    float bv = vector.getQuick(b);
                    if (av != av || bv != bv) {
                        return FloatSorting.compareNaN(av, bv);
                    }
                    return av < bv ? -1 : (av == bv ? 0 : 1);
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public int[] sortIndex(FloatMatrix1D vector, IntComparator comp) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public FloatMatrix1D sort(FloatMatrix1D vector, FloatComparator c) {
        return vector.viewSelection(this.sortIndex(vector, c));
    }

    public int[] sortIndex(final FloatMatrix1D vector, final FloatComparator c) {
        int[] indexes = new int[(int)vector.size()];
        int i = indexes.length;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = null;
        if (vector instanceof DenseFloatMatrix1D) {
            final float[] velems = (float[])vector.elements();
            final int zero = (int)vector.index(0);
            final int stride = vector.stride();
            comp = new IntComparator(){

                @Override
                public int compare(int a, int b) {
                    int idxa = zero + a * stride;
                    int idxb = zero + b * stride;
                    return c.compare(velems[idxa], velems[idxb]);
                }
            };
        } else {
            comp = new IntComparator(){

                @Override
                public int compare(int a, int b) {
                    return c.compare(vector.getQuick(a), vector.getQuick(b));
                }
            };
        }
        this.runSort(indexes, 0, indexes.length, comp);
        return indexes;
    }

    public FloatMatrix2D sort(FloatMatrix2D matrix, final float[] aggregates) {
        int rows = matrix.rows();
        if (aggregates.length != rows) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] indexes = new int[rows];
        int i = rows;
        while (--i >= 0) {
            indexes[i] = i;
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int x, int y) {
                float a = aggregates[x];
                float b = aggregates[y];
                if (a != a || b != b) {
                    return FloatSorting.compareNaN(a, b);
                }
                return a < b ? -1 : (a == b ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int x, int y) {
                int t1 = indexes[x];
                indexes[x] = indexes[y];
                indexes[y] = t1;
                float t2 = aggregates[x];
                aggregates[x] = aggregates[y];
                aggregates[y] = t2;
            }
        };
        this.runSort(0, rows, comp, swapper);
        return matrix.viewSelection(indexes, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D matrix, int column) {
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final FloatMatrix1D col = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                float av = col.getQuick(a);
                float bv = col.getQuick(b);
                if (av != av || bv != bv) {
                    return FloatSorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D matrix, final FloatMatrix1DComparator c) {
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        final FloatMatrix1D[] views = new FloatMatrix1D[matrix.rows()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewRow(i2);
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(rowIndexes, 0, rowIndexes.length, comp);
        return matrix.viewSelection(rowIndexes, null);
    }

    public FloatMatrix2D sort(FloatMatrix2D matrix, FloatBinFunction1D aggregate) {
        FloatMatrix2D tmp = matrix.like(1, matrix.rows());
        FloatBinFunction1D[] func = new FloatBinFunction1D[]{aggregate};
        FloatStatistic.aggregate(matrix.viewDice(), func, tmp);
        float[] aggr = tmp.viewRow(0).toArray();
        return this.sort(matrix, aggr);
    }

    public FloatMatrix3D sort(FloatMatrix3D matrix, int row, int column) {
        if (row < 0 || row >= matrix.rows()) {
            throw new IndexOutOfBoundsException("row=" + row + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IndexOutOfBoundsException("column=" + column + ", matrix=" + AbstractFormatter.shape(matrix));
        }
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final FloatMatrix1D sliceView = matrix.viewRow(row).viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                float av = sliceView.getQuick(a);
                float bv = sliceView.getQuick(b);
                if (av != av || bv != bv) {
                    return FloatSorting.compareNaN(av, bv);
                }
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public FloatMatrix3D sort(FloatMatrix3D matrix, final FloatMatrix2DComparator c) {
        int[] sliceIndexes = new int[matrix.slices()];
        int i = sliceIndexes.length;
        while (--i >= 0) {
            sliceIndexes[i] = i;
        }
        final FloatMatrix2D[] views = new FloatMatrix2D[matrix.slices()];
        int i2 = views.length;
        while (--i2 >= 0) {
            views[i2] = matrix.viewSlice(i2);
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return c.compare(views[a], views[b]);
            }
        };
        this.runSort(sliceIndexes, 0, sliceIndexes.length, comp);
        return matrix.viewSelection(sliceIndexes, null, null);
    }

    public static void zdemo1() {
        FloatSorting sort = quickSort;
        FloatMatrix2D matrix = FloatFactory2D.dense.descending(4, 3);
        FloatMatrix1DComparator comp = new FloatMatrix1DComparator(){

            @Override
            public int compare(FloatMatrix1D a, FloatMatrix1D b) {
                float bs;
                float as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo2() {
        FloatSorting sort = quickSort;
        FloatMatrix3D matrix = FloatFactory3D.dense.descending(4, 3, 2);
        FloatMatrix2DComparator comp = new FloatMatrix2DComparator(){

            @Override
            public int compare(FloatMatrix2D a, FloatMatrix2D b) {
                float bs;
                float as = a.zSum();
                return as < (bs = b.zSum()) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        System.out.println("sorted  :" + sort.sort(matrix, comp));
    }

    public static void zdemo3() {
        FloatSorting sort = quickSort;
        float[] values = new float[]{0.5f, 1.5f, 2.5f, 3.5f};
        DenseFloatMatrix1D matrix = new DenseFloatMatrix1D(values);
        FloatComparator comp = new FloatComparator(){

            @Override
            public int compare(float a, float b) {
                float bs;
                float as = (float)Math.sin(a);
                return as < (bs = (float)Math.sin(b)) ? -1 : (as == bs ? 0 : 1);
            }
        };
        System.out.println("unsorted:" + matrix);
        FloatMatrix1D sorted = sort.sort(matrix, comp);
        System.out.println("sorted  :" + sorted);
        sorted.assign(FloatFunctions.sin);
        System.out.println("sined  :" + sorted);
    }

    protected static void zdemo4() {
        float[] values1 = new float[]{0.0f, 1.0f, 2.0f, 3.0f};
        float[] values2 = new float[]{0.0f, 2.0f, 4.0f, 6.0f};
        DenseFloatMatrix1D matrix1 = new DenseFloatMatrix1D(values1);
        DenseFloatMatrix1D matrix2 = new DenseFloatMatrix1D(values2);
        System.out.println("m1:" + matrix1);
        System.out.println("m2:" + matrix2);
        ((FloatMatrix1D)matrix1).assign(matrix2, FloatFunctions.pow);
        System.out.println("applied:" + matrix1);
    }

    public static void zdemo5(int rows, int columns, boolean print) {
        FloatSorting sort = quickSort;
        System.out.println("\n\n");
        System.out.print("now initializing... ");
        Timer timer = new Timer().start();
        FloatFunctions F = FloatFunctions.functions;
        FloatMatrix2D A = FloatFactory2D.dense.make(rows, columns);
        A.assign(new FRand());
        timer.stop().display();
        FloatMatrix2D B = A.like();
        timer.reset().start();
        System.out.print("now copying... ");
        B.assign(A);
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying subrange... ");
        B.viewPart(0, 0, rows, columns).assign(A.viewPart(0, 0, rows, columns));
        timer.stop().display();
        timer.reset().start();
        System.out.print("now copying selected... ");
        B.viewSelection(null, null).assign(A.viewSelection(null, null));
        timer.stop().display();
        System.out.print("now sorting - quick version with precomputation... ");
        timer.reset().start();
        A = sort.sort(A, FloatBinFunctions1D.median);
        timer.stop().display();
        if (print) {
            int r = Math.min(rows, 5);
            FloatBinFunction1D[] funs = new FloatBinFunction1D[]{FloatBinFunctions1D.median, FloatBinFunctions1D.sumLog, FloatBinFunctions1D.geometricMean};
            String[] rowNames = new String[r];
            String[] columnNames = new String[columns];
            int i = columns;
            while (--i >= 0) {
                columnNames[i] = Integer.toString(i);
            }
            i = r;
            while (--i >= 0) {
                rowNames[i] = Integer.toString(i);
            }
            System.out.println("first part of sorted result = \n" + new FloatFormatter("%G").toTitleString(A.viewPart(0, 0, r, columns), rowNames, columnNames, null, null, null, funs));
        }
        System.out.print("now sorting - slow version... ");
        A = B;
        FloatMatrix1DComparator fun = new FloatMatrix1DComparator(){

            @Override
            public int compare(FloatMatrix1D x, FloatMatrix1D y) {
                float b;
                float a = FloatStatistic.bin(x).median();
                return a < (b = FloatStatistic.bin(y).median()) ? -1 : (a == b ? 0 : 1);
            }
        };
        timer.reset().start();
        A = sort.sort(A, fun);
        timer.stop().display();
    }

    public static void zdemo6() {
        float[][] values = new float[][]{{3.0f, 7.0f, 0.0f}, {2.0f, 1.0f, 0.0f}, {2.0f, 2.0f, 0.0f}, {1.0f, 8.0f, 0.0f}, {2.0f, 5.0f, 0.0f}, {7.0f, 0.0f, 0.0f}, {2.0f, 3.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {4.0f, 0.0f, 0.0f}, {2.0f, 0.0f, 0.0f}};
        FloatMatrix2D A = FloatFactory2D.dense.make(values);
        System.out.println("\n\nunsorted:" + A);
        FloatMatrix2D B = quickSort.sort(A, 1);
        FloatMatrix2D C = quickSort.sort(B, 0);
        System.out.println("quick sorted  :" + C);
        B = mergeSort.sort(A, 1);
        C = mergeSort.sort(B, 0);
        System.out.println("merge sorted  :" + C);
    }

    public static void zdemo7(int rows, int columns, boolean print) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        FloatFunctions F = FloatFunctions.functions;
        FloatMatrix2D A = FloatFactory2D.dense.make(rows, columns);
        A.assign(new FRand());
        float[] v1 = A.viewColumn(0).toArray();
        float[] v2 = A.viewColumn(0).toArray();
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(A, 0);
        timer.stop().display();
        System.out.print("now quick sorting with simple aggregation... ");
        timer.reset().start();
        quickSort.sort(A, v1);
        timer.stop().display();
        System.out.print("now merge sorting with simple aggregation... ");
        timer.reset().start();
        mergeSort.sort(A, v2);
        timer.stop().display();
    }

    public static void zdemo8(int size) {
        System.out.println("\n\n");
        System.out.println("now initializing... ");
        FloatFunctions F = FloatFunctions.functions;
        FloatMatrix1D A = FloatFactory1D.dense.random(size);
        System.out.print("now quick sorting... ");
        Timer timer = new Timer().start();
        quickSort.sort(A);
        timer.stop().display();
        System.out.print("now merge sorting... ");
        timer.reset().start();
        mergeSort.sort(A);
        timer.stop().display();
    }

    public static void main(String[] args) {
        ConcurrencyUtils.setNumberOfThreads((int)2);
        FloatSorting.zdemo8(10000000);
        System.exit(0);
    }
}

