/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatMult;
import cern.jet.math.tfloat.FloatPlusMultSecond;
import java.io.Serializable;

public class DenseFloatLUDecompositionQuick
implements Serializable {
    static final long serialVersionUID = 1020L;
    protected FloatMatrix2D LU;
    protected int pivsign;
    protected int[] piv;
    protected boolean isNonSingular;
    protected DenseFloatAlgebra algebra;
    protected transient float[] workFloat;
    protected transient int[] work1;
    protected transient int[] work2;

    public DenseFloatLUDecompositionQuick() {
        this(FloatProperty.DEFAULT.tolerance());
    }

    public DenseFloatLUDecompositionQuick(float tolerance) {
        this.algebra = new DenseFloatAlgebra(tolerance);
    }

    public void decompose(FloatMatrix2D A) {
        int CUT_OFF = 10;
        this.LU = A;
        int m = A.rows();
        int n = A.columns();
        if (this.piv == null || this.piv.length != m) {
            this.piv = new int[m];
        }
        int i = m;
        while (--i >= 0) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        if (m * n == 0) {
            this.setLU(this.LU);
            return;
        }
        FloatMatrix1D[] LUrows = new FloatMatrix1D[m];
        int i2 = 0;
        while (i2 < m) {
            LUrows[i2] = this.LU.viewRow(i2);
            ++i2;
        }
        IntArrayList nonZeroIndexes = new IntArrayList();
        FloatMatrix1D LUcolj = this.LU.viewColumn(0).like();
        FloatMult multFunction = FloatMult.mult(0.0f);
        int j = 0;
        while (j < n) {
            float jj;
            LUcolj.assign(this.LU.viewColumn(j));
            int maxCardinality = m / 10;
            LUcolj.getNonZeros(nonZeroIndexes, null, maxCardinality);
            int cardinality = nonZeroIndexes.size();
            boolean sparse = cardinality < maxCardinality;
            int i3 = 0;
            while (i3 < m) {
                int kmax = Math.min(i3, j);
                float s = sparse ? LUrows[i3].zDotProduct(LUcolj, 0, kmax, nonZeroIndexes) : LUrows[i3].zDotProduct(LUcolj, 0, kmax);
                float before = LUcolj.getQuick(i3);
                float after = before - s;
                LUcolj.setQuick(i3, after);
                this.LU.setQuick(i3, j, after);
                if (sparse) {
                    if (before == 0.0f && after != 0.0f) {
                        int pos = nonZeroIndexes.binarySearch(i3);
                        pos = -pos - 1;
                        nonZeroIndexes.beforeInsert(pos, i3);
                    }
                    if (before != 0.0f && after == 0.0f) {
                        nonZeroIndexes.remove(nonZeroIndexes.binarySearch(i3));
                    }
                }
                ++i3;
            }
            int p = j;
            if (p < m) {
                float max = Math.abs(LUcolj.getQuick(p));
                int i4 = j + 1;
                while (i4 < m) {
                    float v = Math.abs(LUcolj.getQuick(i4));
                    if (v > max) {
                        p = i4;
                        max = v;
                    }
                    ++i4;
                }
            }
            if (p != j) {
                LUrows[p].swap(LUrows[j]);
                int k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (j < m && (double)(jj = this.LU.getQuick(j, j)) != 0.0) {
                multFunction.multiplicator = 1.0f / jj;
                this.LU.viewColumn(j).viewPart(j + 1, m - (j + 1)).assign(multFunction);
            }
            ++j;
        }
        this.setLU(this.LU);
    }

    public void decompose(FloatMatrix2D A, int semiBandwidth) {
        if (!this.algebra.property().isSquare(A) || semiBandwidth < 0 || semiBandwidth > 2) {
            this.decompose(A);
            return;
        }
        this.LU = A;
        int m = A.rows();
        int n = A.columns();
        if (this.piv == null || this.piv.length != m) {
            this.piv = new int[m];
        }
        int i = m;
        while (--i >= 0) {
            this.piv[i] = i;
        }
        this.pivsign = 1;
        if (m * n == 0) {
            this.setLU(A);
            return;
        }
        if (semiBandwidth == 2) {
            if (n > 1) {
                A.setQuick(1, 0, A.getQuick(1, 0) / A.getQuick(0, 0));
            }
            i = 1;
            while (i < n) {
                float ei = A.getQuick(i, i) - A.getQuick(i, i - 1) * A.getQuick(i - 1, i);
                A.setQuick(i, i, ei);
                if (i < n - 1) {
                    A.setQuick(i + 1, i, A.getQuick(i + 1, i) / ei);
                }
                ++i;
            }
        }
        this.setLU(A);
    }

    public float det() {
        int n;
        int m = this.m();
        if (m != (n = this.n())) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        if (!this.isNonsingular()) {
            return 0.0f;
        }
        float det = this.pivsign;
        int j = 0;
        while (j < n) {
            det *= this.LU.getQuick(j, j);
            ++j;
        }
        return det;
    }

    protected float[] getFloatPivot() {
        int m = this.m();
        float[] vals = new float[m];
        int i = 0;
        while (i < m) {
            vals[i] = this.piv[i];
            ++i;
        }
        return vals;
    }

    public FloatMatrix2D getL() {
        return this.lowerTriangular(this.LU.copy());
    }

    public FloatMatrix2D getLU() {
        return this.LU.copy();
    }

    public int[] getPivot() {
        return this.piv;
    }

    public FloatMatrix2D getU() {
        return this.upperTriangular(this.LU.copy());
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    protected boolean isNonsingular(FloatMatrix2D matrix) {
        int m = matrix.rows();
        int n = matrix.columns();
        float epsilon = this.algebra.property().tolerance();
        int j = Math.min(n, m);
        while (--j >= 0) {
            if (!(Math.abs(matrix.getQuick(j, j)) <= epsilon)) continue;
            return false;
        }
        return true;
    }

    protected FloatMatrix2D lowerTriangular(FloatMatrix2D A) {
        int min;
        int rows = A.rows();
        int columns = A.columns();
        int r = min = Math.min(rows, columns);
        while (--r >= 0) {
            int c = min;
            while (--c >= 0) {
                if (r < c) {
                    A.setQuick(r, c, 0.0f);
                    continue;
                }
                if (r != c) continue;
                A.setQuick(r, c, 1.0f);
            }
        }
        if (columns > rows) {
            A.viewPart(0, min, rows, columns - min).assign(0.0f);
        }
        return A;
    }

    protected int m() {
        return this.LU.rows();
    }

    protected int n() {
        return this.LU.columns();
    }

    public void setLU(FloatMatrix2D LU) {
        this.LU = LU;
        this.isNonSingular = this.isNonsingular(LU);
    }

    public void solve(FloatMatrix1D B) {
        float v;
        int i;
        float f;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.size() != (long)m) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.workFloat == null || this.workFloat.length < m) {
            this.workFloat = new float[m];
        }
        this.algebra.permute(B, this.piv, this.workFloat);
        if (m * n == 0) {
            return;
        }
        int k = 0;
        while (k < n) {
            f = B.getQuick(k);
            if (f != 0.0f) {
                i = k + 1;
                while (i < n) {
                    v = this.LU.getQuick(i, k);
                    if (v != 0.0f) {
                        B.setQuick(i, B.getQuick(i) - f * v);
                    }
                    ++i;
                }
            }
            ++k;
        }
        k = n - 1;
        while (k >= 0) {
            B.setQuick(k, B.getQuick(k) / this.LU.getQuick(k, k));
            f = B.getQuick(k);
            if (f != 0.0f) {
                i = 0;
                while (i < k) {
                    v = this.LU.getQuick(i, k);
                    if (v != 0.0f) {
                        B.setQuick(i, B.getQuick(i) - f * v);
                    }
                    ++i;
                }
            }
            --k;
        }
    }

    public void solve(FloatMatrix2D B) {
        int i;
        boolean sparse;
        int cardinality;
        int maxCardinality;
        int CUT_OFF = 10;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.rows() != m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        if (this.work1 == null || this.work1.length < m) {
            this.work1 = new int[m];
        }
        this.algebra.permuteRows(B, this.piv, this.work1);
        if (m * n == 0) {
            return;
        }
        int nx = B.columns();
        FloatMatrix1D[] Brows = new FloatMatrix1D[n];
        int k = 0;
        while (k < n) {
            Brows[k] = B.viewRow(k);
            ++k;
        }
        FloatMult div = FloatMult.div(0.0f);
        FloatPlusMultSecond minusMult = FloatPlusMultSecond.minusMult(0.0f);
        IntArrayList nonZeroIndexes = new IntArrayList();
        FloatMatrix1D Browk = FloatFactory1D.dense.make(nx);
        int k2 = 0;
        while (k2 < n) {
            Browk.assign(Brows[k2]);
            maxCardinality = nx / 10;
            Browk.getNonZeros(nonZeroIndexes, null, maxCardinality);
            cardinality = nonZeroIndexes.size();
            sparse = cardinality < maxCardinality;
            i = k2 + 1;
            while (i < n) {
                minusMult.multiplicator = -this.LU.getQuick(i, k2);
                if (minusMult.multiplicator != 0.0f) {
                    if (sparse) {
                        Brows[i].assign(Browk, minusMult, nonZeroIndexes);
                    } else {
                        Brows[i].assign(Browk, minusMult);
                    }
                }
                ++i;
            }
            ++k2;
        }
        k2 = n - 1;
        while (k2 >= 0) {
            div.multiplicator = 1.0f / this.LU.getQuick(k2, k2);
            Brows[k2].assign(div);
            if (Browk == null) {
                Browk = FloatFactory1D.dense.make(B.columns());
            }
            Browk.assign(Brows[k2]);
            maxCardinality = nx / 10;
            Browk.getNonZeros(nonZeroIndexes, null, maxCardinality);
            cardinality = nonZeroIndexes.size();
            sparse = cardinality < maxCardinality;
            i = 0;
            while (i < k2) {
                minusMult.multiplicator = -this.LU.getQuick(i, k2);
                if (minusMult.multiplicator != 0.0f) {
                    if (sparse) {
                        Brows[i].assign(Browk, minusMult, nonZeroIndexes);
                    } else {
                        Brows[i].assign(Browk, minusMult);
                    }
                }
                ++i;
            }
            --k2;
        }
    }

    private void solveOld(FloatMatrix2D B) {
        int j;
        this.algebra.property().checkRectangular(this.LU);
        int m = this.m();
        int n = this.n();
        if (B.rows() != m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("Matrix is singular.");
        }
        int nx = B.columns();
        if (this.work1 == null || this.work1.length < m) {
            this.work1 = new int[m];
        }
        this.algebra.permuteRows(B, this.piv, this.work1);
        int k = 0;
        while (k < n) {
            int i = k + 1;
            while (i < n) {
                float mult = this.LU.getQuick(i, k);
                if (mult != 0.0f) {
                    j = 0;
                    while (j < nx) {
                        B.setQuick(i, j, B.getQuick(i, j) - B.getQuick(k, j) * mult);
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
        k = n - 1;
        while (k >= 0) {
            float mult = 1.0f / this.LU.getQuick(k, k);
            if (mult != 1.0f) {
                int j2 = 0;
                while (j2 < nx) {
                    B.setQuick(k, j2, B.getQuick(k, j2) * mult);
                    ++j2;
                }
            }
            int i = 0;
            while (i < k) {
                mult = this.LU.getQuick(i, k);
                if (mult != 0.0f) {
                    j = 0;
                    while (j < nx) {
                        B.setQuick(i, j, B.getQuick(i, j) - B.getQuick(k, j) * mult);
                        ++j;
                    }
                }
                ++i;
            }
            --k;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("-----------------------------------------------------------------------------\n");
        buf.append("LUDecompositionQuick(A) --> isNonSingular(A), det(A), pivot, L, U, inverse(A)\n");
        buf.append("-----------------------------------------------------------------------------\n");
        buf.append("isNonSingular = ");
        try {
            buf.append(String.valueOf(this.isNonsingular()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\ndet = ");
        try {
            buf.append(String.valueOf(this.det()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\npivot = ");
        try {
            buf.append(String.valueOf(new IntArrayList(this.getPivot())));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nU = ");
        try {
            buf.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        FloatMatrix2D identity = FloatFactory2D.dense.identity(this.LU.rows());
        try {
            this.solve(identity);
            buf.append(String.valueOf(identity));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }

    protected FloatMatrix2D upperTriangular(FloatMatrix2D A) {
        int min;
        int rows = A.rows();
        int columns = A.columns();
        int r = min = Math.min(rows, columns);
        while (--r >= 0) {
            int c = min;
            while (--c >= 0) {
                if (r <= c) continue;
                A.setQuick(r, c, 0.0f);
            }
        }
        if (columns < rows) {
            A.viewPart(min, 0, rows - min, columns).assign(0.0f);
        }
        return A;
    }

    private float[] xgetFloatPivot() {
        int m = this.m();
        float[] vals = new float[m];
        int i = 0;
        while (i < m) {
            vals[i] = this.piv[i];
            ++i;
        }
        return vals;
    }
}

