/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseFloatSingularValueDecomposition {
    private FloatMatrix2D U;
    private FloatMatrix2D V;
    private FloatMatrix2D S;
    private float[] elementsU;
    private float[] elementsVt;
    private float[] elementsS;
    private intW info;
    private int m;
    private int n;
    private int mn;
    private boolean wantWholeUV;
    private boolean wantUV;
    private boolean columnMatrix = false;

    public DenseFloatSingularValueDecomposition(FloatMatrix2D A, boolean wantUV, boolean wantWholeUV) {
        float[] elementsA;
        FloatProperty.DEFAULT.checkDense(A);
        this.wantUV = wantUV;
        this.wantWholeUV = wantWholeUV;
        this.m = A.rows();
        this.n = A.columns();
        if (A instanceof DenseColumnFloatMatrix2D) {
            elementsA = (float[])A.copy().elements();
            this.columnMatrix = true;
        } else {
            elementsA = (float[])A.viewDice().copy().elements();
        }
        this.mn = Math.min(this.m, this.n);
        int maxmn = Math.max(this.m, this.n);
        this.info = new intW(2);
        int[] iwork = new int[8 * this.mn];
        this.elementsS = new float[this.mn];
        wantUV = true;
        if (true) {
            if (wantWholeUV) {
                this.elementsU = new float[this.m * this.m];
                this.elementsVt = new float[this.n * this.n];
                int lwork = 3 * this.mn * this.mn + Math.max(maxmn, 4 * this.mn * this.mn + 4 * this.mn) + maxmn;
                float[] work = new float[lwork];
                LAPACK.getInstance().sgesdd("A", this.m, this.n, elementsA, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.n, work, lwork, iwork, this.info);
            } else {
                this.elementsU = new float[this.m * this.mn];
                this.elementsVt = new float[this.mn * this.n];
                int lwork = 3 * this.mn * this.mn + Math.max(maxmn, 4 * this.mn * this.mn + 4 * this.mn) + maxmn;
                float[] work = new float[lwork];
                LAPACK.getInstance().sgesdd("S", this.m, this.n, elementsA, this.m, this.elementsS, this.elementsU, this.m, this.elementsVt, this.mn, work, lwork, iwork, this.info);
            }
        } else {
            int lwork = 3 * this.mn + Math.max(maxmn, 6 * this.mn) + maxmn;
            float[] work = new float[lwork];
            LAPACK.getInstance().sgesdd("N", this.m, this.n, elementsA, this.m, this.elementsS, null, this.m, null, this.n, work, lwork, iwork, this.info);
        }
        if (this.info.val != 0) {
            throw new IllegalArgumentException("Error occured while computing SVD decomposition: " + this.info);
        }
    }

    public float cond() {
        return this.elementsS[0] / this.elementsS[this.mn - 1];
    }

    public FloatMatrix2D getS() {
        if (this.S == null) {
            this.S = !this.wantWholeUV ? new DiagonalFloatMatrix2D(this.mn, this.mn, 0) : new DiagonalFloatMatrix2D(this.m, this.n, 0);
            int i = 0;
            while (i < this.mn) {
                this.S.setQuick(i, i, this.elementsS[i]);
                ++i;
            }
        }
        return this.S.copy();
    }

    public float[] getSingularValues() {
        return this.elementsS;
    }

    public FloatMatrix2D getU() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix U was not computed");
        }
        if (this.U == null) {
            this.U = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.m, this.mn).assign(this.elementsU) : new DenseFloatMatrix2D(this.mn, this.m).assign(this.elementsU).viewDice()) : (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.m, this.m).assign(this.elementsU) : new DenseFloatMatrix2D(this.m, this.m).assign(this.elementsU).viewDice());
        }
        return this.U.copy();
    }

    public FloatMatrix2D getV() {
        if (!this.wantUV) {
            throw new IllegalAccessError("Matrix V was not computed");
        }
        if (this.V == null) {
            this.V = !this.wantWholeUV ? (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.mn, this.n).assign(this.elementsVt).viewDice() : new DenseFloatMatrix2D(this.n, this.mn).assign(this.elementsVt)) : (this.columnMatrix ? new DenseColumnFloatMatrix2D(this.n, this.n).assign(this.elementsVt).viewDice() : new DenseFloatMatrix2D(this.n, this.n).assign(this.elementsVt));
        }
        return this.V.copy();
    }

    public intW getInfo() {
        return this.info;
    }

    public float norm2() {
        return this.elementsS[0];
    }

    public int rank() {
        float eps = (float)Math.pow(2.0, -23.0);
        float tol = (float)Math.max(this.m, this.n) * this.elementsS[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.elementsS.length) {
            if (this.elementsS[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("---------------------------------------------------------------------\n");
        buf.append("SingularValueDecomposition(A) --> cond(A), rank(A), norm2(A), U, S, V\n");
        buf.append("---------------------------------------------------------------------\n");
        buf.append("cond = ");
        try {
            buf.append(String.valueOf(this.cond()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\nrank = ");
        try {
            buf.append(String.valueOf(this.rank()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\nnorm2 = ");
        try {
            buf.append(String.valueOf(this.norm2()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nU = ");
        try {
            buf.append(String.valueOf(this.getU()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nS = ");
        try {
            buf.append(String.valueOf(this.getS()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nV = ");
        try {
            buf.append(String.valueOf(this.getV()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

