/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import edu.emory.mathcs.csparsej.tfloat.Scs_common;
import edu.emory.mathcs.csparsej.tfloat.Scs_dmperm;
import edu.emory.mathcs.csparsej.tfloat.Scs_ipvec;
import edu.emory.mathcs.csparsej.tfloat.Scs_lsolve;
import edu.emory.mathcs.csparsej.tfloat.Scs_lu;
import edu.emory.mathcs.csparsej.tfloat.Scs_sqr;
import edu.emory.mathcs.csparsej.tfloat.Scs_usolve;

public class SparseFloatLUDecomposition {
    private Scs_common.Scss S;
    private Scs_common.Scsn N;
    private FloatMatrix2D L;
    private FloatMatrix2D U;
    private boolean rcMatrix = false;
    private boolean isNonSingular = true;
    private int n;

    public SparseFloatLUDecomposition(FloatMatrix2D A, int order, boolean checkIfSingular) {
        Scs_common.Scsd D;
        Scs_common.Scs dcs;
        FloatProperty.DEFAULT.checkSquare(A);
        FloatProperty.DEFAULT.checkSparse(A);
        if (order < 0 || order > 3) {
            throw new IllegalArgumentException("order must be a number between 0 and 3");
        }
        if (A instanceof SparseRCFloatMatrix2D) {
            this.rcMatrix = true;
            dcs = ((SparseRCFloatMatrix2D)A).getColumnCompressed().elements();
        } else {
            dcs = (Scs_common.Scs)A.elements();
        }
        this.n = A.rows();
        this.S = Scs_sqr.cs_sqr((int)order, (Scs_common.Scs)dcs, (boolean)false);
        if (this.S == null) {
            throw new IllegalArgumentException("Exception occured in cs_sqr()");
        }
        this.N = Scs_lu.cs_lu((Scs_common.Scs)dcs, (Scs_common.Scss)this.S, (float)1.0f);
        if (this.N == null) {
            throw new IllegalArgumentException("Exception occured in cs_lu()");
        }
        if (checkIfSingular && (D = Scs_dmperm.cs_dmperm((Scs_common.Scs)dcs, (int)1)) != null && D.rr[3] < this.n) {
            this.isNonSingular = false;
        }
    }

    public float det() {
        if (!this.isNonsingular()) {
            return 0.0f;
        }
        int pivsign = 1;
        int i = 0;
        while (i < this.n) {
            if (this.N.pinv[i] != i) {
                pivsign = -pivsign;
            }
            ++i;
        }
        if (this.U == null) {
            this.U = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCFloatMatrix2D)this.U).getRowCompressed();
            }
        }
        float det = pivsign;
        int j = 0;
        while (j < this.n) {
            det *= this.U.getQuick(j, j);
            ++j;
        }
        return det;
    }

    public FloatMatrix2D getL() {
        if (this.L == null) {
            this.L = new SparseCCFloatMatrix2D(this.N.L);
            if (this.rcMatrix) {
                this.L = ((SparseCCFloatMatrix2D)this.L).getRowCompressed();
            }
        }
        return this.L.copy();
    }

    public int[] getPivot() {
        if (this.N.pinv == null) {
            return null;
        }
        int[] pinv = new int[this.N.pinv.length];
        System.arraycopy(this.N.pinv, 0, pinv, 0, pinv.length);
        return pinv;
    }

    public FloatMatrix2D getU() {
        if (this.U == null) {
            this.U = new SparseCCFloatMatrix2D(this.N.U);
            if (this.rcMatrix) {
                this.U = ((SparseCCFloatMatrix2D)this.U).getRowCompressed();
            }
        }
        return this.U.copy();
    }

    public Scs_common.Scss getSymbolicAnalysis() {
        Scs_common.Scss S2 = new Scs_common.Scss();
        S2.cp = this.S.cp != null ? (int[])this.S.cp.clone() : null;
        S2.leftmost = this.S.leftmost != null ? (int[])this.S.leftmost.clone() : null;
        S2.lnz = this.S.lnz;
        S2.m2 = this.S.m2;
        S2.parent = this.S.parent != null ? (int[])this.S.parent.clone() : null;
        S2.pinv = this.S.pinv != null ? (int[])this.S.pinv.clone() : null;
        S2.q = this.S.q != null ? (int[])this.S.q.clone() : null;
        S2.unz = this.S.unz;
        return S2;
    }

    public boolean isNonsingular() {
        return this.isNonSingular;
    }

    public void solve(FloatMatrix1D b) {
        if (b.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (!this.isNonsingular()) {
            throw new IllegalArgumentException("A is singular");
        }
        FloatProperty.DEFAULT.checkDense(b);
        float[] y = new float[this.n];
        float[] x = b.isView() ? (float[])b.copy().elements() : (float[])b.elements();
        Scs_ipvec.cs_ipvec((int[])this.N.pinv, (float[])x, (float[])y, (int)this.n);
        Scs_lsolve.cs_lsolve((Scs_common.Scs)this.N.L, (float[])y);
        Scs_usolve.cs_usolve((Scs_common.Scs)this.N.U, (float[])y);
        Scs_ipvec.cs_ipvec((int[])this.S.q, (float[])y, (float[])x, (int)this.n);
        if (b.isView()) {
            b.assign(x);
        }
    }
}

