/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver.preconditioner;

import cern.colt.Sorting;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.algo.solver.preconditioner.FloatPreconditioner;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import java.util.Arrays;

public class FloatICC
implements FloatPreconditioner {
    private SparseRCFloatMatrix2D R;
    private final FloatMatrix1D y;
    private int[] diagind;
    private final int n;

    public FloatICC(int n) {
        this.n = n;
        this.y = new DenseFloatMatrix1D(n);
    }

    @Override
    public FloatMatrix1D apply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    @Override
    public FloatMatrix1D transApply(FloatMatrix1D b, FloatMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        return this.apply(b, x);
    }

    @Override
    public void setMatrix(FloatMatrix2D A) {
        FloatProperty.DEFAULT.isSquare(A);
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.R = new SparseRCFloatMatrix2D(this.n, this.n);
        this.R.assign(A);
        if (!this.R.hasColumnIndexesSorted()) {
            this.R.sortColumnIndexes();
        }
        this.factor();
    }

    private void factor() {
        int n = this.R.rows();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        float[] data = this.R.getValues();
        float[] Rk = new float[n];
        this.diagind = this.findDiagonalIndexes(n, colind, rowptr);
        int k = 0;
        while (k < n) {
            Arrays.fill(Rk, 0.0f);
            int i = rowptr[k];
            while (i < rowptr[k + 1]) {
                Rk[colind[i]] = data[i];
                ++i;
            }
            i = 0;
            while (i < k) {
                float Rii = data[this.diagind[i]];
                if (Rii == 0.0f) {
                    throw new RuntimeException("Zero pivot encountered on row " + (i + 1) + " during ICC process");
                }
                float Rki = Rk[i] / Rii;
                if (Rki != 0.0f) {
                    int j = this.diagind[i] + 1;
                    while (j < rowptr[i + 1]) {
                        int n2 = colind[j];
                        Rk[n2] = Rk[n2] - Rki * data[j];
                        ++j;
                    }
                }
                ++i;
            }
            if (Rk[k] == 0.0f) {
                throw new RuntimeException("Zero diagonal entry encountered on row " + (k + 1) + " during ICC process");
            }
            float sqRkk = (float)Math.sqrt(Rk[k]);
            int i2 = this.diagind[k];
            while (i2 < rowptr[k + 1]) {
                data[i2] = Rk[colind[i2]] / sqRkk;
                ++i2;
            }
            ++k;
        }
    }

    private int[] findDiagonalIndexes(int m, int[] colind, int[] rowptr) {
        int[] diagind = new int[m];
        int k = 0;
        while (k < m) {
            diagind[k] = Sorting.binarySearchFromTo(colind, k, rowptr[k], rowptr[k + 1] - 1);
            if (diagind[k] < 0) {
                throw new RuntimeException("Missing diagonal entry on row " + (k + 1));
            }
            ++k;
        }
        return diagind;
    }

    private FloatMatrix1D upperSolve(FloatMatrix1D b, FloatMatrix1D x) {
        float[] bd = ((DenseFloatMatrix1D)b).elements();
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        float[] data = this.R.getValues();
        int rows = this.R.rows();
        int i = rows - 1;
        while (i >= 0) {
            float sum = 0.0f;
            int j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                sum += data[j] * xd[colind[j]];
                ++j;
            }
            xd[i] = (bd[i] - sum) / data[this.diagind[i]];
            --i;
        }
        return x;
    }

    private FloatMatrix1D upperTransSolve(FloatMatrix1D b, FloatMatrix1D x) {
        x.assign(b);
        float[] xd = ((DenseFloatMatrix1D)x).elements();
        int[] colind = this.R.getColumnIndexes();
        int[] rowptr = this.R.getRowPointers();
        float[] data = this.R.getValues();
        int rows = this.R.rows();
        int i = 0;
        while (i < rows) {
            int n = i;
            xd[n] = xd[n] / data[this.diagind[i]];
            int j = this.diagind[i] + 1;
            while (j < rowptr[i + 1]) {
                int n2 = colind[j];
                xd[n2] = xd[n2] - data[j] * xd[i];
                ++j;
            }
            ++i;
        }
        return x;
    }
}

