/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfloat.FloatFloatFunction;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.colt.matrix.tfloat.impl.DelegateFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DiagonalFloatMatrix2D;
import java.util.concurrent.Future;

public class WrapperFloatMatrix2D
extends FloatMatrix2D {
    private static final long serialVersionUID = 1L;
    protected FloatMatrix2D content;

    @Override
    public FloatMatrix2D assign(final float[] values) {
        if (this.content instanceof DiagonalFloatMatrix2D) {
            int dlength = ((DiagonalFloatMatrix2D)this.content).dlength;
            final float[] elems = ((DiagonalFloatMatrix2D)this.content).elements;
            if (values.length != dlength) {
                throw new IllegalArgumentException("Must have same length: length=" + values.length + " dlength=" + dlength);
            }
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && dlength >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                nthreads = Math.min(nthreads, dlength);
                Future[] futures = new Future[nthreads];
                int k = dlength / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? dlength : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int i = firstIdx;
                            while (i < lastIdx) {
                                elems[i] = values[i];
                                ++i;
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < dlength) {
                    elems[i] = values[i];
                    ++i;
                }
            }
            return this;
        }
        return super.assign(values);
    }

    @Override
    public FloatMatrix2D assign(FloatMatrix2D y, FloatFloatFunction function) {
        this.checkShape(y);
        if (y instanceof WrapperFloatMatrix2D) {
            IntArrayList rowList = new IntArrayList();
            IntArrayList columnList = new IntArrayList();
            FloatArrayList valueList = new FloatArrayList();
            y.getNonZeros(rowList, columnList, valueList);
            this.assign(y, function, rowList, columnList);
        } else {
            super.assign(y, function);
        }
        return this;
    }

    public WrapperFloatMatrix2D(FloatMatrix2D newContent) {
        block3: {
            if (newContent != null) {
                try {
                    this.setUp(newContent.rows(), newContent.columns());
                }
                catch (IllegalArgumentException exc) {
                    if ("matrix too large".equals(exc.getMessage())) break block3;
                    throw exc;
                }
            }
        }
        this.content = newContent;
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public synchronized float getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    @Override
    public boolean equals(float value) {
        if (this.content instanceof DiagonalFloatMatrix2D) {
            float epsilon = FloatProperty.DEFAULT.tolerance();
            float[] elements = (float[])this.content.elements();
            int r = 0;
            while (r < elements.length) {
                float x = elements[r];
                float diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0f;
                }
                if (!(diff <= epsilon)) {
                    return false;
                }
                ++r;
            }
            return true;
        }
        return super.equals(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this.content instanceof DiagonalFloatMatrix2D && obj instanceof DiagonalFloatMatrix2D) {
            float epsilon = FloatProperty.DEFAULT.tolerance();
            if (this == obj) {
                return true;
            }
            if (this == null || obj == null) {
                return false;
            }
            DiagonalFloatMatrix2D A = (DiagonalFloatMatrix2D)this.content;
            DiagonalFloatMatrix2D B = (DiagonalFloatMatrix2D)obj;
            if (A.columns() != B.columns() || A.rows() != B.rows() || A.diagonalIndex() != B.diagonalIndex() || A.diagonalLength() != B.diagonalLength()) {
                return false;
            }
            float[] AElements = A.elements();
            float[] BElements = B.elements();
            int r = 0;
            while (r < AElements.length) {
                float value = BElements[r];
                float x = AElements[r];
                float diff = Math.abs(value - x);
                if (diff != diff && (value != value && x != x || value == x)) {
                    diff = 0.0f;
                }
                if (!(diff <= epsilon)) {
                    return false;
                }
                ++r;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public FloatMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public FloatMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    public void dct2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dct2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dct2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dctColumns(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dctColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dctRows(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dctRows(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dctRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dst2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dst2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dst2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dstColumns(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dstColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dstRows(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dstRows(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dstRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dht2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dht2();
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dht2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtColumns() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dhtColumns();
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dhtColumns();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void dhtRows() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).dhtRows();
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.dhtRows();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).fft2();
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.fft2();
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public DenseLargeFComplexMatrix2D getFft2() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFft2();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFft2();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfft2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getIfft2(scale);
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getIfft2(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getFftColumns() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFftColumns();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFftColumns();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getFftRows() {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getFftRows();
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getFftRows();
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfftColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                return ((DenseLargeFloatMatrix2D)this.content).getIfftColumns(scale);
            }
            return ((DenseLargeFloatMatrix2D)this.copy()).getIfftColumns(scale);
        }
        throw new IllegalArgumentException("This method is not supported");
    }

    public DenseLargeFComplexMatrix2D getIfftRows(boolean scale) {
        if (this.isNoView) {
            return ((DenseLargeFloatMatrix2D)this.content).getIfftRows(scale);
        }
        return ((DenseLargeFloatMatrix2D)this.copy()).getIfftRows(scale);
    }

    public void idct2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idct2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idct2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idctColumns(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idctColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idctRows(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idctRows(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idctRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idst2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idst2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idst2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idstColumns(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idstColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idstRows(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idstRows(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idstRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idht2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idht2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idht2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtColumns(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idhtColumns(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idhtColumns(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void idhtRows(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).idhtRows(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.idhtRows(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2(boolean scale) {
        if (this.content instanceof DenseLargeFloatMatrix2D) {
            if (this.isNoView) {
                ((DenseLargeFloatMatrix2D)this.content).ifft2(scale);
            } else {
                DenseLargeFloatMatrix2D copy = (DenseLargeFloatMatrix2D)this.copy();
                copy.ifft2(scale);
                this.assign(copy);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    @Override
    public synchronized void setQuick(int row, int column, float value) {
        this.content.setQuick(row, column, value);
    }

    @Override
    public FloatMatrix1D vectorize() {
        final DenseFloatMatrix1D v = new DenseFloatMatrix1D((int)this.size());
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.columns);
            Future[] futures = new Future[nthreads];
            int k = this.columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstCol = j * k;
                final int lastCol = j == nthreads - 1 ? this.columns : firstCol + k;
                final int firstidx = j * k * this.rows;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstidx;
                        int c = firstCol;
                        while (c < lastCol) {
                            int r = 0;
                            while (r < WrapperFloatMatrix2D.this.rows) {
                                v.setQuick(idx++, WrapperFloatMatrix2D.this.getQuick(r, c));
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    v.setQuick(idx++, this.getQuick(r, c));
                    ++r;
                }
                ++c;
            }
        }
        return v;
    }

    @Override
    public FloatMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    @Override
    public FloatMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int row, int column) {
                return this.content.getQuick(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float value) {
                this.content.setQuick(row, this.columns - 1 - column, value);
            }

            @Override
            public synchronized float get(int row, int column) {
                return this.content.get(row, this.columns - 1 - column);
            }

            @Override
            public synchronized void set(int row, int column, float value) {
                this.content.set(row, this.columns - 1 - column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FloatMatrix2D viewDice() {
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int row, int column) {
                return this.content.getQuick(column, row);
            }

            @Override
            public synchronized void setQuick(int row, int column, float value) {
                this.content.setQuick(column, row, value);
            }

            @Override
            public synchronized float get(int row, int column) {
                return this.content.get(column, row);
            }

            @Override
            public synchronized void set(int row, int column, float value) {
                this.content.set(column, row, value);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        view.isNoView = false;
        return view;
    }

    @Override
    public FloatMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int i, int j) {
                return this.content.getQuick(row + i, column + j);
            }

            @Override
            public synchronized void setQuick(int i, int j, float value) {
                this.content.setQuick(row + i, column + j, value);
            }

            @Override
            public synchronized float get(int i, int j) {
                return this.content.get(row + i, column + j);
            }

            @Override
            public synchronized void set(int i, int j, float value) {
                this.content.set(row + i, column + j, value);
            }
        };
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    @Override
    public FloatMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateFloatMatrix1D(this, row);
    }

    @Override
    public FloatMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int row, int column) {
                return this.content.getQuick(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float value) {
                this.content.setQuick(this.rows - 1 - row, column, value);
            }

            @Override
            public synchronized float get(int row, int column) {
                return this.content.get(this.rows - 1 - row, column);
            }

            @Override
            public synchronized void set(int row, int column, float value) {
                this.content.set(this.rows - 1 - row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    @Override
    public FloatMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int i, int j) {
                return this.content.getQuick(rix[i], cix[j]);
            }

            @Override
            public synchronized void setQuick(int i, int j, float value) {
                this.content.setQuick(rix[i], cix[j], value);
            }

            @Override
            public synchronized float get(int i, int j) {
                return this.content.get(rix[i], cix[j]);
            }

            @Override
            public synchronized void set(int i, int j, float value) {
                this.content.set(rix[i], cix[j], value);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    @Override
    public FloatMatrix2D viewStrides(final int _rowStride, final int _columnStride) {
        if (_rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFloatMatrix2D view = new WrapperFloatMatrix2D(this){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized float getQuick(int row, int column) {
                return this.content.getQuick(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void setQuick(int row, int column, float value) {
                this.content.setQuick(_rowStride * row, _columnStride * column, value);
            }

            @Override
            public synchronized float get(int row, int column) {
                return this.content.get(_rowStride * row, _columnStride * column);
            }

            @Override
            public synchronized void set(int row, int column, float value) {
                this.content.set(_rowStride * row, _columnStride * column, value);
            }
        };
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    @Override
    protected FloatMatrix2D getContent() {
        return this.content;
    }

    @Override
    protected FloatMatrix1D like1D(int size, int offset, int stride) {
        throw new InternalError();
    }

    @Override
    protected FloatMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }
}

