/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix2DProcedure;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.jet.math.tint.IntFunctions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class IntMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected IntMatrix3D() {
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix3D.this.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = d;
                                while (c < IntMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(IntMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f, final IntProcedure cond) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int elem = IntMatrix3D.this.getQuick(firstSlice, 0, 0);
                        int a = 0;
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = d;
                                while (c < IntMatrix3D.this.columns) {
                                    elem = IntMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        a = aggr.apply(a, f.apply(elem));
                                    }
                                    d = 0;
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int elem = this.getQuick(0, 0, 0);
            if (cond.apply(elem)) {
                a = aggr.apply(a, f.apply(elem));
            }
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            a = aggr.apply(a, f.apply(elem));
                        }
                        d = 0;
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public int aggregate(final IntIntFunction aggr, final IntFunction f, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (sliceList.size() == 0 || rowList.size() == 0 || columnList.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix3D.this.getQuick(sliceElements[firstIdx], rowElements[firstIdx], columnElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            int elem = IntMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(sliceElements[0], rowElements[0], columnElements[0]));
            int i = 1;
            while (i < size) {
                int elem = this.getQuick(sliceElements[i], rowElements[i], columnElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public int aggregate(final IntMatrix3D other, final IntIntFunction aggr, final IntIntFunction f) {
        this.checkShape(other);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int a = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int a = f.apply(IntMatrix3D.this.getQuick(firstSlice, 0, 0), other.getQuick(firstSlice, 0, 0));
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = d;
                                while (c < IntMatrix3D.this.columns) {
                                    a = aggr.apply(a, f.apply(IntMatrix3D.this.getQuick(s, r, c), other.getQuick(s, r, c)));
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(0, 0, 0), other.getQuick(0, 0, 0));
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        a = aggr.apply(a, f.apply(this.getQuick(s, r, c), other.getQuick(s, r, c)));
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return a;
    }

    public IntMatrix3D assign(final IntFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, function.apply(IntMatrix3D.this.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, value);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, value);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[] values) {
        if (values.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + values.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = firstSlice * IntMatrix3D.this.rows * IntMatrix3D.this.columns;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, values[idx++]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = 0;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, values[idx++]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[][][] values) {
        if (values.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + values.length + "slices()=" + this.slices());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int[][] currentSlice = values[s];
                            if (currentSlice.length != IntMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + IntMatrix3D.this.rows());
                            }
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int[] currentRow = currentSlice[r];
                                if (currentRow.length != IntMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + IntMatrix3D.this.columns());
                                }
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, currentRow[c]);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int[][] currentSlice = values[s];
                if (currentSlice.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + currentSlice.length + "rows()=" + this.rows());
                }
                int r = 0;
                while (r < this.rows) {
                    int[] currentRow = currentSlice[r];
                    if (currentRow.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + currentRow.length + "columns()=" + this.columns());
                    }
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, currentRow[c]);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure cond, final IntFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    int elem = IntMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        IntMatrix3D.this.setQuick(s, r, c, f.apply(elem));
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        int elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, f.apply(elem));
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure cond, final int value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    int elem = IntMatrix3D.this.getQuick(s, r, c);
                                    if (cond.apply(elem)) {
                                        IntMatrix3D.this.setQuick(s, r, c, value);
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        int elem = this.getQuick(s, r, c);
                        if (cond.apply(elem)) {
                            this.setQuick(s, r, c, value);
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(IntMatrix3D other) {
        if (other == this) {
            return this;
        }
        this.checkShape(other);
        final IntMatrix3D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, otherLoc.getQuick(s, r, c));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, otherLoc.getQuick(s, r, c));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntMatrix3D y, final IntIntFunction function) {
        this.checkShape(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    IntMatrix3D.this.setQuick(s, r, c, function.apply(IntMatrix3D.this.getQuick(s, r, c), y.getQuick(s, r, c)));
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        this.setQuick(s, r, c, function.apply(this.getQuick(s, r, c), y.getQuick(s, r, c)));
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntMatrix3D y, final IntIntFunction function, IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList) {
        this.checkShape(y);
        int size = sliceList.size();
        final int[] sliceElements = sliceList.elements();
        final int[] rowElements = rowList.elements();
        final int[] columnElements = columnList.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            IntMatrix3D.this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(IntMatrix3D.this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < size) {
                this.setQuick(sliceElements[i], rowElements[i], columnElements[i], function.apply(this.getQuick(sliceElements[i], rowElements[i], columnElements[i]), y.getQuick(sliceElements[i], rowElements[i], columnElements[i])));
                ++i;
            }
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    if (IntMatrix3D.this.getQuick(s, r, c) != 0) {
                                        ++cardinality;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = 0;
                    while (c < this.columns) {
                        if (this.getQuick(s, r, c) != 0) {
                            ++cardinality;
                        }
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return cardinality;
    }

    public IntMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(int value) {
        return IntProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntMatrix3D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix3D)obj);
    }

    public int get(int slice, int row, int column) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        return this.getQuick(slice, row, column);
    }

    protected IntMatrix3D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    int value = this.getQuick(s, r, c);
                    if (value < 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public void getNonZeros(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    int value = this.getQuick(s, r, c);
                    if (value != 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public void getPositiveValues(IntArrayList sliceList, IntArrayList rowList, IntArrayList columnList, IntArrayList valueList) {
        sliceList.clear();
        rowList.clear();
        columnList.clear();
        valueList.clear();
        int s = 0;
        while (s < this.slices) {
            int r = 0;
            while (r < this.rows) {
                int c = 0;
                while (c < this.columns) {
                    int value = this.getQuick(s, r, c);
                    if (value > 0) {
                        sliceList.add(s);
                        rowList.add(r);
                        columnList.add(c);
                        valueList.add(value);
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
    }

    public abstract int getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(IntMatrix3D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D other) {
        return false;
    }

    public IntMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract IntMatrix3D like(int var1, int var2, int var3);

    public abstract IntMatrix2D like2D(int var1, int var2);

    protected abstract IntMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public int[] getMaxLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        int maxValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        int maxValue = IntMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = d;
                                while (c < IntMatrix3D.this.columns) {
                                    int elem = IntMatrix3D.this.getQuick(s, r, c);
                                    if (maxValue < elem) {
                                        maxValue = elem;
                                        sliceLocation = s;
                                        rowLocation = r;
                                        columnLocation = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new int[]{maxValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                sliceLocation = results[0][1];
                rowLocation = results[0][2];
                columnLocation = results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        sliceLocation = results[j][1];
                        rowLocation = results[j][2];
                        columnLocation = results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(0, 0, 0);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int elem = this.getQuick(s, r, c);
                        if (maxValue < elem) {
                            maxValue = elem;
                            sliceLocation = s;
                            rowLocation = r;
                            columnLocation = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new int[]{maxValue, sliceLocation, rowLocation, columnLocation};
    }

    public int[] getMinLocation() {
        int sliceLocation = 0;
        int rowLocation = 0;
        int columnLocation = 0;
        int minValue = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int[][] results = new int[nthreads][2];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int sliceLocation = firstSlice;
                        int rowLocation = 0;
                        int columnLocation = 0;
                        int minValue = IntMatrix3D.this.getQuick(sliceLocation, 0, 0);
                        int d = 1;
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int c = d;
                                while (c < IntMatrix3D.this.columns) {
                                    int elem = IntMatrix3D.this.getQuick(s, r, c);
                                    if (minValue > elem) {
                                        minValue = elem;
                                        sliceLocation = s;
                                        rowLocation = r;
                                        columnLocation = c;
                                    }
                                    ++c;
                                }
                                d = 0;
                                ++r;
                            }
                            ++s;
                        }
                        return new int[]{minValue, sliceLocation, rowLocation, columnLocation};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (int[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                sliceLocation = results[0][1];
                rowLocation = results[0][2];
                columnLocation = results[0][3];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        sliceLocation = results[j][1];
                        rowLocation = results[j][2];
                        columnLocation = results[j][3];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(0, 0, 0);
            int d = 1;
            int s = 0;
            while (s < this.slices) {
                int r = 0;
                while (r < this.rows) {
                    int c = d;
                    while (c < this.columns) {
                        int elem = this.getQuick(s, r, c);
                        if (minValue > elem) {
                            minValue = elem;
                            sliceLocation = s;
                            rowLocation = r;
                            columnLocation = c;
                        }
                        ++c;
                    }
                    d = 0;
                    ++r;
                }
                ++s;
            }
        }
        return new int[]{minValue, sliceLocation, rowLocation, columnLocation};
    }

    public void set(int slice, int row, int column, int value) {
        if (slice < 0 || slice >= this.slices || row < 0 || row >= this.rows || column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + slice + ", row:" + row + ", column:" + column);
        }
        this.setQuick(slice, row, column, value);
    }

    public abstract void setQuick(int var1, int var2, int var3, int var4);

    public int[][][] toArray() {
        final int[][][] values = new int[this.slices][this.rows][this.columns];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int[][] currentSlice = values[s];
                            int r = 0;
                            while (r < IntMatrix3D.this.rows) {
                                int[] currentRow = currentSlice[r];
                                int c = 0;
                                while (c < IntMatrix3D.this.columns) {
                                    currentRow[c] = IntMatrix3D.this.getQuick(s, r, c);
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int s = 0;
            while (s < this.slices) {
                int[][] currentSlice = values[s];
                int r = 0;
                while (r < this.rows) {
                    int[] currentRow = currentSlice[r];
                    int c = 0;
                    while (c < this.columns) {
                        currentRow[c] = this.getQuick(s, r, c);
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
        }
        return values;
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    public abstract IntMatrix1D vectorize();

    protected IntMatrix3D view() {
        return (IntMatrix3D)this.clone();
    }

    public IntMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        int sliceRows = this.slices;
        int sliceColumns = this.rows;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.rowZero + this._columnOffset(this._columnRank(column));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.rowStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public IntMatrix3D viewColumnFlip() {
        return (IntMatrix3D)this.view().vColumnFlip();
    }

    public IntMatrix3D viewDice(int axis0, int axis1, int axis2) {
        return (IntMatrix3D)this.view().vDice(axis0, axis1, axis2);
    }

    public IntMatrix3D viewPart(int slice, int row, int column, int depth, int height, int width) {
        return (IntMatrix3D)this.view().vPart(slice, row, column, depth, height, width);
    }

    public IntMatrix2D viewRow(int row) {
        this.checkRow(row);
        int sliceRows = this.slices;
        int sliceColumns = this.columns;
        int sliceRowZero = this.sliceZero;
        int sliceColumnZero = this.columnZero + this._rowOffset(this._rowRank(row));
        int sliceRowStride = this.sliceStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public IntMatrix3D viewRowFlip() {
        return (IntMatrix3D)this.view().vRowFlip();
    }

    public IntMatrix3D viewSelection(IntMatrix2DProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.slices) {
            if (condition.apply(this.viewSlice(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements(), null, null);
    }

    public IntMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = 0;
            while (i < this.slices) {
                sliceIndexes[i] = i;
                ++i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = 0;
            while (i < this.rows) {
                rowIndexes[i] = i;
                ++i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = 0;
            while (i < this.columns) {
                columnIndexes[i] = i;
                ++i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        int[] sliceOffsets = new int[sliceIndexes.length];
        int[] rowOffsets = new int[rowIndexes.length];
        int[] columnOffsets = new int[columnIndexes.length];
        int i2 = 0;
        while (i2 < sliceIndexes.length) {
            sliceOffsets[i2] = this._sliceOffset(this._sliceRank(sliceIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < rowIndexes.length) {
            rowOffsets[i2] = this._rowOffset(this._rowRank(rowIndexes[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < columnIndexes.length) {
            columnOffsets[i2] = this._columnOffset(this._columnRank(columnIndexes[i2]));
            ++i2;
        }
        return this.viewSelectionLike(sliceOffsets, rowOffsets, columnOffsets);
    }

    protected abstract IntMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public IntMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        int sliceRows = this.rows;
        int sliceColumns = this.columns;
        int sliceRowZero = this.rowZero;
        int sliceColumnZero = this.columnZero + this._sliceOffset(this._sliceRank(slice));
        int sliceRowStride = this.rowStride;
        int sliceColumnStride = this.columnStride;
        return this.like2D(sliceRows, sliceColumns, sliceRowZero, sliceColumnZero, sliceRowStride, sliceColumnStride);
    }

    public IntMatrix3D viewSliceFlip() {
        return (IntMatrix3D)this.view().vSliceFlip();
    }

    public IntMatrix3D viewSorted(int row, int column) {
        return IntSorting.mergeSort.sort(this, row, column);
    }

    public IntMatrix3D viewStrides(int sliceStride, int rowStride, int columnStride) {
        return (IntMatrix3D)this.view().vStrides(sliceStride, rowStride, columnStride);
    }

    public int zSum() {
        if (this.size() == 0L) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

