/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.WrapperObjectMatrix2D;

public class DenseLargeObjectMatrix2D
extends WrapperObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    private Object[][] elements;

    public DenseLargeObjectMatrix2D(int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new Object[rows][columns];
        this.content = this;
    }

    @Override
    public Object getQuick(int row, int column) {
        return this.elements[row][column];
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        this.elements[row][column] = value;
    }

    public Object[][] elements() {
        return this.elements;
    }

    @Override
    protected ObjectMatrix2D getContent() {
        return this;
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new DenseLargeObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new DenseObjectMatrix1D(size);
    }
}

