/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedDenseObjectMatrix1D;

class SelectedDenseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseObjectMatrix2D(Object[] elements, int[] rowOffsets, int[] columnOffsets, int offset) {
        this(rowOffsets.length, columnOffsets.length, elements, 0, 0, 1, 1, rowOffsets, columnOffsets, offset);
    }

    protected SelectedDenseObjectMatrix2D(int rows, int columns, Object[] elements, int rowZero, int columnZero, int rowStride, int columnStride, int[] rowOffsets, int[] columnOffsets, int offset) {
        this.setUp(rows, columns, rowZero, columnZero, rowStride, columnStride);
        this.elements = elements;
        this.rowOffsets = rowOffsets;
        this.columnOffsets = columnOffsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _columnOffset(int absRank) {
        return this.columnOffsets[absRank];
    }

    @Override
    protected int _rowOffset(int absRank) {
        return this.rowOffsets[absRank];
    }

    @Override
    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public Object getQuick(int row, int column) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix2D other) {
        if (other instanceof SelectedDenseObjectMatrix2D) {
            SelectedDenseObjectMatrix2D otherMatrix = (SelectedDenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix2D) {
            DenseObjectMatrix2D otherMatrix = (DenseObjectMatrix2D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int row, int column) {
        return this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride];
    }

    @Override
    public ObjectMatrix2D like(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    @Override
    public ObjectMatrix1D like1D(int size) {
        return new DenseObjectMatrix1D(size);
    }

    @Override
    protected ObjectMatrix1D like1D(int size, int zero, int stride) {
        throw new InternalError();
    }

    @Override
    public void setQuick(int row, int column, Object value) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + row * this.rowStride] + this.columnOffsets[this.columnZero + column * this.columnStride]] = value;
    }

    @Override
    protected void setUp(int rows, int columns) {
        super.setUp(rows, columns);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    @Override
    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D v = new DenseObjectMatrix1D((int)this.size());
        int idx = 0;
        int c = 0;
        while (c < this.columns) {
            int r = 0;
            while (r < this.rows) {
                v.setQuick(idx++, this.getQuick(c, r));
                ++r;
            }
            ++c;
        }
        return v;
    }

    @Override
    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] tmp = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = tmp;
        this.isNoView = false;
        return this;
    }

    @Override
    public ObjectMatrix1D viewColumn(int column) {
        this.checkColumn(column);
        int viewSize = this.rows;
        int viewZero = this.rowZero;
        int viewStride = this.rowStride;
        int[] viewOffsets = this.rowOffsets;
        int viewOffset = this.offset + this._columnOffset(this._columnRank(column));
        return new SelectedDenseObjectMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    public ObjectMatrix1D viewRow(int row) {
        this.checkRow(row);
        int viewSize = this.columns;
        int viewZero = this.columnZero;
        int viewStride = this.columnStride;
        int[] viewOffsets = this.columnOffsets;
        int viewOffset = this.offset + this._rowOffset(this._rowRank(row));
        return new SelectedDenseObjectMatrix1D(viewSize, this.elements, viewZero, viewStride, viewOffsets, viewOffset);
    }

    @Override
    protected ObjectMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        return new SelectedDenseObjectMatrix2D(this.elements, rowOffsets, columnOffsets, this.offset);
    }
}

