/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat;

import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.stat.tdouble.Gamma;

public class FloatDescriptive {
    protected FloatDescriptive() {
    }

    public static float autoCorrelation(FloatArrayList data, int lag, float mean, float variance) {
        int N = data.size();
        if (lag >= N) {
            throw new IllegalArgumentException("Lag is too large");
        }
        float[] elements = data.elements();
        float run = 0.0f;
        int i = lag;
        while (i < N) {
            run += (elements[i] - mean) * (elements[i - lag] - mean);
            ++i;
        }
        return run / (float)(N - lag) / variance;
    }

    protected static void checkRangeFromTo(int from, int to, int theSize) {
        if (to == from - 1) {
            return;
        }
        if (from < 0 || from > to || to >= theSize) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size=" + theSize);
        }
    }

    public static float correlation(FloatArrayList data1, float standardDev1, FloatArrayList data2, float standardDev2) {
        return FloatDescriptive.covariance(data1, data2) / (standardDev1 * standardDev2);
    }

    public static float covariance(FloatArrayList data1, FloatArrayList data2) {
        int size = data1.size();
        if (size != data2.size() || size == 0) {
            throw new IllegalArgumentException();
        }
        float[] elements1 = data1.elements();
        float[] elements2 = data2.elements();
        float sumx = elements1[0];
        float sumy = elements2[0];
        float Sxy = 0.0f;
        int i = 1;
        while (i < size) {
            float x = elements1[i];
            float y = elements2[i];
            Sxy += (x - (sumx += x) / (float)(i + 1)) * (y - sumy / (float)i);
            sumy += y;
            ++i;
        }
        return Sxy / (float)(size - 1);
    }

    private static float covariance2(FloatArrayList data1, FloatArrayList data2) {
        int size = data1.size();
        float mean1 = FloatDescriptive.mean(data1);
        float mean2 = FloatDescriptive.mean(data2);
        float covariance = 0.0f;
        int i = 0;
        while (i < size) {
            float x = data1.get(i);
            float y = data2.get(i);
            covariance += (x - mean1) * (y - mean2);
            ++i;
        }
        return covariance / (float)(size - 1);
    }

    public static float durbinWatson(FloatArrayList data) {
        int size = data.size();
        if (size < 2) {
            throw new IllegalArgumentException("data sequence must contain at least two values.");
        }
        float[] elements = data.elements();
        float run = 0.0f;
        float run_sq = 0.0f;
        run_sq = elements[0] * elements[0];
        int i = 1;
        while (i < size) {
            float x = elements[i] - elements[i - 1];
            run += x * x;
            run_sq += elements[i] * elements[i];
            ++i;
        }
        return run / run_sq;
    }

    public static void frequencies(FloatArrayList sortedData, FloatArrayList distinctValues, IntArrayList frequencies) {
        distinctValues.clear();
        if (frequencies != null) {
            frequencies.clear();
        }
        float[] sortedElements = sortedData.elements();
        int size = sortedData.size();
        int i = 0;
        while (i < size) {
            float element = sortedElements[i];
            int cursor = i;
            while (++i < size && sortedElements[i] == element) {
            }
            int runLength = i - cursor;
            distinctValues.add(element);
            if (frequencies == null) continue;
            frequencies.add(runLength);
        }
    }

    public static float geometricMean(int size, float sumOfLogarithms) {
        return (float)Math.exp(sumOfLogarithms / (float)size);
    }

    public static float geometricMean(FloatArrayList data) {
        return FloatDescriptive.geometricMean(data.size(), FloatDescriptive.sumOfLogarithms(data, 0, data.size() - 1));
    }

    public static float harmonicMean(int size, float sumOfInversions) {
        return (float)size / sumOfInversions;
    }

    public static void incrementalUpdate(FloatArrayList data, int from, int to, float[] inOut) {
        FloatDescriptive.checkRangeFromTo(from, to, data.size());
        float min = inOut[0];
        float max = inOut[1];
        float sum = inOut[2];
        float sumSquares = inOut[3];
        float[] elements = data.elements();
        while (from <= to) {
            float element = elements[from];
            sum += element;
            sumSquares += element * element;
            if (element < min) {
                min = element;
            }
            if (element > max) {
                max = element;
            }
            ++from;
        }
        inOut[0] = min;
        inOut[1] = max;
        inOut[2] = sum;
        inOut[3] = sumSquares;
    }

    public static void incrementalUpdateSumsOfPowers(FloatArrayList data, int from, int to, int fromSumIndex, int toSumIndex, float[] sumOfPowers) {
        int size = data.size();
        int lastIndex = toSumIndex - fromSumIndex;
        if (from > size || lastIndex + 1 > sumOfPowers.length) {
            throw new IllegalArgumentException();
        }
        if (fromSumIndex == 1) {
            if (toSumIndex == 2) {
                float[] elements = data.elements();
                float sum = sumOfPowers[0];
                float sumSquares = sumOfPowers[1];
                int i = from - 1;
                while (++i <= to) {
                    float element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                return;
            }
            if (toSumIndex == 3) {
                float[] elements = data.elements();
                float sum = sumOfPowers[0];
                float sumSquares = sumOfPowers[1];
                float sum_xxx = sumOfPowers[2];
                int i = from - 1;
                while (++i <= to) {
                    float element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                return;
            }
            if (toSumIndex == 4) {
                float[] elements = data.elements();
                float sum = sumOfPowers[0];
                float sumSquares = sumOfPowers[1];
                float sum_xxx = sumOfPowers[2];
                float sum_xxxx = sumOfPowers[3];
                int i = from - 1;
                while (++i <= to) {
                    float element = elements[i];
                    sum += element;
                    sumSquares += element * element;
                    sum_xxx += element * element * element;
                    sum_xxxx += element * element * element * element;
                }
                sumOfPowers[0] = sumOfPowers[0] + sum;
                sumOfPowers[1] = sumOfPowers[1] + sumSquares;
                sumOfPowers[2] = sumOfPowers[2] + sum_xxx;
                sumOfPowers[3] = sumOfPowers[3] + sum_xxxx;
                return;
            }
        }
        if (fromSumIndex == toSumIndex || fromSumIndex >= -1 && toSumIndex <= 5) {
            int i = fromSumIndex;
            while (i <= toSumIndex) {
                int n = i - fromSumIndex;
                sumOfPowers[n] = sumOfPowers[n] + FloatDescriptive.sumOfPowerDeviations(data, i, 0.0f, from, to);
                ++i;
            }
            return;
        }
        float[] elements = data.elements();
        int i = from - 1;
        while (++i <= to) {
            float element = elements[i];
            float pow = (float)Math.pow(element, fromSumIndex);
            int j = 0;
            int m = lastIndex;
            while (--m >= 0) {
                int n = j++;
                sumOfPowers[n] = sumOfPowers[n] + pow;
                pow *= element;
            }
            int n = j;
            sumOfPowers[n] = sumOfPowers[n] + pow;
        }
    }

    public static void incrementalWeightedUpdate(FloatArrayList data, FloatArrayList weights, int from, int to, float[] inOut) {
        int dataSize = data.size();
        FloatDescriptive.checkRangeFromTo(from, to, dataSize);
        if (dataSize != weights.size()) {
            throw new IllegalArgumentException("from=" + from + ", to=" + to + ", data.size()=" + dataSize + ", weights.size()=" + weights.size());
        }
        float sum = inOut[0];
        float sumOfSquares = inOut[1];
        float[] elements = data.elements();
        float[] w = weights.elements();
        int i = from - 1;
        while (++i <= to) {
            float element = elements[i];
            float weight = w[i];
            float prod = element * weight;
            sum += prod;
            sumOfSquares += element * prod;
        }
        inOut[0] = sum;
        inOut[1] = sumOfSquares;
    }

    public static float kurtosis(float moment4, float standardDeviation) {
        return -3.0f + moment4 / (standardDeviation * standardDeviation * standardDeviation * standardDeviation);
    }

    public static float kurtosis(FloatArrayList data, float mean, float standardDeviation) {
        return FloatDescriptive.kurtosis(FloatDescriptive.moment(data, 4, mean), standardDeviation);
    }

    public static float lag1(FloatArrayList data, float mean) {
        int size = data.size();
        float[] elements = data.elements();
        float q = 0.0f;
        float v = (elements[0] - mean) * (elements[0] - mean);
        int i = 1;
        while (i < size) {
            float delta0 = elements[i - 1] - mean;
            float delta1 = elements[i] - mean;
            q += (delta0 * delta1 - q) / (float)(i + 1);
            v += (delta1 * delta1 - v) / (float)(i + 1);
            ++i;
        }
        float r1 = q / v;
        return r1;
    }

    public static float max(FloatArrayList data) {
        int size = data.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        float[] elements = data.elements();
        float max = elements[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(elements[i] > max)) continue;
            max = elements[i];
        }
        return max;
    }

    public static float mean(FloatArrayList data) {
        return FloatDescriptive.sum(data) / (float)data.size();
    }

    public static float meanDeviation(FloatArrayList data, float mean) {
        float[] elements = data.elements();
        int size = data.size();
        float sum = 0.0f;
        int i = size;
        while (--i >= 0) {
            sum += Math.abs(elements[i] - mean);
        }
        return sum / (float)size;
    }

    public static float median(FloatArrayList sortedData) {
        return FloatDescriptive.quantile(sortedData, 0.5f);
    }

    public static float min(FloatArrayList data) {
        int size = data.size();
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        float[] elements = data.elements();
        float min = elements[size - 1];
        int i = size - 1;
        while (--i >= 0) {
            if (!(elements[i] < min)) continue;
            min = elements[i];
        }
        return min;
    }

    public static float moment(int k, float c, int size, float[] sumOfPowers) {
        float sum = 0.0f;
        int sign = 1;
        int i = 0;
        while (i <= k) {
            float y = i == 0 ? 1.0f : (i == 1 ? c : (i == 2 ? c * c : (i == 3 ? c * c * c : (float)Math.pow(c, i))));
            sum += (float)sign * FloatArithmetic.binomial(k, (long)i) * y * sumOfPowers[k - i];
            sign = -sign;
            ++i;
        }
        return sum / (float)size;
    }

    public static float moment(FloatArrayList data, int k, float c) {
        return FloatDescriptive.sumOfPowerDeviations(data, k, c) / (float)data.size();
    }

    public static float pooledMean(int size1, float mean1, int size2, float mean2) {
        return ((float)size1 * mean1 + (float)size2 * mean2) / (float)(size1 + size2);
    }

    public static float pooledVariance(int size1, float variance1, int size2, float variance2) {
        return ((float)size1 * variance1 + (float)size2 * variance2) / (float)(size1 + size2);
    }

    public static float product(int size, float sumOfLogarithms) {
        return (float)Math.pow(Math.exp(sumOfLogarithms / (float)size), size);
    }

    public static float product(FloatArrayList data) {
        int size = data.size();
        float[] elements = data.elements();
        float product = 1.0f;
        int i = size;
        while (--i >= 0) {
            product *= elements[i];
        }
        return product;
    }

    public static float quantile(FloatArrayList sortedData, float phi) {
        float[] sortedElements = sortedData.elements();
        int n = sortedData.size();
        float index = phi * (float)(n - 1);
        int lhs = (int)index;
        float delta = index - (float)lhs;
        if (n == 0) {
            return 0.0f;
        }
        float result = lhs == n - 1 ? sortedElements[lhs] : (1.0f - delta) * sortedElements[lhs] + delta * sortedElements[lhs + 1];
        return result;
    }

    public static float quantileInverse(FloatArrayList sortedList, float element) {
        return FloatDescriptive.rankInterpolated(sortedList, element) / (float)sortedList.size();
    }

    public static FloatArrayList quantiles(FloatArrayList sortedData, FloatArrayList percentages) {
        int s = percentages.size();
        FloatArrayList quantiles = new FloatArrayList(s);
        int i = 0;
        while (i < s) {
            quantiles.add(FloatDescriptive.quantile(sortedData, percentages.get(i)));
            ++i;
        }
        return quantiles;
    }

    public static float rankInterpolated(FloatArrayList sortedList, float element) {
        int index = sortedList.binarySearch(element);
        if (index >= 0) {
            int to = index + 1;
            int s = sortedList.size();
            while (to < s && sortedList.get(to) == element) {
                ++to;
            }
            return to;
        }
        int insertionPoint = -index - 1;
        if (insertionPoint == 0 || insertionPoint == sortedList.size()) {
            return insertionPoint;
        }
        float from = sortedList.get(insertionPoint - 1);
        float to = sortedList.get(insertionPoint);
        float delta = (element - from) / (to - from);
        return (float)insertionPoint + delta;
    }

    public static float rms(int size, float sumOfSquares) {
        return (float)Math.sqrt(sumOfSquares / (float)size);
    }

    public static float sampleKurtosis(int size, float moment4, float sampleVariance) {
        int n = size;
        float s2 = sampleVariance;
        float m4 = moment4 * (float)n;
        return (float)((double)(m4 * (float)n * (float)(n + 1) / ((float)((n - 1) * (n - 2) * (n - 3)) * s2 * s2)) - 3.0 * (double)(n - 1) * (double)(n - 1) / (double)((n - 2) * (n - 3)));
    }

    public static float sampleKurtosis(FloatArrayList data, float mean, float sampleVariance) {
        return FloatDescriptive.sampleKurtosis(data.size(), FloatDescriptive.moment(data, 4, mean), sampleVariance);
    }

    public static float sampleKurtosisStandardError(int size) {
        int n = size;
        return (float)Math.sqrt(24.0 * (double)n * (double)(n - 1) * (double)(n - 1) / (double)((n - 3) * (n - 2) * (n + 3) * (n + 5)));
    }

    public static float sampleSkew(int size, float moment3, float sampleVariance) {
        int n = size;
        float s = (float)Math.sqrt(sampleVariance);
        float m3 = moment3 * (float)n;
        return (float)n * m3 / ((float)((n - 1) * (n - 2)) * s * s * s);
    }

    public static float sampleSkew(FloatArrayList data, float mean, float sampleVariance) {
        return FloatDescriptive.sampleSkew(data.size(), FloatDescriptive.moment(data, 3, mean), sampleVariance);
    }

    public static float sampleSkewStandardError(int size) {
        int n = size;
        return (float)Math.sqrt(6.0 * (double)n * (double)(n - 1) / (double)((n - 2) * (n + 1) * (n + 3)));
    }

    public static float sampleStandardDeviation(int size, float sampleVariance) {
        int n = size;
        float s = (float)Math.sqrt(sampleVariance);
        float Cn = n > 30 ? (float)(1.0 + 1.0 / (double)(4 * (n - 1))) : (float)(Math.sqrt((double)(n - 1) * 0.5) * Gamma.gamma((double)(n - 1) * 0.5) / Gamma.gamma((double)n * 0.5));
        return Cn * s;
    }

    public static float sampleVariance(int size, float sum, float sumOfSquares) {
        float mean = sum / (float)size;
        return (sumOfSquares - mean * sum) / (float)(size - 1);
    }

    public static float sampleVariance(FloatArrayList data, float mean) {
        float[] elements = data.elements();
        int size = data.size();
        float sum = 0.0f;
        int i = size;
        while (--i >= 0) {
            float delta = elements[i] - mean;
            sum += delta * delta;
        }
        return sum / (float)(size - 1);
    }

    public static float sampleWeightedVariance(float sumOfWeights, float sumOfProducts, float sumOfSquaredProducts) {
        return (sumOfSquaredProducts - sumOfProducts * sumOfProducts / sumOfWeights) / (sumOfWeights - 1.0f);
    }

    public static float skew(float moment3, float standardDeviation) {
        return moment3 / (standardDeviation * standardDeviation * standardDeviation);
    }

    public static float skew(FloatArrayList data, float mean, float standardDeviation) {
        return FloatDescriptive.skew(FloatDescriptive.moment(data, 3, mean), standardDeviation);
    }

    public static FloatArrayList[] split(FloatArrayList sortedList, FloatArrayList splitters) {
        int noOfBins = splitters.size() + 1;
        FloatArrayList[] bins = new FloatArrayList[noOfBins];
        int i = noOfBins;
        while (--i >= 0) {
            bins[i] = new FloatArrayList();
        }
        int listSize = sortedList.size();
        int nextStart = 0;
        int i2 = 0;
        while (nextStart < listSize && i2 < noOfBins - 1) {
            float splitValue = splitters.get(i2);
            int index = sortedList.binarySearch(splitValue);
            if (index < 0) {
                int insertionPosition = -index - 1;
                bins[i2].addAllOfFromTo(sortedList, nextStart, insertionPosition - 1);
                nextStart = insertionPosition;
            } else {
                while (--index >= 0 && sortedList.get(index) == splitValue) {
                }
                bins[i2].addAllOfFromTo(sortedList, nextStart, index);
                nextStart = index + 1;
            }
            ++i2;
        }
        bins[noOfBins - 1].addAllOfFromTo(sortedList, nextStart, sortedList.size() - 1);
        return bins;
    }

    public static float standardDeviation(float variance) {
        return (float)Math.sqrt(variance);
    }

    public static float standardError(int size, float variance) {
        return (float)Math.sqrt(variance / (float)size);
    }

    public static void standardize(FloatArrayList data, float mean, float standardDeviation) {
        float[] elements = data.elements();
        int i = data.size();
        while (--i >= 0) {
            elements[i] = (elements[i] - mean) / standardDeviation;
        }
    }

    public static float sum(FloatArrayList data) {
        return FloatDescriptive.sumOfPowerDeviations(data, 1, 0.0f);
    }

    public static float sumOfInversions(FloatArrayList data, int from, int to) {
        return FloatDescriptive.sumOfPowerDeviations(data, -1, 0.0f, from, to);
    }

    public static float sumOfLogarithms(FloatArrayList data, int from, int to) {
        float[] elements = data.elements();
        float logsum = 0.0f;
        int i = from - 1;
        while (++i <= to) {
            logsum = (float)((double)logsum + Math.log(elements[i]));
        }
        return logsum;
    }

    public static float sumOfPowerDeviations(FloatArrayList data, int k, float c) {
        return FloatDescriptive.sumOfPowerDeviations(data, k, c, 0, data.size() - 1);
    }

    public static float sumOfPowerDeviations(FloatArrayList data, int k, float c, int from, int to) {
        float[] elements = data.elements();
        float sum = 0.0f;
        switch (k) {
            case -2: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i];
                        sum += 1.0f / (v * v);
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i] - c;
                        sum += 1.0f / (v * v);
                    }
                }
                break;
            }
            case -1: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0f / elements[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += 1.0f / (elements[i] - c);
                    }
                }
                break;
            }
            case 0: {
                sum += (float)(to - from + 1);
                break;
            }
            case 1: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += elements[i];
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        sum += elements[i] - c;
                    }
                }
                break;
            }
            case 2: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i];
                        sum += v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i] - c;
                        sum += v * v;
                    }
                }
                break;
            }
            case 3: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i];
                        sum += v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i] - c;
                        sum += v * v * v;
                    }
                }
                break;
            }
            case 4: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i];
                        sum += v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i] - c;
                        sum += v * v * v * v;
                    }
                }
                break;
            }
            case 5: {
                if ((double)c == 0.0) {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i];
                        sum += v * v * v * v * v;
                    }
                } else {
                    int i = from - 1;
                    while (++i <= to) {
                        float v = elements[i] - c;
                        sum += v * v * v * v * v;
                    }
                }
                break;
            }
            default: {
                int i = from - 1;
                while (++i <= to) {
                    sum = (float)((double)sum + Math.pow(elements[i] - c, k));
                }
                break block0;
            }
        }
        return sum;
    }

    public static float sumOfPowers(FloatArrayList data, int k) {
        return FloatDescriptive.sumOfPowerDeviations(data, k, 0.0f);
    }

    public static float sumOfSquaredDeviations(int size, float variance) {
        return variance * (float)(size - 1);
    }

    public static float sumOfSquares(FloatArrayList data) {
        return FloatDescriptive.sumOfPowerDeviations(data, 2, 0.0f);
    }

    public static float trimmedMean(FloatArrayList sortedData, float mean, int left, int right) {
        int N = sortedData.size();
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        float[] sortedElements = sortedData.elements();
        int N0 = N;
        int i = 0;
        while (i < left) {
            mean += (mean - sortedElements[i]) / (float)(--N);
            ++i;
        }
        i = 0;
        while (i < right) {
            mean += (mean - sortedElements[N0 - 1 - i]) / (float)(--N);
            ++i;
        }
        return mean;
    }

    public static float variance(float standardDeviation) {
        return standardDeviation * standardDeviation;
    }

    public static float variance(int size, float sum, float sumOfSquares) {
        float mean = sum / (float)size;
        return (sumOfSquares - mean * sum) / (float)size;
    }

    public static float weightedMean(FloatArrayList data, FloatArrayList weights) {
        int size = data.size();
        if (size != weights.size() || size == 0) {
            throw new IllegalArgumentException();
        }
        float[] elements = data.elements();
        float[] theWeights = weights.elements();
        float sum = 0.0f;
        float weightsSum = 0.0f;
        int i = size;
        while (--i >= 0) {
            float w = theWeights[i];
            sum += elements[i] * w;
            weightsSum += w;
        }
        return sum / weightsSum;
    }

    public static float weightedRMS(float sumOfProducts, float sumOfSquaredProducts) {
        return sumOfProducts / sumOfSquaredProducts;
    }

    public static float winsorizedMean(FloatArrayList sortedData, float mean, int left, int right) {
        int N = sortedData.size();
        if (N == 0) {
            throw new IllegalArgumentException("Empty data.");
        }
        if (left + right >= N) {
            throw new IllegalArgumentException("Not enough data.");
        }
        float[] sortedElements = sortedData.elements();
        float leftElement = sortedElements[left];
        int i = 0;
        while (i < left) {
            mean += (leftElement - sortedElements[i]) / (float)N;
            ++i;
        }
        float rightElement = sortedElements[N - 1 - right];
        int i2 = 0;
        while (i2 < right) {
            mean += (rightElement - sortedElements[N - 1 - i2]) / (float)N;
            ++i2;
        }
        return mean;
    }
}

