/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.function.tfloat.FloatProcedure;
import cern.jet.stat.BufferSet;
import cern.jet.stat.tfloat.quantile.FloatBuffer;

class FloatBufferSet
extends BufferSet {
    private static final long serialVersionUID = 1L;
    protected FloatBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    public FloatBufferSet(int b, int k) {
        this.buffers = new FloatBuffer[b];
        this.clear(k);
    }

    public FloatBuffer _getFirstEmptyBuffer() {
        FloatBuffer emptyBuffer = null;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            if (this.buffers[i].isAllocated()) {
                return this.buffers[i];
            }
            emptyBuffer = this.buffers[i];
        }
        return emptyBuffer;
    }

    public FloatBuffer[] _getFullOrPartialBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            ++count;
        }
        FloatBuffer[] collectedBuffers = new FloatBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty()) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public FloatBuffer[] _getFullOrPartialBuffersWithLevel(int level) {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || this.buffers[i].level() != level) continue;
            ++count;
        }
        FloatBuffer[] collectedBuffers = new FloatBuffer[count];
        int j = 0;
        int i2 = this.buffers.length;
        while (--i2 >= 0) {
            if (this.buffers[i2].isEmpty() || this.buffers[i2].level() != level) continue;
            collectedBuffers[j++] = this.buffers[i2];
        }
        return collectedBuffers;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int b = this.b();
        int minLevel = Integer.MAX_VALUE;
        int i = 0;
        while (i < b) {
            FloatBuffer buffer = this.buffers[i];
            if (!buffer.isEmpty() && buffer.level() < minLevel) {
                minLevel = buffer.level();
            }
            ++i;
        }
        return minLevel;
    }

    public int _getNumberOfEmptyBuffers() {
        int count = 0;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public FloatBuffer _getPartialBuffer() {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (!this.buffers[i].isPartial()) continue;
            return this.buffers[i];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int k) {
        int i = this.b();
        while (--i >= 0) {
            this.buffers[i] = new FloatBuffer(k);
        }
        this.nextTriggerCalculationState = true;
    }

    @Override
    public Object clone() {
        FloatBufferSet copy = (FloatBufferSet)super.clone();
        copy.buffers = (FloatBuffer[])copy.buffers.clone();
        int i = this.buffers.length;
        while (--i >= 0) {
            copy.buffers[i] = (FloatBuffer)copy.buffers[i].clone();
        }
        return copy;
    }

    public FloatBuffer collapse(FloatBuffer[] buffers) {
        int W = 0;
        int i = 0;
        while (i < buffers.length) {
            W += buffers[i].weight();
            ++i;
        }
        int k = this.k();
        long[] triggerPositions = new long[k];
        int j = 0;
        while (j < k) {
            triggerPositions[j] = this.nextTriggerPosition(j, W);
            ++j;
        }
        float[] outputValues = this.getValuesAtPositions(buffers, triggerPositions);
        int b = 1;
        while (b < buffers.length) {
            buffers[b].clear();
            ++b;
        }
        FloatBuffer outputBuffer = buffers[0];
        outputBuffer.values.elements(outputValues);
        outputBuffer.weight(W);
        return outputBuffer;
    }

    public boolean contains(float element) {
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty() || !this.buffers[i].contains(element)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(FloatProcedure procedure) {
        int i = this.buffers.length;
        while (--i >= 0) {
            int w = this.buffers[i].weight();
            while (--w >= 0) {
                if (this.buffers[i].values.forEach(procedure)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected float[] getValuesAtPositions(FloatBuffer[] buffers, long[] triggerPositions) {
        i = buffers.length;
        while (--i >= 0) {
            buffers[i].sort();
        }
        bufferSizes = new int[buffers.length];
        bufferValues = new float[buffers.length][];
        totalBuffersSize = 0;
        i = buffers.length;
        while (--i >= 0) {
            bufferSizes[i] = buffers[i].size();
            bufferValues[i] = buffers[i].values.elements();
            totalBuffersSize += bufferSizes[i];
        }
        buffersSize = buffers.length;
        triggerPositionsLength = triggerPositions.length;
        j = 0;
        cursors = new int[buffers.length];
        counter = 0L;
        nextHit = triggerPositions[j];
        outputValues = new float[triggerPositionsLength];
        if (totalBuffersSize != 0) ** GOTO lbl45
        i = 0;
        while (i < triggerPositions.length) {
            outputValues[i] = NaNf;
            ++i;
        }
        return outputValues;
lbl-1000:
        // 1 sources

        {
            minValue = Infinityf;
            minBufferIndex = -1;
            b = buffersSize;
            while (--b >= 0) {
                if (cursors[b] >= bufferSizes[b] || !((value = bufferValues[b][cursors[b]]) <= minValue)) continue;
                minValue = value;
                minBufferIndex = b;
            }
            minBuffer = buffers[minBufferIndex];
            counter += (long)minBuffer.weight();
            while (counter > nextHit && j < triggerPositionsLength) {
                outputValues[j++] = minValue;
                if (j >= triggerPositionsLength) continue;
                nextHit = triggerPositions[j];
            }
            v0 = minBufferIndex;
            cursors[v0] = cursors[v0] + 1;
lbl45:
            // 2 sources

            ** while (j < triggerPositionsLength)
        }
lbl46:
        // 1 sources

        return outputValues;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long memory = 0L;
        int i = this.buffers.length;
        while (--i >= 0) {
            memory += (long)this.buffers[i].memory();
        }
        return memory;
    }

    protected long nextTriggerPosition(int j, long W) {
        long nextTriggerPosition = W % 2L != 0L ? (long)j * W + (W + 1L) / 2L : (this.nextTriggerCalculationState ? (long)j * W + W / 2L : (long)j * W + (W + 2L) / 2L);
        return nextTriggerPosition;
    }

    public float phi(float element) {
        float elementsLessThanOrEqualToElement = 0.0f;
        int i = this.buffers.length;
        while (--i >= 0) {
            if (this.buffers[i].isEmpty()) continue;
            elementsLessThanOrEqualToElement += (float)this.buffers[i].weight * this.buffers[i].rank(element);
        }
        return elementsLessThanOrEqualToElement / (float)this.totalSize();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int b = 0;
        while (b < this.b()) {
            if (!this.buffers[b].isEmpty()) {
                buf.append("buffer#" + b + " = ");
                buf.append(String.valueOf(this.buffers[b].toString()) + "\n");
            }
            ++b;
        }
        return buf.toString();
    }

    public long totalSize() {
        FloatBuffer[] fullBuffers = this._getFullOrPartialBuffers();
        long totalSize = 0L;
        int i = fullBuffers.length;
        while (--i >= 0) {
            totalSize += (long)(fullBuffers[i].size() * fullBuffers[i].weight());
        }
        return totalSize;
    }
}

