/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tobject.ObjectArrayList;
import cern.jet.stat.Utils;
import cern.jet.stat.tfloat.quantile.FloatBuffer;
import cern.jet.stat.tfloat.quantile.FloatBufferSet;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;

abstract class FloatQuantileEstimator
extends PersistentObject
implements FloatQuantileFinder {
    private static final long serialVersionUID = 1L;
    protected FloatBufferSet bufferSet;
    protected FloatBuffer currentBufferToFill;
    protected int totalElementsFilled;

    protected FloatQuantileEstimator() {
    }

    @Override
    public void add(float value) {
        ++this.totalElementsFilled;
        if (!this.sampleNextElement()) {
            return;
        }
        if (this.currentBufferToFill == null) {
            if (this.bufferSet._getFirstEmptyBuffer() == null) {
                this.collapse();
            }
            this.newBuffer();
        }
        this.currentBufferToFill.add(value);
        if (this.currentBufferToFill.isFull()) {
            this.currentBufferToFill = null;
        }
    }

    @Override
    public void addAllOf(FloatArrayList values) {
        this.addAllOfFromTo(values, 0, values.size() - 1);
    }

    @Override
    public void addAllOfFromTo(FloatArrayList values, int from, int to) {
        int k;
        float[] valuesToAdd = values.elements();
        int bufferSize = k = this.bufferSet.k();
        float[] bufferValues = null;
        if (this.currentBufferToFill != null) {
            bufferValues = this.currentBufferToFill.values.elements();
            bufferSize = this.currentBufferToFill.size();
        }
        int i = from - 1;
        while (++i <= to) {
            if (!this.sampleNextElement()) continue;
            if (bufferSize == k) {
                if (this.bufferSet._getFirstEmptyBuffer() == null) {
                    this.collapse();
                }
                this.newBuffer();
                if (!this.currentBufferToFill.isAllocated) {
                    this.currentBufferToFill.allocate();
                }
                this.currentBufferToFill.isSorted = false;
                bufferValues = this.currentBufferToFill.values.elements();
                bufferSize = 0;
            }
            bufferValues[bufferSize++] = valuesToAdd[i];
            if (bufferSize != k) continue;
            this.currentBufferToFill.values.setSize(bufferSize);
            this.currentBufferToFill = null;
        }
        if (this.currentBufferToFill != null) {
            this.currentBufferToFill.values.setSize(bufferSize);
        }
        this.totalElementsFilled += to - from + 1;
    }

    protected FloatBuffer[] buffersToCollapse() {
        int minLevel = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    @Override
    public void clear() {
        this.totalElementsFilled = 0;
        this.currentBufferToFill = null;
        this.bufferSet.clear();
    }

    @Override
    public Object clone() {
        FloatQuantileEstimator copy = (FloatQuantileEstimator)super.clone();
        if (this.bufferSet != null) {
            copy.bufferSet = (FloatBufferSet)copy.bufferSet.clone();
            if (this.currentBufferToFill != null) {
                int index = new ObjectArrayList(this.bufferSet.buffers).indexOf(this.currentBufferToFill, true);
                copy.currentBufferToFill = copy.bufferSet.buffers[index];
            }
        }
        return copy;
    }

    protected void collapse() {
        FloatBuffer[] toCollapse = this.buffersToCollapse();
        FloatBuffer outputBuffer = this.bufferSet.collapse(toCollapse);
        int minLevel = toCollapse[0].level();
        outputBuffer.level(minLevel + 1);
        this.postCollapse(toCollapse);
    }

    public boolean contains(float element) {
        return this.bufferSet.contains(element);
    }

    @Override
    public boolean forEach(FloatProcedure procedure) {
        return this.bufferSet.forEach(procedure);
    }

    @Override
    public long memory() {
        return this.bufferSet.memory();
    }

    protected abstract void newBuffer();

    @Override
    public float phi(float element) {
        return this.bufferSet.phi(element);
    }

    protected abstract void postCollapse(FloatBuffer[] var1);

    protected FloatArrayList preProcessPhis(FloatArrayList phis) {
        return phis;
    }

    @Override
    public FloatArrayList quantileElements(FloatArrayList phis) {
        phis = this.preProcessPhis(phis);
        long[] triggerPositions = new long[phis.size()];
        long totalSize = this.bufferSet.totalSize();
        int i = phis.size();
        while (--i >= 0) {
            triggerPositions[i] = Utils.epsilonCeiling(phis.get(i) * (float)totalSize) - 1L;
        }
        FloatBuffer[] fullBuffers = this.bufferSet._getFullOrPartialBuffers();
        float[] quantileElements = new float[phis.size()];
        return new FloatArrayList(this.bufferSet.getValuesAtPositions(fullBuffers, triggerPositions));
    }

    protected abstract boolean sampleNextElement();

    protected void setUp(int b, int k) {
        if (b < 2 || k < 1) {
            throw new IllegalArgumentException("Assertion: b>=2 && k>=1");
        }
        this.bufferSet = new FloatBufferSet(b, k);
        this.clear();
    }

    @Override
    public long size() {
        return this.totalElementsFilled;
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        int b = this.bufferSet.b();
        int k = this.bufferSet.k();
        return String.valueOf(s) + "(mem=" + this.memory() + ", b=" + b + ", k=" + k + ", size=" + this.size() + ", totalSize=" + this.bufferSet.totalSize() + ")";
    }

    @Override
    public long totalMemory() {
        return this.bufferSet.b() * this.bufferSet.k();
    }
}

