/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.stat.tfloat.quantile.ExactFloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.KnownFloatQuantileEstimator;
import cern.jet.stat.tfloat.quantile.UnknownFloatQuantileEstimator;

public class FloatQuantileFinderFactory {
    protected FloatQuantileFinderFactory() {
    }

    public static long[] known_N_compute_B_and_K(long N, float epsilon, float delta, int quantiles, float[] returnSamplingRate) {
        returnSamplingRate[0] = 1.0f;
        if ((double)epsilon <= 0.0) {
            long[] result = new long[]{1L, N};
            return result;
        }
        if ((double)epsilon >= 1.0 || (double)delta >= 1.0) {
            long[] result = new long[]{2L, 1L};
            return result;
        }
        if ((double)delta > 0.0) {
            return FloatQuantileFinderFactory.known_N_compute_B_and_K_slow(N, epsilon, delta, quantiles, returnSamplingRate);
        }
        return FloatQuantileFinderFactory.known_N_compute_B_and_K_quick(N, epsilon);
    }

    protected static long[] known_N_compute_B_and_K_quick(long N, float epsilon) {
        long k;
        long b;
        int maxBuffers = 50;
        int maxHeight = 50;
        float N_float = N;
        float c = N_float * epsilon * 2.0f;
        int[] heightMaximums = new int[49];
        int b2 = 2;
        while (b2 <= 50) {
            int h = 3;
            while (h <= 50 && (double)((float)(h - 2) * FloatArithmetic.binomial(b2 + h - 2, (long)(h - 1)) - FloatArithmetic.binomial(b2 + h - 3, (long)(h - 3)) + FloatArithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c) > 0.0) {
                ++h;
            }
            while (h <= 50 && (double)((float)(h - 2) * FloatArithmetic.binomial(b2 + h - 2, (long)(h - 1)) - FloatArithmetic.binomial(b2 + h - 3, (long)(h - 3)) + FloatArithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c) <= 0.0) {
                ++h;
            }
            int hMax = --h >= 50 && (double)((float)(h - 2) * FloatArithmetic.binomial(b2 + h - 2, (long)(h - 1)) - FloatArithmetic.binomial(b2 + h - 3, (long)(h - 3)) + FloatArithmetic.binomial(b2 + h - 3, (long)(h - 2)) - c) > 0.0 ? Integer.MIN_VALUE : h;
            heightMaximums[b2 - 2] = hMax;
            ++b2;
        }
        long[] kMinimums = new long[49];
        int b3 = 2;
        while (b3 <= 50) {
            float value;
            long tmpK;
            int h = heightMaximums[b3 - 2];
            long kMin = Long.MAX_VALUE;
            if (h > Integer.MIN_VALUE && (tmpK = (long)Math.ceil(N_float / (value = FloatArithmetic.binomial(b3 + h - 2, (long)(h - 1))))) <= Long.MAX_VALUE) {
                kMin = tmpK;
            }
            kMinimums[b3 - 2] = kMin;
            ++b3;
        }
        long multMin = Long.MAX_VALUE;
        int minB = -1;
        int b4 = 2;
        while (b4 <= 50) {
            long mult;
            if (kMinimums[b4 - 2] < Long.MAX_VALUE && (mult = (long)b4 * kMinimums[b4 - 2]) < multMin) {
                multMin = mult;
                minB = b4;
            }
            ++b4;
        }
        if (minB != -1) {
            b = minB;
            k = kMinimums[minB - 2];
        } else {
            b = 1L;
            k = N;
        }
        long[] result = new long[]{b, k};
        return result;
    }

    protected static long[] known_N_compute_B_and_K_slow(long N, float epsilon, float delta, int quantiles, float[] returnSamplingRate) {
        int maxBuffers = 50;
        int maxHeight = 50;
        float N_float = N;
        long ret_b = 1L;
        long ret_k = N;
        float sampling_rate = 1.0f;
        long memory = N;
        float logarithm = (float)Math.log(2.0 * (double)quantiles / (double)delta);
        float c = 2.0f * epsilon * N_float;
        long b = 2L;
        while (b < 50L) {
            long h = 3L;
            while (h < 50L) {
                float binomial = FloatArithmetic.binomial(b + h - 2L, h - 1L);
                long tmp = (long)Math.ceil(N_float / binomial);
                if (b * tmp < memory && (float)(h - 2L) * binomial - FloatArithmetic.binomial(b + h - 3L, h - 3L) + FloatArithmetic.binomial(b + h - 3L, h - 2L) <= c) {
                    ret_k = tmp;
                    ret_b = b;
                    memory = ret_k * b;
                    sampling_rate = 1.0f;
                }
                if ((double)delta > 0.0) {
                    float t = (float)(h - 2L) * FloatArithmetic.binomial(b + h - 2L, h - 1L) - FloatArithmetic.binomial(b + h - 3L, h - 3L) + FloatArithmetic.binomial(b + h - 3L, h - 2L);
                    float u = logarithm / epsilon;
                    float v = FloatArithmetic.binomial(b + h - 2L, h - 1L);
                    float w = logarithm / (2.0f * epsilon * epsilon);
                    float x = (float)(0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * (double)t / (double)u));
                    long k = (long)Math.ceil(w * x * x / v);
                    if (b * k < memory) {
                        ret_k = k;
                        ret_b = b;
                        memory = b * k;
                        sampling_rate = N_float * 2.0f * epsilon * epsilon / logarithm;
                    }
                }
                ++h;
            }
            ++b;
        }
        long[] result = new long[]{ret_b, ret_k};
        returnSamplingRate[0] = sampling_rate;
        return result;
    }

    public static FloatQuantileFinder newFloatQuantileFinder(boolean known_N, long N, float epsilon, float delta, int quantiles, FloatRandomEngine generator) {
        if ((double)epsilon <= 0.0 || N < 1000L) {
            return new ExactFloatQuantileFinder();
        }
        if (epsilon > 1.0f) {
            epsilon = 1.0f;
        }
        if (delta < 0.0f) {
            delta = 0.0f;
        }
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        if (quantiles < 1) {
            quantiles = 1;
        }
        if ((long)quantiles > N) {
            N = quantiles;
        }
        if (known_N) {
            float[] samplingRate = new float[1];
            long[] resultKnown = FloatQuantileFinderFactory.known_N_compute_B_and_K(N, epsilon, delta, quantiles, samplingRate);
            long b = resultKnown[0];
            long k = resultKnown[1];
            if (b == 1L) {
                return new ExactFloatQuantileFinder();
            }
            return new KnownFloatQuantileEstimator((int)b, (int)k, N, samplingRate[0], generator);
        }
        long[] resultUnknown = FloatQuantileFinderFactory.unknown_N_compute_B_and_K(epsilon, delta, quantiles);
        long b1 = resultUnknown[0];
        long k1 = resultUnknown[1];
        long h1 = resultUnknown[2];
        float preComputeEpsilon = -1.0f;
        if (resultUnknown[3] == 1L) {
            preComputeEpsilon = epsilon;
        }
        if (b1 == 1L) {
            return new ExactFloatQuantileFinder();
        }
        return new UnknownFloatQuantileEstimator((int)b1, (int)k1, (int)h1, preComputeEpsilon, generator);
    }

    public static FloatArrayList newEquiDepthPhis(int quantiles) {
        FloatArrayList phis = new FloatArrayList(quantiles - 1);
        int i = 1;
        while (i <= quantiles - 1) {
            phis.add((float)i / (float)quantiles);
            ++i;
        }
        return phis;
    }

    public static long[] unknown_N_compute_B_and_K(float epsilon, float delta, int quantiles) {
        return FloatQuantileFinderFactory.unknown_N_compute_B_and_K_raw(epsilon, delta, quantiles);
    }

    protected static long[] unknown_N_compute_B_and_K_raw(float epsilon, float delta, int quantiles) {
        if ((double)epsilon <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return result;
        }
        if ((double)epsilon >= 1.0 || (double)delta >= 1.0) {
            long[] result = new long[]{2L, 1L, 3L, 0L};
            return result;
        }
        if ((double)delta <= 0.0) {
            long[] result = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return result;
        }
        int max_b = 50;
        int max_h = 50;
        int max_H = 50;
        int max_Iterations = 2;
        long best_b = Long.MAX_VALUE;
        long best_k = Long.MAX_VALUE;
        long best_h = Long.MAX_VALUE;
        long best_memory = Long.MAX_VALUE;
        float pow = (float)Math.pow(2.0, max_H);
        float logDelta = (float)(Math.log(2.0 / (double)(delta / (float)quantiles)) / (2.0 * (double)epsilon * (double)epsilon));
        while (best_b == Long.MAX_VALUE && max_Iterations-- > 0) {
            int b = 2;
            while (b <= max_b) {
                int h = 2;
                while (h <= max_h) {
                    float beta;
                    float cc;
                    float d;
                    float Ls;
                    float Ld = FloatArithmetic.binomial(b + h - 2, (long)(h - 1));
                    float c = (float)((double)logDelta / Math.min((double)Ld, 8.0 * (double)(Ls = FloatArithmetic.binomial(b + h - 3, (long)(h - 1))) / 3.0));
                    float f = c * c + 4.0f * c * (d = (float)((double)((float)(h + 3) + (cc = (float)(((double)(beta = Ld / Ls) - 2.0) * ((double)max_H - 2.0) / ((double)(beta + pow) - 2.0)))) / (2.0 * (double)epsilon)));
                    if (!((double)f < 0.0)) {
                        float root = (float)Math.sqrt(f);
                        float alpha_one = (float)(((double)c + 2.0 * (double)d + (double)root) / (2.0 * (double)d));
                        float alpha_two = (float)(((double)c + 2.0 * (double)d - (double)root) / (2.0 * (double)d));
                        boolean alpha_one_OK = false;
                        boolean alpha_two_OK = false;
                        if (0.0 < (double)alpha_one && (double)alpha_one < 1.0) {
                            alpha_one_OK = true;
                        }
                        if (0.0 < (double)alpha_two && (double)alpha_two < 1.0) {
                            alpha_two_OK = true;
                        }
                        if (alpha_one_OK || alpha_two_OK) {
                            long memory;
                            float alpha = alpha_one;
                            if (alpha_one_OK && alpha_two_OK) {
                                alpha = Math.max(alpha_one, alpha_two);
                            } else if (alpha_two_OK) {
                                alpha = alpha_two;
                            }
                            long k = (long)Math.ceil(Math.max((double)(d / alpha), (double)(h + 1) / (2.0 * (double)epsilon)));
                            if (k > 0L && (memory = (long)b * k) < best_memory) {
                                best_k = k;
                                best_b = b;
                                best_h = h;
                                best_memory = memory;
                            }
                        }
                    }
                    ++h;
                }
                ++b;
            }
            if (best_b != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            max_b *= 2;
            max_h *= 2;
            max_H *= 2;
        }
        long[] result = new long[4];
        result[3] = 0L;
        if (best_b == Long.MAX_VALUE) {
            result[0] = 1L;
            result[1] = Long.MAX_VALUE;
            result[2] = Long.MAX_VALUE;
        } else {
            result[0] = best_b;
            result[1] = best_k;
            result[2] = best_h;
        }
        return result;
    }
}

