/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.random.tdouble.engine.DRand;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinder;
import cern.jet.stat.tdouble.quantile.DoubleQuantileFinderFactory;
import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.bin.AbstractDoubleBin1D;
import hep.aida.tdouble.bin.MightyStaticDoubleBin1D;
import hep.aida.tdouble.ref.DoubleConverter;
import java.util.Date;

public class QuantileDoubleBin1D
extends MightyStaticDoubleBin1D {
    private static final long serialVersionUID = 1L;
    protected DoubleQuantileFinder finder = null;

    protected QuantileDoubleBin1D() {
        super(false, false, 2);
    }

    public QuantileDoubleBin1D(double epsilon) {
        this(false, Long.MAX_VALUE, epsilon, 0.001, 10000, new DRand(new Date()));
    }

    public QuantileDoubleBin1D(boolean known_N, long N, double epsilon, double delta, int quantiles, DoubleRandomEngine randomGenerator) {
        this(known_N, N, epsilon, delta, quantiles, randomGenerator, false, false, 2);
    }

    public QuantileDoubleBin1D(boolean known_N, long N, double epsilon, double delta, int quantiles, DoubleRandomEngine randomGenerator, boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        super(hasSumOfLogarithms, hasSumOfInversions, maxOrderForSumOfPowers);
        this.finder = DoubleQuantileFinderFactory.newDoubleQuantileFinder(known_N, N, epsilon, delta, quantiles, randomGenerator);
        this.clear();
    }

    @Override
    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(list, from, to);
        }
    }

    @Override
    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    @Override
    public synchronized Object clone() {
        QuantileDoubleBin1D clone = (QuantileDoubleBin1D)super.clone();
        if (this.finder != null) {
            clone.finder = (DoubleQuantileFinder)clone.finder.clone();
        }
        return clone;
    }

    @Override
    public String compareWith(AbstractDoubleBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof QuantileDoubleBin1D) {
            QuantileDoubleBin1D q = (QuantileDoubleBin1D)other;
            buf.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25), q.quantile(0.25)) + ", " + this.relError(this.quantile(0.5), q.quantile(0.5)) + ", " + this.relError(this.quantile(0.75), q.quantile(0.75)));
            buf.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), q.quantileInverse(q.mean())) + " %");
            buf.append("\n");
        }
        return buf.toString();
    }

    public double median() {
        return this.quantile(0.5);
    }

    public synchronized double quantile(double phi) {
        return this.quantiles(new DoubleArrayList(new double[]{phi})).get(0);
    }

    public synchronized double quantileInverse(double element) {
        return this.finder.phi(element);
    }

    public synchronized DoubleArrayList quantiles(DoubleArrayList phis) {
        return this.finder.quantileElements(phis);
    }

    public int sizeOfRange(double minElement, double maxElement) {
        return (int)Math.round((double)this.size() * (this.quantileInverse(maxElement) - this.quantileInverse(minElement)));
    }

    public synchronized MightyStaticDoubleBin1D[] splitApproximately(DoubleArrayList percentages, int k) {
        int percentSize = percentages.size();
        if (k < 1 || percentSize < 2) {
            throw new IllegalArgumentException();
        }
        double[] percent = percentages.elements();
        int noOfBins = percentSize - 1;
        double[] subBins = new double[1 + k * (percentSize - 1)];
        subBins[0] = percent[0];
        int c = 1;
        int i = 0;
        while (i < noOfBins) {
            double step = (percent[i + 1] - percent[i]) / (double)k;
            int j = 1;
            while (j <= k) {
                subBins[c++] = percent[i] + (double)j * step;
                ++j;
            }
            ++i;
        }
        double[] quantiles = this.quantiles(new DoubleArrayList(subBins)).elements();
        MightyStaticDoubleBin1D[] splitBins = new MightyStaticDoubleBin1D[noOfBins];
        int maxOrderForSumOfPowers = this.getMaxOrderForSumOfPowers();
        maxOrderForSumOfPowers = Math.min(10, maxOrderForSumOfPowers);
        int dataSize = this.size();
        c = 0;
        int i2 = 0;
        while (i2 < noOfBins) {
            double binMax;
            double binMin;
            double step = (percent[i2 + 1] - percent[i2]) / (double)k;
            double binSum = 0.0;
            double binSumOfSquares = 0.0;
            double binSumOfLogarithms = 0.0;
            double binSumOfInversions = 0.0;
            double[] binSumOfPowers = null;
            if (maxOrderForSumOfPowers > 2) {
                binSumOfPowers = new double[maxOrderForSumOfPowers - 2];
            }
            double safe_min = binMin = quantiles[c++];
            double subIntervalSize = (double)dataSize * step;
            int j = 1;
            while (j <= k) {
                binMax = quantiles[c++];
                double binMean = (binMin + binMax) / 2.0;
                binSum += binMean * subIntervalSize;
                binSumOfSquares += binMean * binMean * subIntervalSize;
                if (this.hasSumOfLogarithms) {
                    binSumOfLogarithms += Math.log(binMean) * subIntervalSize;
                }
                if (this.hasSumOfInversions) {
                    binSumOfInversions += 1.0 / binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 3) {
                    binSumOfPowers[0] = binSumOfPowers[0] + binMean * binMean * binMean * subIntervalSize;
                }
                if (maxOrderForSumOfPowers >= 4) {
                    binSumOfPowers[1] = binSumOfPowers[1] + binMean * binMean * binMean * binMean * subIntervalSize;
                }
                int p = 5;
                while (p <= maxOrderForSumOfPowers) {
                    int n = p - 3;
                    binSumOfPowers[n] = binSumOfPowers[n] + Math.pow(binMean, p) * subIntervalSize;
                    ++p;
                }
                binMin = binMax;
                ++j;
            }
            --c;
            int binSize = (int)Math.round((percent[i2 + 1] - percent[i2]) * (double)dataSize);
            binMax = binMin;
            binMin = safe_min;
            splitBins[i2] = new MightyStaticDoubleBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, maxOrderForSumOfPowers);
            if (binSize > 0) {
                splitBins[i2].size = binSize;
                splitBins[i2].min = binMin;
                splitBins[i2].max = binMax;
                splitBins[i2].sum = binSum;
                splitBins[i2].sum_xx = binSumOfSquares;
                splitBins[i2].sumOfLogarithms = binSumOfLogarithms;
                splitBins[i2].sumOfInversions = binSumOfInversions;
                splitBins[i2].sumOfPowers = binSumOfPowers;
            }
            ++i2;
        }
        return splitBins;
    }

    public synchronized MightyStaticDoubleBin1D[] splitApproximately(DoubleIAxis axis, int k) {
        DoubleArrayList percentages = new DoubleArrayList(new DoubleConverter().edges(axis));
        percentages.beforeInsert(0, Double.NEGATIVE_INFINITY);
        percentages.add(Double.POSITIVE_INFINITY);
        int i = percentages.size();
        while (--i >= 0) {
            percentages.set(i, this.quantileInverse(percentages.get(i)));
        }
        return this.splitApproximately(percentages, k);
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25) + ", " + this.quantile(0.5) + ", " + this.quantile(0.75));
        buf.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        buf.append("\n");
        return buf.toString();
    }
}

