/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.StriddenByte1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte1D
extends Array1D
implements ByteArray {
    protected Byte1D(int dim1) {
        super(dim1);
    }

    protected Byte1D(int[] dims) {
        super(dims);
    }

    protected Byte1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1);

    public abstract void set(int var1, byte var2);

    @Override
    public void fill(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, value);
            ++i1;
        }
    }

    @Override
    public void increment(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (byte)(this.get(i1) + value));
            ++i1;
        }
    }

    @Override
    public void decrement(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (byte)(this.get(i1) - value));
            ++i1;
        }
    }

    @Override
    public void scale(byte value) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, (byte)(this.get(i1) * value));
            ++i1;
        }
    }

    @Override
    public void map(ByteFunction function) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, function.apply(this.get(i1)));
            ++i1;
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, generator.nextByte());
            ++i1;
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        scanner.initialize(this.get(0));
        int i1 = 1;
        while (i1 < this.dim1) {
            scanner.update(this.get(i1));
            ++i1;
        }
    }

    @Override
    public byte[] flatten(boolean forceCopy) {
        byte[] out = new byte[this.number];
        int i1 = 0;
        while (i1 < this.dim1) {
            out[i1] = this.get(i1);
            ++i1;
        }
        return out;
    }

    @Override
    public byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0) & 0xFF;
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1) & 0xFF;
            if (value < minValue) {
                minValue = value;
            }
            ++i1;
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0) & 0xFF;
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1) & 0xFF;
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0) & 0xFF;
        int i1 = 1;
        while (i1 < this.dim1) {
            int value = this.get(i1) & 0xFF;
            if (value < minValue) {
                minValue = value;
            }
            if (value > maxValue) {
                maxValue = value;
            }
            ++i1;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = this.get(0) & 0xFF;
        int i1 = 1;
        while (i1 < this.dim1) {
            totalValue += this.get(i1) & 0xFF;
            ++i1;
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        return this;
    }

    @Override
    public Short1D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Short1D.wrap(out, this.dim1);
    }

    @Override
    public Int1D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Int1D.wrap(out, this.dim1);
    }

    @Override
    public Long1D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Long1D.wrap(out, this.dim1);
    }

    @Override
    public Float1D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Float1D.wrap(out, this.dim1);
    }

    @Override
    public Double1D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i1 = 0;
        while (i1 < this.dim1) {
            out[++i] = this.get(i1);
            ++i1;
        }
        return Double1D.wrap(out, this.dim1);
    }

    @Override
    public Byte1D copy() {
        return new FlatByte1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Byte1D src = arr.getType() == 0 ? (Byte1D)arr : (Byte1D)arr.toByte();
        int i1 = 0;
        while (i1 < this.dim1) {
            this.set(i1, src.get(i1));
            ++i1;
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (byte)src.get(i1));
                ++i1;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i1 = 0;
            while (i1 < this.dim1) {
                this.set(i1, (byte)src.get(i1));
                ++i1;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte1D create() {
        return new FlatByte1D(this.getShape());
    }

    public static Byte1D create(int dim1) {
        return new FlatByte1D(dim1);
    }

    public static Byte1D create(int[] dims) {
        return new FlatByte1D(dims);
    }

    public static Byte1D create(Shape shape) {
        return new FlatByte1D(shape);
    }

    public static Byte1D wrap(byte[] data, int dim1) {
        return new FlatByte1D(data, dim1);
    }

    public static Byte1D wrap(byte[] data, int[] dims) {
        return new FlatByte1D(data, dims);
    }

    public static Byte1D wrap(byte[] data, Shape shape) {
        return new FlatByte1D(data, shape);
    }

    public static Byte1D wrap(byte[] data, int offset, int stride1, int dim1) {
        return new StriddenByte1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract ByteScalar slice(int var1);

    @Override
    public abstract ByteScalar slice(int var1, int var2);

    @Override
    public abstract Byte1D view(Range var1);

    @Override
    public abstract Byte1D view(int[] var1);

    @Override
    public abstract Byte1D as1D();
}

