/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float1D;
import mitiv.array.FloatArray;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatFloat2D;
import mitiv.array.impl.StriddenFloat2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float2D
extends Array2D
implements FloatArray {
    protected Float2D(int dim1, int dim2) {
        super(dim1, dim2);
    }

    protected Float2D(int[] dims) {
        super(dims);
    }

    protected Float2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2);

    public abstract void set(int var1, int var2, float var3);

    @Override
    public void fill(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void increment(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, this.get(i1, i2) + value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void decrement(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, this.get(i1, i2) - value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scale(float value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, this.get(i1, i2) * value);
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void map(FloatFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, function.apply(this.get(i1, i2)));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void fill(FloatGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, generator.nextFloat());
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, generator.nextFloat());
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void scan(FloatScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (initialized) {
                        scanner.update(this.get(i1, i2));
                    } else {
                        scanner.initialize(this.get(i1, i2));
                        initialized = true;
                    }
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public float[] flatten(boolean forceCopy) {
        float[] out = new float[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return out;
    }

    @Override
    public float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return minValue;
    }

    @Override
    public float max() {
        float maxValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        return maxValue;
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float minValue;
        float maxValue = minValue = this.get(0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    if (skip) {
                        skip = false;
                    } else {
                        float value = this.get(i1, i2);
                        if (value < minValue) {
                            minValue = value;
                        }
                        if (value > maxValue) {
                            maxValue = value;
                        }
                    }
                    ++i1;
                }
                ++i2;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public float sum() {
        float totalValue = 0.0f;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    totalValue += this.get(i1, i2);
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    totalValue += this.get(i1, i2);
                    ++i1;
                }
                ++i2;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = (byte)this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Byte2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Short2D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = (short)this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Short2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Int2D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = (int)this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Int2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Long2D toLong() {
        long[] out = new long[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = (long)this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Long2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Float2D toFloat() {
        return this;
    }

    @Override
    public Double2D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i2 = 0;
        while (i2 < this.dim2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                out[++i] = this.get(i1, i2);
                ++i1;
            }
            ++i2;
        }
        return Double2D.wrap(out, this.dim1, this.dim2);
    }

    @Override
    public Float2D copy() {
        return new FlatFloat2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Float2D src = arr.getType() == 4 ? (Float2D)arr : (Float2D)arr.toFloat();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, src.get(i1, i2));
                    ++i1;
                }
                ++i2;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (float)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i2 = 0;
            while (i2 < this.dim2) {
                int i1 = 0;
                while (i1 < this.dim1) {
                    this.set(i1, i2, (float)src.get(++i));
                    ++i1;
                }
                ++i2;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float2D create() {
        return new FlatFloat2D(this.getShape());
    }

    public static Float2D create(int dim1, int dim2) {
        return new FlatFloat2D(dim1, dim2);
    }

    public static Float2D create(int[] dims) {
        return new FlatFloat2D(dims);
    }

    public static Float2D create(Shape shape) {
        return new FlatFloat2D(shape);
    }

    public static Float2D wrap(float[] data, int dim1, int dim2) {
        return new FlatFloat2D(data, dim1, dim2);
    }

    public static Float2D wrap(float[] data, int[] dims) {
        return new FlatFloat2D(data, dims);
    }

    public static Float2D wrap(float[] data, Shape shape) {
        return new FlatFloat2D(data, shape);
    }

    public static Float2D wrap(float[] data, int offset, int stride1, int stride2, int dim1, int dim2) {
        return new StriddenFloat2D(data, offset, stride1, stride2, dim1, dim2);
    }

    @Override
    public abstract Float1D slice(int var1);

    @Override
    public abstract Float1D slice(int var1, int var2);

    @Override
    public abstract Float2D view(Range var1, Range var2);

    @Override
    public abstract Float2D view(int[] var1, int[] var2);

    @Override
    public abstract Float1D as1D();
}

