/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array6D;
import mitiv.array.Byte6D;
import mitiv.array.Double6D;
import mitiv.array.Float6D;
import mitiv.array.Int6D;
import mitiv.array.Long1D;
import mitiv.array.Long5D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short6D;
import mitiv.array.impl.FlatLong6D;
import mitiv.array.impl.StriddenLong6D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long6D
extends Array6D
implements LongArray {
    protected Long6D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        super(dim1, dim2, dim3, dim4, dim5, dim6);
    }

    protected Long6D(int[] dims) {
        super(dims);
    }

    protected Long6D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, long var7);

    @Override
    public void fill(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void increment(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) + value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) + value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void decrement(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) - value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) - value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void scale(long value) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) * value);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, this.get(i1, i2, i3, i4, i5, i6) * value);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void map(LongFunction function) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, function.apply(this.get(i1, i2, i3, i4, i5, i6)));
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, function.apply(this.get(i1, i2, i3, i4, i5, i6)));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, generator.nextLong());
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, generator.nextLong());
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (initialized) {
                                        scanner.update(this.get(i1, i2, i3, i4, i5, i6));
                                    } else {
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6));
                                        initialized = true;
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (initialized) {
                                        scanner.update(this.get(i1, i2, i3, i4, i5, i6));
                                    } else {
                                        scanner.initialize(this.get(i1, i2, i3, i4, i5, i6));
                                        initialized = true;
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        long[] out = new long[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return out;
    }

    @Override
    public long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long minValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return minValue;
    }

    @Override
    public long max() {
        long maxValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return maxValue;
    }

    @Override
    public long[] getMinAndMax() {
        long[] result = new long[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(long[] mm) {
        long minValue;
        long maxValue = minValue = this.get(0, 0, 0, 0, 0, 0);
        boolean skip = true;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    if (skip) {
                                        skip = false;
                                    } else {
                                        long value = this.get(i1, i2, i3, i4, i5, i6);
                                        if (value < minValue) {
                                            minValue = value;
                                        }
                                        if (value > maxValue) {
                                            maxValue = value;
                                        }
                                    }
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public long sum() {
        long totalValue = 0L;
        if (this.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    totalValue += this.get(i1, i2, i3, i4, i5, i6);
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    totalValue += this.get(i1, i2, i3, i4, i5, i6);
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte6D toByte() {
        byte[] out = new byte[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (byte)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Byte6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Short6D toShort() {
        short[] out = new short[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (short)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Short6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Int6D toInt() {
        int[] out = new int[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = (int)this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Int6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Long6D toLong() {
        return this;
    }

    @Override
    public Float6D toFloat() {
        float[] out = new float[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Float6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Double6D toDouble() {
        double[] out = new double[this.number];
        int i = -1;
        int i6 = 0;
        while (i6 < this.dim6) {
            int i5 = 0;
            while (i5 < this.dim5) {
                int i4 = 0;
                while (i4 < this.dim4) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i2 = 0;
                        while (i2 < this.dim2) {
                            int i1 = 0;
                            while (i1 < this.dim1) {
                                out[++i] = this.get(i1, i2, i3, i4, i5, i6);
                                ++i1;
                            }
                            ++i2;
                        }
                        ++i3;
                    }
                    ++i4;
                }
                ++i5;
            }
            ++i6;
        }
        return Double6D.wrap(out, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Long6D copy() {
        return new FlatLong6D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        Long6D src = arr.getType() == 3 ? (Long6D)arr : (Long6D)arr.toLong();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            int i1 = 0;
            while (i1 < this.dim1) {
                int i2 = 0;
                while (i2 < this.dim2) {
                    int i3 = 0;
                    while (i3 < this.dim3) {
                        int i4 = 0;
                        while (i4 < this.dim4) {
                            int i5 = 0;
                            while (i5 < this.dim5) {
                                int i6 = 0;
                                while (i6 < this.dim6) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(i1, i2, i3, i4, i5, i6));
                                    ++i6;
                                }
                                ++i5;
                            }
                            ++i4;
                        }
                        ++i3;
                    }
                    ++i2;
                }
                ++i1;
            }
        } else {
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, src.get(i1, i2, i3, i4, i5, i6));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape.");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, (long)src.get(++i));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            int i6 = 0;
            while (i6 < this.dim6) {
                int i5 = 0;
                while (i5 < this.dim5) {
                    int i4 = 0;
                    while (i4 < this.dim4) {
                        int i3 = 0;
                        while (i3 < this.dim3) {
                            int i2 = 0;
                            while (i2 < this.dim2) {
                                int i1 = 0;
                                while (i1 < this.dim1) {
                                    this.set(i1, i2, i3, i4, i5, i6, (long)src.get(++i));
                                    ++i1;
                                }
                                ++i2;
                            }
                            ++i3;
                        }
                        ++i4;
                    }
                    ++i5;
                }
                ++i6;
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long6D create() {
        return new FlatLong6D(this.getShape());
    }

    public static Long6D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new FlatLong6D(dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Long6D create(int[] dims) {
        return new FlatLong6D(dims);
    }

    public static Long6D create(Shape shape) {
        return new FlatLong6D(shape);
    }

    public static Long6D wrap(long[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new FlatLong6D(data, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    public static Long6D wrap(long[] data, int[] dims) {
        return new FlatLong6D(data, dims);
    }

    public static Long6D wrap(long[] data, Shape shape) {
        return new FlatLong6D(data, shape);
    }

    public static Long6D wrap(long[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6) {
        return new StriddenLong6D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, dim1, dim2, dim3, dim4, dim5, dim6);
    }

    @Override
    public abstract Long5D slice(int var1);

    @Override
    public abstract Long5D slice(int var1, int var2);

    @Override
    public abstract Long6D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6);

    @Override
    public abstract Long6D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6);

    @Override
    public abstract Long1D as1D();
}

