/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;

public abstract class Scalar
implements ShapedArray {
    protected static final Shape shape = Shape.make();
    protected static final int number = 1;

    protected Scalar() {
    }

    protected Scalar(int[] dims) {
        this(Shape.make(dims));
    }

    protected Scalar(Shape shape) {
        if (shape.rank() != 0) {
            throw new IllegalArgumentException("Bad number of dimensions for 0-D array.");
        }
    }

    @Override
    public final int getRank() {
        return 0;
    }

    @Override
    public final Shape getShape() {
        return shape;
    }

    @Override
    public final int getNumber() {
        return 1;
    }

    @Override
    public final int getDimension(int k) {
        return shape.dimension(k);
    }

    @Override
    public abstract Scalar copy();

    @Override
    public abstract Array1D as1D();
}

