/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Typed;

public class ArrayDescriptor
implements Shaped,
Typed {
    final int type;
    final int number;
    final Shape shape;

    public ArrayDescriptor(int type, int[] shape) {
        this(type, Shape.make(shape));
    }

    public ArrayDescriptor(int type, Shape shape) {
        this.type = type;
        this.shape = shape;
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large.");
        }
        this.number = (int)this.shape.number();
    }

    public static int computeNumber(int[] shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Illegal NULL shape.");
        }
        int number = 1;
        int r = 0;
        while (r < shape.length) {
            if (shape[r] <= 0) {
                throw new IllegalArgumentException("Bad dimension length.");
            }
            number *= shape[r];
            ++r;
        }
        return number;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public final int getRank() {
        return this.shape.rank();
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }
}

