/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.PseudoL1NormOfDoubleVector;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;

public class PseudoL1NormOfBoundedDoubleVector
extends PseudoL1NormOfDoubleVector {
    public static final int SCALAR_MIN = 1;
    public static final int VECTOR_MIN = 2;
    public static final int SCALAR_MAX = 4;
    public static final int VECTOR_MAX = 8;
    protected double xmin = Double.NEGATIVE_INFINITY;
    protected double xmax = Double.POSITIVE_INFINITY;
    protected double xmid = 0.0;
    protected int typeOfBounds = 0;

    public PseudoL1NormOfBoundedDoubleVector(DoubleShapedVectorSpace inputSpace) {
        super(inputSpace);
    }

    public PseudoL1NormOfBoundedDoubleVector(DoubleShapedVectorSpace inputSpace, double xmin, double xmax) {
        super(inputSpace);
        this.setBounds(xmin, xmax);
    }

    public void setBounds(double xmin, double xmax) {
        if (Double.isNaN(xmax) || Double.isNaN(xmin)) {
            throw new IllegalArgumentException("Bounds must be regular values or +/-infinity.");
        }
        if (xmin > xmax) {
            throw new IllegalArgumentException("Empty feasible set.");
        }
        this.typeOfBounds = 0;
        this.xmid = 0.0;
        if (Double.isInfinite(xmin)) {
            this.xmin = Double.NEGATIVE_INFINITY;
        } else {
            this.xmin = xmin;
            this.xmid = Math.max(this.xmid, xmin);
            this.typeOfBounds |= 1;
        }
        if (Double.isInfinite(xmax)) {
            this.xmax = Double.POSITIVE_INFINITY;
        } else {
            this.xmax = xmax;
            this.xmid = Math.min(this.xmid, xmax);
            this.typeOfBounds |= 4;
        }
    }

    private final double minCut(double x) {
        return Math.max(x, this.xmin);
    }

    private final double maxCut(double x) {
        return Math.min(x, this.xmax);
    }

    private final double cut(double x) {
        return Math.min(Math.max(x, this.xmin), this.xmax);
    }

    @Override
    public void applyProx(Vector out, double alpha, Vector inp, double tol) {
        if (alpha == 0.0) {
            out.copyFrom(inp);
        } else if (alpha > 0.0) {
            if (!inp.belongsTo(this.inputSpace) || !out.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException();
            }
            double[] x = ((DoubleShapedVector)inp).getData();
            double[] y = ((DoubleShapedVector)inp).getData();
            double tmin = -alpha;
            double tmax = alpha;
            int n = x.length;
            switch (this.typeOfBounds) {
                case 0: {
                    int j = 0;
                    while (j < n) {
                        double t = x[j];
                        y[j] = t <= tmin ? t - tmin : (t >= tmax ? t - tmax : this.xmid);
                        ++j;
                    }
                    break;
                }
                case 1: {
                    if (this.xmin >= 0.0) {
                        int j = 0;
                        while (j < n) {
                            y[j] = this.minCut(x[j] - alpha);
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < n) {
                            double t = x[j];
                            y[j] = t <= tmin ? this.minCut(t - tmin) : (t >= tmax ? this.minCut(t - tmax) : this.xmid);
                            ++j;
                        }
                    }
                    break;
                }
                case 4: {
                    if (this.xmax <= 0.0) {
                        int j = 0;
                        while (j < n) {
                            y[j] = this.maxCut(x[j] + alpha);
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < n) {
                            double t = x[j];
                            y[j] = t <= tmin ? this.maxCut(t - tmin) : (t >= tmax ? this.maxCut(t - tmax) : this.xmid);
                            ++j;
                        }
                    }
                    break;
                }
                case 5: {
                    int j = 0;
                    while (j < n) {
                        double t = x[j];
                        y[j] = t <= tmin ? this.cut(t - tmin) : (t >= tmax ? this.cut(t - tmax) : this.xmid);
                        ++j;
                    }
                    break;
                }
            }
        }
    }
}

