/*
 * Decompiled with CFR 0.152.
 */
package mitiv.invpb;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LeftHandSideMatrix
extends LinearOperator {
    private LinearOperator H;
    private LinearOperator W;
    private LinearOperator Q;
    private double mu;
    private Vector tmp1;
    private Vector tmp2;

    public LeftHandSideMatrix(LinearOperator H, LinearOperator W, LinearOperator Q, double mu) {
        super(H.getInputSpace());
        if (W.getOutputSpace() != W.getInputSpace()) {
            throw new IllegalArgumentException("Linear operator W must be an endomorphism.");
        }
        if (W.getInputSpace() != H.getOutputSpace()) {
            throw new IllegalArgumentException("Linear operator W must operate on output space of H.");
        }
        if (Q.getOutputSpace() != Q.getInputSpace()) {
            throw new IllegalArgumentException("Linear operator Q must be an endomorphism.");
        }
        if (Q.getInputSpace() != H.getInputSpace()) {
            throw new IllegalArgumentException("Linear operator Q must operate on input space of H.");
        }
        this.H = H;
        this.W = W;
        this.Q = Q;
        this.setMu(mu);
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job != DIRECT) {
            throw new IllegalLinearOperationException();
        }
        if (this.tmp1 == null) {
            this.tmp1 = this.H.getOutputSpace().create();
        }
        this.H.apply(this.tmp1, src);
        this.W.apply(this.tmp1, this.tmp1);
        this.H.apply(dst, this.tmp1, ADJOINT);
        if (this.mu > 0.0) {
            if (this.tmp2 == null) {
                VectorSpace space = this.Q.getOutputSpace();
                this.tmp2 = this.tmp1.belongsTo(space) ? this.tmp1 : space.create();
            }
            this.Q.apply(this.tmp2, src);
            this.outputSpace.combine(this.mu, this.tmp2, 1.0, dst);
        }
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double mu) {
        if (mu < 0.0) {
            throw new IllegalArgumentException("Regularization weight MU must be non-negative.");
        }
        this.mu = mu;
    }

    public void computeRightHandSideVector(Vector y, Vector b) {
        if (this.tmp1 == null) {
            this.tmp1 = this.H.getOutputSpace().create();
        }
        this.W.apply(this.tmp1, y);
        this.H.apply(b, this.tmp1, ADJOINT);
    }
}

