/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.utils.CommonUtils;

public class BufferedImageUtils {
    public static ShapedArray imageToArray(BufferedImage image) {
        return BufferedImageUtils.imageToArray(image, false);
    }

    public static ShapedArray imageToArray(BufferedImage image, boolean single) {
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster raster = image.getRaster();
        if (single) {
            int size = width * height;
            float[] out = new float[size];
            int[] tmp = new int[raster.getNumBands()];
            int j = 0;
            while (j < height) {
                int i = 0;
                while (i < width) {
                    raster.getPixel(i, j, tmp);
                    out[i + j * width] = tmp.length == 1 || tmp.length == 2 ? (float)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (float)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                    ++i;
                }
                ++j;
            }
            return Float2D.wrap(out, width, height);
        }
        int size = width * height;
        double[] out = new double[size];
        int[] tmp = new int[raster.getNumBands()];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                raster.getPixel(i, j, tmp);
                out[i + j * width] = tmp.length == 1 || tmp.length == 2 ? (double)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (double)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                ++i;
            }
            ++j;
        }
        return Double2D.wrap(out, width, height);
    }

    public static ShapedArray imageToArray(ArrayList<BufferedImage> listImage) {
        return BufferedImageUtils.imageToArray(listImage, false);
    }

    public static ShapedArray imageToArray(ArrayList<BufferedImage> listImage, boolean single) {
        int width = listImage.get(0).getWidth();
        int height = listImage.get(0).getHeight();
        int sizeZ = listImage.size();
        if (single) {
            float[] out = new float[sizeZ * width * height];
            int k = 0;
            while (k < sizeZ) {
                BufferedImage current = listImage.get(k);
                WritableRaster raster = current.getRaster();
                int[] tmp = new int[raster.getNumBands()];
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        raster.getPixel(i, j, tmp);
                        out[i + j * width + k * width * height] = tmp.length == 1 || tmp.length == 2 ? (float)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (float)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            return Float3D.wrap(out, width, height, sizeZ);
        }
        double[] out = new double[sizeZ * width * height];
        int k = 0;
        while (k < sizeZ) {
            BufferedImage current = listImage.get(k);
            WritableRaster raster = current.getRaster();
            int[] tmp = new int[raster.getNumBands()];
            int j = 0;
            while (j < height) {
                int i = 0;
                while (i < width) {
                    raster.getPixel(i, j, tmp);
                    out[i + j * width + k * width * height] = tmp.length == 1 || tmp.length == 2 ? (double)CommonUtils.colorToGrey(tmp[0], tmp[0], tmp[0]) : (double)CommonUtils.colorToGrey(tmp[0], tmp[1], tmp[2]);
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return Double3D.wrap(out, width, height, sizeZ);
    }

    public static ShapedArray arrayToImage(double[] array, Shape shape) {
        if (shape.rank() == 2) {
            return BufferedImageUtils.arrayToImage(array, shape.dimension(0), shape.dimension(1));
        }
        if (shape.rank() == 3) {
            return BufferedImageUtils.arrayToImage(array, shape.dimension(0), shape.dimension(1), shape.dimension(2));
        }
        throw new IllegalArgumentException("Only Bi and tri dimensionnal images are accepted now");
    }

    public static ShapedArray arrayToImage(double[] array, int width, int height) {
        return Double2D.wrap(array, width, height);
    }

    public static ShapedArray arrayToImage(double[] array, int width, int height, int depth) {
        return Double3D.wrap(array, width, height, depth);
    }

    public static ShapedArray arrayToImage(float[] array, Shape shape) {
        if (shape.rank() == 2) {
            return BufferedImageUtils.arrayToImage(array, shape.dimension(0), shape.dimension(1));
        }
        if (shape.rank() == 3) {
            return BufferedImageUtils.arrayToImage(array, shape.dimension(0), shape.dimension(1), shape.dimension(2));
        }
        throw new IllegalArgumentException("Only Bi and tri dimensionnal images are accepted now");
    }

    public static ShapedArray arrayToImage(float[] array, int width, int height) {
        return Float2D.wrap(array, width, height);
    }

    public static ShapedArray arrayToImage(float[] array, int width, int height, int sizeZ) {
        return Float3D.wrap(array, width, height, sizeZ);
    }

    public static ArrayList<BufferedImage> arrayToImage(ShapedArray array) {
        Shape shape = array.getShape();
        int width = shape.dimension(0);
        int height = shape.dimension(1);
        if (array.getType() == 5) {
            if (shape.rank() == 2) {
                BufferedImage tmp = CommonUtils.arrayToImage1D(((Double2D)array).flatten(), width, height, false);
                return BufferedImageUtils.fill(tmp);
            }
            if (shape.rank() == 3) {
                double[] data = ((Double3D)array).flatten();
                int sizeZ = shape.dimension(2);
                ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
                int j = 0;
                while (j < sizeZ) {
                    double[] tmp = new double[width * height];
                    int i = 0;
                    while (i < width * height) {
                        tmp[i] = data[i + j * width * height];
                        ++i;
                    }
                    BufferedImage tmpImg = CommonUtils.arrayToImage1D(((Double2D)array).flatten(), width, height, false);
                    list.add(tmpImg);
                    ++j;
                }
                return list;
            }
            throw new IllegalArgumentException("Rank of the Shaped Array can only be 2 or 3");
        }
        if (shape.rank() == 2) {
            BufferedImage tmp = BufferedImageUtils.createNewBufferedImage(width, height);
            return BufferedImageUtils.fill(tmp);
        }
        if (shape.rank() == 3) {
            float[] data = ((Float3D)array).flatten();
            int sizeZ = shape.dimension(2);
            ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
            int j = 0;
            while (j < sizeZ) {
                float[] tmp = new float[width * height];
                int i = 0;
                while (i < width * height) {
                    tmp[i] = data[i + j * width * height];
                    ++i;
                }
                BufferedImage tmpImg = CommonUtils.arrayToImage1D(((Float2D)array).flatten(), width, height, false);
                list.add(tmpImg);
                ++j;
            }
            return list;
        }
        throw new IllegalArgumentException("Rank of the Shaped Array can only be 2 or 3");
    }

    private static ArrayList<BufferedImage> fill(BufferedImage img) {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        list.add(img);
        return list;
    }

    public static ShapedArray imagePad(ShapedArray input, double coef) {
        Shape shape = input.getShape();
        if (input.getRank() == 2) {
            return BufferedImageUtils.imagePad(input, shape.dimension(0), shape.dimension(1), 1, coef, coef);
        }
        return BufferedImageUtils.imagePad(input, shape.dimension(0), shape.dimension(1), shape.dimension(2), coef, coef);
    }

    public static ShapedArray imagePad(ShapedArray input, int width, int height, int sizeZ, double coef) {
        return BufferedImageUtils.imagePad(input, width, height, sizeZ, coef, coef);
    }

    public static ShapedArray imagePad(ShapedArray input, int width, int height, int sizeZ, double coefWH, double coefZ) {
        int sizePadW = (int)((double)width * coefWH - (double)width);
        int sizePadH = (int)((double)height * coefWH - (double)height);
        int sizePadZ = (int)((double)sizeZ * coefZ - (double)sizeZ);
        int halfSizePadW = sizePadW / 2;
        int halfSizePadH = sizePadH / 2;
        int halfSizePadZ = sizePadZ / 2;
        Shape shape = Shape.make(width + sizePadW, height + sizePadH, sizeZ + sizePadZ);
        if (input.getType() == 5) {
            double[] output = new double[(width + sizePadW) * (height + sizePadH) * (sizeZ + sizePadZ)];
            double[] inputDbl = input.toDouble().flatten();
            int i = 0;
            while (i < output.length) {
                output[i] = 0.0;
                ++i;
            }
            int k = 0;
            while (k < sizeZ) {
                int j = 0;
                while (j < height) {
                    int i2 = 0;
                    while (i2 < width) {
                        double temp;
                        output[i2 + halfSizePadW + (j + halfSizePadH) * (width + sizePadW) + (k + halfSizePadZ) * (width + sizePadW) * (height + sizePadH)] = temp = inputDbl[i2 + j * width + k * width * height];
                        ++i2;
                    }
                    ++j;
                }
                ++k;
            }
            return Double3D.wrap(output, shape);
        }
        float[] output = new float[(width + sizePadW) * (height + sizePadH) * (sizeZ + sizePadZ)];
        float[] inputFlt = input.toFloat().flatten();
        int i = 0;
        while (i < output.length) {
            output[i] = 0.0f;
            ++i;
        }
        int k = 0;
        while (k < sizeZ) {
            int j = 0;
            while (j < height) {
                int i3 = 0;
                while (i3 < width) {
                    float temp;
                    output[i3 + halfSizePadW + (j + halfSizePadH) * (width + sizePadW) + (k + halfSizePadZ) * (width + sizePadW) * (height + sizePadH)] = temp = inputFlt[i3 + j * width + k * width * height];
                    ++i3;
                }
                ++j;
            }
            ++k;
        }
        return Float3D.wrap(output, shape);
    }

    public static BufferedImage imageUnPad(BufferedImage image, int sizePSF) {
        int hlf = sizePSF / 2;
        return image.getSubimage(hlf, hlf, image.getWidth() - sizePSF, image.getHeight() - sizePSF);
    }

    public static ArrayList<BufferedImage> imageUnPad(ArrayList<BufferedImage> image, int sizePSF) {
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>();
        int i = image.size() / 4;
        while (i < image.size() * 3 / 4) {
            out.add(BufferedImageUtils.imageUnPad(image.get(i), sizePSF));
            ++i;
        }
        return out;
    }

    public static ShapedArray shiftPsf(ShapedArray psf) {
        Shape shape = psf.getShape();
        int width = shape.dimension(0);
        int height = shape.dimension(1);
        if (shape.rank() == 2) {
            double[] data = psf.toDouble().flatten();
            double[] out = new double[data.length];
            CommonUtils.psfPadding1D(out, width, height, data, width, height, false);
            return Double2D.wrap(out, shape);
        }
        if (shape.rank() == 3) {
            double[] data = psf.toDouble().flatten();
            double[] out = new double[data.length];
            CommonUtils.psf3DPadding1D(data, out, width, height, shape.dimension(2));
            return Double3D.wrap(out, shape);
        }
        throw new IllegalArgumentException("Input should be bi or tri dimensionnal");
    }

    public static BufferedImage createNewBufferedImage(BufferedImage originalImage) {
        BufferedImage imageout = originalImage.getType() == 0 ? new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 5) : new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), originalImage.getType());
        return imageout;
    }

    public static BufferedImage createNewBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 5);
    }

    public static void showBufferedImage(BufferedImage I) {
        JFrame frame = new JFrame();
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(I));
        frame.add(label);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public static void saveBufferedImage(BufferedImage I, String name) {
        try {
            ImageIO.write((RenderedImage)I, "PNG", new File(name));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage openAsBufferedImage(String path) {
        BufferedImage I = null;
        try {
            I = ImageIO.read(new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return I;
    }

    public static void saveArrayToImage(ShapedArray A, String name) {
        if (A.getShape().rank() != 2) {
            throw new IllegalArgumentException("The shapped array should be bi-dimensionnal");
        }
        BufferedImage I = BufferedImageUtils.arrayToImage(A).get(0);
        BufferedImageUtils.saveBufferedImage(I, name);
    }
}

