/*
 * Decompiled with CFR 0.152.
 */
package mitiv.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import mitiv.io.InternalBuffer;

public class BufferedInputDataStream
extends InternalBuffer {
    private final ReadableByteChannel channel;
    private boolean readable;

    BufferedInputDataStream(FileInputStream file, int capacity) {
        super(capacity);
        this.buffer.clear().flip();
        this.channel = file.getChannel();
        this.readable = true;
    }

    BufferedInputDataStream(FileInputStream file) {
        this(file, 0);
    }

    public void close() throws IOException {
        this.channel.close();
        this.readable = false;
    }

    public int insure(int size) throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining >= size) {
            return remaining;
        }
        return this.fill();
    }

    public int fill() throws IOException {
        if (this.readable) {
            try {
                this.buffer.compact();
                if (this.buffer.remaining() > 0) {
                    this.channel.read(this.buffer);
                }
            }
            finally {
                this.buffer.flip();
            }
        }
        return this.buffer.remaining();
    }

    public byte readByte() throws IOException {
        if (this.insure(1) < 1) {
            throw new IOException("end of stream");
        }
        return this.buffer.get();
    }

    public short readShort() throws IOException {
        if (this.insure(2) < 2) {
            throw new IOException("end of stream");
        }
        return this.buffer.getShort();
    }

    public int readInt() throws IOException {
        if (this.insure(4) < 4) {
            throw new IOException("end of stream");
        }
        return this.buffer.getInt();
    }

    public long readLong() throws IOException {
        if (this.insure(8) < 8) {
            throw new IOException("end of stream");
        }
        return this.buffer.getLong();
    }

    public float readFloat() throws IOException {
        if (this.insure(4) < 4) {
            throw new IOException("end of stream");
        }
        return this.buffer.getFloat();
    }

    public double readDouble() throws IOException {
        if (this.insure(8) < 8) {
            throw new IOException("end of stream");
        }
        return this.buffer.getDouble();
    }

    public int read(byte[] arr, int offset, int number) throws IOException {
        int chunk;
        if (offset < 0 || number <= 0 || this.insure(1) < 1) {
            return 0;
        }
        int start = offset;
        do {
            chunk = Math.min(number, this.buffer.remaining());
            this.buffer.get(arr, offset, chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 1);
        return offset - start;
    }

    public int read(short[] arr, int offset, int number) throws IOException {
        int chunk;
        int elemSize = 2;
        if (offset < 0 || number <= 0 || this.insure(2) < 2) {
            return 0;
        }
        int start = offset;
        do {
            ShortBuffer buf = this.buffer.asShortBuffer();
            chunk = Math.min(number, buf.remaining());
            buf.get(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 2 * chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 2);
        return offset - start;
    }

    public int read(int[] arr, int offset, int number) throws IOException {
        int chunk;
        int elemSize = 4;
        if (offset < 0 || number <= 0 || this.insure(4) < 4) {
            return 0;
        }
        int start = offset;
        do {
            IntBuffer buf = this.buffer.asIntBuffer();
            chunk = Math.min(number, buf.remaining());
            buf.get(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 4 * chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 4);
        return offset - start;
    }

    public int read(long[] arr, int offset, int number) throws IOException {
        int chunk;
        int elemSize = 8;
        if (offset < 0 || number <= 0 || this.insure(8) < 8) {
            return 0;
        }
        int start = offset;
        do {
            LongBuffer buf = this.buffer.asLongBuffer();
            chunk = Math.min(number, buf.remaining());
            buf.get(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 8 * chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 8);
        return offset - start;
    }

    public int read(float[] arr, int offset, int number) throws IOException {
        int chunk;
        int elemSize = 4;
        if (offset < 0 || number <= 0 || this.insure(4) < 4) {
            return 0;
        }
        int start = offset;
        do {
            FloatBuffer buf = this.buffer.asFloatBuffer();
            chunk = Math.min(number, buf.remaining());
            buf.get(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 4 * chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 4);
        return offset - start;
    }

    public int read(double[] arr, int offset, int number) throws IOException {
        int chunk;
        int elemSize = 8;
        if (offset < 0 || number <= 0 || this.insure(8) < 8) {
            return 0;
        }
        int start = offset;
        do {
            DoubleBuffer buf = this.buffer.asDoubleBuffer();
            chunk = Math.min(number, buf.remaining());
            buf.get(arr, offset, chunk);
            this.buffer.position(this.buffer.position() + 8 * chunk);
            offset += chunk;
        } while ((number -= chunk) > 0 && this.fill() >= 8);
        return offset - start;
    }
}

