/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class LinearOperator {
    protected final VectorSpace inputSpace;
    protected final VectorSpace outputSpace;
    public static int DIRECT = 0;
    public static int ADJOINT = 1;
    public static int INVERSE = 2;
    public static int INVERSE_ADJOINT = ADJOINT | INVERSE;
    public static int ADJOINT_INVERSE = ADJOINT | INVERSE;

    public LinearOperator(VectorSpace vsp) {
        this.inputSpace = vsp;
        this.outputSpace = vsp;
    }

    protected LinearOperator(VectorSpace inp, VectorSpace out) {
        this.inputSpace = inp;
        this.outputSpace = out;
    }

    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }

    public VectorSpace getOutputSpace() {
        return this.outputSpace;
    }

    public boolean isEndomorphism() {
        return this.outputSpace == this.inputSpace;
    }

    public void apply(Vector dst, Vector src) throws IncorrectSpaceException {
        this.apply(dst, src, DIRECT);
    }

    public void apply(Vector dst, Vector src, int job) throws IncorrectSpaceException, IllegalLinearOperationException, NotImplementedException {
        if (dst == src) {
            this.apply(src, job);
        } else {
            if (job == DIRECT || job == (INVERSE | ADJOINT)) {
                this.inputSpace.check(src);
                this.outputSpace.check(dst);
            } else if (job == ADJOINT || job == INVERSE) {
                this.outputSpace.check(src);
                this.inputSpace.check(dst);
            } else {
                throw new IllegalLinearOperationException();
            }
            this._apply(dst, src, job);
        }
    }

    public void apply(Vector vec) throws IncorrectSpaceException, NotImplementedException, IllegalLinearOperationException {
        this.apply(vec, DIRECT);
    }

    public void apply(Vector vec, int job) throws IncorrectSpaceException, NotImplementedException, IllegalLinearOperationException {
        if (!this.isEndomorphism() || (job & (DIRECT | ADJOINT | INVERSE)) != job) {
            throw new IllegalLinearOperationException();
        }
        this.inputSpace.check(vec);
        this._apply(vec, job);
    }

    protected abstract void _apply(Vector var1, Vector var2, int var3) throws NotImplementedException;

    protected void _apply(Vector vec, int job) {
        this._apply(vec, vec.clone(), job);
    }

    public static void checkLinearProblem(LinearOperator A, Vector b, Vector x, boolean endomorphism) throws IncorrectSpaceException {
        if (!x.belongsTo(A.getInputSpace()) || !b.belongsTo(A.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (endomorphism && A.getInputSpace() != A.getOutputSpace()) {
            throw new IllegalArgumentException("LHS linear operator is not an endomorphism");
        }
    }

    public double checkAdjoint(Vector x, Vector y) {
        Vector Ax = this.outputSpace.create();
        this.apply(Ax, x);
        Vector Aty = this.inputSpace.create();
        this.apply(Aty, y, ADJOINT);
        double a = this.outputSpace.dot(y, Ax);
        double b = this.inputSpace.dot(Aty, x);
        if (a == b) {
            return 0.0;
        }
        return Math.abs(a - b) / Math.max(Math.abs(a), Math.abs(b));
    }
}

