/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;

public class ArmijoLineSearch
extends LineSearch {
    private double bestStep = 0.0;
    private double bestFunc = 0.0;
    private boolean bypass = false;
    protected double sigma = 0.05;
    protected double rho = 0.5;

    public void setGain(double value) {
        if (Double.isNaN(value) || value <= 0.0 || value >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.rho = value;
    }

    public double getGain() {
        return this.rho;
    }

    public void setTolerance(double value) {
        if (Double.isNaN(value) || value <= 0.0 || value >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.sigma = value;
    }

    public double getTolerance() {
        return this.sigma;
    }

    public static void main(String[] args) {
        ArmijoLineSearch lineSearch = new ArmijoLineSearch(0.5, 0.001);
        double alpha = 12.0;
        double f0 = 0.0;
        double g0 = -1.0;
        double h0 = 5.0;
        LineSearchTask task = lineSearch.start(f0, g0, alpha, 0.0, 1.0E20 * alpha);
        System.out.println("state = " + (Object)((Object)task));
        System.out.println("finished = " + lineSearch.finished());
        int k = 1;
        while (k <= 6) {
            alpha = lineSearch.getStep();
            double f1 = f0 + alpha * (g0 + 0.5 * h0 * alpha);
            double g1 = g0 + h0 * alpha;
            task = lineSearch.iterate(alpha, f1, g1);
            System.out.println("alpha[" + k + "] = " + alpha + ";" + " f[" + k + "] = " + f1 + ";" + " g[" + k + "] = " + g1 + ";" + " state[" + k + "] = " + (Object)((Object)task) + ";" + " finished[" + k + "] = " + lineSearch.finished() + ";");
            ++k;
        }
    }

    public ArmijoLineSearch() {
    }

    public ArmijoLineSearch(double rho, double sigma) {
        this.setGain(rho);
        this.setTolerance(sigma);
    }

    @Override
    public boolean useDerivative() {
        return true;
    }

    @Override
    protected void startHook() {
        this.bestFunc = this.finit;
        this.bestStep = 0.0;
        this.bypass = false;
        this.success(LineSearchTask.SEARCH);
    }

    @Override
    public void iterateHook(double f, double g) {
        if (this.bypass || f - this.finit <= this.stp * this.sigma * this.ginit) {
            this.success(LineSearchTask.CONVERGENCE);
        } else {
            if (f < this.bestFunc) {
                this.bestStep = this.stp;
                this.bestFunc = f;
                this.stp = this.rho * this.stp;
            } else if (this.bestStep > this.stp) {
                this.bypass = true;
                this.stp = this.bestStep;
            } else {
                this.stp = this.rho * this.stp;
            }
            this.success(LineSearchTask.SEARCH);
        }
    }
}

