/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LBFGSOperator
extends LinearOperator {
    static final int NO_SCALING = 0;
    static final int OREN_SPEDICATO_SCALING = 1;
    static final int BARZILAI_BORWEIN_SCALING = 2;
    static final int CONSTANT_SCALING = 4;
    protected Vector[] s;
    protected Vector[] y;
    protected final int m;
    protected int mp;
    protected int updates;
    protected double[] rho;
    protected double gamma;
    protected double[] alpha;
    protected LinearOperator H0;
    protected int rule = 1;

    public LBFGSOperator(VectorSpace space, int m) {
        super(space);
        this.m = m;
        this.H0 = null;
        this.allocateWorkspace();
    }

    public LBFGSOperator(LinearOperator H0, int m) {
        super(H0.getInputSpace());
        if (!H0.isEndomorphism()) {
            throw new IncorrectSpaceException("Preconditioner must be an endomorphism");
        }
        this.m = m;
        this.H0 = H0;
        this.allocateWorkspace();
    }

    private void allocateWorkspace() {
        this.s = new Vector[this.m];
        this.y = new Vector[this.m];
        int i = 0;
        while (i < this.m) {
            this.s[i] = this.outputSpace.create();
            this.y[i] = this.inputSpace.create();
            ++i;
        }
        this.alpha = new double[this.m];
        this.rho = new double[this.m];
        this.mp = 0;
        this.updates = 0;
        this.gamma = 1.0;
    }

    public void reset() {
        this.mp = 0;
    }

    public void setScaling(int value) {
        this.rule = value;
    }

    public int getScaling() {
        return this.rule;
    }

    public void setScale(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("scale factor must be strictly positive");
        }
        this.gamma = value;
        this.rule = 4;
    }

    public double getScale() {
        return this.gamma;
    }

    protected int slot(int j) {
        if (j < 0 || j > this.mp) {
            throw new IndexOutOfBoundsException("BFGS slot index is out of bounds");
        }
        return (this.updates - j) % this.m;
    }

    protected Vector s(int j) {
        return this.s[this.slot(j)];
    }

    protected Vector y(int j) {
        return this.y[this.slot(j)];
    }

    private boolean solveInPlace(Vector vec) {
        int k;
        int j = 1;
        while (j <= this.mp) {
            k = this.slot(j);
            if (this.rho[k] > 0.0) {
                this.alpha[k] = this.rho[k] * vec.dot(this.s[k]);
                vec.combine(1.0, vec, -this.alpha[k], this.y[k]);
            }
            ++j;
        }
        if (this.H0 != null) {
            this.H0.apply(vec);
        } else if (this.gamma != 1.0) {
            vec.scale(this.gamma);
        }
        j = this.mp;
        while (j >= 1) {
            k = this.slot(j);
            if (this.rho[k] > 0.0) {
                double beta = this.rho[k] * vec.dot(this.y[k]);
                vec.combine(1.0, vec, this.alpha[k] - beta, this.s[k]);
            }
            --j;
        }
        return true;
    }

    private boolean solveInPlace(Vector wgt, Vector vec) {
        int k;
        boolean flag = this.H0 == null;
        this.gamma = 0.0;
        int j = 1;
        while (j <= this.mp) {
            k = this.slot(j);
            double sty = wgt.dot(this.y[k], this.s[k]);
            if (sty <= 0.0) {
                this.rho[k] = 0.0;
            } else {
                double yty;
                this.rho[k] = 1.0 / sty;
                this.alpha[k] = this.rho[k] * wgt.dot(vec, this.s[k]);
                vec.combine(1.0, vec, -this.alpha[k], this.y[k]);
                if (flag && (yty = wgt.dot(this.y[k], this.y[k])) > 0.0) {
                    this.gamma = sty / yty;
                    flag = false;
                }
            }
            ++j;
        }
        if (flag) {
            return false;
        }
        if (this.H0 != null) {
            this.H0.apply(vec);
        } else if (this.gamma != 1.0) {
            vec.scale(this.gamma);
        }
        j = this.mp;
        while (j >= 1) {
            k = this.slot(j);
            if (this.rho[k] > 0.0) {
                double beta = this.rho[k] * wgt.dot(vec, this.y[k]);
                vec.combine(1.0, vec, this.alpha[k] - beta, this.s[k]);
            }
            --j;
        }
        return true;
    }

    public boolean apply(Vector wgt, Vector vec, Vector dst) {
        if (wgt != null && !wgt.belongsTo(this.inputSpace) || !vec.belongsTo(this.inputSpace) || !dst.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException();
        }
        if (this.mp < 1) {
            return false;
        }
        if (vec != dst) {
            dst.copyFrom(vec);
        }
        if (wgt == null) {
            return this.solveInPlace(vec);
        }
        return this.solveInPlace(wgt, vec);
    }

    @Override
    protected void _apply(Vector vec, int job) {
        if (job != DIRECT && job != ADJOINT) {
            throw new IllegalLinearOperationException();
        }
        this.solveInPlace(vec);
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        dst.copyFrom(src);
        this._apply(dst, job);
    }

    public void update(Vector x1, Vector x0, Vector g1, Vector g0) throws IncorrectSpaceException {
        this.update(x1, x0, g1, g0, false);
    }

    public void update(Vector x1, Vector x0, Vector g1, Vector g0, boolean partial) throws IncorrectSpaceException {
        int k = this.slot(0);
        this.s[k].combine(1.0, x1, -1.0, x0);
        this.y[k].combine(1.0, g1, -1.0, g0);
        if (partial) {
            this.rho[k] = 0.0;
            this.gamma = 0.0;
        } else {
            double sty = this.s[k].dot(this.y[k]);
            if (sty <= 0.0) {
                this.rho[k] = 0.0;
                return;
            }
            this.rho[k] = 1.0 / sty;
            if (this.rule == 1 || this.rule == 5 && this.updates == 0) {
                double ynorm = this.y[k].norm2();
                this.gamma = sty / ynorm / ynorm;
            } else if (this.rule == 2 || this.rule == 6 && this.updates == 0) {
                double snorm = this.s[k].norm2();
                this.gamma = snorm / sty * snorm;
            }
        }
        ++this.updates;
        if (this.mp < this.m) {
            ++this.mp;
        }
    }
}

