/*
 * Decompiled with CFR 0.152.
 */
package mitiv.tests;

import mitiv.tests.MinPack1Tests;

public class AdaptativeSteepestDescent {
    protected double sigma1 = 0.1;
    protected double sigma2 = 0.9;
    protected double stepGain = 2.0;
    protected boolean favorStepGrowth = true;

    public void setTolerances(double sigma) {
        this.setTolerances(sigma, 1.0 - sigma);
    }

    public void setTolerances(double sigma1, double sigma2) {
        if (sigma1 <= 0.0 || sigma1 >= sigma2 || sigma2 >= 1.0) {
            throw new IllegalArgumentException();
        }
        this.sigma1 = sigma1;
        this.sigma2 = sigma2;
    }

    public void setTolerances(double[] sigma) {
        if (sigma == null || sigma.length != 2) {
            throw new IllegalArgumentException();
        }
        this.setTolerances(sigma[0], sigma[1]);
    }

    public double getStepGain() {
        return this.stepGain;
    }

    public void setStepGain(double value) {
        if (value <= 1.0) {
            throw new IllegalArgumentException();
        }
        this.stepGain = value;
    }

    public boolean isFavorStepGrowth() {
        return this.favorStepGrowth;
    }

    public void setFavorStepGrowth(boolean favorStepGrowth) {
        this.favorStepGrowth = favorStepGrowth;
    }

    public static double gradientThreshold(double atol, double rtol, double gnrm, int normType) {
        if (normType == 2) {
            double r = Math.max(0.0, Math.max(atol, rtol * Math.sqrt(gnrm)));
            return r * r;
        }
        return Math.max(0.0, Math.max(atol, rtol * gnrm));
    }

    public static void main(String[] args) {
        int prob = 2;
        int n = 6;
        double[] x0 = new double[n];
        double[] x = new double[n];
        double[] g = new double[n];
        AdaptativeSteepestDescent t = new AdaptativeSteepestDescent();
        MinPack1Tests.umipt(x0, prob, 1.0);
        t.test(x0, x, g, prob, 1.0, 0.0, 1.0E-5);
    }

    void test(double[] x0, double[] x, double[] g, int prob, double alpha, double atol, double rtol) {
        double epsilon = 0.0;
        if (alpha <= 0.0) {
            alpha = 1.0;
        }
        double alphaNext = alpha;
        int n = x0.length;
        int nf = 0;
        int ng = 0;
        double f0 = MinPack1Tests.umobj(x0, prob);
        ++nf;
        System.out.println("f0 = " + f0);
        while (true) {
            double f;
            MinPack1Tests.umgrd(x0, g, prob);
            ++ng;
            double rho = 0.0;
            int i = 0;
            while (i < n) {
                rho += g[i] * g[i];
                ++i;
            }
            if (ng == 1) {
                epsilon = AdaptativeSteepestDescent.gradientThreshold(atol, rtol, rho, 2);
            }
            if (rho <= epsilon) {
                System.out.println("after " + nf + " function and " + ng + " gradient calls, final f = " + f0 + ", rho = " + rho + ", epsilon = " + epsilon);
                return;
            }
            System.out.println("after " + nf + " function and " + ng + " gradient calls, best f = " + f0 + ", rho = " + rho + ", epsilon = " + epsilon);
            double alphaMin = 0.0;
            double alphaMax = Double.MAX_VALUE;
            alpha = alphaNext;
            while (true) {
                int i2 = 0;
                while (i2 < n) {
                    x[i2] = x0[i2] - alpha * g[i2];
                    ++i2;
                }
                f = MinPack1Tests.umobj(x, prob);
                ++nf;
                double f1 = f0 - this.sigma1 * rho * alpha;
                double f2 = f0 - this.sigma2 * rho * alpha;
                if (f > f1) {
                    alphaMax = alpha;
                    if (!((alpha /= this.stepGain) <= alphaMin)) continue;
                    alpha = (alphaMin + alphaMax) / 2.0;
                    continue;
                }
                if (!(f < f2)) break;
                alphaMin = alpha;
                if (!((alpha *= this.stepGain) >= alphaMax)) continue;
                alpha = (alphaMin + alphaMax) / 2.0;
            }
            double[] tmp = x0;
            x0 = x;
            x = tmp;
            f0 = f;
            alphaNext = this.favorStepGrowth ? alpha * this.stepGain : alpha;
        }
    }
}

