/*
 * Decompiled with CFR 0.152.
 */
package mitiv.tests;

public class MinPack1Tests {
    public static final int TEST18_NMAX = 50;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    protected static final double TPI = Math.PI * 2;
    protected static final double AP = 1.0E-5;
    protected static final double BP = 1.0;
    private static final double[] um_y = new double[]{9.0E-4, 0.0044, 0.0175, 0.054, 0.1295, 0.242, 0.3521, 0.3989, 0.3521, 0.242, 0.1295, 0.054, 0.0175, 0.0044, 9.0E-4};

    public static void main(String[] args) {
        String[] info = new String[1];
        int MX = Integer.MAX_VALUE;
        int[] nArray = new int[19];
        nArray[1] = 3;
        nArray[2] = 6;
        nArray[3] = 3;
        nArray[4] = 2;
        nArray[5] = 3;
        nArray[6] = 1;
        nArray[7] = 2;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 2;
        nArray[11] = 4;
        nArray[12] = 3;
        nArray[13] = 1;
        nArray[14] = 2;
        nArray[15] = 4;
        nArray[16] = 2;
        nArray[17] = 4;
        nArray[18] = 1;
        int[] minSize = nArray;
        int[] nArray2 = new int[19];
        nArray2[1] = 3;
        nArray2[2] = 6;
        nArray2[3] = 3;
        nArray2[4] = 2;
        nArray2[5] = 3;
        nArray2[6] = Integer.MAX_VALUE;
        nArray2[7] = Integer.MAX_VALUE;
        nArray2[8] = Integer.MAX_VALUE;
        nArray2[9] = Integer.MAX_VALUE;
        nArray2[10] = 2;
        nArray2[11] = 4;
        nArray2[12] = 3;
        nArray2[13] = Integer.MAX_VALUE;
        nArray2[14] = Integer.MAX_VALUE;
        nArray2[15] = Integer.MAX_VALUE;
        nArray2[16] = 2;
        nArray2[17] = 4;
        nArray2[18] = 50;
        int[] maxSize = nArray2;
        int[] nArray3 = new int[19];
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 1;
        nArray3[10] = 1;
        nArray3[11] = 1;
        nArray3[12] = 1;
        nArray3[13] = 1;
        nArray3[14] = 2;
        nArray3[15] = 4;
        nArray3[16] = 1;
        nArray3[17] = 1;
        nArray3[18] = 1;
        int[] mulSize = nArray3;
        int prob = 1;
        while (prob < minSize.length) {
            int n = minSize[prob] == maxSize[prob] ? minSize[prob] : (maxSize[prob] < Integer.MAX_VALUE ? maxSize[prob] : MinPack1Tests.roundUp(20, mulSize[prob]));
            int status = MinPack1Tests.umck(info, n, prob);
            if (status != 0) {
                System.out.println("FAILURE prob = " + prob + " (with n = " + n + "): " + info[0]);
            } else {
                System.out.println("SUCCESS prob = " + prob + " (with n = " + n + "): " + info[0]);
                double[] x = new double[n];
                double[] g = new double[n];
                MinPack1Tests.umipt(x, prob, 1.0);
                double f0 = MinPack1Tests.umobj(x, prob);
                System.out.println("   initial cost: " + f0);
                MinPack1Tests.umgrd(x, g, prob);
                double alpha = 0.01;
                int i = 0;
                while (i < n) {
                    int n2 = i;
                    x[n2] = x[n2] - alpha * g[i];
                    ++i;
                }
                double f1 = MinPack1Tests.umobj(x, prob);
                System.out.println("   cost after a small descent step: " + f1);
            }
            ++prob;
        }
    }

    private static int roundUp(int a, int b) {
        return (a + (b - 1)) / b * b;
    }

    private static int check(boolean success, String[] str, String descr, String reason) {
        if (success) {
            if (str != null && str.length >= 1) {
                str[0] = descr;
            }
            return 0;
        }
        if (str != null && str.length >= 1) {
            str[0] = reason;
        }
        return -1;
    }

    public static int umck(String[] str, int n, int prob) {
        int status;
        switch (prob) {
            case 1: {
                status = MinPack1Tests.check(n == 3, str, "Helical valley function.", "N must be 3 for problem #1");
                break;
            }
            case 2: {
                status = MinPack1Tests.check(n == 6, str, "Biggs exp6 function.", "N must be 6 for problem #2");
                break;
            }
            case 3: {
                status = MinPack1Tests.check(n == 3, str, "Gaussian function.", "N must be 3 for problem #3");
                break;
            }
            case 4: {
                status = MinPack1Tests.check(n == 2, str, "Powell badly scaled function.", "N must be 2 for problem #4");
                break;
            }
            case 5: {
                status = MinPack1Tests.check(n == 3, str, "Box 3-dimensional function.", "N must be 3 for problem #5");
                break;
            }
            case 6: {
                status = MinPack1Tests.check(n >= 1, str, "Variably dimensioned function.", "N must be >= 1 in problem #6");
                break;
            }
            case 7: {
                status = MinPack1Tests.check(n >= 2, str, "Watson function.", "N may be 2 or greater but is usually 6 or 9 for problem #7");
                break;
            }
            case 8: {
                status = MinPack1Tests.check(n >= 1, str, "Penalty function I.", "N must be >= 1 in problem #8");
                break;
            }
            case 9: {
                status = MinPack1Tests.check(n >= 1, str, "Penalty function II.", "N must be >= 1 in problem #9");
                break;
            }
            case 10: {
                status = MinPack1Tests.check(n == 2, str, "Brown badly scaled function.", "N must be 2 for problem #10");
                break;
            }
            case 11: {
                status = MinPack1Tests.check(n == 4, str, "Brown and Dennis function.", "N must be 4 for problem #11");
                break;
            }
            case 12: {
                status = MinPack1Tests.check(n == 3, str, "Gulf research and development function.", "N must be 3 for problem #12");
                break;
            }
            case 13: {
                status = MinPack1Tests.check(n >= 1, str, "Trigonometric function.", "N must be >= 1 in problem #13");
                break;
            }
            case 14: {
                status = MinPack1Tests.check(n >= 1 && n % 2 == 0, str, "Extended Rosenbrock function.", "N must be a multiple of 2 in problem #14");
                break;
            }
            case 15: {
                status = MinPack1Tests.check(n >= 1 && n % 4 == 0, str, "Extended Powell function.", "N must be a multiple of 4 in problem #15");
                break;
            }
            case 16: {
                status = MinPack1Tests.check(n == 2, str, "Beale function.", "N must be 2 for problem #16");
                break;
            }
            case 17: {
                status = MinPack1Tests.check(n == 4, str, "Wood function.", "N must be 4 for problem #17");
                break;
            }
            case 18: {
                status = MinPack1Tests.check(n >= 1 && n <= 50, str, "Chebyquad function.", "N must be <= 50 for problem #18");
                break;
            }
            default: {
                status = -1;
                if (str == null || str.length < 1) break;
                str[0] = "PROB must be an integer between 1 and 18";
            }
        }
        return status;
    }

    public static void umipt(double[] x, int prob, double factor) {
        block32: {
            int j;
            int n = x.length;
            switch (prob) {
                case 1: {
                    x[0] = -1.0;
                    x[1] = 0.0;
                    x[2] = 0.0;
                    break;
                }
                case 2: {
                    x[0] = 1.0;
                    x[1] = 2.0;
                    x[2] = 1.0;
                    x[3] = 1.0;
                    x[4] = 1.0;
                    x[5] = 1.0;
                    break;
                }
                case 3: {
                    x[0] = 0.4;
                    x[1] = 1.0;
                    x[2] = 0.0;
                    break;
                }
                case 4: {
                    x[0] = 0.0;
                    x[1] = 1.0;
                    break;
                }
                case 5: {
                    x[0] = 0.0;
                    x[1] = 10.0;
                    x[2] = 20.0;
                    break;
                }
                case 6: {
                    double h = 1.0 / (double)n;
                    j = 0;
                    while (j < n) {
                        x[j] = 1.0 - (double)(j + 1) * h;
                        ++j;
                    }
                    break;
                }
                case 7: {
                    j = 0;
                    while (j < n) {
                        x[j] = 0.0;
                        ++j;
                    }
                    break;
                }
                case 8: {
                    j = 0;
                    while (j < n) {
                        x[j] = j + 1;
                        ++j;
                    }
                    break;
                }
                case 9: {
                    j = 0;
                    while (j < n) {
                        x[j] = 0.5;
                        ++j;
                    }
                    break;
                }
                case 10: {
                    x[0] = 1.0;
                    x[1] = 1.0;
                    break;
                }
                case 11: {
                    x[0] = 25.0;
                    x[1] = 5.0;
                    x[2] = -5.0;
                    x[3] = -1.0;
                    break;
                }
                case 12: {
                    x[0] = 5.0;
                    x[1] = 2.5;
                    x[2] = 0.15;
                    break;
                }
                case 13: {
                    double h = 1.0 / (double)n;
                    j = 0;
                    while (j < n) {
                        x[j] = h;
                        ++j;
                    }
                    break;
                }
                case 14: {
                    j = 0;
                    while (j < n) {
                        x[j] = -1.2;
                        x[j + 1] = 1.0;
                        j += 2;
                    }
                    break;
                }
                case 15: {
                    j = 0;
                    while (j < n) {
                        x[j] = 3.0;
                        x[j + 1] = -1.0;
                        x[j + 2] = 0.0;
                        x[j + 3] = 1.0;
                        j += 4;
                    }
                    break;
                }
                case 16: {
                    x[0] = 1.0;
                    x[1] = 1.0;
                    break;
                }
                case 17: {
                    x[0] = -3.0;
                    x[1] = -1.0;
                    x[2] = -3.0;
                    x[3] = -1.0;
                    break;
                }
                case 18: {
                    double h = 1.0 / (double)(n + 1);
                    j = 0;
                    while (j < n) {
                        x[j] = (double)(j + 1) * h;
                        ++j;
                    }
                    break;
                }
            }
            if (factor == 1.0) break block32;
            if (prob == 7) {
                j = 0;
                while (j < n) {
                    x[j] = factor;
                    ++j;
                }
            } else {
                j = 0;
                while (j < n) {
                    int n2 = j++;
                    x[n2] = x[n2] * factor;
                }
            }
        }
    }

    public static double umobj(double[] x, int prob) {
        double f;
        double[] fvec = new double[50];
        int n = x.length;
        switch (prob) {
            case 1: {
                double th = x[0] > 0.0 ? Math.atan(x[1] / x[0]) / (Math.PI * 2) : (x[0] < 0.0 ? Math.atan(x[1] / x[0]) / (Math.PI * 2) + 0.5 : (x[1] >= 0.0 ? 0.25 : -0.25));
                double arg = x[0] * x[0] + x[1] * x[1];
                double r = Math.sqrt(arg) - 1.0;
                double t = x[2] - 10.0 * th;
                f = 100.0 * (t * t + r * r) + x[2] * x[2];
                break;
            }
            case 2: {
                f = 0.0;
                int i = 1;
                while (i <= 13) {
                    double d1 = (double)i / 10.0;
                    double d2 = Math.exp(-d1) - 5.0 * Math.exp(-10.0 * d1) + 3.0 * Math.exp(-4.0 * d1);
                    double s1 = Math.exp(-d1 * x[0]);
                    double s2 = Math.exp(-d1 * x[1]);
                    double s3 = Math.exp(-d1 * x[4]);
                    double t = x[2] * s1 - x[3] * s2 + x[5] * s3 - d2;
                    f += t * t;
                    ++i;
                }
                break;
            }
            case 3: {
                f = 0.0;
                int i = 0;
                while (i < 15) {
                    double d1 = 0.5 * (double)i;
                    double d2 = 3.5 - d1 - x[2];
                    double arg = -0.5 * x[1] * (d2 * d2);
                    double r = Math.exp(arg);
                    double t = x[0] * r - um_y[i];
                    f += t * t;
                    ++i;
                }
                break;
            }
            case 4: {
                double t1 = 10000.0 * x[0] * x[1] - 1.0;
                double s1 = Math.exp(-x[0]);
                double s2 = Math.exp(-x[1]);
                double t2 = s1 + s2 - 1.0001;
                f = t1 * t1 + t2 * t2;
                break;
            }
            case 5: {
                f = 0.0;
                int i = 1;
                while (i <= 10) {
                    double d1 = i;
                    double d2 = d1 / 10.0;
                    double s1 = Math.exp(-d2 * x[0]);
                    double s2 = Math.exp(-d2 * x[1]);
                    double s3 = Math.exp(-d2) - Math.exp(-d1);
                    double t = s1 - s2 - s3 * x[2];
                    f += t * t;
                    ++i;
                }
                break;
            }
            case 6: {
                double t;
                double t1 = 0.0;
                double t2 = 0.0;
                int j = 0;
                while (j < n) {
                    t1 += (double)(j + 1) * (x[j] - 1.0);
                    t = x[j] - 1.0;
                    t2 += t * t;
                    ++j;
                }
                t = t1 * t1;
                f = t2 + t * (1.0 + t);
                break;
            }
            case 7: {
                double t;
                f = 0.0;
                int i = 1;
                while (i <= 29) {
                    double d1 = (double)i / 29.0;
                    double s1 = 0.0;
                    double d2 = 1.0;
                    int j = 1;
                    while (j < n) {
                        s1 += (double)j * d2 * x[j];
                        d2 *= d1;
                        ++j;
                    }
                    double s2 = 0.0;
                    d2 = 1.0;
                    j = 0;
                    while (j < n) {
                        s2 += d2 * x[j];
                        d2 *= d1;
                        ++j;
                    }
                    t = s1 - s2 * s2 - 1.0;
                    f += t * t;
                    ++i;
                }
                t = x[0] * x[0];
                double t1 = x[1] - t - 1.0;
                f += t + t1 * t1;
                break;
            }
            case 8: {
                double t1 = -0.25;
                double t2 = 0.0;
                int j = 0;
                while (j < n) {
                    t1 += x[j] * x[j];
                    double t = x[j] - 1.0;
                    t2 += t * t;
                    ++j;
                }
                f = 1.0E-5 * t2 + 1.0 * (t1 * t1);
                break;
            }
            case 9: {
                double t;
                double t1 = -1.0;
                double t2 = 0.0;
                double t3 = 0.0;
                double d1 = Math.exp(0.1);
                double d2 = 1.0;
                double s2 = 0.0;
                int j = 0;
                while (j < n) {
                    t1 += (double)(n - j) * (x[j] * x[j]);
                    double s1 = Math.exp(x[j] / 10.0);
                    if (j > 0) {
                        double s3 = s1 + s2 - d2 * (d1 + 1.0);
                        t2 += s3 * s3;
                        t = s1 - 1.0 / d1;
                        t3 += t * t;
                    }
                    s2 = s1;
                    d2 *= d1;
                    ++j;
                }
                t = x[0] - 0.2;
                f = 1.0E-5 * (t2 + t3) + 1.0 * (t1 * t1 + t * t);
                break;
            }
            case 10: {
                double t1 = x[0] - 1000000.0;
                double t2 = x[1] - 2.0E-6;
                double t3 = x[0] * x[1] - 2.0;
                f = t1 * t1 + t2 * t2 + t3 * t3;
                break;
            }
            case 11: {
                f = 0.0;
                int i = 1;
                while (i <= 20) {
                    double d1 = (double)i / 5.0;
                    double d2 = Math.sin(d1);
                    double t1 = x[0] + d1 * x[1] - Math.exp(d1);
                    double t2 = x[2] + d2 * x[3] - Math.cos(d1);
                    double t = t1 * t1 + t2 * t2;
                    f += t * t;
                    ++i;
                }
                break;
            }
            case 12: {
                f = 0.0;
                double d1 = 0.6666666666666666;
                int i = 1;
                while (i <= 99) {
                    double arg = (double)i / 100.0;
                    double r = Math.abs(Math.pow(-50.0 * Math.log(arg), d1) + 25.0 - x[1]);
                    double t1 = Math.pow(r, x[2]) / x[0];
                    double t2 = Math.exp(-t1);
                    double t = t2 - arg;
                    f += t * t;
                    ++i;
                }
                break;
            }
            case 13: {
                double s1 = 0.0;
                int j = 0;
                while (j < n) {
                    s1 += Math.cos(x[j]);
                    ++j;
                }
                f = 0.0;
                j = 0;
                while (j < n) {
                    double t = (double)(n + 1 + j) - Math.sin(x[j]) - s1 - (double)(1 + j) * Math.cos(x[j]);
                    f += t * t;
                    ++j;
                }
                break;
            }
            case 14: {
                f = 0.0;
                int j = 0;
                while (j < n) {
                    double t1 = 1.0 - x[j];
                    double t2 = 10.0 * (x[j + 1] - x[j] * x[j]);
                    f += t1 * t1 + t2 * t2;
                    j += 2;
                }
                break;
            }
            case 15: {
                f = 0.0;
                int j = 0;
                while (j < n) {
                    double t = x[j] + 10.0 * x[j + 1];
                    double t1 = x[j + 2] - x[j + 3];
                    double s1 = 5.0 * t1;
                    double t2 = x[j + 1] - 2.0 * x[j + 2];
                    double s2 = t2 * t2 * t2;
                    double t3 = x[j] - x[j + 3];
                    double s3 = 10.0 * (t3 * t3 * t3);
                    f += t * t + s1 * t1 + s2 * t2 + s3 * t3;
                    j += 4;
                }
                break;
            }
            case 16: {
                double s1 = 1.0 - x[1];
                double t1 = 1.5 - x[0] * s1;
                double s2 = 1.0 - x[1] * x[1];
                double t2 = 2.25 - x[0] * s2;
                double s3 = 1.0 - x[1] * x[1] * x[1];
                double t3 = 2.625 - x[0] * s3;
                f = t1 * t1 + t2 * t2 + t3 * t3;
                break;
            }
            case 17: {
                double s1 = x[1] - x[0] * x[0];
                double s2 = 1.0 - x[0];
                double s3 = x[1] - 1.0;
                double t1 = x[3] - x[2] * x[2];
                double t2 = 1.0 - x[2];
                double t3 = x[3] - 1.0;
                double d1 = s3 + t3;
                double d2 = s3 - t3;
                f = 100.0 * (s1 * s1) + s2 * s2 + 90.0 * (t1 * t1) + t2 * t2 + 10.0 * (d1 * d1) + d2 * d2 / 10.0;
                break;
            }
            case 18: {
                double t;
                int i = 0;
                while (i < n) {
                    fvec[i] = 0.0;
                    ++i;
                }
                int j = 0;
                while (j < n) {
                    double t1 = 1.0;
                    double t2 = 2.0 * x[j] - 1.0;
                    t = 2.0 * t2;
                    i = 0;
                    while (i < n) {
                        int n2 = i++;
                        fvec[n2] = fvec[n2] + t2;
                        double th = t * t2 - t1;
                        t1 = t2;
                        t2 = th;
                    }
                    ++j;
                }
                f = 0.0;
                double d1 = 1.0 / (double)n;
                int iev = -1;
                i = 0;
                while (i < n) {
                    t = d1 * fvec[i];
                    if (iev > 0) {
                        double r = i + 1;
                        t += 1.0 / (r * r - 1.0);
                    }
                    f += t * t;
                    iev = -iev;
                    ++i;
                }
                break;
            }
            default: {
                f = 0.0;
            }
        }
        return f;
    }

    public static void umgrd(double[] x, double[] g, int prob) {
        double[] fvec = new double[50];
        int n = x.length;
        switch (prob) {
            case 1: {
                double th = x[0] > 0.0 ? Math.atan(x[1] / x[0]) / (Math.PI * 2) : (x[0] < 0.0 ? Math.atan(x[1] / x[0]) / (Math.PI * 2) + 0.5 : (x[1] >= 0.0 ? 0.25 : -0.25));
                double arg = x[0] * x[0] + x[1] * x[1];
                double r = Math.sqrt(arg);
                double t = x[2] - 10.0 * th;
                double s1 = 10.0 * t / (Math.PI * 2 * arg);
                g[0] = 200.0 * (x[0] - x[0] / r + x[1] * s1);
                g[1] = 200.0 * (x[1] - x[1] / r - x[0] * s1);
                g[2] = 2.0 * (100.0 * t + x[2]);
                break;
            }
            case 2: {
                int j = 0;
                while (j < 6) {
                    g[j] = 0.0;
                    ++j;
                }
                int i = 1;
                while (i <= 13) {
                    double d1 = (double)i / 10.0;
                    double d2 = Math.exp(-d1) - 5.0 * Math.exp(-10.0 * d1) + 3.0 * Math.exp(-4.0 * d1);
                    double s1 = Math.exp(-d1 * x[0]);
                    double s2 = Math.exp(-d1 * x[1]);
                    double s3 = Math.exp(-d1 * x[4]);
                    double t = x[2] * s1 - x[3] * s2 + x[5] * s3 - d2;
                    double th = d1 * t;
                    g[0] = g[0] - s1 * th;
                    g[1] = g[1] + s2 * th;
                    g[2] = g[2] + s1 * t;
                    g[3] = g[3] - s2 * t;
                    g[4] = g[4] - s3 * th;
                    g[5] = g[5] + s3 * t;
                    ++i;
                }
                g[0] = g[0] * (2.0 * x[2]);
                g[1] = g[1] * (2.0 * x[3]);
                g[2] = g[2] * 2.0;
                g[3] = g[3] * 2.0;
                g[4] = g[4] * (2.0 * x[5]);
                g[5] = g[5] * 2.0;
                break;
            }
            case 3: {
                g[0] = 0.0;
                g[1] = 0.0;
                g[2] = 0.0;
                int i = 0;
                while (i < 15) {
                    double d1 = 0.5 * (double)i;
                    double d2 = 3.5 - d1 - x[2];
                    double arg = -0.5 * x[1] * (d2 * d2);
                    double r = Math.exp(arg);
                    double t = x[0] * r - um_y[i];
                    double s1 = r * t;
                    double s2 = d2 * s1;
                    g[0] = g[0] + s1;
                    g[1] = g[1] - d2 * s2;
                    g[2] = g[2] + s2;
                    ++i;
                }
                g[0] = g[0] * 2.0;
                g[1] = g[1] * x[0];
                g[2] = g[2] * (2.0 * x[0] * x[1]);
                break;
            }
            case 4: {
                double t1 = 10000.0 * x[0] * x[1] - 1.0;
                double s1 = Math.exp(-x[0]);
                double s2 = Math.exp(-x[1]);
                double t2 = s1 + s2 - 1.0001;
                g[0] = 2.0 * (10000.0 * x[1] * t1 - s1 * t2);
                g[1] = 2.0 * (10000.0 * x[0] * t1 - s2 * t2);
                break;
            }
            case 5: {
                g[0] = 0.0;
                g[1] = 0.0;
                g[2] = 0.0;
                int i = 1;
                while (i <= 10) {
                    double d1 = i;
                    double d2 = d1 / 10.0;
                    double s1 = Math.exp(-d2 * x[0]);
                    double s2 = Math.exp(-d2 * x[1]);
                    double s3 = Math.exp(-d2) - Math.exp(-d1);
                    double t = s1 - s2 - s3 * x[2];
                    double th = d2 * t;
                    g[0] = g[0] - s1 * th;
                    g[1] = g[1] + s2 * th;
                    g[2] = g[2] - s3 * t;
                    ++i;
                }
                g[0] = g[0] * 2.0;
                g[1] = g[1] * 2.0;
                g[2] = g[2] * 2.0;
                break;
            }
            case 6: {
                double t1 = 0.0;
                int j = 0;
                while (j < n) {
                    t1 += (double)(j + 1) * (x[j] - 1.0);
                    ++j;
                }
                double t = t1 * (1.0 + 2.0 * (t1 * t1));
                j = 0;
                while (j < n) {
                    g[j] = 2.0 * (x[j] - 1.0 + (double)(j + 1) * t);
                    ++j;
                }
                break;
            }
            case 7: {
                int j = 0;
                while (j < n) {
                    g[j] = 0.0;
                    ++j;
                }
                int i = 1;
                while (i <= 29) {
                    double d1 = (double)i / 29.0;
                    double s1 = 0.0;
                    double d2 = 1.0;
                    j = 1;
                    while (j < n) {
                        s1 += (double)j * d2 * x[j];
                        d2 *= d1;
                        ++j;
                    }
                    double s2 = 0.0;
                    d2 = 1.0;
                    j = 0;
                    while (j < n) {
                        s2 += d2 * x[j];
                        d2 *= d1;
                        ++j;
                    }
                    double t = s1 - s2 * s2 - 1.0;
                    double s3 = 2.0 * d1 * s2;
                    d2 = 2.0 / d1;
                    j = 0;
                    while (j < n) {
                        int n2 = j;
                        g[n2] = g[n2] + d2 * ((double)j - s3) * t;
                        d2 *= d1;
                        ++j;
                    }
                    ++i;
                }
                double t1 = x[1] - x[0] * x[0] - 1.0;
                g[0] = g[0] + x[0] * (2.0 - 4.0 * t1);
                g[1] = g[1] + 2.0 * t1;
                break;
            }
            case 8: {
                double t1 = -0.25;
                int j = 0;
                while (j < n) {
                    t1 += x[j] * x[j];
                    ++j;
                }
                double d1 = 2.0E-5;
                double th = 4.0 * t1;
                j = 0;
                while (j < n) {
                    g[j] = d1 * (x[j] - 1.0) + x[j] * th;
                    ++j;
                }
                break;
            }
            case 9: {
                double s2 = 0.0;
                double t1 = -1.0;
                int j = 0;
                while (j < n) {
                    t1 += (double)(n - j) * (x[j] * x[j]);
                    ++j;
                }
                double d1 = Math.exp(0.1);
                double d2 = 1.0;
                double th = 4.0 * t1;
                j = 0;
                while (j < n) {
                    g[j] = (double)(n - j) * x[j] * th;
                    double s1 = Math.exp(x[j] / 10.0);
                    if (j > 0) {
                        double s3 = s1 + s2 - d2 * (d1 + 1.0);
                        int n3 = j;
                        g[n3] = g[n3] + 1.0E-5 * s1 * (s3 + s1 - 1.0 / d1) / 5.0;
                        int n4 = j - 1;
                        g[n4] = g[n4] + 1.0E-5 * s2 * s3 / 5.0;
                    }
                    s2 = s1;
                    d2 *= d1;
                    ++j;
                }
                g[0] = g[0] + 2.0 * (x[0] - 0.2);
                break;
            }
            case 10: {
                double t1 = x[0] - 1000000.0;
                double t2 = x[1] - 2.0E-6;
                double t3 = x[0] * x[1] - 2.0;
                g[0] = 2.0 * (t1 + x[1] * t3);
                g[1] = 2.0 * (t2 + x[0] * t3);
                break;
            }
            case 11: {
                g[0] = 0.0;
                g[1] = 0.0;
                g[2] = 0.0;
                g[3] = 0.0;
                int i = 1;
                while (i <= 20) {
                    double d1 = (double)i / 5.0;
                    double d2 = Math.sin(d1);
                    double t1 = x[0] + d1 * x[1] - Math.exp(d1);
                    double t2 = x[2] + d2 * x[3] - Math.cos(d1);
                    double t = t1 * t1 + t2 * t2;
                    double s1 = t1 * t;
                    double s2 = t2 * t;
                    g[0] = g[0] + s1;
                    g[1] = g[1] + d1 * s1;
                    g[2] = g[2] + s2;
                    g[3] = g[3] + d2 * s2;
                    ++i;
                }
                g[0] = g[0] * 4.0;
                g[1] = g[1] * 4.0;
                g[2] = g[2] * 4.0;
                g[3] = g[3] * 4.0;
                break;
            }
            case 12: {
                g[0] = 0.0;
                g[1] = 0.0;
                g[2] = 0.0;
                double d1 = 0.6666666666666666;
                int i = 1;
                while (i <= 99) {
                    double arg = (double)i / 100.0;
                    double r = Math.abs(Math.pow(-50.0 * Math.log(arg), d1) + 25.0 - x[1]);
                    double t1 = Math.pow(r, x[2]) / x[0];
                    double t2 = Math.exp(-t1);
                    double t = t2 - arg;
                    double s1 = t1 * t2 * t;
                    g[0] = g[0] + s1;
                    g[1] = g[1] + s1 / r;
                    g[2] = g[2] - s1 * Math.log(r);
                    ++i;
                }
                g[0] = g[0] * (2.0 / x[0]);
                g[1] = g[1] * (2.0 * x[2]);
                g[2] = g[2] * 2.0;
                break;
            }
            case 13: {
                double s1 = 0.0;
                int j = 0;
                while (j < n) {
                    g[j] = Math.cos(x[j]);
                    s1 += g[j];
                    ++j;
                }
                double s2 = 0.0;
                j = 0;
                while (j < n) {
                    double th = Math.sin(x[j]);
                    double t = (double)(n + 1 + j) - th - s1 - (double)(1 + j) * g[j];
                    s2 += t;
                    g[j] = ((double)(1 + j) * th - g[j]) * t;
                    ++j;
                }
                j = 0;
                while (j < n) {
                    g[j] = 2.0 * (g[j] + Math.sin(x[j]) * s2);
                    ++j;
                }
                break;
            }
            case 14: {
                int j = 0;
                while (j < n) {
                    double t1 = 1.0 - x[j];
                    g[j + 1] = 200.0 * (x[j + 1] - x[j] * x[j]);
                    g[j] = -2.0 * (x[j] * g[j + 1] + t1);
                    j += 2;
                }
                break;
            }
            case 15: {
                int j = 0;
                while (j < n) {
                    double t = x[j] + 10.0 * x[j + 1];
                    double t1 = x[j + 2] - x[j + 3];
                    double s1 = 5.0 * t1;
                    double t2 = x[j + 1] - 2.0 * x[j + 2];
                    double s2 = 4.0 * (t2 * t2 * t2);
                    double t3 = x[j] - x[j + 3];
                    double s3 = 20.0 * (t3 * t3 * t3);
                    g[j] = 2.0 * (t + s3);
                    g[j + 1] = 20.0 * t + s2;
                    g[j + 2] = 2.0 * (s1 - s2);
                    g[j + 3] = -2.0 * (s1 + s3);
                    j += 4;
                }
                break;
            }
            case 16: {
                double s1 = 1.0 - x[1];
                double t1 = 1.5 - x[0] * s1;
                double s2 = 1.0 - x[1] * x[1];
                double t2 = 2.25 - x[0] * s2;
                double s3 = 1.0 - x[1] * x[1] * x[1];
                double t3 = 2.625 - x[0] * s3;
                g[0] = -2.0 * (s1 * t1 + s2 * t2 + s3 * t3);
                g[1] = 2.0 * x[0] * (t1 + x[1] * (2.0 * t2 + 3.0 * x[1] * t3));
                break;
            }
            case 17: {
                double s1 = x[1] - x[0] * x[0];
                double s2 = 1.0 - x[0];
                double s3 = x[1] - 1.0;
                double t1 = x[3] - x[2] * x[2];
                double t2 = 1.0 - x[2];
                double t3 = x[3] - 1.0;
                g[0] = -2.0 * (200.0 * x[0] * s1 + s2);
                g[1] = 200.0 * s1 + 20.2 * s3 + 19.8 * t3;
                g[2] = -2.0 * (180.0 * x[2] * t1 + t2);
                g[3] = 180.0 * t1 + 20.2 * t3 + 19.8 * s3;
                break;
            }
            case 18: {
                double th;
                double t;
                double t2;
                double t1;
                int i = 0;
                while (i < n) {
                    fvec[i] = 0.0;
                    ++i;
                }
                int j = 0;
                while (j < n) {
                    t1 = 1.0;
                    t2 = 2.0 * x[j] - 1.0;
                    t = 2.0 * t2;
                    i = 0;
                    while (i < n) {
                        int n5 = i++;
                        fvec[n5] = fvec[n5] + t2;
                        th = t * t2 - t1;
                        t1 = t2;
                        t2 = th;
                    }
                    ++j;
                }
                double d1 = 1.0 / (double)n;
                int iev = -1;
                i = 0;
                while (i < n) {
                    int n6 = i;
                    fvec[n6] = fvec[n6] * d1;
                    if (iev > 0) {
                        double r = i + 1;
                        int n7 = i;
                        fvec[n7] = fvec[n7] + 1.0 / (r * r - 1.0);
                    }
                    iev = -iev;
                    ++i;
                }
                j = 0;
                while (j < n) {
                    g[j] = 0.0;
                    t1 = 1.0;
                    t2 = 2.0 * x[j] - 1.0;
                    t = 2.0 * t2;
                    double s1 = 0.0;
                    double s2 = 2.0;
                    i = 0;
                    while (i < n) {
                        int n8 = j;
                        g[n8] = g[n8] + fvec[i] * s2;
                        th = 4.0 * t2 + t * s2 - s1;
                        s1 = s2;
                        s2 = th;
                        th = t * t2 - t1;
                        t1 = t2;
                        t2 = th;
                        ++i;
                    }
                    ++j;
                }
                double d2 = 2.0 * d1;
                j = 0;
                while (j < n) {
                    int n9 = j++;
                    g[n9] = g[n9] * d2;
                }
                break;
            }
            default: {
                int j = 0;
                while (j < n) {
                    g[j] = 0.0;
                    ++j;
                }
                break block0;
            }
        }
    }
}

