/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import mitiv.deconv.ConvolutionOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.RealComplexFFT;
import mitiv.utils.ColorMap;
import mitiv.utils.NavigableImagePanel;
import org.jtransforms.fft.DoubleFFT_2D;

public class MathUtils {
    public static final int COLORMAP_GRAYSCALE = 0;
    public static final int COLORMAP_JET = 1;
    public static final int GAUSSIAN = 2;
    public static final int AVERAGE = 3;
    public static final int PREWITT = 4;
    public static final int SOBEL = 5;
    public static final int KIRSH = 6;
    public static final int DISK = 7;

    public static boolean even(int x) {
        return x % 2 == 0;
    }

    public static long factorial(long n) {
        if (n == 0L) {
            return 1L;
        }
        return n * MathUtils.factorial(n - 1L);
    }

    public static double[][] cartesDist2D(int W, int H) {
        double[][] R = new double[H][W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2, 1.0);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2, 1.0);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                R[i][j] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
                ++i;
            }
            ++j;
        }
        return R;
    }

    public static double[] cartesDist1D(int W, int H) {
        double[] R = new double[H * W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                R[j * H + i] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
                ++i;
            }
            ++j;
        }
        return R;
    }

    public static double[] cartesAngle1D(int W, int H) {
        double[] THETA = new double[H * W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                THETA[j * H + i] = Math.atan2(y[i], x[j]);
                ++i;
            }
            ++j;
        }
        return THETA;
    }

    public static double[][] cartesAngle2D(int W, int H) {
        double[][] THETA = new double[H][W];
        double[] x = MathUtils.indgen((-W + 1) / 2, W / 2);
        double[] y = MathUtils.indgen((-H + 1) / 2, H / 2);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                THETA[i][j] = Math.atan2(y[i], x[j]);
                ++i;
            }
            ++j;
        }
        return THETA;
    }

    public static double[] catArray(double[] a, double[] b) {
        int L = a.length + b.length;
        double[] out = new double[L];
        int i = 0;
        while (i < a.length) {
            out[i] = a[i];
            ++i;
        }
        i = b.length;
        while (i < L) {
            out[i] = b[i - b.length];
            ++i;
        }
        return out;
    }

    public static DoubleShapedVector convolution(double[] x, double[] h, int nx, int ny, int nz) {
        int[] shape = new int[]{nx, nx, nz};
        DoubleShapedVectorSpace space = new DoubleShapedVectorSpace(shape);
        DoubleShapedVector hVector = space.wrap(h);
        DoubleShapedVector xVector = space.wrap(x);
        RealComplexFFT FFT = new RealComplexFFT(space);
        ConvolutionOperator H = new ConvolutionOperator(FFT, hVector);
        DoubleShapedVector y = space.create();
        H.apply((Vector)y, xVector);
        return y;
    }

    public static double[] convol(double[] x, double[] h, int nx, int ny, int nz) {
        int[] shape = new int[]{nx, nx, nz};
        DoubleShapedVectorSpace space = new DoubleShapedVectorSpace(shape);
        DoubleShapedVector hVector = space.wrap(h);
        DoubleShapedVector xVector = space.wrap(x);
        RealComplexFFT FFT = new RealComplexFFT(space);
        ConvolutionOperator H = new ConvolutionOperator(FFT, hVector);
        DoubleShapedVector y = space.create();
        H.apply((Vector)y, xVector);
        return y.getData();
    }

    public static double[] create3DSquare(int nxy, int nz, int sizeSquare) {
        double[] out = new double[nxy * nxy * nz];
        int k = 0;
        while (k < nz) {
            int j = nxy / 2 - sizeSquare / 2;
            while (j < nxy / 2 + sizeSquare / 2) {
                int i = nxy / 2 - sizeSquare / 2;
                while (i < nxy / 2 + sizeSquare / 2) {
                    out[k * nxy * nxy + j * nxy + i] = 1.0;
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return out;
    }

    public static double[][] fftAngle(int W, int H) {
        double[][] THETA = new double[H][W];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                THETA[i][j] = Math.atan2(y[i], x[j]);
                ++i;
            }
            ++j;
        }
        return THETA;
    }

    public static double[] fftAngle1D(int W, int H) {
        double[] THETA = new double[W * H];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        int j = 0;
        while (j < H) {
            int i = 0;
            while (i < W) {
                THETA[i + j * W] = Math.atan2(y[j], x[i]);
                ++i;
            }
            ++j;
        }
        return THETA;
    }

    public static double[] fftIndgen(int L) {
        double[] k = new double[L];
        double[] u = MathUtils.indgen(0, L - 1);
        int i = 0;
        while (i < L) {
            k[i] = u[i] > (double)(L / 2) ? u[i] - (double)L : u[i];
            ++i;
        }
        return k;
    }

    public static double[] fftDist(int L) {
        double[] x = new double[L];
        double[] R = new double[L];
        x = MathUtils.fftIndgen(L);
        int i = 0;
        while (i < L) {
            R[i] = Math.sqrt(x[i] * x[i] + x[i] * x[i]);
            ++i;
        }
        return R;
    }

    public static double[][] fftDist(int W, int H) {
        double[] x = new double[W];
        double[] y = new double[H];
        double[][] R = new double[H][W];
        x = MathUtils.fftIndgen(W);
        y = MathUtils.fftIndgen(H);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                R[i][j] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
                ++i;
            }
            ++j;
        }
        return R;
    }

    public static double[] fftDist1D(int W, int H) {
        double[] R = new double[H * W];
        double[] x = MathUtils.fftIndgen(W);
        double[] y = MathUtils.fftIndgen(H);
        int j = 0;
        while (j < H) {
            int i = 0;
            while (i < W) {
                R[i + j * W] = Math.sqrt(x[i] * x[i] + y[j] * y[j]);
                ++i;
            }
            ++j;
        }
        return R;
    }

    public static double[][][] gram_schmidt_orthonormalization(double[][][] A) {
        int D = A.length;
        int H = A[0].length;
        int W = A[0][0].length;
        double[][] Ai = new double[H][W];
        double[][] Aj = new double[H][W];
        double[][] s = new double[H][W];
        int i = 0;
        while (i < D) {
            double SAii;
            int x;
            int y;
            int x2 = 0;
            while (x2 < W) {
                y = 0;
                while (y < H) {
                    Ai[y][x2] = A[i][y][x2];
                    ++y;
                }
                ++x2;
            }
            if (i > 0) {
                x2 = 0;
                while (x2 < W) {
                    y = 0;
                    while (y < H) {
                        Aj[y][x2] = A[0][y][x2];
                        ++y;
                    }
                    ++x2;
                }
                double SAij = MathUtils.sum(MathUtils.hadamardProd(Ai, Aj, 0));
                x = 0;
                while (x < W) {
                    int y2 = 0;
                    while (y2 < H) {
                        s[y2][x] = SAij * Aj[y2][x];
                        ++y2;
                    }
                    ++x;
                }
                int j = 1;
                while (j < i) {
                    int x3 = 0;
                    while (x3 < W) {
                        int y3 = 0;
                        while (y3 < H) {
                            Aj[y3][x3] = A[j][y3][x3];
                            ++y3;
                        }
                        ++x3;
                    }
                    double SAij2 = MathUtils.sum(MathUtils.hadamardProd(Ai, Aj, 0));
                    int x4 = 0;
                    while (x4 < W) {
                        int y4 = 0;
                        while (y4 < H) {
                            double[] dArray = s[y4];
                            int n = x4;
                            dArray[n] = dArray[n] + SAij2 * Aj[y4][x4];
                            ++y4;
                        }
                        ++x4;
                    }
                    ++j;
                }
                x = 0;
                while (x < W) {
                    int y5 = 0;
                    while (y5 < H) {
                        double[] dArray = Ai[y5];
                        int n = x;
                        dArray[n] = dArray[n] - s[y5][x];
                        ++y5;
                    }
                    ++x;
                }
            }
            if ((SAii = MathUtils.sum(MathUtils.hadamardProd(Ai, Ai, 0))) > 0.0) {
                x = 0;
                while (x < W) {
                    int y6 = 0;
                    while (y6 < H) {
                        A[i][y6][x] = 1.0 / Math.sqrt(SAii) * Ai[y6][x];
                        ++y6;
                    }
                    ++x;
                }
            } else {
                x = 0;
                while (x < W) {
                    int y7 = 0;
                    while (y7 < H) {
                        A[i][y7][x] = 0.0;
                        ++y7;
                    }
                    ++x;
                }
            }
            ++i;
        }
        return A;
    }

    public static double[] gram_schmidt_orthonormalization(double[] A, int dim1, int dim2, int dim3) {
        double[] Ak = new double[dim1 * dim2];
        double[] Al = new double[dim1 * dim2];
        double[] s = new double[dim1 * dim2];
        int k = 0;
        while (k < dim3) {
            double SA_kl;
            int i1;
            int i2 = 0;
            while (i2 < dim2) {
                i1 = 0;
                while (i1 < dim1) {
                    Ak[i1 + dim1 * i2] = A[i1 + dim1 * i2 + k * dim1 * dim2];
                    ++i1;
                }
                ++i2;
            }
            if (k > 0) {
                i2 = 0;
                while (i2 < dim2) {
                    i1 = 0;
                    while (i1 < dim1) {
                        Al[i1 + dim1 * i2] = A[i1 + dim1 * i2];
                        ++i1;
                    }
                    ++i2;
                }
                SA_kl = MathUtils.innerProd(Ak, Al);
                int i12 = 0;
                while (i12 < dim1 * dim2) {
                    s[i12] = SA_kl * Al[i12];
                    ++i12;
                }
                int l = 1;
                while (l < k) {
                    int i22 = 0;
                    while (i22 < dim2) {
                        int i13 = 0;
                        while (i13 < dim1) {
                            Al[i13 + dim1 * i22] = A[i13 + dim1 * i22 + l * dim1 * dim2];
                            ++i13;
                        }
                        ++i22;
                    }
                    SA_kl = MathUtils.innerProd(Ak, Al);
                    int i122 = 0;
                    while (i122 < dim1 * dim2) {
                        int n = i122;
                        s[n] = s[n] + SA_kl * Al[i122];
                        ++i122;
                    }
                    ++l;
                }
                i12 = 0;
                while (i12 < dim1 * dim2) {
                    int n = i12;
                    Ak[n] = Ak[n] - s[i12];
                    ++i12;
                }
            }
            if ((SA_kl = MathUtils.innerProd(Ak, Ak)) > 0.0) {
                i2 = 0;
                while (i2 < dim2) {
                    i1 = 0;
                    while (i1 < dim1) {
                        A[i1 + dim1 * i2 + k * dim1 * dim2] = 1.0 / Math.sqrt(SA_kl) * Ak[i1 + dim1 * i2];
                        ++i1;
                    }
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < dim2) {
                    i1 = 0;
                    while (i1 < dim1) {
                        A[i1 + dim1 * i2 + k * dim1 * dim2] = 0.0;
                        ++i1;
                    }
                    ++i2;
                }
            }
            ++k;
        }
        return A;
    }

    public static double[] span(double begin, double end, double scale) {
        double a = begin;
        int L = 0;
        while (a <= end) {
            a += scale;
            ++L;
        }
        double[] tab = new double[L];
        a = begin;
        int b = 0;
        double i = begin;
        while (i <= end) {
            tab[b] = i;
            ++b;
            i += scale;
        }
        return tab;
    }

    public static double[] indgen(int n) {
        double[] out = new double[n];
        int i = 0;
        while (i < n) {
            out[i] = i + 1;
            ++i;
        }
        return out;
    }

    public static double[] indgen(int start, int stop) {
        int L = stop - start + 1;
        double[] out = new double[L];
        int i = start;
        while (i <= stop) {
            out[i - start] = i;
            ++i;
        }
        return out;
    }

    public static double[] indgen(int start, int stop, double scale) {
        double a = start;
        int L = 0;
        while (a <= (double)stop) {
            a += scale;
            ++L;
        }
        double[] tab = new double[L];
        a = start;
        int b = 0;
        double i = start;
        while (i <= (double)stop) {
            tab[b] = i;
            ++b;
            i += scale;
        }
        return tab;
    }

    public static double[] span(double start, double stop, int n) {
        double[] out = new double[n];
        double c1 = (stop - start) / (double)(n - 1);
        double c2 = (double)(n + 1) / 2.0;
        double c3 = (start + stop) / 2.0;
        int i = 0;
        while (i < n) {
            out[i] = c1 * ((double)(i + 1) - c2) + c3;
            ++i;
        }
        return out;
    }

    public static double[] scaleArrayTo8bit(double[] A) {
        int L = A.length;
        double[] scaleA = new double[L];
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        int i = 0;
        while (i < L) {
            scaleA[i] = (A[i] - minScaleA) * 255.0 / deltaScaleA;
            ++i;
        }
        return scaleA;
    }

    public static double[][] scaleArrayTo8bit(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double[][] scaleA = new double[H][W];
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                scaleA[i][j] = (A[i][j] - minScaleA) * 255.0 / deltaScaleA;
                ++i;
            }
            ++j;
        }
        return scaleA;
    }

    public static void uint8(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                A[i][j] = (A[i][j] - minScaleA) * 255.0 / deltaScaleA;
                ++i;
            }
            ++j;
        }
    }

    public static double[] uint16(double[] A) {
        int L = A.length;
        double minScaleA = MathUtils.min(A);
        double maxScaleA = MathUtils.max(A);
        double deltaScaleA = maxScaleA - minScaleA;
        int i = 0;
        while (i < L) {
            A[i] = (A[i] - minScaleA) * 65535.0 / deltaScaleA;
            ++i;
        }
        return A;
    }

    public static void normalise(double[] A) {
        int L = A.length;
        double N = MathUtils.sum(MathUtils.abs2(A, 0));
        int i = 0;
        while (i < L) {
            A[i] = A[i] / N;
            ++i;
        }
    }

    public static void im2double(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        double minA = MathUtils.min(a);
        double maxA = MathUtils.max(a);
        double delta = maxA - minA;
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                a[i][j] = (a[i][j] - minA) / delta;
                ++i;
            }
            ++j;
        }
    }

    public static double[][] conj1(double[][] A) {
        int H = A.length;
        int W = A[0].length;
        double[][] conjA = new double[H][W];
        int j = 0;
        while (j < W / 2) {
            int i = 0;
            while (i < H) {
                conjA[i][2 * j] = A[i][2 * j];
                conjA[i][2 * j + 1] = -A[i][2 * j + 1];
                ++i;
            }
            ++j;
        }
        return conjA;
    }

    public static void conj2(double[] A) {
        int i = 0;
        while (i < A.length / 2) {
            A[2 * i + 1] = -A[2 * i + 1];
            ++i;
        }
    }

    public static double[][] abs2(double[][] IN) {
        int H = IN.length;
        int W = IN[0].length / 2;
        double[][] OUT = new double[H][W];
        int i = 0;
        while (i < H) {
            OUT[i] = MathUtils.abs2(IN[i], 1);
            ++i;
        }
        return OUT;
    }

    public static double[] abs2(double[] x, int isComplex) {
        if (isComplex == 1) {
            int L = x.length / 2;
            double[] y = new double[L];
            int i = 0;
            while (i < L) {
                y[i] = x[2 * i] * x[2 * i] + x[2 * i + 1] * x[2 * i + 1];
                ++i;
            }
            return y;
        }
        int L = x.length;
        double[] y = new double[L];
        int i = 0;
        while (i < L) {
            y[i] = x[i] * x[i];
            ++i;
        }
        return y;
    }

    public static double[] abs2(double[] x, int begin, int end, int isComplex) {
        if (isComplex == 1) {
            int L = x.length / 2;
            double[] y = new double[L];
            int i = begin;
            while (i < end) {
                y[i] = x[2 * i] * x[2 * i] + x[2 * i + 1] * x[2 * i + 1];
                ++i;
            }
            return y;
        }
        int L = end - begin + 1;
        double[] y = new double[L];
        int i = 0;
        while (i < L) {
            y[i] = x[i + begin] * x[i + begin];
            ++i;
        }
        return y;
    }

    public static double min(double[] matrix) {
        double min = matrix[0];
        int i = 0;
        while (i < matrix.length) {
            if (min > matrix[i]) {
                min = matrix[i];
            }
            ++i;
        }
        return min;
    }

    public static double min(double[][] matrix) {
        double min = matrix[0][0];
        int col = 0;
        while (col < matrix.length) {
            int row = 0;
            while (row < matrix[col].length) {
                if (min > matrix[col][row]) {
                    min = matrix[col][row];
                }
                ++row;
            }
            ++col;
        }
        return min;
    }

    public static double max(double[] matrix) {
        double max = matrix[0];
        int i = 0;
        while (i < matrix.length) {
            if (max < matrix[i]) {
                max = matrix[i];
            }
            ++i;
        }
        return max;
    }

    public static double max(double[][] matrix) {
        double max = matrix[0][0];
        int col = 0;
        while (col < matrix.length) {
            int row = 0;
            while (row < matrix[col].length) {
                if (max < matrix[col][row]) {
                    max = matrix[col][row];
                }
                ++row;
            }
            ++col;
        }
        return max;
    }

    public static void printArray(int[] A) {
        System.out.println(Arrays.toString(A));
    }

    public static void printArray(double[] A) {
        System.out.println(Arrays.toString(A));
    }

    public static void printArray(double[] A, int begin, int end, int decimal) {
        if (decimal == 0) {
            int k = begin;
            while (k <= end) {
                System.out.printf("%f ", A[k]);
                ++k;
            }
        } else {
            int k = begin;
            while (k <= end) {
                System.out.printf("%.4E ", A[k]);
                ++k;
            }
        }
    }

    public static void printArray(double[] A, int width, int height, int deepth, int decimal) {
        if (decimal == 0) {
            int k = 0;
            while (k < deepth) {
                System.out.println("k = " + k);
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        System.out.printf("%.2f ", A[i + j * width + k * width * height]);
                        ++i;
                    }
                    System.out.println();
                    ++j;
                }
                ++k;
            }
        } else {
            int k = 0;
            while (k < deepth) {
                System.out.println("k = " + k);
                int j = 0;
                while (j < height) {
                    int i = 0;
                    while (i < width) {
                        System.out.printf("%.4E ", A[i + j * width + k * width * height]);
                        ++i;
                    }
                    System.out.println();
                    ++j;
                }
                ++k;
            }
        }
        System.out.println();
    }

    public static void printArray(double[][] A) {
        int H = A.length;
        int i = 0;
        while (i < H) {
            System.out.println(Arrays.toString(A[i]));
            ++i;
        }
    }

    public static void pli(double[][] A, int colorMap) {
        int H = A.length;
        int W = A[0].length;
        double[][] S = MathUtils.scaleArrayTo8bit(A);
        BufferedImage bufferedI = new BufferedImage(W, H, 1);
        switch (colorMap) {
            case 1: {
                ColorMap map = ColorMap.getJet(256);
                int j = 0;
                while (j < W) {
                    int i = 0;
                    while (i < H) {
                        Color b = map.table[(int)S[i][j]];
                        bufferedI.setRGB(i, j, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 0: {
                int j = 0;
                while (j < W) {
                    int i = 0;
                    while (i < H) {
                        Color b = new Color((int)S[i][j], (int)S[i][j], (int)S[i][j]);
                        bufferedI.setRGB(i, j, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
            }
            default: {
                throw new IllegalArgumentException("bad value for colorMap");
            }
        }
        JFrame frame = new JFrame();
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(bufferedI));
        frame.add(label);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public static void pli2(double[][] A, int colorMap) {
        int H = A.length;
        int W = A[0].length;
        double[][] S = MathUtils.scaleArrayTo8bit(A);
        BufferedImage bufferedI = new BufferedImage(W, H, 1);
        switch (colorMap) {
            case 1: {
                ColorMap map = ColorMap.getJet(256);
                int j = 0;
                while (j < W) {
                    int i = 0;
                    while (i < H) {
                        Color b = map.table[(int)S[i][j]];
                        bufferedI.setRGB(i, j, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 0: {
                int j = 0;
                while (j < W) {
                    int i = 0;
                    while (i < H) {
                        Color b = new Color((int)S[i][j], (int)S[i][j], (int)S[i][j]);
                        bufferedI.setRGB(i, j, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
            }
            default: {
                throw new IllegalArgumentException("bad value for colorMap");
            }
        }
        NavigableImagePanel.afficher(bufferedI);
    }

    public static void pli2(double[] A, int W, int H, int colorMap) {
        double[] S = MathUtils.scaleArrayTo8bit(A);
        BufferedImage bufferedI = new BufferedImage(W, H, 1);
        switch (colorMap) {
            case 1: {
                ColorMap map = ColorMap.getJet(256);
                int j = 0;
                while (j < H) {
                    int i = 0;
                    while (i < W) {
                        Color b = map.table[(int)S[i + j * W]];
                        bufferedI.setRGB(j, i, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 0: {
                int j = 0;
                while (j < H) {
                    int i = 0;
                    while (i < W) {
                        Color b = new Color((int)S[i + j * W], (int)S[i + j * W], (int)S[i + j * W]);
                        bufferedI.setRGB(j, i, b.getRGB());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad value for colorMap");
            }
        }
        NavigableImagePanel.afficher(bufferedI);
    }

    public static void fftPli2(double[][] A) {
        MathUtils.uint8(A);
        double[][] A_padded = MathUtils.fftShift(A);
        MathUtils.pli2(A_padded, 1);
    }

    public static void fftPli(double[][] A) {
        MathUtils.uint8(A);
        double[][] A_padded = MathUtils.fftShift(A);
        MathUtils.pli(A_padded, 1);
    }

    public static double[][] fftShift(double[][] A) {
        int i;
        int H = A.length;
        int W = A[0].length;
        double[][] A_shift = new double[H][W];
        int j = 0;
        while (j < W / 2) {
            i = 0;
            while (i < H / 2) {
                A_shift[H - H / 2 + i][W - W / 2 + j] = A[i][j];
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < W / 2) {
            i = 0;
            while (i < H / 2) {
                A_shift[H - H / 2 + i][j] = A[i][j + W / 2];
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < W / 2) {
            i = 0;
            while (i < H / 2) {
                A_shift[i][W - W / 2 + j] = A[i + H / 2][j];
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < W / 2) {
            i = 0;
            while (i < H / 2) {
                A_shift[i][j] = A[i + H / 2][j + W / 2];
                ++i;
            }
            ++j;
        }
        return A_shift;
    }

    public static double[] fftShift1D(double[] A, int w, int h, int d) {
        double[] A_shift = new double[w * h * d];
        int k = 0;
        while (k < d) {
            int j = 0;
            while (j < h / 2) {
                int i = 0;
                while (i < w / 2) {
                    A_shift[w * (h - h / 2 + j) + w - w / 2 + i] = A[i + w * j];
                    A_shift[w * (h - h / 2 + j) + i] = A[w * j + i + w / 2];
                    A_shift[w * j + w - w / 2 + i] = A[w * (j + h / 2) + i];
                    A_shift[i + w * j] = A[w * (j + h / 2) + i + w / 2];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return A_shift;
    }

    public static double[] fftShift1D(double[] A, int w, int h) {
        double[] A_shift = new double[w * h];
        int j = 0;
        while (j < h / 2) {
            int i = 0;
            while (i < w / 2) {
                A_shift[w * (h - h / 2 + j) + w - w / 2 + i] = A[i + w * j];
                A_shift[w * (h - h / 2 + j) + i] = A[w * j + i + w / 2];
                A_shift[w * j + w - w / 2 + i] = A[w * (j + h / 2) + i];
                A_shift[i + w * j] = A[w * (j + h / 2) + i + w / 2];
                ++i;
            }
            ++j;
        }
        return A_shift;
    }

    public static double[] fftShift3D(double[] A, int w, int h, int d) {
        double[] A_shift = new double[w * h * d];
        int wh = w * h;
        int k = 0;
        while (k < d / 2) {
            int j = 0;
            while (j < h / 2) {
                int i = 0;
                while (i < w / 2) {
                    A_shift[w - w / 2 + i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = A[i + w * j + k * wh];
                    A_shift[i + w * (h - h / 2 + j) + wh * (d - d / 2 + k)] = A[i + w / 2 + w * j + k * wh];
                    A_shift[w - w / 2 + i + w * j + wh * (d - d / 2 + k)] = A[i + w * (j + h / 2) + k * wh];
                    A_shift[i + w * j + wh * (d - d / 2 + k)] = A[i + w / 2 + w * (j + h / 2) + k * wh];
                    A_shift[w - w / 2 + i + w * (h - h / 2 + j) + k * wh] = A[i + w * j + wh * (d - d / 2 + k)];
                    A_shift[i + w * (h - h / 2 + j) + k * wh] = A[i + w / 2 + w * j + wh * (d - d / 2 + k)];
                    A_shift[w - w / 2 + i + w * j + k * wh] = A[i + w * (j + h / 2) + wh * (d - d / 2 + k)];
                    A_shift[i + w * j + k * wh] = A[i + w / 2 + w * (j + h / 2) + wh * (d - d / 2 + k)];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return A_shift;
    }

    public static double[][] fftConv(double[][] img, double[][] h) {
        int H = img.length;
        int W = img[0].length;
        DoubleFFT_2D FFT2D = new DoubleFFT_2D((long)H, (long)W);
        double[][] res = new double[H][W];
        double[][] hC = MathUtils.real2complex(h);
        double[][] imgC = MathUtils.real2complex(img);
        FFT2D.complexForward(hC);
        FFT2D.complexForward(imgC);
        double[][] fft_img_h = MathUtils.hadamardProd(hC, imgC, 1);
        FFT2D.complexInverse(fft_img_h, true);
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                res[i][j] = fft_img_h[i][2 * j];
                ++i;
            }
            ++j;
        }
        return res;
    }

    public static double[][] real2complex(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        double[][] c = new double[H][2 * W];
        int j = 0;
        while (j < W) {
            int i = 0;
            while (i < H) {
                c[i][2 * j] = a[i][j];
                ++i;
            }
            ++j;
        }
        return c;
    }

    public static double avg(double[] a) {
        return MathUtils.sum(a) / (double)a.length;
    }

    public static double avg(long[] a) {
        return MathUtils.sum(a) / (long)a.length;
    }

    public static double avg(double[][] a) {
        int H = a.length;
        int W = a[0].length;
        return MathUtils.sum(a) / (double)(H * W);
    }

    public static double avg(double[][][] a) {
        int W = a.length;
        int H = a[0].length;
        int D = a[0][0].length;
        return MathUtils.sum(a) / (double)(D * H * W);
    }

    public static double sum(double[] a) {
        int size = a.length;
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static double sum(double[] a, int begin, int end) {
        double sum = 0.0;
        int i = begin;
        while (i <= end) {
            sum += a[i];
            ++i;
        }
        return sum;
    }

    public static long sum(long[] array) {
        int size = array.length;
        long sum = 0L;
        int i = 0;
        while (i < size) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static double sum(double[][] array) {
        int H = array.length;
        double sum = 0.0;
        int i = 0;
        while (i < H) {
            sum += MathUtils.sum(array[i]);
            ++i;
        }
        return sum;
    }

    public static double sum(double[][][] array) {
        int D = array.length;
        double sum = 0.0;
        int k = 0;
        while (k < D) {
            sum += MathUtils.sum(array[k]);
            ++k;
        }
        return sum;
    }

    public static double innerProd(double[] a, double[] b) {
        int L = a.length;
        double out = 0.0;
        int i = 0;
        while (i < L) {
            out += a[i] * b[i];
            ++i;
        }
        return out;
    }

    public static double[] im2array(String imageName) {
        File fileI = new File(imageName);
        BufferedImage I = null;
        try {
            I = ImageIO.read(fileI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int H = I.getHeight();
        int W = I.getWidth();
        double[] ImArray = new double[H * W];
        WritableRaster raster = I.getRaster();
        int j = 0;
        while (j < H) {
            int i = 0;
            while (i < W) {
                int[] pixels = raster.getPixel(j, i, (int[])null);
                ImArray[i + j * W] = pixels[0];
                ++i;
            }
            ++j;
        }
        return ImArray;
    }

    public static double[][] img_pad(double[][] img, int newW, int newH, int just) {
        int oldH = img.length;
        int oldW = img[0].length;
        double[][] New = new double[newH][newW];
        switch (just) {
            case 0: {
                int i = 0;
                while (i < oldH) {
                    int j = 0;
                    while (j < oldW) {
                        New[i][j] = img[i][j];
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i1 = (newW - oldW) / 2;
                int i2 = (newH - oldH) / 2;
                int i = 0;
                while (i < oldH) {
                    int j = 0;
                    while (j < oldW) {
                        New[i2 + i][j + i1] = img[i][j];
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case -1: {
                int j;
                int i;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    i = 0;
                    while (i < oldH2) {
                        j = 0;
                        while (j < oldW2) {
                            New[newH - oldH2 + i][newW - oldW2 + j] = img[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                if (oldW2 != 0) {
                    i = 0;
                    while (i < oldH2) {
                        j = 0;
                        while (j < oldW - oldW2) {
                            New[newH - oldH2 + i][j] = img[i][j + oldW2];
                            ++j;
                        }
                        ++i;
                    }
                }
                if (oldH2 != 0) {
                    i = 0;
                    while (i < oldH - oldH2) {
                        j = 0;
                        while (j < oldW2) {
                            New[i][newW - oldW2 + j] = img[i + oldH2][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < oldH - oldH2) {
                    j = 0;
                    while (j < oldW - oldW2) {
                        New[i][j] = img[i + oldH2][j + oldW2];
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[] img_pad1d(double[] img, int oldW, int oldH, int newW, int newH, int just) {
        double[] New = new double[newH * newW];
        switch (just) {
            case 0: {
                int j = 0;
                while (j < oldH) {
                    int i = 0;
                    while (i < oldW) {
                        New[i + j * newW] = img[i + j * oldW];
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 1: {
                int i1 = (newW - oldW) / 2;
                int i2 = (newH - oldH) / 2;
                int j = 0;
                while (j < oldH) {
                    int i = 0;
                    while (i < oldW) {
                        New[i2 + j + (i + i1) * newW] = img[i * oldW + j];
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case -1: {
                int i;
                int j;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    j = 0;
                    while (j < oldH2) {
                        i = 0;
                        while (i < oldW2) {
                            New[newH - oldH2 + j + (newW - oldW2 + i) * newW] = img[i * oldW + j];
                            ++i;
                        }
                        ++j;
                    }
                }
                if (oldW2 != 0) {
                    j = 0;
                    while (j < oldH2) {
                        i = 0;
                        while (i < oldW - oldW2) {
                            New[(newH - oldH2 + j) * newW + i] = img[j * oldW + i + oldW2];
                            ++i;
                        }
                        ++j;
                    }
                }
                if (oldH2 != 0) {
                    j = 0;
                    while (j < oldH - oldH2) {
                        i = 0;
                        while (i < oldW2) {
                            New[j * newW + newW - oldW2 + i] = img[(j + oldH2) * oldW + i];
                            ++i;
                        }
                        ++j;
                    }
                }
                j = 0;
                while (j < oldH - oldH2) {
                    i = 0;
                    while (i < oldW - oldW2) {
                        New[i + j * newW] = img[(j + oldH2) * oldW + i + oldW2];
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[] img_pad(double[] img, int oldW, int oldH, int oldD, int newW, int newH, int newD, int just) {
        double[] New = new double[newH * newW * newD];
        int newWH = newW * newH;
        int oldWH = oldW * oldH;
        switch (just) {
            case 0: {
                int k = 0;
                while (k < oldD) {
                    int j = 0;
                    while (j < oldH) {
                        int i = 0;
                        while (i < oldW) {
                            New[i + j * newW] = img[i + j * oldW];
                            ++i;
                        }
                        ++j;
                    }
                    ++k;
                }
                break;
            }
            case 1: {
                int i2 = (newW - oldW) / 2;
                int j2 = (newH - oldH) / 2;
                int k2 = (newD - oldD) / 2;
                int k = 0;
                while (k < oldD) {
                    int j = 0;
                    while (j < oldH) {
                        int i = 0;
                        while (i < oldW) {
                            New[i2 + i + (j + j2) * newW + (k + k2) * newWH] = img[i + j * oldW + k * oldWH];
                            ++i;
                        }
                        ++j;
                    }
                    ++k;
                }
                break;
            }
            case -1: {
                int i;
                int j;
                int oldW2 = oldW / 2;
                int oldH2 = oldH / 2;
                if (oldW2 != 0 || oldH2 != 0) {
                    j = 0;
                    while (j < oldH2) {
                        i = 0;
                        while (i < oldW2) {
                            New[newH - oldH2 + j + (newW - oldW2 + i) * newW] = img[i * oldW + j];
                            ++i;
                        }
                        ++j;
                    }
                }
                if (oldW2 != 0) {
                    j = 0;
                    while (j < oldH2) {
                        i = 0;
                        while (i < oldW - oldW2) {
                            New[(newH - oldH2 + j) * newW + i] = img[j * oldW + i + oldW2];
                            ++i;
                        }
                        ++j;
                    }
                }
                if (oldH2 != 0) {
                    j = 0;
                    while (j < oldH - oldH2) {
                        i = 0;
                        while (i < oldW2) {
                            New[j * newW + newW - oldW2 + i] = img[(j + oldH2) * oldW + i];
                            ++i;
                        }
                        ++j;
                    }
                }
                j = 0;
                while (j < oldH - oldH2) {
                    i = 0;
                    while (i < oldW - oldW2) {
                        New[i + j * newW] = img[(j + oldH2) * oldW + i + oldW2];
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return New;
    }

    public static double[][] hadamardProd(double[][] a, double[][] b, int isComplex) {
        int H = a.length;
        int W = a[0].length;
        double[][] out = new double[H][W];
        if (isComplex == 0) {
            int j = 0;
            while (j < W) {
                int i = 0;
                while (i < H) {
                    out[i][j] = a[i][j] * b[i][j];
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < W) {
                int i = 0;
                while (i < H) {
                    out[i][2 * j] = a[i][2 * j] * b[i][2 * j] - a[i][2 * j + 1] * b[i][2 * j + 1];
                    out[i][2 * j + 1] = a[i][2 * j] * b[i][2 * j + 1] + a[i][2 * j + 1] * b[i][2 * j];
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static double[][] sumArrays(double[][] a, double[][] b, String sign) {
        int H = a.length;
        int W = a[0].length;
        double[][] out = new double[H][W];
        if (sign == "+") {
            int j = 0;
            while (j < W) {
                int i = 0;
                while (i < H) {
                    out[i][j] = a[i][j] + b[i][j];
                    ++i;
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < W) {
                int i = 0;
                while (i < H) {
                    out[i][j] = a[i][j] - b[i][j];
                    ++i;
                }
                ++j;
            }
        }
        return out;
    }

    public static double std(double[] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double std(double[][] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double std(double[][][] a) {
        double V = MathUtils.var(a);
        return Math.sqrt(V);
    }

    public static double var(double[] a) {
        double mean = MathUtils.avg(a);
        double out = 0.0;
        int k = 0;
        while (k < a.length) {
            out += a[k] * a[k];
            ++k;
        }
        return out / (double)a.length - mean * mean;
    }

    public static double var(double[][] a) {
        double mean = MathUtils.avg(a);
        double out = MathUtils.avg(MathUtils.hadamardProd(a, a, 0)) - mean * mean;
        return out;
    }

    public static double var(double[][][] a) {
        double x = 0.0;
        double mean = MathUtils.avg(a);
        double N = 0.0;
        double tmp = 0.0;
        int k = 0;
        while (k < a[0][0].length) {
            int j = 0;
            while (j < a[0].length) {
                int i = 0;
                while (i < a.length) {
                    tmp = a[i][j][k] - mean;
                    x += tmp * tmp;
                    N += 1.0;
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return x / N;
    }

    public static void stat(double[][] a) {
        System.out.println("H " + a.length + " W " + a[0].length);
        System.out.println("min " + MathUtils.min(a) + " max " + MathUtils.max(a));
        System.out.println("avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
    }

    public static void stat(double[] a) {
        System.out.println("size " + a.length);
        System.out.println("min " + MathUtils.min(a) + " max " + MathUtils.max(a));
        System.out.println("avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
    }

    public static void statC(double[] a) {
        int L = a.length;
        System.out.println("size " + a.length);
        double[] realA = new double[L / 2];
        double[] imgA = new double[L / 2];
        int i = 0;
        while (i < L / 2) {
            realA[i] = a[2 * i];
            imgA[i] = a[2 * i + 1];
            ++i;
        }
        System.out.println("Real part");
        System.out.println("min " + MathUtils.min(realA) + " max " + MathUtils.max(realA));
        System.out.println("avg " + MathUtils.avg(realA) + " var " + MathUtils.var(realA) + " std " + MathUtils.std(realA));
        System.out.println("Imaginary part");
        System.out.println("min " + MathUtils.min(imgA) + " max " + MathUtils.max(imgA));
        System.out.println("avg " + MathUtils.avg(imgA) + " var " + MathUtils.var(imgA) + " std " + MathUtils.std(imgA));
    }

    public static void stat(double[] a, int begin, int end) {
        double[] b = new double[end - begin + 1];
        int k = begin;
        while (k <= end) {
            b[k - begin] = a[k];
            ++k;
        }
        System.out.println("size " + b.length);
        System.out.println("min " + MathUtils.min(b) + " max " + MathUtils.max(b));
        System.out.println("avg " + MathUtils.avg(b) + " var " + MathUtils.var(b) + " std " + MathUtils.std(b));
    }

    public static double[][] imnoise(double[][] img, int type, double arg1, double arg2) {
        int H = img.length;
        int W = img[0].length;
        double[][] imnoise = new double[H][W];
        switch (type) {
            case 2: {
                Random rand = new Random();
                double std = Math.sqrt(arg1);
                double mean = arg2;
                MathUtils.im2double(img);
                int j = 0;
                while (j < W) {
                    int i = 0;
                    while (i < H) {
                        imnoise[i][j] = img[i][j] + std * rand.nextGaussian() + mean;
                        ++i;
                    }
                    ++j;
                }
                MathUtils.uint8(imnoise);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type does not exist");
            }
        }
        return imnoise;
    }

    public static double[][] fspecialAverage(int[] arg1) {
        double[][] ha = new double[arg1[0]][arg1[1]];
        double coef = 1.0 / (double)(arg1[0] * arg1[1]);
        int H = arg1[0];
        int W = arg1[1];
        int k2 = 0;
        while (k2 < H) {
            int k1 = 0;
            while (k1 < W) {
                ha[k2][k1] = coef;
                ++k1;
            }
            ++k2;
        }
        return ha;
    }

    public static double[][] fspecial(int type, int arg1) {
        switch (type) {
            case 7: {
                int i;
                int radius = arg1;
                int diameter = 2 * radius;
                double[][] r = MathUtils.cartesDist2D(diameter, diameter);
                double[][] mask = new double[diameter][diameter];
                double[][] hd = new double[diameter][diameter];
                int j = 0;
                while (j < r.length) {
                    i = 0;
                    while (i < r.length) {
                        if (r[i][j] <= (double)radius) {
                            mask[i][j] = 1.0;
                        }
                        ++i;
                    }
                    ++j;
                }
                double cd = MathUtils.sum(mask);
                j = 0;
                while (j < r.length) {
                    i = 0;
                    while (i < r.length) {
                        if (mask[i][j] == 1.0) {
                            hd[i][j] = 1.0 / cd;
                        }
                        ++i;
                    }
                    ++j;
                }
                return hd;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int type, int[] arg1, double arg2) {
        switch (type) {
            case 3: {
                double[][] ha = new double[arg1[0]][arg1[1]];
                double coef = 1.0 / (double)(arg1[0] * arg1[1]);
                int H = arg1[0];
                int W = arg1[1];
                int k2 = 0;
                while (k2 < H) {
                    int k1 = 0;
                    while (k1 < W) {
                        ha[k2][k1] = coef;
                        ++k1;
                    }
                    ++k2;
                }
                return ha;
            }
            case 2: {
                double[][] hg = new double[arg1[0]][arg1[1]];
                double A = 2.0 * arg2 * arg2;
                double B = 1.0 / Math.sqrt(Math.PI * A);
                int bk1 = (-arg1[1] + 1) / 2;
                int ek1 = arg1[1] / 2;
                int bk2 = (-arg1[0] + 1) / 2;
                int ek2 = arg1[0] / 2;
                int k2 = bk2;
                while (k2 <= ek2) {
                    int k1 = bk1;
                    while (k1 <= ek1) {
                        hg[k2 - bk2][k1 - bk1] = B * Math.exp((double)(-(k1 * k1 + k2 * k2)) / A);
                        ++k1;
                    }
                    ++k2;
                }
                return hg;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int type, int[] arg1, double arg2) {
        int L = arg1[0] * arg1[1];
        switch (type) {
            case 3: {
                double[] ha = new double[L];
                double coef = 1.0 / (double)L;
                int i = 0;
                while (i < L) {
                    ha[i] = coef;
                    ++i;
                }
                return ha;
            }
            case 2: {
                double[] hg = new double[L];
                int bk1 = (-arg1[1] + 1) / 2;
                int ek1 = arg1[1] / 2;
                int bk2 = (-arg1[0] + 1) / 2;
                int ek2 = arg1[0] / 2;
                int k2 = bk2;
                while (k2 <= ek2) {
                    int k1 = bk1;
                    while (k1 <= ek1) {
                        ++k1;
                    }
                    ++k2;
                }
                return hg;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int type) {
        switch (type) {
            case 3: {
                double ca = 0.1111111111111111;
                double[] ha = new double[]{ca, ca, ca, ca, ca, ca, ca, ca, ca};
                return ha;
            }
            case 7: {
                int radius = 5;
                int diameter = 2 * radius;
                double[] r = MathUtils.cartesDist1D(diameter, diameter);
                double[] mask = new double[diameter * diameter];
                double[] hd = new double[diameter * diameter];
                int i = 0;
                while (i < r.length) {
                    if (r[i] <= (double)radius) {
                        mask[i] = 1.0;
                    }
                    ++i;
                }
                double cd = MathUtils.sum(mask);
                i = 0;
                while (i < r.length) {
                    if (mask[i] == 1.0) {
                        hd[i] = 1.0 / cd;
                    }
                    ++i;
                }
                return hd;
            }
            case 5: {
                double[] hs = new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0};
                return hs;
            }
            case 4: {
                double[] hp = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0};
                return hp;
            }
            case 6: {
                double[] hk = new double[]{3.0, 3.0, 3.0, 3.0, 0.0, 3.0, -5.0, -5.0, -5.0};
                return hk;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int type) {
        switch (type) {
            case 3: {
                double ca = 0.1111111111111111;
                double[][] ha = new double[][]{{ca, ca, ca}, {ca, ca, ca}, {ca, ca, ca}};
                return ha;
            }
            case 7: {
                int i;
                int radius = 5;
                int diameter = 2 * radius;
                double[][] r = MathUtils.cartesDist2D(diameter, diameter);
                double[][] mask = new double[diameter][diameter];
                double[][] hd = new double[diameter][diameter];
                int j = 0;
                while (j < r.length) {
                    i = 0;
                    while (i < r.length) {
                        if (r[i][j] <= (double)radius) {
                            mask[i][j] = 1.0;
                        }
                        ++i;
                    }
                    ++j;
                }
                double cd = MathUtils.sum(mask);
                j = 0;
                while (j < r.length) {
                    i = 0;
                    while (i < r.length) {
                        if (mask[i][j] == 1.0) {
                            hd[i][j] = 1.0 / cd;
                        }
                        ++i;
                    }
                    ++j;
                }
                return hd;
            }
            case 5: {
                double[][] hs = new double[][]{{1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -2.0, -1.0}};
                return hs;
            }
            case 4: {
                double[][] hp = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -1.0, -1.0}};
                return hp;
            }
            case 6: {
                double[][] hk = new double[][]{{3.0, 3.0, 3.0}, {3.0, 0.0, 3.0}, {-5.0, -5.0, -5.0}};
                return hk;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] getArray(double[] In, int width, int height, int depth) {
        int L = width * height;
        double[] Out = new double[L];
        int i = 0;
        while (i < L) {
            Out[i] = In[depth * L + i];
            ++i;
        }
        return Out;
    }

    public static double[] transpose(double[] array, int W, int H, int D) {
        int L = array.length;
        double[] out = new double[L];
        int k = 0;
        while (k < D) {
            int j = 0;
            while (j < H) {
                int i = 0;
                while (i < W) {
                    out[j + H * i + k * W * H] = array[i + W * j + k * W * H];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        return out;
    }

    public static void writeStat(double[][] a, String name) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File("temp"), true));
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i <= 5) {
                sb.append(name);
                ++i;
            }
            sb.append("H " + a.length + " W " + a[0].length + "\n min " + MathUtils.min(a) + " max " + MathUtils.max(a) + "\n avg " + MathUtils.avg(a) + " var " + MathUtils.var(a) + " std " + MathUtils.std(a));
            bw.write(sb.toString());
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double[][][] XY2XZ(double[][][] inXY) {
        int Nz = inXY.length;
        int Ny = inXY[0].length;
        int Nx = inXY[0][0].length;
        double[][][] outXZ = new double[Ny][Nz][Nx];
        int j = 0;
        while (j < Nx) {
            int z = Nz - 1;
            while (z >= 0) {
                int i = 0;
                while (i < Nx) {
                    outXZ[j][Math.abs((int)(z - 1))][i] = inXY[z][i][j];
                    ++i;
                }
                --z;
            }
            ++j;
        }
        return outXZ;
    }

    public static double[] cumSum(double[] tab) {
        int L = tab.length;
        double[] out = new double[L];
        out[0] = tab[0];
        int i = 1;
        while (i < L) {
            out[i] = out[i - 1] + tab[i];
            ++i;
        }
        return out;
    }

    public static double mse(double[] yEstimate, double[] yTrue) {
        int n = yTrue.length;
        double tmp1 = 0.0;
        double out = 0.0;
        int i = 0;
        while (i < n) {
            tmp1 = yTrue[i] - yEstimate[i];
            out += tmp1 * tmp1;
            ++i;
        }
        return out / (double)n;
    }
}

