/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils.reconstruction;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ReconstructionThreadToken {
    private double[] values = null;
    private int number = 0;
    private final Lock lock = new ReentrantLock();
    private Condition canRun = this.lock.newCondition();
    private Condition jobFinished = this.lock.newCondition();
    private boolean run = false;
    private boolean stop = false;
    private boolean exit = false;

    public synchronized void setValue(int i, double value) {
        this.values[i] = value;
    }

    public ReconstructionThreadToken(double[] initialValues) {
        this.number = initialValues != null ? initialValues.length : 0;
        this.values = new double[this.number];
        int i = 0;
        while (i < this.number) {
            this.values[i] = initialValues[i];
            ++i;
        }
    }

    public synchronized boolean fetchValues(double[] values, boolean[] changed) {
        boolean anyChange = false;
        int i = 0;
        while (i < this.number) {
            if (values[i] != this.values[i]) {
                anyChange = true;
                changed[i] = true;
                values[i] = this.values[i];
            } else {
                changed[i] = false;
            }
            ++i;
        }
        return anyChange;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean waitForJob) {
        this.run = true;
        this.stop = false;
        try {
            this.lock.lock();
            this.canRun.signal();
        }
        finally {
            this.lock.unlock();
        }
        if (waitForJob) {
            this.waitForJob();
        }
    }

    public void waitForStart() {
        try {
            try {
                this.lock.lock();
                this.canRun.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitForJob() {
        try {
            try {
                this.lock.lock();
                if (this.run && !this.stop && !this.exit) {
                    this.jobFinished.await();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.stop = true;
    }

    public void exit() {
        this.exit = true;
        this.start();
    }

    public void jobFinished() {
        this.run = false;
        try {
            this.lock.lock();
            this.jobFinished.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.run;
    }

    public boolean isStopped() {
        return this.stop;
    }

    public boolean isExiting() {
        return this.exit;
    }
}

