/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.deconv;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadataImpl;
import mitiv.array.ArrayUtils;
import mitiv.array.Double1D;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.mapping.DoubleFunction;
import mitiv.invpb.ReconstructionJob;
import mitiv.invpb.ReconstructionViewer;
import mitiv.linalg.WeightGenerator;
import mitiv.utils.FFTUtils;
import mitiv.utils.reconstruction.ReconstructionThread;
import mitiv.utils.reconstruction.ReconstructionThreadToken;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.IcyBufferedImageUtils;
import plugins.mitiv.reconstruction.TotalVariationJobForIcy;

public class MitivDeconvolution
extends EzPlug
implements Block,
EzStoppable,
SequenceListener,
EzVarListener<String> {
    TotalVariationJobForIcy tvDec;
    private Sequence sequence;
    private double mu = 0.1;
    private double epsilon = 0.1;
    private double grtol = 0.0;
    private double gatol = 0.0;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private int maxIter = 50;
    private boolean goodInput = true;
    private boolean computeNew = true;
    private boolean reuse = false;
    private int width = -1;
    private int height = -1;
    private int sizeZ = -1;
    private int widthPad = -1;
    private int heightPad = -1;
    private int sizeZPad = -1;
    private double coefXY = 1.0;
    private double coefZ = 1.0;
    private Shape shapePad;
    private ReconstructionThreadToken token;
    ReconstructionThread thread;
    private EzVarSequence sequencePsf;
    private EzVarSequence sequenceImg;
    private EzVarSequence lastResult;
    private EzVarSequence output;
    private EzVarDouble eZmu;
    private EzVarDouble eZepsilon;
    private EzVarInteger eZcoefXY;
    private EzVarInteger eZcoefZ;
    private EzVarInteger eZmaxIter;
    private EzVarBoolean eZpositivity;
    private String weightOption1;
    private String weightOption2;
    private String weightOption3;
    private String weightOption4;
    private EzVarText options;
    private EzVarSequence weightMap;
    private EzVarSequence varianceMap;
    private EzVarBoolean showPixMap;
    private EzVarSequence deadPixel;
    private EzVarDouble alpha;
    private EzVarDouble beta;
    private EzGroup groupRegularization;
    private EzGroup groupWeighting;
    private EzGroup groupConvergence;
    IcyBufferedImage result;

    private void message(String info) {
        new AnnounceFrame(info);
        this.goodInput = false;
    }

    protected void initialize() {
        this.sequencePsf = new EzVarSequence("Input PSF");
        this.sequenceImg = new EzVarSequence("Input Image");
        this.lastResult = new EzVarSequence("Previous result");
        this.output = new EzVarSequence("Output");
        this.eZmu = new EzVarDouble("Regularization level", 0.0, Double.MAX_VALUE, 0.1);
        this.eZepsilon = new EzVarDouble("Threshold level", 0.0, Double.MAX_VALUE, 1.0);
        this.eZcoefXY = new EzVarInteger("Number of lines to add (padding xy)", 0, 10000, 1);
        this.eZcoefZ = new EzVarInteger("Number of lines to add (padding z)", 0, 10000, 1);
        this.eZmaxIter = new EzVarInteger("Max Iterations", -1, Integer.MAX_VALUE, 1);
        this.eZpositivity = new EzVarBoolean("Enforce nonnegativity", false);
        this.weightOption1 = new String("None");
        this.weightOption2 = new String("Personnalized weightMap");
        this.weightOption3 = new String("Variance map");
        this.weightOption4 = new String("Computed Variance");
        this.options = new EzVarText("Options", new String[]{this.weightOption1, this.weightOption2, this.weightOption3, this.weightOption4}, 0, Boolean.valueOf(false));
        this.weightMap = new EzVarSequence("Weight Map");
        this.varianceMap = new EzVarSequence("Variance Map");
        this.showPixMap = new EzVarBoolean("Data Map?", false);
        this.deadPixel = new EzVarSequence("Dead pixel map");
        this.alpha = new EzVarDouble("Gain e-/lvl");
        this.beta = new EzVarDouble("Readout noise e-/pxl");
        this.groupRegularization = new EzGroup("Regularization", new EzComponent[]{this.eZmu, this.eZepsilon});
        this.groupWeighting = new EzGroup("Weighting", new EzComponent[]{this.options, this.weightMap, this.varianceMap, this.alpha, this.beta, this.showPixMap, this.deadPixel});
        this.groupConvergence = new EzGroup("Convergence settings", new EzComponent[]{this.eZmaxIter});
        this.lastResult.setNoSequenceSelection();
        this.eZmu.setValue((Object)this.mu);
        this.eZepsilon.setValue((Object)this.epsilon);
        this.eZmaxIter.setValue((Object)this.maxIter);
        this.eZcoefXY.setValue((Object)0);
        this.eZcoefZ.setValue((Object)0);
        this.options.addVarChangeListener((EzVarListener)this);
        this.alpha.setVisible(false);
        this.beta.setVisible(false);
        this.deadPixel.setVisible(false);
        this.showPixMap.addVisibilityTriggerTo((EzComponent)this.deadPixel, (Object[])new Boolean[]{true});
        this.sequencePsf.setToolTipText("The PSF associated to the image given");
        this.sequenceImg.setToolTipText("The image on which we will work");
        this.lastResult.setToolTipText("Restart from previous result, if enabled will start with last image and PSF");
        this.eZmu.setToolTipText("Mu");
        this.eZepsilon.setToolTipText("Epsilon");
        this.eZmaxIter.setToolTipText("Maximum number of iterations, -1 for no limits");
        this.eZcoefXY.setToolTipText("Add X zero lines around the image");
        this.eZcoefZ.setToolTipText("Add X zero lines around the image");
        this.alpha.setToolTipText("The gain in e-/level");
        this.beta.setToolTipText("The readout noise i.e the RMS in e-/pixel");
        this.eZpositivity.setToolTipText("Limit the negatives values while computing the solution");
        this.showPixMap.setToolTipText("The binary pixel map representing the pixels that we should ignore");
        this.weightMap.setToolTipText("The weight map to possibly ignore or minize errors in the image");
        this.varianceMap.setToolTipText("The variance map");
        this.addEzComponent((EzComponent)this.sequenceImg);
        this.addEzComponent((EzComponent)this.sequencePsf);
        this.addEzComponent((EzComponent)this.lastResult);
        this.addEzComponent((EzComponent)this.groupRegularization);
        this.addEzComponent((EzComponent)this.groupConvergence);
        this.addEzComponent((EzComponent)this.groupWeighting);
        this.addEzComponent((EzComponent)this.eZcoefXY);
        this.addEzComponent((EzComponent)this.eZcoefZ);
        this.addEzComponent((EzComponent)this.eZpositivity);
        this.token = new ReconstructionThreadToken(new double[]{this.mu, this.epsilon, this.gatol, this.grtol});
        this.thread = new ReconstructionThread(this.token);
        this.thread.start();
    }

    protected void execute() {
        this.goodInput = true;
        this.mu = (Double)this.eZmu.getValue();
        this.epsilon = (Double)this.eZepsilon.getValue();
        this.maxIter = (Integer)this.eZmaxIter.getValue();
        Sequence seqImg = (Sequence)this.sequenceImg.getValue();
        Sequence seqPsf = (Sequence)this.sequencePsf.getValue();
        Sequence seqRes = (Sequence)this.lastResult.getValue();
        if (seqImg == null || seqPsf == null) {
            if (seqImg == null || seqPsf == null) {
                String message = "You have forgotten to give ";
                String messageEnd = "";
                if (seqImg == null) {
                    messageEnd = messageEnd.concat("the image ");
                }
                if (seqPsf == null) {
                    if (seqImg == null) {
                        messageEnd = messageEnd.concat("and ");
                    }
                    messageEnd = messageEnd.concat("a PSF");
                }
                this.message(String.valueOf(message) + messageEnd);
            }
            return;
        }
        double tmp = seqImg.getSizeX();
        this.coefXY = (tmp + (double)((Integer)this.eZcoefXY.getValue()).intValue()) / tmp;
        this.coefZ = (seqImg.getSizeZ() + (Integer)this.eZcoefZ.getValue()) / seqImg.getSizeZ();
        if (this.isHeadLess()) {
            this.reuse = false;
        } else {
            boolean bl = this.reuse = seqRes != null;
        }
        if (this.mu < 0.0) {
            this.message("Regularization level MU must be strictly positive");
        }
        if (this.epsilon <= 0.0) {
            this.message("Threshold level EPSILON must be strictly positive");
        }
        if (this.grtol < 0.0 || this.grtol >= 1.0) {
            this.message("grtol canno't be lower than 0 or greater than 1");
        }
        if (this.coefXY < 0.0 || this.coefZ < 0.0) {
            this.message("The Padding can not be lower than 0");
        }
        if (this.maxIter < -1) {
            this.maxIter = -1;
        }
        try {
            if (this.reuse) {
                this.result = seqRes.getFirstNonNullImage();
            }
            if (seqPsf.getWidth() > seqImg.getWidth() || seqPsf.getHeight() > seqImg.getHeight()) {
                this.message("The psf can not be larger than the image");
            }
            if (this.reuse) {
                boolean sameAsPrevious;
                boolean sameAsOrigin = seqRes.getSizeX() == seqImg.getSizeX() && seqRes.getSizeY() == seqImg.getSizeY() && seqRes.getSizeZ() == seqImg.getSizeZ();
                boolean bl = sameAsPrevious = seqRes.getSizeX() == this.shapePad.dimension(0) && seqRes.getSizeY() == this.shapePad.dimension(1) && (seqRes.getSizeZ() == 1 || seqRes.getSizeZ() == this.shapePad.dimension(2));
                if (!sameAsOrigin && !sameAsPrevious) {
                    this.message("The previous result does not have the same dimensions as the input image");
                }
            }
            if (seqImg.getSizeZ() == 1 && seqPsf.getSizeZ() > 1 || seqImg.getSizeZ() > 1 && seqPsf.getSizeZ() == 1) {
                this.message("The psf and the image should have the same number of dimensions in Z");
            }
            if (seqImg.getSizeT() > 1 || seqPsf.getSizeT() > 1) {
                this.message("Sorry we do not support 4D data for now");
            }
            if (this.goodInput) {
                this.width = Math.max(seqImg.getWidth(), seqPsf.getWidth());
                this.height = Math.max(seqImg.getHeight(), seqPsf.getHeight());
                this.sizeZ = Math.max(seqImg.getSizeZ(), seqPsf.getSizeZ());
                this.widthPad = FFTUtils.bestDimension((int)((double)this.width * this.coefXY));
                this.heightPad = FFTUtils.bestDimension((int)((double)this.height * this.coefXY));
                this.sizeZPad = FFTUtils.bestDimension((int)((double)this.sizeZ * this.coefZ));
                this.shapePad = seqImg.getSizeZ() == 1 ? Shape.make(this.widthPad, this.heightPad) : Shape.make(this.widthPad, this.heightPad, this.sizeZPad);
                if (this.reuse && this.tvDec != null) {
                    this.tvDec.setRegularizationWeight(this.mu);
                    this.tvDec.setRegularizationThreshold(this.epsilon);
                    this.tvDec.setRelativeTolerance(this.grtol);
                    this.tvDec.setMaximumIterations(this.maxIter);
                    this.tvDec.setOutputShape(this.shapePad);
                    this.tvDec.setPositivity((Boolean)this.eZpositivity.getValue());
                    this.lowerBound = this.tvDec.getLowerBound();
                    DoubleArray psfArray = (DoubleArray)IcyBufferedImageUtils.imageToArray(seqPsf, 0);
                    DoubleArray resArray = (DoubleArray)IcyBufferedImageUtils.imageToArray(seqRes, 0);
                    resArray.map(new DoubleFunction(){

                        @Override
                        public double apply(double arg) {
                            if (arg >= MitivDeconvolution.this.lowerBound) {
                                return arg;
                            }
                            return MitivDeconvolution.this.lowerBound;
                        }
                    });
                    resArray = (DoubleArray)ArrayUtils.pad(resArray, this.shapePad);
                    this.tvDec.setPsf(psfArray);
                    this.tvDec.setResult(resArray);
                    this.token.start();
                    this.computeNew = true;
                } else {
                    this.tvDec = new TotalVariationJobForIcy(this.token);
                    this.tvDec.setRegularizationWeight(this.mu);
                    this.tvDec.setRegularizationThreshold(this.epsilon);
                    this.tvDec.setRelativeTolerance(this.grtol);
                    this.tvDec.setAbsoluteTolerance(this.gatol);
                    this.tvDec.setMaximumIterations(this.maxIter);
                    this.tvDec.setPositivity((Boolean)this.eZpositivity.getValue());
                    this.tvDec.setViewer(new tvViewer());
                    this.thread.setJob(this.tvDec);
                    DoubleArray imgArray = (DoubleArray)IcyBufferedImageUtils.imageToArray(seqImg, 0);
                    DoubleArray psfArray = (DoubleArray)IcyBufferedImageUtils.imageToArray(seqPsf, 0);
                    DoubleArray weight = this.createWeight(imgArray);
                    imgArray = (DoubleArray)ArrayUtils.pad(imgArray, this.shapePad);
                    psfArray = (DoubleArray)ArrayUtils.pad(psfArray, this.shapePad);
                    weight = (DoubleArray)ArrayUtils.pad(weight, this.shapePad);
                    this.tvDec.setWeight(weight);
                    this.tvDec.setData(imgArray);
                    this.tvDec.setPsf(psfArray);
                    this.tvDec.setOutputShape(this.shapePad);
                    this.lowerBound = this.tvDec.getLowerBound();
                    DoubleArray myArray = this.tvDec.getData();
                    myArray.map(new DoubleFunction(){

                        @Override
                        public double apply(double arg) {
                            if (arg >= MitivDeconvolution.this.lowerBound) {
                                return arg;
                            }
                            return MitivDeconvolution.this.lowerBound;
                        }
                    });
                    this.token.start();
                    this.computeNew = true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            new AnnounceFrame("Oops, Error: " + e.getMessage());
        }
    }

    private static ShapedArray weightMapToArray(EzVarSequence seq) {
        Sequence in = (Sequence)seq.getValue();
        if (in != null) {
            return IcyBufferedImageUtils.imageToArray(in, 0);
        }
        throw new IllegalArgumentException("The input requested was not found");
    }

    private DoubleArray createWeight(ShapedArray data) {
        WeightGenerator weightGen = new WeightGenerator();
        String newValue = (String)this.options.getValue();
        ShapedArray deadPixMap = null;
        if (((Boolean)this.showPixMap.getValue()).booleanValue() && this.deadPixel.getValue() != null && ((Sequence)this.deadPixel.getValue()).getFirstNonNullImage() != null) {
            deadPixMap = MitivDeconvolution.weightMapToArray(this.deadPixel);
        }
        if (newValue == this.weightOption1) {
            double[] weight = new double[this.width * this.height * this.sizeZ];
            int i = 0;
            while (i < weight.length) {
                weight[i] = 1.0;
                ++i;
            }
            weightGen.setWeightMap(Double1D.wrap(weight, weight.length));
        } else if (newValue == this.weightOption2) {
            ShapedArray array = MitivDeconvolution.weightMapToArray(this.weightMap);
            weightGen.setWeightMap(array);
        } else if (newValue == this.weightOption3) {
            ShapedArray array = MitivDeconvolution.weightMapToArray(this.varianceMap);
            weightGen.setWeightMap(array);
        } else if (newValue == this.weightOption4) {
            weightGen.setComputedVariance(data, (Double)this.alpha.getValue(), (Double)this.beta.getValue());
        } else {
            throw new IllegalArgumentException("Incorrect argument for weightmap");
        }
        weightGen.setPixelMap(deadPixMap);
        return weightGen.getWeightMap(data.getShape()).toDouble();
    }

    private void addImage(double[] in, String name, int width, int height, int sizeZ) {
        Sequence tmpSeq = new Sequence();
        int j = 0;
        while (j < sizeZ) {
            double[] temp = new double[width * height];
            int i = 0;
            while (i < width * height) {
                temp[i] = in[i + j * width * height];
                ++i;
            }
            tmpSeq.setImage(0, j, (BufferedImage)new IcyBufferedImage(width, height, (Object)temp));
            ++j;
        }
        tmpSeq.setName(name);
        this.addSequence(tmpSeq);
    }

    private void updateMetaData(Sequence seq) {
        Sequence imageIn = (Sequence)this.sequenceImg.getValue();
        OMEXMLMetadataImpl newMetdat = OMEUtil.createOMEMetadata((MetadataRetrieve)imageIn.getMetadata());
        seq.setMetaData(newMetdat);
    }

    private void setResult() {
        if (this.sequence == null || this.computeNew) {
            this.sequence = new Sequence();
            this.sequence.addListener((SequenceListener)this);
            if (this.isHeadLess()) {
                this.output.setValue(this.sequence);
            } else {
                this.addSequence(this.sequence);
            }
            this.updateMetaData(this.sequence);
            this.computeNew = false;
        }
        try {
            this.sequence.beginUpdate();
            double[] in = this.tvDec.getResult().toDouble().flatten();
            int j = 0;
            while (j < this.sizeZPad) {
                double[] temp = new double[this.widthPad * this.heightPad];
                int i = 0;
                while (i < this.widthPad * this.heightPad) {
                    temp[i] = in[i + j * this.widthPad * this.heightPad];
                    ++i;
                }
                this.sequence.setImage(0, j, (BufferedImage)new IcyBufferedImage(this.widthPad, this.heightPad, (Object)temp));
                ++j;
            }
        }
        finally {
            this.sequence.endUpdate();
        }
        this.sequence.setName("TV mu=" + this.mu + " Epsilon=" + this.epsilon + " Iteration=" + this.tvDec.getIterations());
    }

    public void clean() {
        if (this.token != null) {
            this.token.stop();
            this.token.exit();
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
    }

    public void sequenceClosed(Sequence seq) {
    }

    public void variableChanged(EzVar<String> source, String newValue) {
        if (newValue == this.weightOption1) {
            this.weightMap.setVisible(false);
            this.varianceMap.setVisible(false);
            this.alpha.setVisible(false);
            this.beta.setVisible(false);
        } else if (newValue == this.weightOption2) {
            this.weightMap.setVisible(true);
            this.varianceMap.setVisible(false);
            this.alpha.setVisible(false);
            this.beta.setVisible(false);
        } else if (newValue == this.weightOption3) {
            this.weightMap.setVisible(false);
            this.varianceMap.setVisible(true);
            this.alpha.setVisible(false);
            this.beta.setVisible(false);
        } else if (newValue == this.weightOption4) {
            this.weightMap.setVisible(false);
            this.varianceMap.setVisible(false);
            this.alpha.setVisible(true);
            this.beta.setVisible(true);
        } else {
            throw new IllegalArgumentException("Incorrect argument for weightmap");
        }
    }

    public void stopExecution() {
        if (this.token != null) {
            this.token.stop();
        }
    }

    public void declareInput(VarList inputMap) {
        this.initialize();
        inputMap.add("image", (Var)this.sequenceImg.getVariable());
        inputMap.add("psf", (Var)this.sequencePsf.getVariable());
        inputMap.add("mu", this.eZmu.getVariable());
        inputMap.add("epsilon", this.eZepsilon.getVariable());
        inputMap.add("maxIter", this.eZmaxIter.getVariable());
        inputMap.add("coefXY", this.eZcoefXY.getVariable());
        inputMap.add("coefZ", this.eZcoefZ.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output.getVariable());
    }

    public class tvViewer
    implements ReconstructionViewer {
        @Override
        public void display(ReconstructionJob job) {
            MitivDeconvolution.this.setResult();
        }
    }
}

