/*
 * Decompiled with CFR 0.152.
 */
package plugins.mitiv.deconv;

import icy.gui.frame.progress.AnnounceFrame;
import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import mitiv.array.ShapedArray;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.mitiv.io.IcyBufferedImageUtils;

public class MitivNormalization
extends EzPlug
implements Block {
    EzVarSequence image = new EzVarSequence("Image to normalize");
    EzVarSequence imageOut = new EzVarSequence("Image Normalized");
    boolean goodInput = true;

    protected void initialize() {
        this.addEzComponent((EzComponent)this.image);
    }

    private void message(String info) {
        new AnnounceFrame(info);
        this.goodInput = false;
    }

    protected void execute() {
        Sequence seq = (Sequence)this.image.getValue();
        if (seq == null) {
            this.message("You should give a image");
        }
        if (this.goodInput) {
            IcyBufferedImage img = seq.getFirstNonNullImage();
            int width = img.getWidth();
            int height = img.getHeight();
            int sizeZ = seq.getSizeZ();
            double count = 0.0;
            ShapedArray tmp1 = IcyBufferedImageUtils.imageToArray(seq, 0);
            double[] out = tmp1.toDouble().flatten();
            int i = 0;
            while (i < out.length) {
                count += out[i];
                ++i;
            }
            System.out.println("SUM: " + count);
            Sequence seqOut = new Sequence();
            int j = 0;
            while (j < sizeZ) {
                double[] tmp = new double[width * height];
                int i2 = 0;
                while (i2 < tmp.length) {
                    tmp[i2] = out[i2 + j * tmp.length] / count;
                    ++i2;
                }
                seqOut.setImage(0, j, (BufferedImage)new IcyBufferedImage(width, height, (Object)tmp));
                ++j;
            }
            seqOut.setName("Normalized_" + seq.getName());
            if (this.isHeadLess()) {
                this.imageOut.setValue(seqOut);
            } else {
                this.addSequence(seqOut);
            }
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("imageIn", (Var)this.image.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("imageOut", (Var)this.imageOut.getVariable());
    }
}

