/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.qr;

import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class QRDecompositionHouseholder
implements QRDecomposition<DenseMatrix64F> {
    protected DenseMatrix64F QR;
    protected double[] u;
    protected double[] v;
    protected int numCols;
    protected int numRows;
    protected int minLength;
    protected double[] dataQR;
    protected double[] gammas;
    protected double gamma;
    protected double tau;
    protected boolean error;

    public void setExpectedMaxSize(int n, int n2) {
        this.error = false;
        this.numCols = n2;
        this.numRows = n;
        this.minLength = Math.min(n, n2);
        int n3 = Math.max(n, n2);
        if (this.QR == null) {
            this.QR = new DenseMatrix64F(n, n2);
            this.u = new double[n3];
            this.v = new double[n3];
            this.gammas = new double[this.minLength];
        } else {
            this.QR.reshape(n, n2, false);
        }
        this.dataQR = this.QR.data;
        if (this.u.length < n3) {
            this.u = new double[n3];
            this.v = new double[n3];
        }
        if (this.gammas.length < this.minLength) {
            this.gammas = new double[this.minLength];
        }
    }

    public DenseMatrix64F getQR() {
        return this.QR;
    }

    @Override
    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F, boolean bl) {
        if (bl) {
            if (denseMatrix64F == null) {
                denseMatrix64F = CommonOps.identity(this.numRows, this.minLength);
            } else {
                if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.minLength) {
                    throw new IllegalArgumentException("Unexpected matrix dimension.");
                }
                CommonOps.setIdentity(denseMatrix64F);
            }
        } else if (denseMatrix64F == null) {
            denseMatrix64F = CommonOps.identity(this.numRows);
        } else {
            if (denseMatrix64F.numRows != this.numRows || denseMatrix64F.numCols != this.numRows) {
                throw new IllegalArgumentException("Unexpected matrix dimension.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (int i = this.minLength - 1; i >= 0; --i) {
            this.u[i] = 1.0;
            for (int j = i + 1; j < this.numRows; ++j) {
                this.u[j] = this.QR.get(j, i);
            }
            QrHelperFunctions.rank1UpdateMultR(denseMatrix64F, this.u, this.gammas[i], i, i, this.numRows, this.v);
        }
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getR(DenseMatrix64F denseMatrix64F, boolean bl) {
        int n;
        int n2;
        if (denseMatrix64F == null) {
            denseMatrix64F = bl ? new DenseMatrix64F(this.minLength, this.numCols) : new DenseMatrix64F(this.numRows, this.numCols);
        } else {
            if (bl ? denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.minLength : denseMatrix64F.numCols != this.numCols || denseMatrix64F.numRows != this.numRows) {
                throw new IllegalArgumentException("Unexpected dimensions");
            }
            for (n2 = 0; n2 < denseMatrix64F.numRows; ++n2) {
                n = Math.min(n2, denseMatrix64F.numCols);
                for (int i = 0; i < n; ++i) {
                    denseMatrix64F.set(n2, i, 0.0);
                }
            }
        }
        for (n2 = 0; n2 < this.minLength; ++n2) {
            for (n = n2; n < this.numCols; ++n) {
                double d = this.QR.get(n2, n);
                denseMatrix64F.set(n2, n, d);
            }
        }
        return denseMatrix64F;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.commonSetup(denseMatrix64F);
        for (int i = 0; i < this.minLength; ++i) {
            this.householder(i);
            this.updateA(i);
        }
        return !this.error;
    }

    @Override
    public boolean inputModified() {
        return false;
    }

    protected void householder(int n) {
        double d;
        int n2;
        int n3 = n + n * this.numCols;
        double d2 = 0.0;
        for (n2 = n; n2 < this.numRows; ++n2) {
            this.u[n2] = this.dataQR[n3];
            d = this.u[n2];
            if (d < 0.0) {
                d = -d;
            }
            if (d2 < d) {
                d2 = d;
            }
            n3 += this.numCols;
        }
        if (d2 == 0.0) {
            this.gamma = 0.0;
            this.error = true;
        } else {
            this.tau = 0.0;
            for (n2 = n; n2 < this.numRows; ++n2) {
                int n4 = n2;
                this.u[n4] = this.u[n4] / d2;
                d = this.u[n2];
                this.tau += d * d;
            }
            this.tau = Math.sqrt(this.tau);
            if (this.u[n] < 0.0) {
                this.tau = -this.tau;
            }
            double d3 = this.u[n] + this.tau;
            this.gamma = d3 / this.tau;
            int n5 = n + 1;
            while (n5 < this.numRows) {
                int n6 = n5++;
                this.u[n6] = this.u[n6] / d3;
            }
            this.u[n] = 1.0;
            this.tau *= d2;
        }
        this.gammas[n] = this.gamma;
    }

    protected void updateA(int n) {
        int n2;
        for (n2 = n + 1; n2 < this.numCols; ++n2) {
            this.v[n2] = this.u[n] * this.dataQR[n * this.numCols + n2];
        }
        for (n2 = n + 1; n2 < this.numRows; ++n2) {
            int n3 = n2 * this.numCols + n + 1;
            int n4 = n + 1;
            while (n4 < this.numCols) {
                int n5 = n4++;
                this.v[n5] = this.v[n5] + this.u[n2] * this.dataQR[n3++];
            }
        }
        n2 = n + 1;
        while (n2 < this.numCols) {
            int n6 = n2++;
            this.v[n6] = this.v[n6] * this.gamma;
        }
        for (n2 = n; n2 < this.numRows; ++n2) {
            double d = this.u[n2];
            int n7 = n2 * this.numCols + n + 1;
            for (int i = n + 1; i < this.numCols; ++i) {
                int n8 = n7++;
                this.dataQR[n8] = this.dataQR[n8] - d * this.v[i];
            }
        }
        if (n < this.numCols) {
            this.dataQR[n + n * this.numCols] = -this.tau;
        }
        for (n2 = n + 1; n2 < this.numRows; ++n2) {
            this.dataQR[n + n2 * this.numCols] = this.u[n2];
        }
    }

    protected void commonSetup(DenseMatrix64F denseMatrix64F) {
        this.setExpectedMaxSize(denseMatrix64F.numRows, denseMatrix64F.numCols);
        this.QR.set(denseMatrix64F);
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

