/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.ops;

import java.util.Random;
import org.ejml.alg.dense.linsol.LinearSolver;
import org.ejml.alg.dense.linsol.LinearSolverFactory;
import org.ejml.alg.dense.linsol.LinearSolverSafe;
import org.ejml.alg.dense.misc.UnrolledInverseFromMinor;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CovarianceRandomDraw;
import org.ejml.ops.MatrixFeatures;

public class CovarianceOps {
    public static double TOL = 1.0E-9;

    public static boolean isValidFast(DenseMatrix64F denseMatrix64F) {
        return MatrixFeatures.isDiagonalPositive(denseMatrix64F);
    }

    public static int isValid(DenseMatrix64F denseMatrix64F) {
        if (!MatrixFeatures.isDiagonalPositive(denseMatrix64F)) {
            return 1;
        }
        if (!MatrixFeatures.isSymmetric(denseMatrix64F, TOL)) {
            return 2;
        }
        if (!MatrixFeatures.isPositiveSemidefinite(denseMatrix64F)) {
            return 3;
        }
        return 0;
    }

    public static boolean invert(DenseMatrix64F denseMatrix64F) {
        return CovarianceOps.invert(denseMatrix64F, denseMatrix64F);
    }

    public static boolean invert(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        if (denseMatrix64F.numCols <= 4) {
            if (denseMatrix64F.numCols != denseMatrix64F.numRows) {
                throw new IllegalArgumentException("Must be a square matrix.");
            }
            if (denseMatrix64F.numCols >= 2) {
                UnrolledInverseFromMinor.inv(denseMatrix64F, denseMatrix64F2);
            } else {
                denseMatrix64F2.data[0] = 1.0 / denseMatrix64F2.data[0];
            }
        } else {
            LinearSolver<DenseMatrix64F> linearSolver = LinearSolverFactory.symmPosDef(denseMatrix64F.numRows);
            if (!(linearSolver = new LinearSolverSafe<DenseMatrix64F>(linearSolver)).setA(denseMatrix64F)) {
                return false;
            }
            linearSolver.invert(denseMatrix64F2);
        }
        return true;
    }

    public static void randomVector(DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2, Random random) {
        CovarianceRandomDraw covarianceRandomDraw = new CovarianceRandomDraw(random, denseMatrix64F);
        covarianceRandomDraw.next(denseMatrix64F2);
    }
}

