/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ForwWTFull
extends ForwardWT {
    private boolean intData;
    private SubbandAn[][] subbTrees;
    private BlkImgDataSrc src;
    private int cb0x;
    private int cb0y;
    private IntegerSpec dls;
    private AnWTFilterSpec filters;
    private CBlkSizeSpec cblks;
    private PrecinctSizeSpec pss;
    private DataBlk[] decomposedComps;
    private int[] lastn;
    private int[] lastm;
    SubbandAn[] currentSubband;
    Point ncblks;

    public ForwWTFull(BlkImgDataSrc src, J2KImageWriteParamJava wp, int pox, int poy) {
        super(src);
        this.src = src;
        this.cb0x = this.cb0x;
        this.cb0y = this.cb0y;
        this.dls = wp.getDecompositionLevel();
        this.filters = wp.getFilters();
        this.cblks = wp.getCodeBlockSize();
        this.pss = wp.getPrecinctPartition();
        int ncomp = src.getNumComps();
        int ntiles = src.getNumTiles();
        this.currentSubband = new SubbandAn[ncomp];
        this.decomposedComps = new DataBlk[ncomp];
        this.subbTrees = new SubbandAn[ntiles][ncomp];
        this.lastn = new int[ncomp];
        this.lastm = new int[ncomp];
    }

    @Override
    public int getImplementationType(int c) {
        return 2;
    }

    @Override
    public int getDecompLevels(int t, int c) {
        return (Integer)this.dls.getTileCompVal(t, c);
    }

    @Override
    public int getDecomp(int t, int c) {
        return 0;
    }

    @Override
    public AnWTFilter[] getHorAnWaveletFilters(int t, int c) {
        return this.filters.getHFilters(t, c);
    }

    @Override
    public AnWTFilter[] getVertAnWaveletFilters(int t, int c) {
        return this.filters.getVFilters(t, c);
    }

    @Override
    public boolean isReversible(int t, int c) {
        return this.filters.isReversible(t, c);
    }

    @Override
    public int getCbULX() {
        return this.cb0x;
    }

    @Override
    public int getCbULY() {
        return this.cb0y;
    }

    @Override
    public int getFixedPoint(int c) {
        return this.src.getFixedPoint(c);
    }

    @Override
    public CBlkWTData getNextInternCodeBlock(int c, CBlkWTData cblk) {
        block13: {
            boolean bl = this.intData = this.filters.getWTDataType(this.tIdx, c) == 3;
            if (this.decomposedComps[c] == null) {
                int lstart;
                DataBlk bufblk;
                int w = this.getTileCompWidth(this.tIdx, c);
                int h = this.getTileCompHeight(this.tIdx, c);
                if (this.intData) {
                    this.decomposedComps[c] = new DataBlkInt(0, 0, w, h);
                    bufblk = new DataBlkInt();
                } else {
                    this.decomposedComps[c] = new DataBlkFloat(0, 0, w, h);
                    bufblk = new DataBlkFloat();
                }
                Object dst_data = this.decomposedComps[c].getData();
                bufblk.ulx = lstart = this.getCompULX(c);
                bufblk.w = w;
                bufblk.h = 1;
                int kk = this.getCompULY(c);
                for (int k = 0; k < h; ++k) {
                    bufblk.uly = kk++;
                    bufblk.ulx = lstart;
                    bufblk = this.src.getInternCompData(bufblk, c);
                    System.arraycopy(bufblk.getData(), bufblk.offset, dst_data, k * w, w);
                }
                this.waveletTreeDecomposition(this.decomposedComps[c], this.getAnSubbandTree(this.tIdx, c), c);
                this.currentSubband[c] = this.getNextSubband(c);
                this.lastn[c] = -1;
                this.lastm[c] = 0;
            }
            do {
                this.ncblks = this.currentSubband[c].numCb;
                int n = c;
                this.lastn[n] = this.lastn[n] + 1;
                if (this.lastn[c] == this.ncblks.x) {
                    this.lastn[c] = 0;
                    int n2 = c;
                    this.lastm[n2] = this.lastm[n2] + 1;
                }
                if (this.lastm[c] < this.ncblks.y) break block13;
                this.currentSubband[c] = this.getNextSubband(c);
                this.lastn[c] = -1;
                this.lastm[c] = 0;
            } while (this.currentSubband[c] != null);
            this.decomposedComps[c] = null;
            return null;
        }
        int acb0x = this.cb0x;
        int acb0y = this.cb0y;
        switch (this.currentSubband[c].sbandIdx) {
            case 0: {
                break;
            }
            case 1: {
                acb0x = 0;
                break;
            }
            case 2: {
                acb0y = 0;
                break;
            }
            case 3: {
                acb0x = 0;
                acb0y = 0;
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        if (cblk == null) {
            cblk = this.intData ? new CBlkWTDataInt() : new CBlkWTDataFloat();
        }
        int cbn = this.lastn[c];
        int cbm = this.lastm[c];
        SubbandAn sb = this.currentSubband[c];
        cblk.n = cbn;
        cblk.m = cbm;
        cblk.sb = sb;
        int cn = (sb.ulcx - acb0x + sb.nomCBlkW) / sb.nomCBlkW - 1;
        int cm = (sb.ulcy - acb0y + sb.nomCBlkH) / sb.nomCBlkH - 1;
        cblk.ulx = cbn == 0 ? sb.ulx : (cn + cbn) * sb.nomCBlkW - (sb.ulcx - acb0x) + sb.ulx;
        cblk.uly = cbm == 0 ? sb.uly : (cm + cbm) * sb.nomCBlkH - (sb.ulcy - acb0y) + sb.uly;
        cblk.w = cbn < this.ncblks.x - 1 ? (cn + cbn + 1) * sb.nomCBlkW - (sb.ulcx - acb0x) + sb.ulx - cblk.ulx : sb.ulx + sb.w - cblk.ulx;
        cblk.h = cbm < this.ncblks.y - 1 ? (cm + cbm + 1) * sb.nomCBlkH - (sb.ulcy - acb0y) + sb.uly - cblk.uly : sb.uly + sb.h - cblk.uly;
        cblk.wmseScaling = 1.0f;
        cblk.offset = cblk.uly * this.decomposedComps[c].w + cblk.ulx;
        cblk.scanw = this.decomposedComps[c].w;
        cblk.setData(this.decomposedComps[c].getData());
        return cblk;
    }

    @Override
    public CBlkWTData getNextCodeBlock(int c, CBlkWTData cblk) {
        this.intData = this.filters.getWTDataType(this.tIdx, c) == 3;
        Object dst_data = null;
        if (cblk != null) {
            dst_data = cblk.getData();
        }
        if ((cblk = this.getNextInternCodeBlock(c, cblk)) == null) {
            return null;
        }
        if (this.intData) {
            int[] dst_data_int = (int[])dst_data;
            if (dst_data_int == null || dst_data_int.length < cblk.w * cblk.h) {
                dst_data = new int[cblk.w * cblk.h];
            }
        } else {
            float[] dst_data_float = (float[])dst_data;
            if (dst_data_float == null || dst_data_float.length < cblk.w * cblk.h) {
                dst_data = new float[cblk.w * cblk.h];
            }
        }
        Object src_data = cblk.getData();
        int w = cblk.w;
        int j = w * (cblk.h - 1);
        int k = cblk.offset + (cblk.h - 1) * cblk.scanw;
        while (j >= 0) {
            System.arraycopy(src_data, k, dst_data, j, w);
            j -= w;
            k -= cblk.scanw;
        }
        cblk.setData(dst_data);
        cblk.offset = 0;
        cblk.scanw = w;
        return cblk;
    }

    @Override
    public int getDataType(int t, int c) {
        return this.filters.getWTDataType(t, c);
    }

    private SubbandAn getNextSubband(int c) {
        boolean down = true;
        boolean up = false;
        boolean direction = down;
        SubbandAn nextsb = this.currentSubband[c];
        if (nextsb == null) {
            nextsb = this.getAnSubbandTree(this.tIdx, c);
            if (!nextsb.isNode) {
                return nextsb;
            }
        }
        while (nextsb != null) {
            if (!nextsb.isNode) {
                switch (nextsb.orientation) {
                    case 3: {
                        nextsb = (SubbandAn)nextsb.getParent().getLH();
                        direction = down;
                        break;
                    }
                    case 2: {
                        nextsb = (SubbandAn)nextsb.getParent().getHL();
                        direction = down;
                        break;
                    }
                    case 1: {
                        nextsb = (SubbandAn)nextsb.getParent().getLL();
                        direction = down;
                        break;
                    }
                    case 0: {
                        nextsb = (SubbandAn)nextsb.getParent();
                        direction = up;
                    }
                }
            } else if (nextsb.isNode) {
                if (direction == down) {
                    nextsb = (SubbandAn)nextsb.getHH();
                } else if (direction == up) {
                    switch (nextsb.orientation) {
                        case 3: {
                            nextsb = (SubbandAn)nextsb.getParent().getLH();
                            direction = down;
                            break;
                        }
                        case 2: {
                            nextsb = (SubbandAn)nextsb.getParent().getHL();
                            direction = down;
                            break;
                        }
                        case 1: {
                            nextsb = (SubbandAn)nextsb.getParent().getLL();
                            direction = down;
                            break;
                        }
                        case 0: {
                            nextsb = (SubbandAn)nextsb.getParent();
                            direction = up;
                        }
                    }
                }
            }
            if (nextsb != null && nextsb.isNode) continue;
        }
        return nextsb;
    }

    private void waveletTreeDecomposition(DataBlk band, SubbandAn subband, int c) {
        if (!subband.isNode) {
            return;
        }
        this.wavelet2DDecomposition(band, subband, c);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getHH(), c);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getLH(), c);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getHL(), c);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getLL(), c);
    }

    private void wavelet2DDecomposition(DataBlk band, SubbandAn subband, int c) {
        if (subband.w == 0 || subband.h == 0) {
            return;
        }
        int ulx = subband.ulx;
        int uly = subband.uly;
        int w = subband.w;
        int h = subband.h;
        int band_w = this.getTileCompWidth(this.tIdx, c);
        int band_h = this.getTileCompHeight(this.tIdx, c);
        if (this.intData) {
            int i;
            int offset;
            int j;
            int[] tmpVector = new int[Math.max(w, h)];
            int[] data = ((DataBlkInt)band).getDataInt();
            if (subband.ulcy % 2 == 0) {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_lpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + (h + 1) / 2 * band_w, band_w);
                }
            } else {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_hpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + h / 2 * band_w, band_w);
                }
            }
            if (subband.ulcx % 2 == 0) {
                for (i = 0; i < h; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
                }
            } else {
                for (i = 0; i < h; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
                }
            }
        } else {
            int i;
            int offset;
            int j;
            float[] tmpVector = new float[Math.max(w, h)];
            float[] data = ((DataBlkFloat)band).getDataFloat();
            if (subband.ulcy % 2 == 0) {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_lpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + (h + 1) / 2 * band_w, band_w);
                }
            } else {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_hpf(tmpVector, 0, h, 1, data, offset, band_w, data, offset + h / 2 * band_w, band_w);
                }
            }
            if (subband.ulcx % 2 == 0) {
                for (i = 0; i < h; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
                }
            } else {
                for (i = 0; i < h; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
                }
            }
        }
    }

    @Override
    public void setTile(int x, int y) {
        super.setTile(x, y);
        if (this.decomposedComps != null) {
            for (int i = this.decomposedComps.length - 1; i >= 0; --i) {
                this.decomposedComps[i] = null;
                this.currentSubband[i] = null;
            }
        }
    }

    @Override
    public void nextTile() {
        super.nextTile();
        if (this.decomposedComps != null) {
            for (int i = this.decomposedComps.length - 1; i >= 0; --i) {
                this.decomposedComps[i] = null;
                this.currentSubband[i] = null;
            }
        }
    }

    @Override
    public SubbandAn getAnSubbandTree(int t, int c) {
        if (this.subbTrees[t][c] == null) {
            this.subbTrees[t][c] = new SubbandAn(this.getTileCompWidth(this.tIdx, c), this.getTileCompHeight(this.tIdx, c), this.getCompULX(c), this.getCompULY(c), this.getDecompLevels(t, c), this.getHorAnWaveletFilters(t, c), this.getVertAnWaveletFilters(t, c));
            this.initSubbandsFields(t, c, this.subbTrees[t][c]);
        }
        return this.subbTrees[t][c];
    }

    private void initSubbandsFields(int t, int c, Subband sb) {
        int cbw = this.cblks.getCBlkWidth((byte)3, t, c);
        int cbh = this.cblks.getCBlkHeight((byte)3, t, c);
        if (!sb.isNode) {
            int ppx = this.pss.getPPX(t, c, sb.resLvl);
            int ppy = this.pss.getPPY(t, c, sb.resLvl);
            if (ppx != 65535 || ppy != 65535) {
                int ppxExp = MathUtil.log2(ppx);
                int ppyExp = MathUtil.log2(ppy);
                int cbwExp = MathUtil.log2(cbw);
                int cbhExp = MathUtil.log2(cbh);
                switch (sb.resLvl) {
                    case 0: {
                        sb.nomCBlkW = cbwExp < ppxExp ? 1 << cbwExp : 1 << ppxExp;
                        sb.nomCBlkH = cbhExp < ppyExp ? 1 << cbhExp : 1 << ppyExp;
                        break;
                    }
                    default: {
                        sb.nomCBlkW = cbwExp < ppxExp - 1 ? 1 << cbwExp : 1 << ppxExp - 1;
                        sb.nomCBlkH = cbhExp < ppyExp - 1 ? 1 << cbhExp : 1 << ppyExp - 1;
                        break;
                    }
                }
            } else {
                sb.nomCBlkW = cbw;
                sb.nomCBlkH = cbh;
            }
            if (sb.numCb == null) {
                sb.numCb = new Point();
            }
            if (sb.w != 0 && sb.h != 0) {
                int acb0x = this.cb0x;
                int acb0y = this.cb0y;
                switch (sb.sbandIdx) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        acb0x = 0;
                        break;
                    }
                    case 2: {
                        acb0y = 0;
                        break;
                    }
                    case 3: {
                        acb0x = 0;
                        acb0y = 0;
                        break;
                    }
                    default: {
                        throw new Error("Internal JJ2000 error");
                    }
                }
                if (sb.ulcx - acb0x < 0 || sb.ulcy - acb0y < 0) {
                    throw new IllegalArgumentException("Invalid code-blocks partition origin or image offset in the reference grid.");
                }
                int tmp = sb.ulcx - acb0x + sb.nomCBlkW;
                sb.numCb.x = (tmp + sb.w - 1) / sb.nomCBlkW - (tmp / sb.nomCBlkW - 1);
                tmp = sb.ulcy - acb0y + sb.nomCBlkH;
                sb.numCb.y = (tmp + sb.h - 1) / sb.nomCBlkH - (tmp / sb.nomCBlkH - 1);
            } else {
                sb.numCb.y = 0;
                sb.numCb.x = 0;
            }
        } else {
            this.initSubbandsFields(t, c, sb.getLL());
            this.initSubbandsFields(t, c, sb.getHL());
            this.initSubbandsFields(t, c, sb.getLH());
            this.initSubbandsFields(t, c, sb.getHH());
        }
    }
}

