/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Reference;
import ome.xml.model.Settings;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Medium;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectiveSettings
extends Settings {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveSettings.class);
    private Double refractiveIndex;
    private Double correctionCollar;
    private String id;
    private Medium medium;
    private Objective objective;

    public ObjectiveSettings() {
    }

    public ObjectiveSettings(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ObjectiveSettings(ObjectiveSettings orig) {
        super(orig);
        this.refractiveIndex = orig.refractiveIndex;
        this.correctionCollar = orig.correctionCollar;
        this.id = orig.id;
        this.medium = orig.medium;
        this.objective = orig.objective;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ObjectiveSettings".equals(tagName)) {
            LOGGER.debug("Expecting node name of ObjectiveSettings got {}", (Object)tagName);
        }
        if (element.hasAttribute("RefractiveIndex")) {
            this.setRefractiveIndex(Double.valueOf(element.getAttribute("RefractiveIndex")));
        }
        if (element.hasAttribute("CorrectionCollar")) {
            this.setCorrectionCollar(Double.valueOf(element.getAttribute("CorrectionCollar")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("ObjectiveSettings missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Medium")) {
            this.setMedium(Medium.fromString(element.getAttribute("Medium")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Double getRefractiveIndex() {
        return this.refractiveIndex;
    }

    public void setRefractiveIndex(Double refractiveIndex) {
        this.refractiveIndex = refractiveIndex;
    }

    public Double getCorrectionCollar() {
        return this.correctionCollar;
    }

    public void setCorrectionCollar(Double correctionCollar) {
        this.correctionCollar = correctionCollar;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public Medium getMedium() {
        return this.medium;
    }

    public void setMedium(Medium medium) {
        this.medium = medium;
    }

    public Objective getObjective() {
        return this.objective;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element ObjectiveSettings_element) {
        if (ObjectiveSettings_element == null) {
            ObjectiveSettings_element = document.createElementNS(NAMESPACE, "ObjectiveSettings");
        }
        if (this.refractiveIndex != null) {
            ObjectiveSettings_element.setAttribute("RefractiveIndex", this.refractiveIndex.toString());
        }
        if (this.correctionCollar != null) {
            ObjectiveSettings_element.setAttribute("CorrectionCollar", this.correctionCollar.toString());
        }
        if (this.id != null) {
            ObjectiveSettings_element.setAttribute("ID", this.id.toString());
        }
        if (this.medium != null) {
            ObjectiveSettings_element.setAttribute("Medium", this.medium.toString());
        }
        if (this.objective != null) {
            // empty if block
        }
        return super.asXMLElement(document, ObjectiveSettings_element);
    }
}

