/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Frequency;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsFrequency;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsFrequencyEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsFrequencyEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsFrequencyEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*YHz\\s*", "YHz");
        p.put("^\\s*ZHz\\s*", "ZHz");
        p.put("^\\s*EHz\\s*", "EHz");
        p.put("^\\s*PHz\\s*", "PHz");
        p.put("^\\s*THz\\s*", "THz");
        p.put("^\\s*GHz\\s*", "GHz");
        p.put("^\\s*MHz\\s*", "MHz");
        p.put("^\\s*kHz\\s*", "kHz");
        p.put("^\\s*hHz\\s*", "hHz");
        p.put("^\\s*daHz\\s*", "daHz");
        p.put("^\\s*Hz\\s*", "Hz");
        p.put("^\\s*dHz\\s*", "dHz");
        p.put("^\\s*cHz\\s*", "cHz");
        p.put("^\\s*mHz\\s*", "mHz");
        p.put("^\\s*\u00b5Hz\\s*", "\u00b5Hz");
        p.put("^\\s*nHz\\s*", "nHz");
        p.put("^\\s*pHz\\s*", "pHz");
        p.put("^\\s*fHz\\s*", "fHz");
        p.put("^\\s*aHz\\s*", "aHz");
        p.put("^\\s*zHz\\s*", "zHz");
        p.put("^\\s*yHz\\s*", "yHz");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsFrequency.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsFrequency", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Frequency inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Frequency> getBaseUnit(UnitsFrequency inModelUnit) {
        Unit<Frequency> theResult = UNITS.HERTZ;
        if (UnitsFrequency.YOTTAHZ.equals(inModelUnit)) {
            theResult = UNITS.YOTTAHZ;
        }
        if (UnitsFrequency.ZETTAHZ.equals(inModelUnit)) {
            theResult = UNITS.ZETTAHZ;
        }
        if (UnitsFrequency.EXAHZ.equals(inModelUnit)) {
            theResult = UNITS.EXAHZ;
        }
        if (UnitsFrequency.PETAHZ.equals(inModelUnit)) {
            theResult = UNITS.PETAHZ;
        }
        if (UnitsFrequency.TERAHZ.equals(inModelUnit)) {
            theResult = UNITS.TERAHZ;
        }
        if (UnitsFrequency.GIGAHZ.equals(inModelUnit)) {
            theResult = UNITS.GIGAHZ;
        }
        if (UnitsFrequency.MEGAHZ.equals(inModelUnit)) {
            theResult = UNITS.MEGAHZ;
        }
        if (UnitsFrequency.KHZ.equals(inModelUnit)) {
            theResult = UNITS.KHZ;
        }
        if (UnitsFrequency.HHZ.equals(inModelUnit)) {
            theResult = UNITS.HHZ;
        }
        if (UnitsFrequency.DAHZ.equals(inModelUnit)) {
            theResult = UNITS.DAHZ;
        }
        if (UnitsFrequency.HZ.equals(inModelUnit)) {
            theResult = UNITS.HZ;
        }
        if (UnitsFrequency.DHZ.equals(inModelUnit)) {
            theResult = UNITS.DHZ;
        }
        if (UnitsFrequency.CHZ.equals(inModelUnit)) {
            theResult = UNITS.CHZ;
        }
        if (UnitsFrequency.MHZ.equals(inModelUnit)) {
            theResult = UNITS.MHZ;
        }
        if (UnitsFrequency.MICROHZ.equals(inModelUnit)) {
            theResult = UNITS.MICROHZ;
        }
        if (UnitsFrequency.NHZ.equals(inModelUnit)) {
            theResult = UNITS.NHZ;
        }
        if (UnitsFrequency.PHZ.equals(inModelUnit)) {
            theResult = UNITS.PHZ;
        }
        if (UnitsFrequency.FHZ.equals(inModelUnit)) {
            theResult = UNITS.FHZ;
        }
        if (UnitsFrequency.AHZ.equals(inModelUnit)) {
            theResult = UNITS.AHZ;
        }
        if (UnitsFrequency.ZHZ.equals(inModelUnit)) {
            theResult = UNITS.ZHZ;
        }
        if (UnitsFrequency.YHZ.equals(inModelUnit)) {
            theResult = UNITS.YHZ;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Frequency getQuantity(T inValue, UnitsFrequency inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Frequency' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsFrequencyEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Frequency getQuantity(T inValue, UnitsFrequency inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Frequency(doubleValue, UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Frequency(intValue, UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Frequency' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsFrequencyEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsFrequency.class;
    }
}

