/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsLengthEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsLengthEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsLengthEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*Ym\\s*", "Ym");
        p.put("^\\s*Zm\\s*", "Zm");
        p.put("^\\s*Em\\s*", "Em");
        p.put("^\\s*Pm\\s*", "Pm");
        p.put("^\\s*Tm\\s*", "Tm");
        p.put("^\\s*Gm\\s*", "Gm");
        p.put("^\\s*Mm\\s*", "Mm");
        p.put("^\\s*km\\s*", "km");
        p.put("^\\s*hm\\s*", "hm");
        p.put("^\\s*dam\\s*", "dam");
        p.put("^\\s*m\\s*", "m");
        p.put("^\\s*dm\\s*", "dm");
        p.put("^\\s*cm\\s*", "cm");
        p.put("^\\s*mm\\s*", "mm");
        p.put("^\\s*\u00b5m\\s*", "\u00b5m");
        p.put("^\\s*nm\\s*", "nm");
        p.put("^\\s*pm\\s*", "pm");
        p.put("^\\s*fm\\s*", "fm");
        p.put("^\\s*am\\s*", "am");
        p.put("^\\s*zm\\s*", "zm");
        p.put("^\\s*ym\\s*", "ym");
        p.put("^\\s*\u00c5\\s*", "\u00c5");
        p.put("^\\s*thou\\s*", "thou");
        p.put("^\\s*li\\s*", "li");
        p.put("^\\s*in\\s*", "in");
        p.put("^\\s*ft\\s*", "ft");
        p.put("^\\s*yd\\s*", "yd");
        p.put("^\\s*mi\\s*", "mi");
        p.put("^\\s*ua\\s*", "ua");
        p.put("^\\s*ly\\s*", "ly");
        p.put("^\\s*pc\\s*", "pc");
        p.put("^\\s*pt\\s*", "pt");
        p.put("^\\s*pixel\\s*", "pixel");
        p.put("^\\s*reference frame\\s*", "reference frame");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsLength.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsLength", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Length inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Length> getBaseUnit(UnitsLength inModelUnit) {
        Unit<Length> theResult = UNITS.METRE;
        if (UnitsLength.YOTTAM.equals(inModelUnit)) {
            theResult = UNITS.YOTTAM;
        }
        if (UnitsLength.ZETTAM.equals(inModelUnit)) {
            theResult = UNITS.ZETTAM;
        }
        if (UnitsLength.EXAM.equals(inModelUnit)) {
            theResult = UNITS.EXAM;
        }
        if (UnitsLength.PETAM.equals(inModelUnit)) {
            theResult = UNITS.PETAM;
        }
        if (UnitsLength.TERAM.equals(inModelUnit)) {
            theResult = UNITS.TERAM;
        }
        if (UnitsLength.GIGAM.equals(inModelUnit)) {
            theResult = UNITS.GIGAM;
        }
        if (UnitsLength.MEGAM.equals(inModelUnit)) {
            theResult = UNITS.MEGAM;
        }
        if (UnitsLength.KM.equals(inModelUnit)) {
            theResult = UNITS.KM;
        }
        if (UnitsLength.HM.equals(inModelUnit)) {
            theResult = UNITS.HM;
        }
        if (UnitsLength.DAM.equals(inModelUnit)) {
            theResult = UNITS.DAM;
        }
        if (UnitsLength.M.equals(inModelUnit)) {
            theResult = UNITS.M;
        }
        if (UnitsLength.DM.equals(inModelUnit)) {
            theResult = UNITS.DM;
        }
        if (UnitsLength.CM.equals(inModelUnit)) {
            theResult = UNITS.CM;
        }
        if (UnitsLength.MM.equals(inModelUnit)) {
            theResult = UNITS.MM;
        }
        if (UnitsLength.MICROM.equals(inModelUnit)) {
            theResult = UNITS.MICROM;
        }
        if (UnitsLength.NM.equals(inModelUnit)) {
            theResult = UNITS.NM;
        }
        if (UnitsLength.PM.equals(inModelUnit)) {
            theResult = UNITS.PM;
        }
        if (UnitsLength.FM.equals(inModelUnit)) {
            theResult = UNITS.FM;
        }
        if (UnitsLength.AM.equals(inModelUnit)) {
            theResult = UNITS.AM;
        }
        if (UnitsLength.ZM.equals(inModelUnit)) {
            theResult = UNITS.ZM;
        }
        if (UnitsLength.YM.equals(inModelUnit)) {
            theResult = UNITS.YM;
        }
        if (UnitsLength.ANGSTROM.equals(inModelUnit)) {
            theResult = UNITS.ANGSTROM;
        }
        if (UnitsLength.THOU.equals(inModelUnit)) {
            theResult = UNITS.THOU;
        }
        if (UnitsLength.LI.equals(inModelUnit)) {
            theResult = UNITS.LI;
        }
        if (UnitsLength.IN.equals(inModelUnit)) {
            theResult = UNITS.IN;
        }
        if (UnitsLength.FT.equals(inModelUnit)) {
            theResult = UNITS.FT;
        }
        if (UnitsLength.YD.equals(inModelUnit)) {
            theResult = UNITS.YD;
        }
        if (UnitsLength.MI.equals(inModelUnit)) {
            theResult = UNITS.MI;
        }
        if (UnitsLength.UA.equals(inModelUnit)) {
            theResult = UNITS.UA;
        }
        if (UnitsLength.LY.equals(inModelUnit)) {
            theResult = UNITS.LY;
        }
        if (UnitsLength.PC.equals(inModelUnit)) {
            theResult = UNITS.PC;
        }
        if (UnitsLength.PT.equals(inModelUnit)) {
            theResult = UNITS.PT;
        }
        if (UnitsLength.PIXEL.equals(inModelUnit)) {
            theResult = UNITS.PIXEL;
        }
        if (UnitsLength.REFERENCEFRAME.equals(inModelUnit)) {
            theResult = UNITS.REFERENCEFRAME;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Length getQuantity(T inValue, UnitsLength inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Length((Number)typedValue.getValue(), UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Length' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsLengthEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Length getQuantity(T inValue, UnitsLength inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Length(doubleValue, UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Length(intValue, UnitsLengthEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Length' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsLengthEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsLength.class;
    }
}

