/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class DenseFloatCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D L;
    private FloatMatrix2D Lt;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public DenseFloatCholeskyDecomposition(FloatMatrix2D A) {
        FloatProperty.DEFAULT.checkSquare(A);
        this.n = A.rows();
        this.L = A.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = A.columns() == this.n;
        FloatMatrix1D[] Lrows = new FloatMatrix1D[this.n];
        int j = 0;
        while (j < this.n) {
            Lrows[j] = this.L.viewRow(j);
            ++j;
        }
        j = 0;
        while (j < this.n) {
            float d = 0.0f;
            int k = 0;
            while (k < j) {
                float s = Lrows[k].zDotProduct(Lrows[j], 0, k);
                s = (A.getQuick(j, k) - s) / this.L.getQuick(k, k);
                Lrows[j].setQuick(k, s);
                d += s * s;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && A.getQuick(k, j) == A.getQuick(j, k);
                ++k;
            }
            d = A.getQuick(j, j) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && (double)d > 0.0;
            this.L.setQuick(j, j, (float)Math.sqrt(Math.max((double)d, 0.0)));
            k = j + 1;
            while (k < this.n) {
                this.L.setQuick(j, k, 0.0f);
                ++k;
            }
            ++j;
        }
        this.Lt = this.L.viewDice().copy();
    }

    public FloatMatrix2D getL() {
        return this.L;
    }

    public FloatMatrix2D getLtranspose() {
        return this.Lt;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public FloatMatrix2D solve(FloatMatrix2D B) {
        FloatMatrix2D X = B.copy();
        int nx = B.columns();
        int c = 0;
        while (c < nx) {
            int k;
            float sum;
            int i = 0;
            while (i < this.n) {
                sum = B.getQuick(i, c);
                k = i - 1;
                while (k >= 0) {
                    sum -= this.L.getQuick(i, k) * X.getQuick(k, c);
                    --k;
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
                ++i;
            }
            i = this.n - 1;
            while (i >= 0) {
                sum = X.getQuick(i, c);
                k = i + 1;
                while (k < this.n) {
                    sum -= this.L.getQuick(k, i) * X.getQuick(k, c);
                    ++k;
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
                --i;
            }
            ++c;
        }
        return X;
    }

    public FloatMatrix1D solve(FloatMatrix1D b) {
        int k;
        float sum;
        FloatMatrix1D x = b.copy();
        int i = 0;
        while (i < this.n) {
            sum = b.getQuick(i);
            k = i - 1;
            while (k >= 0) {
                sum -= this.L.getQuick(i, k) * x.getQuick(k);
                --k;
            }
            x.setQuick(i, sum / this.L.getQuick(i, i));
            ++i;
        }
        i = this.n - 1;
        while (i >= 0) {
            sum = x.getQuick(i);
            k = i + 1;
            while (k < this.n) {
                sum -= this.L.getQuick(k, i) * x.getQuick(k);
                ++k;
            }
            x.setQuick(i, sum / this.L.getQuick(i, i));
            --i;
        }
        return x;
    }

    private FloatMatrix2D XXXsolveBuggy(FloatMatrix2D B) {
        int i;
        FloatFunctions F = FloatFunctions.functions;
        if (B.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        FloatMatrix2D X = B.copy();
        int nx = B.columns();
        FloatMatrix1D[] Xrows = new FloatMatrix1D[this.n];
        int k = 0;
        while (k < this.n) {
            Xrows[k] = X.viewRow(k);
            ++k;
        }
        k = 0;
        while (k < this.n) {
            i = k + 1;
            while (i < this.n) {
                Xrows[i].assign(Xrows[k], FloatFunctions.minusMult(this.L.getQuick(i, k)));
                ++i;
            }
            Xrows[k].assign(FloatFunctions.div(this.L.getQuick(k, k)));
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            Xrows[k].assign(FloatFunctions.div(this.L.getQuick(k, k)));
            i = 0;
            while (i < k) {
                Xrows[i].assign(Xrows[k], FloatFunctions.minusMult(this.L.getQuick(k, i)));
                ++i;
            }
            --k;
        }
        return X;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("isSymmetricPositiveDefinite = ");
        try {
            buf.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(String.valueOf(unknown) + exc.getMessage());
        }
        return buf.toString();
    }
}

