/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;

public class SparseRCMIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseIntMatrix1D[] elements;

    public SparseRCMIntMatrix2D(int rows, int columns) {
        block3: {
            super(null);
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        this.elements = new SparseIntMatrix1D[rows];
        int i = 0;
        while (i < rows) {
            this.elements[i] = new SparseIntMatrix1D(columns);
            ++i;
        }
    }

    public SparseIntMatrix1D[] elements() {
        return this.elements;
    }

    @Override
    public int getQuick(int row, int column) {
        return this.elements[row].getQuick(column);
    }

    @Override
    public void setQuick(int row, int column, int value) {
        this.elements[row].setQuick(column, value);
    }

    @Override
    public void trimToSize() {
        int r = 0;
        while (r < this.rows) {
            this.elements[r].trimToSize();
            ++r;
        }
    }

    @Override
    public SparseIntMatrix1D viewRow(int row) {
        return this.elements[row];
    }

    @Override
    protected IntMatrix2D getContent() {
        return this;
    }

    @Override
    public IntMatrix2D like(int rows, int columns) {
        return new SparseRCMIntMatrix2D(rows, columns);
    }
}

