/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import javax.vecmath.Point3f;
import mcib3d.geom.Point3D;

public class Voxel3D
extends Point3D
implements Comparable<Voxel3D> {
    double value;

    public Voxel3D() {
        this.value = Double.NaN;
    }

    public Voxel3D(int n, int n2, int n3, float f) {
        super(n, n2, n3);
        this.value = f;
    }

    public Voxel3D(int n, int n2, int n3, double d) {
        super(n, n2, n3);
        this.value = d;
    }

    public Voxel3D(double d, double d2, double d3, double d4) {
        super(d, d2, d3);
        this.value = d4;
    }

    public Voxel3D(Voxel3D voxel3D) {
        super(voxel3D.getX(), voxel3D.getY(), voxel3D.getZ());
        this.value = voxel3D.getValue();
    }

    public Voxel3D(Point3f point3f, double d) {
        super(point3f.x, point3f.y, point3f.z);
        this.value = d;
    }

    public Voxel3D(Point3D point3D, double d) {
        super(point3D);
        this.value = d;
    }

    public void setVoxel(int n, int n2, int n3, float f) {
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.value = f;
    }

    public void setVoxel(int n, int n2, int n3, double d) {
        this.setX(n);
        this.setY(n2);
        this.setZ(n3);
        this.value = (float)d;
    }

    public void setVoxel(double d, double d2, double d3, double d4) {
        this.setX(d);
        this.setY(d2);
        this.setZ(d3);
        this.value = (float)d4;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "(" + this.getX() + " , " + this.getY() + " , " + this.getZ() + ")";
    }

    public void setValue(double d) {
        this.value = d;
    }

    public int getXYCoord(int n) {
        return (int)(this.x + 0.5) + (int)(this.y + 0.5) * n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Voxel3D) {
            Voxel3D voxel3D = (Voxel3D)object;
            return voxel3D.x == this.x && voxel3D.y == this.y && voxel3D.z == this.z;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 31 * n + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        n = 31 * n + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        n = 31 * n + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return n;
    }

    @Override
    public int compareTo(Voxel3D voxel3D) {
        if (voxel3D.x == this.x && voxel3D.y == this.y && voxel3D.z == this.z) {
            return 0;
        }
        if (this.value < voxel3D.value) {
            return 1;
        }
        if (this.value > voxel3D.value) {
            return -1;
        }
        return 0;
    }
}

