/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class ImageLabeller {
    HashMap<Integer, Spot> spots = null;
    int[][] labels;
    boolean debug = false;
    int minSize = 0;
    int maxsize = Integer.MAX_VALUE;
    ImageHandler currentMask = null;

    public ImageLabeller(boolean bl) {
        this.debug = bl;
    }

    public ImageLabeller() {
    }

    public ImageLabeller(int n, int n2) {
        this.minSize = n;
        this.maxsize = n2;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int n) {
        this.minSize = n;
    }

    public int getMaxsize() {
        return this.maxsize;
    }

    public void setMaxsize(int n) {
        this.maxsize = n;
    }

    private void labelSpots6(ImageHandler imageHandler) {
        this.currentMask = imageHandler;
        this.labels = new int[imageHandler.sizeZ][imageHandler.sizeXY];
        int n = imageHandler.sizeX;
        this.spots = new HashMap();
        int n2 = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int i = 0; i < imageHandler.sizeZ; ++i) {
            for (int j = 0; j < imageHandler.sizeY; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n3;
                    int n4 = k + j * n;
                    if (imageHandler.getPixel(n4, i) == 0.0f) continue;
                    Spot spot = null;
                    Vox3D vox3D = new Vox3D(n4, i);
                    if (k > 0 && (n3 = this.labels[i][n4 - 1]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            spot.addVox(vox3D);
                        } else if (n3 != spot.label) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                        }
                    }
                    if (j > 0 && (n3 = this.labels[i][n4 - n]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            spot.addVox(vox3D);
                        } else if (n3 != spot.label) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                        }
                    }
                    if (i > 0 && (n3 = this.labels[i - 1][n4]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            spot.addVox(vox3D);
                        } else if (n3 != spot.label) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                        }
                    }
                    if (spot != null) continue;
                    this.spots.put(n2, new Spot(n2++, vox3D));
                }
            }
        }
    }

    private void labelSpots26(ImageHandler imageHandler) {
        this.currentMask = imageHandler;
        this.labels = new int[imageHandler.sizeZ][imageHandler.sizeXY];
        int n = imageHandler.sizeX;
        this.spots = new HashMap();
        int n2 = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int i = 0; i < imageHandler.sizeZ; ++i) {
            for (int j = 0; j < imageHandler.sizeY; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n3 = k + j * n;
                    if (imageHandler.getPixel(n3, i) == 0.0f) continue;
                    Spot spot = null;
                    Vox3D vox3D = new Vox3D(n3, i);
                    for (int i2 = -1; i2 <= 1; ++i2) {
                        for (int i3 = -1; i3 <= 1; ++i3) {
                            for (int i4 = -1; i4 <= 1; ++i4) {
                                int n4;
                                if (!imageHandler.contains(k + i4, j + i3, i + i2) || i4 * i4 + i3 * i3 + i2 * i2 == 0 || i4 >= 0 && i3 >= 0 && i2 >= 0 || (n4 = this.labels[i + i2][n3 + i4 + i3 * n]) == 0) continue;
                                if (spot == null) {
                                    spot = this.spots.get(n4);
                                    spot.addVox(vox3D);
                                    continue;
                                }
                                if (n4 == spot.label) continue;
                                spot = spot.fusion(this.spots.get(n4));
                                spot.addVox(vox3D);
                            }
                        }
                    }
                    if (spot != null) continue;
                    this.spots.put(n2, new Spot(n2++, vox3D));
                }
            }
        }
    }

    private void labelSpotsCheckSize(ImageHandler imageHandler) {
        this.currentMask = imageHandler;
        this.labels = new int[imageHandler.sizeZ][imageHandler.sizeXY];
        int n = imageHandler.sizeX;
        this.spots = new HashMap();
        int n2 = 1;
        if (this.debug) {
            System.out.println("Labelling...");
        }
        for (int i = 0; i < imageHandler.sizeZ; ++i) {
            for (int j = 0; j < imageHandler.sizeY; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n3;
                    int n4 = k + j * n;
                    if (imageHandler.getPixel(n4, i) == 0.0f) continue;
                    Spot spot = null;
                    Vox3D vox3D = new Vox3D(n4, i);
                    if (k > 0 && (n3 = this.labels[i][n4 - 1]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            if (!spot.tooBig) {
                                spot.addVox(vox3D);
                                if (spot.getSize() > this.maxsize) {
                                    spot.tooBig = true;
                                }
                            }
                        } else if (n3 != spot.label && !spot.tooBig && !this.spots.get((Object)Integer.valueOf((int)n3)).tooBig) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                            if (spot.getSize() > this.maxsize) {
                                spot.tooBig = true;
                            }
                        }
                    }
                    if (j > 0 && (n3 = this.labels[i][n4 - n]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            if (!spot.tooBig) {
                                spot.addVox(vox3D);
                                if (spot.getSize() > this.maxsize) {
                                    spot.tooBig = true;
                                }
                            }
                        } else if (n3 != spot.label && !spot.tooBig && !this.spots.get((Object)Integer.valueOf((int)n3)).tooBig) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                            if (spot.getSize() > this.maxsize) {
                                spot.tooBig = true;
                            }
                        }
                    }
                    if (i > 0 && (n3 = this.labels[i - 1][n4]) != 0) {
                        if (spot == null) {
                            spot = this.spots.get(n3);
                            if (!spot.tooBig) {
                                spot.addVox(vox3D);
                                if (spot.getSize() > this.maxsize) {
                                    spot.tooBig = true;
                                }
                            }
                        } else if (n3 != spot.label && !spot.tooBig && !this.spots.get((Object)Integer.valueOf((int)n3)).tooBig) {
                            spot = spot.fusion(this.spots.get(n3));
                            spot.addVox(vox3D);
                            if (spot.getSize() > this.maxsize) {
                                spot.tooBig = true;
                            }
                        }
                    }
                    if (spot != null) continue;
                    this.spots.put(n2, new Spot(n2++, vox3D));
                }
            }
        }
    }

    public ImageInt getLabels(ImageHandler imageHandler, boolean bl) {
        if (this.spots == null || imageHandler != this.currentMask) {
            if (bl) {
                this.labelSpots6(imageHandler);
            } else {
                this.labelSpots26(imageHandler);
            }
        }
        ImageShort imageShort = new ImageShort(imageHandler.getTitle() + "::segmented", imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
        int n = 1;
        for (Spot spot : this.spots.values()) {
            ArrayList<Vox3D> arrayList = spot.voxels;
            if (arrayList.size() < this.minSize || arrayList.size() > this.maxsize) continue;
            for (Vox3D vox3D : arrayList) {
                imageShort.pixels[vox3D.z][vox3D.xy] = n;
            }
            n = (short)(n + 1);
        }
        return imageShort;
    }

    public ImageFloat getLabelsFloat(ImageHandler imageHandler) {
        return this.getLabelsFloat(imageHandler, false);
    }

    public ImageFloat getLabelsFloat(ImageHandler imageHandler, boolean bl) {
        if (this.spots == null || imageHandler != this.currentMask) {
            if (bl) {
                this.labelSpots6(imageHandler);
            } else {
                this.labelSpots26(imageHandler);
            }
        }
        ImageFloat imageFloat = new ImageFloat(imageHandler.getTitle() + "::segmented", imageHandler.sizeX, imageHandler.sizeY, imageHandler.sizeZ);
        int n = 1;
        for (Spot spot : this.spots.values()) {
            ArrayList<Vox3D> arrayList = spot.voxels;
            if (arrayList.size() < this.minSize || arrayList.size() > this.maxsize) continue;
            for (Vox3D vox3D : arrayList) {
                imageFloat.pixels[vox3D.z][vox3D.xy] = n;
            }
            n = (short)(n + 1);
        }
        return imageFloat;
    }

    public ImageInt getLabels(ImageHandler imageHandler) {
        return this.getLabels(imageHandler, false);
    }

    public int getNbObjectsTotal(ImageHandler imageHandler, boolean bl) {
        if (this.spots == null || imageHandler != this.currentMask) {
            if (bl) {
                this.labelSpots6(imageHandler);
            } else {
                this.labelSpots26(imageHandler);
            }
        }
        return this.spots.size();
    }

    public int getNbObjectsTotal(ImageHandler imageHandler) {
        return this.getNbObjectsTotal(imageHandler, false);
    }

    public int getNbObjectsinSizeRange(ImageHandler imageHandler, boolean bl) {
        return this.getObjects(imageHandler, bl).size();
    }

    public int getNbObjectsinSizeRange(ImageHandler imageHandler) {
        return this.getNbObjectsinSizeRange(imageHandler, false);
    }

    public ArrayList<Object3DVoxels> getObjects(ImageHandler imageHandler, boolean bl) {
        if (this.spots == null || imageHandler != this.currentMask) {
            if (bl) {
                this.labelSpots6(imageHandler);
            } else {
                this.labelSpots26(imageHandler);
            }
        }
        ArrayList<Object3DVoxels> arrayList = new ArrayList<Object3DVoxels>();
        int n = imageHandler.sizeX;
        int n2 = 1;
        for (Spot spot : this.spots.values()) {
            ArrayList<Vox3D> arrayList2 = spot.voxels;
            if (arrayList2.size() < this.minSize || arrayList2.size() > this.maxsize) continue;
            ArrayList<Voxel3D> arrayList3 = new ArrayList<Voxel3D>();
            for (Vox3D vox3D : arrayList2) {
                arrayList3.add(new Voxel3D(vox3D.xy % n, vox3D.xy / n, vox3D.z, n2));
            }
            ArrayList arrayList4 = new ArrayList(new HashSet(arrayList3));
            arrayList.add(new Object3DVoxels(arrayList4));
            n2 = (short)(n2 + 1);
        }
        return arrayList;
    }

    public ArrayList<Object3DVoxels> getObjects(ImageHandler imageHandler) {
        return this.getObjects(imageHandler, false);
    }

    protected class Vox3D {
        public int xy;
        public int z;

        public Vox3D(int n, int n2) {
            this.xy = n;
            this.z = n2;
        }

        public void setLabel(int n) {
            ImageLabeller.this.labels[this.z][this.xy] = n;
        }

        public boolean equals(Object object) {
            if (object instanceof Vox3D) {
                return this.xy == ((Vox3D)object).xy && this.z == ((Vox3D)object).z;
            }
            return false;
        }

        public int hashCode() {
            int n = 3;
            n = 47 * n + this.xy;
            n = 47 * n + this.z;
            return n;
        }
    }

    private class Spot {
        ArrayList<Vox3D> voxels;
        int label;
        boolean tooBig = false;

        public Spot(int n, Vox3D vox3D) {
            this.label = n;
            this.voxels = new ArrayList();
            this.voxels.add(vox3D);
            vox3D.setLabel(n);
        }

        public void addVox(Vox3D vox3D) {
            this.voxels.add(vox3D);
            vox3D.setLabel(this.label);
        }

        public void setLabel(int n) {
            this.label = n;
            for (Vox3D vox3D : this.voxels) {
                vox3D.setLabel(n);
            }
        }

        public Spot fusion(Spot spot) {
            if (spot.label < this.label) {
                return spot.fusion(this);
            }
            ImageLabeller.this.spots.remove(spot.label);
            this.voxels.addAll(spot.voxels);
            spot.setLabel(this.label);
            return this;
        }

        public int getSize() {
            return this.voxels.size();
        }
    }
}

